/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.Nas.gui.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.Nas.gui.admin.NasAgentPanel;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasAgentDDI
extends DataDisplayInfo
implements GuiRequestor,
ActionListener {
    private boolean dataRetrieved = false;
    private NasFilesystem[] dataArray;
    private NasFilesystem[] updateArray;
    private ListNode treeList;
    private NameList[] windowsAgents;
    private boolean closing;
    private static final int VISIBLE_DELETE_COUNT = 3;

    public NasAgentDDI() {
        this.setDescription(MessageLog.getMessageNoID("NAG0012L"));
        this.displayInScrollPane = false;
        this.helpID = "asco60";
    }

    public void reDisplay() {
        if (!this.dataRetrieved) {
            Request request = new Request();
            GuiRequest.nasFsList(request);
            GuiClient.doRequest(this, request);
            return;
        }
        if (this.panel == null) {
            this.buildEditor();
        }
        this.showAndAddListeners();
    }

    private void buildEditor() {
        this.panel = new NasAgentPanel(this, this.dataArray, this.treeList, this.windowsAgents);
    }

    private void showAndAddListeners() {
        this.show();
        String string = MessageLog.getMessageNoID("ADG0302L");
        guiMain.setSaveActionEnabled(true, false);
        guiMain.setSaveActionToolTip(string);
        guiMain.addSaveActionListener(this);
    }

    public void losingFocus() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this);
    }

    public boolean isEditable() {
        return true;
    }

    public boolean changesPending() {
        if (this.dataArray != null) {
            int n = 0;
            while (n < this.dataArray.length) {
                NasFilesystem nasFilesystem = this.dataArray[n];
                if (nasFilesystem.nflRepoAgentID != nasFilesystem.nflAgentID) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void saveAndClose() {
        this.closing = true;
        this.save();
    }

    private void save() {
        if (this.dataArray == null) {
            return;
        }
        HashMap<MutableInteger, NasFilesystem> hashMap = new HashMap<MutableInteger, NasFilesystem>();
        MutableInteger mutableInteger = new MutableInteger();
        NasFilesystem nasFilesystem = null;
        int n = 0;
        while (n < this.dataArray.length) {
            NasFilesystem nasFilesystem2 = this.dataArray[n];
            if (nasFilesystem2.nflRepoAgentID != nasFilesystem2.nflAgentID) {
                nasFilesystem2.nflDeleteFiler = false;
                nasFilesystem2.nflNext = nasFilesystem;
                nasFilesystem = nasFilesystem2;
                if (nasFilesystem2.nflAgentID == 0) {
                    mutableInteger.value = nasFilesystem2.nflComputerID;
                    if (hashMap.get(mutableInteger) == null) {
                        hashMap.put(mutableInteger, nasFilesystem2);
                        mutableInteger = new MutableInteger();
                    }
                }
            }
            ++n;
        }
        if (nasFilesystem != null) {
            String[] stringArray;
            this.updateArray = (NasFilesystem[])Packer.pack(nasFilesystem);
            if (!hashMap.isEmpty() && (stringArray = this.getFilerDeletes(hashMap, mutableInteger)) != null && !this.showConfirmDialog(stringArray)) {
                return;
            }
            Arrays.sort(this.updateArray, new ComputerComparator());
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.nas.NasGuiAgentHndlr";
            request.requestData = this.updateArray;
            request.flags = (byte)4;
            GuiClient.doRequest(this, request);
        }
    }

    private String[] getFilerDeletes(HashMap hashMap, MutableInteger mutableInteger) {
        int n = 0;
        while (n < this.dataArray.length) {
            NasFilesystem nasFilesystem = this.dataArray[n];
            if (nasFilesystem.nflAgentID != 0) {
                mutableInteger.value = nasFilesystem.nflComputerID;
                hashMap.remove(mutableInteger);
            }
            ++n;
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[hashMap.size()];
        int n2 = 0;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            NasFilesystem nasFilesystem = (NasFilesystem)iterator.next();
            nasFilesystem.nflDeleteFiler = true;
            stringArray[n2++] = nasFilesystem.nflServerName;
        }
        return stringArray;
    }

    private boolean showConfirmDialog(String[] stringArray) {
        String string = MessageLog.getMessageNoID("GUI0045L");
        String string2 = MessageLog.getMessageNoID("GUI0261L", null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        Color color = jPanel.getBackground();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setBackground(color);
        jTextArea.setText(string2);
        jTextArea.setFont(jTextArea.getFont().deriveFont(1));
        jPanel.add((Component)jTextArea, "North");
        JList<String> jList = new JList<String>(stringArray);
        jList.setBackground(color);
        jList.setVisibleRowCount(3);
        JComponent jComponent = stringArray.length > 3 ? new JScrollPane(jList) : jList;
        jPanel.add(jComponent, "Center");
        int n = JOptionPane.showConfirmDialog(guiMain.getFrame(), jPanel, string, 0);
        return n == 0;
    }

    public void handleResponse(short s, Response response) {
        boolean bl = this.closing;
        this.closing = false;
        if (s > 4) {
            return;
        }
        if (bl) {
            this.remove();
            return;
        }
        this.massageData((Object[])response.responseData);
        this.buildEditor();
        if (!this.dataRetrieved) {
            this.dataRetrieved = true;
            this.showAndAddListeners();
            return;
        }
        this.currentPanelReplaced();
        this.updateArray = null;
    }

    private void massageData(Object[] objectArray) {
        this.dataArray = (NasFilesystem[])objectArray[0];
        this.treeList = null;
        this.windowsAgents = null;
        int n = this.dataArray == null ? 0 : this.dataArray.length;
        if (n > 0) {
            String[] stringArray = new String[3];
            int n2 = 0;
            while (n2 < n) {
                NasFilesystem nasFilesystem = this.dataArray[n2];
                GComputer gComputer = GuiUtil.getComputer(nasFilesystem.nflComputerID);
                nasFilesystem.nflOsType = gComputer.gcOsType;
                nasFilesystem.nflManufacturer = gComputer.gcManufacturer;
                if (gComputer.gcManufacturer.toLowerCase().equals("unknown")) {
                    nasFilesystem.nflManufacturer = MessageLog.getMessageNoID("STG1020L");
                }
                if (gComputer.gcOsType == 8) {
                    nasFilesystem.nflNasBox = false;
                    NasFiler.parseNetWareName(gComputer.gcTSName, stringArray);
                    nasFilesystem.nflServerName = stringArray[0];
                    nasFilesystem.nflDomainName = stringArray[1];
                    nasFilesystem.nflTreeName = stringArray[2];
                } else {
                    nasFilesystem.nflNasBox = true;
                    nasFilesystem.nflServerName = gComputer.gcTSName;
                    nasFilesystem.nflTreeName = " ";
                }
                if (nasFilesystem.nflAgentID > 0) {
                    nasFilesystem.nflRepoAgentID = nasFilesystem.nflAgentID;
                    nasFilesystem.nflAgentName = GuiUtil.getComputer((int)nasFilesystem.nflAgentID).gcTSName;
                }
                ++n2;
            }
            Arrays.sort(this.dataArray, new TableComparator());
            this.windowsAgents = (NameList[])objectArray[2];
            n2 = 0;
            while (n2 < this.windowsAgents.length) {
                this.windowsAgents[n2].nlName = GuiUtil.getComputer((int)this.windowsAgents[n2].nlID2).gcTSName;
                ++n2;
            }
            NameListComparator nameListComparator = new NameListComparator();
            Arrays.sort(this.windowsAgents, nameListComparator);
            this.buildAgents((NameList[])objectArray[1], nameListComparator);
        }
    }

    private void buildAgents(NameList[] nameListArray, NameListComparator nameListComparator) {
        NasFilesystem nasFilesystem;
        if (nameListArray != null && nameListArray.length > 0) {
            int n;
            int n2;
            NameList nameList = null;
            NameList nameList2 = null;
            NameList nameList3 = null;
            NameList nameList4 = null;
            NameList nameList5 = null;
            int n3 = 0;
            while (n3 < nameListArray.length) {
                nameList3 = nameListArray[n3];
                if (nameList3.nlID3 == 68) {
                    if (nameList2 == null) {
                        nameList2 = nameList3;
                    } else {
                        nameList5.nlNext = nameList3;
                    }
                    nameList5 = nameList3;
                } else {
                    if (nameList == null) {
                        nameList = nameList3;
                    } else {
                        nameList4.nlNext = nameList3;
                    }
                    nameList4 = nameList3;
                }
                ++n3;
            }
            if (nameList5 != null) {
                nameList5.nlNext = null;
            }
            if (nameList4 != null) {
                nameList4.nlNext = null;
            }
            NameList nameList6 = nameList;
            while (nameList6 != null) {
                n2 = 0;
                nameList3 = nameList6;
                while (nameList6 != null && nameList6.nlID == nameList3.nlID) {
                    ++n2;
                    nameList6 = nameList6.nlNext;
                }
                ListNode listNode = new ListNode();
                listNode.next = this.treeList;
                this.treeList = listNode;
                listNode.ID = nameList3.nlID;
                listNode.name = nameList3.nlName;
                NameList[] nameListArray2 = new NameList[n2];
                listNode.agentArray = nameListArray2;
                n = 0;
                while (n < nameListArray2.length) {
                    nameList3.nlName = GuiUtil.getComputer((int)nameList3.nlID2).gcTSName;
                    nameListArray2[n] = nameList3;
                    nameList3 = nameList3.nlNext;
                    ++n;
                }
                Arrays.sort(nameListArray2, nameListComparator);
            }
            nasFilesystem = null;
            nameList6 = nameList2;
            while (nameList6 != null) {
                n2 = 0;
                nameList3 = nameList6;
                while (nameList6 != null && nameList6.nlID == nameList3.nlID) {
                    ++n2;
                    nameList6 = nameList6.nlNext;
                }
                n = 0;
                while (n < this.dataArray.length) {
                    if (this.dataArray[n].nflFsID == nameList3.nlID) {
                        nasFilesystem = this.dataArray[n];
                        break;
                    }
                    ++n;
                }
                if (n >= this.dataArray.length) continue;
                NameList[] nameListArray3 = nasFilesystem.nflSeenFromWindows ? new NameList[n2 + this.windowsAgents.length] : new NameList[n2];
                nasFilesystem.nflAgentArray = nameListArray3;
                int n4 = 0;
                while (n4 < n2) {
                    nameList3.nlName = GuiUtil.getComputer((int)nameList3.nlID2).gcTSName;
                    nameListArray3[n4] = nameList3;
                    nameList3 = nameList3.nlNext;
                    ++n4;
                }
                if (nasFilesystem.nflSeenFromWindows) {
                    System.arraycopy(this.windowsAgents, 0, nameListArray3, n2, this.windowsAgents.length);
                }
                Arrays.sort(nameListArray3, nameListComparator);
            }
        }
        int n = 0;
        while (n < this.dataArray.length) {
            nasFilesystem = this.dataArray[n];
            if (nasFilesystem.nflSeenFromWindows && nasFilesystem.nflAgentArray == null) {
                nasFilesystem.nflAgentArray = this.windowsAgents;
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.save();
    }

    private class TableComparator
    implements Comparator {
        private TableComparator() {
        }

        public int compare(Object object, Object object2) {
            NasFilesystem nasFilesystem = (NasFilesystem)object;
            NasFilesystem nasFilesystem2 = (NasFilesystem)object2;
            int n = Util.compareStrings(nasFilesystem.nflServerName, nasFilesystem2.nflServerName);
            if (n != 0) {
                return n;
            }
            n = Util.compareStrings(nasFilesystem.nflDomainName, nasFilesystem2.nflDomainName);
            if (n != 0) {
                return n;
            }
            n = Util.compareStrings(nasFilesystem.nflTreeName, nasFilesystem2.nflTreeName);
            if (n != 0) {
                return n;
            }
            return Util.compareStrings(nasFilesystem.nflFsName, nasFilesystem2.nflFsName);
        }
    }

    private class ComputerComparator
    implements Comparator {
        private ComputerComparator() {
        }

        public int compare(Object object, Object object2) {
            NasFilesystem nasFilesystem = (NasFilesystem)object;
            NasFilesystem nasFilesystem2 = (NasFilesystem)object2;
            int n = nasFilesystem.nflComputerID - nasFilesystem2.nflComputerID;
            if (n == 0) {
                n = nasFilesystem.nflAgentID - nasFilesystem2.nflAgentID;
            }
            return n;
        }
    }

    private class NameListComparator
    implements Comparator {
        private NameListComparator() {
        }

        public int compare(Object object, Object object2) {
            NameList nameList = (NameList)object;
            NameList nameList2 = (NameList)object2;
            return nameList.toString().compareTo(nameList2.toString());
        }
    }

    class ListNode {
        public ListNode next;
        public int ID;
        public String name;
        public NameList[] agentArray;

        ListNode() {
        }
    }
}

