/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.aperi.San.server.guireq.RespEndToEnd;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class EndToEndAdjuster
extends CustomReportDataAdjuster {
    public static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    public static final String DISK_ARRAY = MessageLog.getMessageNoID("STG5272L");
    public static final String LVFS_PATH = MessageLog.getMessageNoID("STG5273L");
    public static final String ARRAY_SIDE_PATH = MessageLog.getMessageNoID("SAG0645L");
    public static final String COMP_LUN_PATH = MessageLog.getMessageNoID("STG5276L");
    public static final String MANUFACTURER = MessageLog.getMessageNoID("STG1105L");
    public static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    public static final String SERIAL_NUMBER = MessageLog.getMessageNoID("STG1107L");
    public static final String PHYSICAL_ALLOC = MessageLog.getMessageNoID("STG5271L");
    public static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    public static final String FREE_SPACE = MessageLog.getMessageNoID("STG1184L");
    public static final String SSTYPE = MessageLog.getMessageNoID("SAG0036L");
    public static final String UNKNOWN = MessageLog.getMessageNoID("STG1020L");
    public static final String LUN_CAPACITY = MessageLog.getMessageNoID("STG7744L");
    public static final String UNALLOCATED = MessageLog.getMessageNoID("STG6083L");
    public static final String ALLOCATED = MessageLog.getMessageNoID("STG6084L");
    public static final String LUN_WWN = MessageLog.getMessageNoID("SAG0646L");
    public static final String DISK = MessageLog.getMessageNoID("STG1240L");
    public static final String[] namesArray1a = new String[]{COMPUTER, DISK_ARRAY, SSTYPE, PHYSICAL_ALLOC, LUN_CAPACITY, ALLOCATED, UNALLOCATED};
    public static final String[] namesArray1b = new String[]{DISK_ARRAY, SSTYPE, COMPUTER, PHYSICAL_ALLOC, LUN_CAPACITY, ALLOCATED, UNALLOCATED};
    public static final String[] namesArray2a = new String[]{COMPUTER, COMP_LUN_PATH, DISK_ARRAY, SSTYPE, ARRAY_SIDE_PATH, LUN_WWN, LUN_CAPACITY, ALLOCATED, UNALLOCATED};
    public static final String[] namesArray2b = new String[]{DISK_ARRAY, SSTYPE, ARRAY_SIDE_PATH, LUN_WWN, COMPUTER, COMP_LUN_PATH, LUN_CAPACITY, ALLOCATED, UNALLOCATED};
    public static final String[] namesArray3a = new String[]{COMPUTER, DISK_ARRAY, SSTYPE, DISK, MANUFACTURER, MODEL, SERIAL_NUMBER, PHYSICAL_ALLOC};
    public static final String[] namesArray3b = new String[]{DISK_ARRAY, SSTYPE, DISK, MANUFACTURER, MODEL, SERIAL_NUMBER, COMPUTER, PHYSICAL_ALLOC};
    public static final String[] namesArray4a = new String[]{COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, DISK_ARRAY, SSTYPE};
    public static final String[] namesArray4b = new String[]{DISK_ARRAY, SSTYPE, COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE};
    public static final String[] namesArray5a = new String[]{COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, COMP_LUN_PATH, DISK_ARRAY, SSTYPE, ARRAY_SIDE_PATH, LUN_CAPACITY, LUN_WWN};
    public static final String[] namesArray5b = new String[]{DISK_ARRAY, SSTYPE, ARRAY_SIDE_PATH, LUN_CAPACITY, LUN_WWN, COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, COMP_LUN_PATH};
    public static final String[] namesArray6a = new String[]{COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, DISK_ARRAY, SSTYPE, MANUFACTURER, MODEL, SERIAL_NUMBER, PHYSICAL_ALLOC};
    public static final String[] namesArray6b = new String[]{DISK_ARRAY, SSTYPE, DISK, MANUFACTURER, MODEL, SERIAL_NUMBER, COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, PHYSICAL_ALLOC};
    public String[] namesArray;
    public final int COMPUTER_COL;
    public final int DISK_ARRAY_COL;
    public final int SS_TYPE_COL;
    public final int LVFS_PATH_COL;
    public final int ARRAY_SIDE_PATH_COL;
    public final int COMP_LUN_PATH_COL;
    public final int MANUFACTURER_COL;
    public final int MODEL_COL;
    public final int SERIAL_NUMBER_COL;
    public final int PHYSICAL_ALLOC_COL;
    public final int CAPACITY_COL;
    public final int FREE_SPACE_COL;
    public final int LUN_ALLOCATED_COL;
    public final int LUN_CAPACITY_COL;
    public final int LUN_WWN_COL;
    public final int DISK_COL;
    public GuiReportReq grr;
    public RespEndToEnd[] endArray;
    public RespEndToEnd endNode;
    private int[] rendererArray;
    private MutableLong[] mLong;
    private boolean computerFirst = false;
    private boolean batch = false;
    private boolean checkDups = false;
    private boolean checkLUNDups = false;
    private boolean checkDiskDups = false;
    private int rows;
    public int frozenRows = 0;

    public EndToEndAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        if (guiReportReq.bySubtype <= 0) {
            guiReportReq.bySubtype = guiReportReq.reportSubtype == 12 || guiReportReq.reportSubtype == 73 ? 75 : 12;
        }
        if (guiReportReq.reportSubtype == 12 && guiReportReq.bySubtype == 74) {
            this.namesArray = namesArray1a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 1;
            this.SS_TYPE_COL = 2;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = 3;
            this.CAPACITY_COL = 4;
            this.FREE_SPACE_COL = 6;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = 5;
            this.DISK_COL = -777;
            this.computerFirst = true;
        } else if (guiReportReq.reportSubtype == 74 && guiReportReq.bySubtype == 12) {
            this.namesArray = namesArray1b;
            this.COMPUTER_COL = 2;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = 3;
            this.CAPACITY_COL = 4;
            this.FREE_SPACE_COL = 6;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = 5;
            this.DISK_COL = -777;
        } else if (guiReportReq.reportSubtype == 12 && guiReportReq.bySubtype == 75) {
            this.namesArray = namesArray2a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 2;
            this.SS_TYPE_COL = 3;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = 4;
            this.LUN_WWN_COL = 5;
            this.COMP_LUN_PATH_COL = 1;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 6;
            this.FREE_SPACE_COL = 8;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = 7;
            this.DISK_COL = -777;
            this.computerFirst = true;
        } else if (guiReportReq.reportSubtype == 75 && guiReportReq.bySubtype == 12) {
            this.namesArray = namesArray2b;
            this.COMPUTER_COL = 4;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = 2;
            this.LUN_WWN_COL = 3;
            this.COMP_LUN_PATH_COL = 5;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 6;
            this.FREE_SPACE_COL = 8;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = 7;
            this.DISK_COL = -777;
        } else if (guiReportReq.reportSubtype == 12 && guiReportReq.bySubtype == 76) {
            this.namesArray = namesArray3a;
            this.COMPUTER_COL = 0;
            this.DISK_COL = 3;
            this.DISK_ARRAY_COL = 1;
            this.SS_TYPE_COL = 2;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = 4;
            this.MODEL_COL = 5;
            this.SERIAL_NUMBER_COL = 6;
            this.PHYSICAL_ALLOC_COL = 7;
            this.CAPACITY_COL = -777;
            this.FREE_SPACE_COL = -777;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.computerFirst = true;
        } else if (guiReportReq.reportSubtype == 76 && guiReportReq.bySubtype == 12) {
            this.namesArray = namesArray3b;
            this.COMPUTER_COL = 6;
            this.DISK_ARRAY_COL = 0;
            this.DISK_COL = 2;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = 3;
            this.MODEL_COL = 4;
            this.SERIAL_NUMBER_COL = 5;
            this.PHYSICAL_ALLOC_COL = 7;
            this.CAPACITY_COL = -777;
            this.FREE_SPACE_COL = -777;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
        } else if (guiReportReq.reportSubtype == 73 && guiReportReq.bySubtype == 74) {
            this.namesArray = namesArray4a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 4;
            this.SS_TYPE_COL = 5;
            this.LVFS_PATH_COL = 1;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 2;
            this.FREE_SPACE_COL = 3;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.checkDups = true;
            this.computerFirst = true;
        } else if (guiReportReq.reportSubtype == 74 && guiReportReq.bySubtype == 73) {
            this.namesArray = namesArray4b;
            this.COMPUTER_COL = 2;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = 3;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 4;
            this.FREE_SPACE_COL = 5;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.checkDups = true;
        } else if (guiReportReq.reportSubtype == 73 && guiReportReq.bySubtype == 75) {
            this.namesArray = namesArray5a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 5;
            this.SS_TYPE_COL = 6;
            this.LVFS_PATH_COL = 1;
            this.ARRAY_SIDE_PATH_COL = 7;
            this.LUN_WWN_COL = 9;
            this.COMP_LUN_PATH_COL = 4;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 2;
            this.FREE_SPACE_COL = 3;
            this.LUN_CAPACITY_COL = 8;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.computerFirst = true;
            this.checkDups = true;
            this.checkLUNDups = true;
        } else if (guiReportReq.reportSubtype == 75 && guiReportReq.bySubtype == 73) {
            this.namesArray = namesArray5b;
            this.COMPUTER_COL = 5;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = 6;
            this.ARRAY_SIDE_PATH_COL = 2;
            this.LUN_WWN_COL = 4;
            this.COMP_LUN_PATH_COL = 9;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 7;
            this.FREE_SPACE_COL = 8;
            this.LUN_CAPACITY_COL = 3;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.checkDups = true;
            this.checkLUNDups = true;
        } else if (guiReportReq.reportSubtype == 73 && guiReportReq.bySubtype == 76) {
            this.namesArray = namesArray6a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 4;
            this.SS_TYPE_COL = 5;
            this.LVFS_PATH_COL = 1;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = 6;
            this.MODEL_COL = 7;
            this.SERIAL_NUMBER_COL = 8;
            this.PHYSICAL_ALLOC_COL = 9;
            this.CAPACITY_COL = 2;
            this.FREE_SPACE_COL = 3;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.computerFirst = true;
            this.checkDups = true;
            this.checkDiskDups = true;
        } else {
            this.namesArray = namesArray6b;
            this.COMPUTER_COL = 6;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = 7;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.DISK_COL = 2;
            this.MANUFACTURER_COL = 3;
            this.MODEL_COL = 4;
            this.SERIAL_NUMBER_COL = 5;
            this.PHYSICAL_ALLOC_COL = 10;
            this.CAPACITY_COL = 8;
            this.FREE_SPACE_COL = 9;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.checkDups = true;
            this.checkDiskDups = true;
        }
        this.rendererArray = new int[this.namesArray.length];
        if (this.PHYSICAL_ALLOC_COL >= 0) {
            this.rendererArray[this.PHYSICAL_ALLOC_COL] = 7;
        }
        if (this.CAPACITY_COL >= 0) {
            this.rendererArray[this.CAPACITY_COL] = 7;
        }
        if (this.FREE_SPACE_COL >= 0) {
            this.rendererArray[this.FREE_SPACE_COL] = 7;
        }
        if (this.LUN_CAPACITY_COL >= 0) {
            this.rendererArray[this.LUN_CAPACITY_COL] = 7;
        }
        if (this.LUN_ALLOCATED_COL >= 0) {
            this.rendererArray[this.LUN_ALLOCATED_COL] = 7;
        }
        this.frozenColumns = 1;
        this.namesArray = this.getCustomizedColNames(this.namesArray);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        if (this.computerFirst) {
            Arrays.sort(this.endArray, this.frozenRows, this.endArray.length, new ComputerSorter());
        } else {
            Arrays.sort(this.endArray, this.frozenRows, this.endArray.length, new DiskArraySorter());
        }
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.endArray = (RespEndToEnd[])objectArray;
        this.rows = this.endArray.length;
        if (this.rows > 1) {
            this.addTotal();
        }
        if (this.mLong == null) {
            this.mLong = new MutableLong[this.rows];
        }
        int n = 0;
        while (n < this.rows) {
            this.mLong[n] = new MutableLong();
            ++n;
        }
    }

    public void adjustData() {
        int n = 0;
        while (n < this.rows) {
            this.endNode = this.endArray[n];
            this.endNode.reePhysicalAlloc *= 512L;
            this.endNode.reeCapacity *= 512L;
            this.endNode.reeLUNCapacity *= 512L;
            this.endNode.reeFreeSpace *= 512L;
            ++n;
        }
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        ColumnDescriptor columnDescriptor = columnDescriptorArray[this.SS_TYPE_COL];
        columnDescriptor.cdValidValue = ColumnDescriptor.SS_TYPES;
    }

    public void replaceArray(Object object) {
        this.endArray = (RespEndToEnd[])object;
    }

    public Object getArray() {
        return this.endArray;
    }

    public int getNumberRows() {
        return this.endArray.length;
    }

    public int getNumberColumns() {
        return this.namesArray.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getCellData(int n, int n2) {
        Object object;
        if (n2 == this.COMPUTER_COL) {
            object = this.endArray[n].reeComputer;
        } else if (n2 == this.DISK_ARRAY_COL) {
            object = this.endArray[n].reeDiskArray;
        } else if (n2 == this.SS_TYPE_COL) {
            object = this.endArray[n].reeOSType > 0 ? (this.endArray[n].reeManufacturer != null && this.endArray[n].reeManufacturer.length() > 0 ? (this.endArray[n].reeManufacturer.toUpperCase().indexOf("HEWLETT") >= 0 || this.endArray[n].reeManufacturer.toUpperCase().indexOf("HP") >= 0 ? MessageLog.getMessageNoID(Constants.OSTYPES[18]) : MessageLog.getMessageNoID(Constants.OSTYPES[this.endArray[n].reeOSType])) : MessageLog.getMessageNoID(Constants.OSTYPES[this.endArray[n].reeOSType])) : " ";
        } else if (n2 == this.LVFS_PATH_COL) {
            object = this.endArray[n].reeLVFSPath;
        } else if (n2 == this.ARRAY_SIDE_PATH_COL) {
            if (this.endArray[n].reeArraySidePath == null) {
                object = UNKNOWN;
            } else {
                int n3;
                object = this.endArray[n].reeArraySidePath;
                if (this.endArray[n].reeOSType == 21 && (n3 = ((String)object).indexOf(":")) > 0) {
                    object = ((String)object).substring(0, n3);
                }
                if (this.endArray[n].reeOSType == 12) {
                    object = object.toString().substring(1);
                }
            }
        } else if (n2 == this.LUN_WWN_COL) {
            object = this.endArray[n].reeLUNWWN == null ? UNKNOWN : this.endArray[n].reeLUNWWN;
        } else if (n2 == this.COMP_LUN_PATH_COL) {
            object = this.endArray[n].reeCompLUNPath;
        } else if (n2 == this.MANUFACTURER_COL) {
            object = Util.isEmpty(this.endArray[n].reeManufacturer) ? UNKNOWN : this.endArray[n].reeManufacturer;
        } else if (n2 == this.MODEL_COL) {
            object = Util.isEmpty(this.endArray[n].reeModel) ? UNKNOWN : this.endArray[n].reeModel;
        } else if (n2 == this.SERIAL_NUMBER_COL) {
            object = Util.isEmpty(this.endArray[n].reeSerialNumber) ? String.valueOf(this.endArray[n].reeArraySidePath) + '-' + this.endArray[n].reeDiskArrayName : this.endArray[n].reeSerialNumber;
        } else if (n2 == this.PHYSICAL_ALLOC_COL) {
            this.mLong[n].value = this.endArray[n].reePhysicalAlloc;
            object = this.mLong[n];
        } else if (n2 == this.CAPACITY_COL) {
            this.mLong[n].value = this.endArray[n].reeCapacity;
            object = this.mLong[n];
        } else if (n2 == this.FREE_SPACE_COL) {
            this.mLong[n].value = this.endArray[n].reeFreeSpace;
            object = this.mLong[n];
        } else if (n2 == this.LUN_CAPACITY_COL) {
            this.mLong[n].value = this.endArray[n].reeLUNCapacity;
            object = this.mLong[n];
        } else if (n2 == this.LUN_ALLOCATED_COL) {
            this.mLong[n].value = this.endArray[n].reeFreeSpace < 0L ? -1L : this.endArray[n].reeCapacity - this.endArray[n].reeFreeSpace;
            object = this.mLong[n];
        } else {
            object = n2 == this.DISK_COL ? this.endArray[n].reeArraySidePath : null;
        }
        return object;
    }

    private void addTotal() {
        StringBuffer stringBuffer;
        HashMap<String, String> hashMap;
        StringBuffer stringBuffer2;
        HashMap<String, String> hashMap2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<MutableInteger, MutableInteger> hashMap3 = this.checkDups ? new HashMap<MutableInteger, MutableInteger>() : null;
        if (this.checkLUNDups) {
            hashMap2 = new HashMap<String, String>();
            stringBuffer2 = new StringBuffer(100);
        } else {
            hashMap2 = null;
            stringBuffer2 = null;
        }
        if (this.checkDiskDups) {
            hashMap = new HashMap<String, String>();
            stringBuffer = new StringBuffer(100);
        } else {
            hashMap = null;
            stringBuffer = null;
        }
        this.bHasTotalRow = true;
        RespEndToEnd[] respEndToEndArray = new RespEndToEnd[this.rows + 1];
        respEndToEndArray[0] = this.endNode = new RespEndToEnd();
        if (this.computerFirst) {
            this.endNode.reeComputer = MessageLog.getMessageNoID("STG4136L");
            this.endNode.reeDiskArray = " ";
        } else {
            this.endNode.reeComputer = " ";
            this.endNode.reeDiskArray = MessageLog.getMessageNoID("STG4136L");
        }
        this.endNode.reeLVFSPath = " ";
        this.endNode.reeArraySidePath = " ";
        this.endNode.reeCompLUNPath = " ";
        this.endNode.reeManufacturer = "  ";
        this.endNode.reeModel = "  ";
        this.endNode.reeSerialNumber = "  ";
        this.endNode.reeLUNWWN = "  ";
        this.endNode.reeOSType = (short)-1;
        int n = 0;
        while (n < this.rows) {
            MutableInteger mutableInteger;
            if (this.checkDups) {
                int n2 = (int)this.endArray[n].reeFilesystemID;
                if (n2 <= 0) {
                    n2 = this.endArray[n].reeLogicalDiskID;
                }
                if (n2 <= 0) {
                    bl = true;
                } else {
                    bl = false;
                    mutableInteger = new MutableInteger(n2);
                    Object v = hashMap3.get(mutableInteger);
                    if (v != null) {
                        bl = true;
                    } else {
                        hashMap3.put(mutableInteger, mutableInteger);
                    }
                }
            }
            if (this.checkLUNDups) {
                bl2 = false;
                String string = this.endArray[n].reeUniqueID;
                if (Util.isEmpty(string)) {
                    stringBuffer2.setLength(0);
                    stringBuffer2.append(this.endArray[n].reeArraySidePath);
                    stringBuffer2.append(this.endArray[n].reeDiskArrayName);
                    string = stringBuffer.toString();
                }
                if ((mutableInteger = hashMap2.get(string)) != null) {
                    bl2 = true;
                } else {
                    hashMap2.put(string, string);
                }
            }
            if (this.checkDiskDups) {
                bl3 = false;
                stringBuffer.setLength(0);
                stringBuffer.append(this.endArray[n].reeDiskArrayName);
                stringBuffer.append(this.endArray[n].reeUniqueID);
                stringBuffer.append(this.endArray[n].reeArraySidePath);
                String string = stringBuffer.toString();
                mutableInteger = hashMap.get(string);
                if (mutableInteger != null) {
                    bl3 = true;
                } else {
                    hashMap.put(string, string);
                }
            }
            if (!bl3 && this.endArray[n].reePhysicalAlloc > 0L) {
                this.endNode.reePhysicalAlloc += this.endArray[n].reePhysicalAlloc;
            }
            if (!bl) {
                if (this.endArray[n].reeCapacity > 0L) {
                    this.endNode.reeCapacity += this.endArray[n].reeCapacity;
                }
                if (this.endArray[n].reeFreeSpace > 0L) {
                    this.endNode.reeFreeSpace += this.endArray[n].reeFreeSpace;
                }
            }
            if (!bl2) {
                this.endNode.reeLUNCapacity += this.endArray[n].reeLUNCapacity;
            }
            respEndToEndArray[n + 1] = this.endArray[n];
            ++n;
        }
        this.endArray = respEndToEndArray;
        this.frozenRows = 1;
        ++this.rows;
    }

    private class ComputerSorter
    implements Comparator {
        private ComputerSorter() {
        }

        public int compare(Object object, Object object2) {
            RespEndToEnd respEndToEnd = (RespEndToEnd)object;
            RespEndToEnd respEndToEnd2 = (RespEndToEnd)object2;
            return respEndToEnd.reeComputer.compareTo(respEndToEnd2.reeComputer);
        }
    }

    private class DiskArraySorter
    implements Comparator {
        private DiskArraySorter() {
        }

        public int compare(Object object, Object object2) {
            RespEndToEnd respEndToEnd = (RespEndToEnd)object;
            RespEndToEnd respEndToEnd2 = (RespEndToEnd)object2;
            return respEndToEnd.reeDiskArray.compareTo(respEndToEnd2.reeDiskArray);
        }
    }
}

