/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeAdjuster
extends CustomReportDataAdjuster {
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String MOUNTPNT = MessageLog.getMessageNoID("STG1230L");
    private static final String DETECTABLE = MessageLog.getMessageNoID("STG7748L");
    private static final String PATH = MessageLog.getMessageNoID("STG1219L");
    private static final String TYPE = MessageLog.getMessageNoID("STG1132L");
    private static final String SIZE = MessageLog.getMessageNoID("STG1231L");
    private static final String CAPACITY = MessageLog.getMessageNoID("STG1220L");
    public static final String USED = MessageLog.getMessageNoID("STG1237L");
    public static final String FREE = MessageLog.getMessageNoID("STG1184L");
    private static final String PROBE_TIME = MessageLog.getMessageNoID("STG1182L");
    private static final String SCAN_TIME = MessageLog.getMessageNoID("STG1233L");
    private static final String DISCOVERED_TIME = MessageLog.getMessageNoID("STG1134L");
    private static final String LV_CAPACITY = MessageLog.getMessageNoID("STG3258L");
    private static final String OVERHEAD = MessageLog.getMessageNoID("STG6054L");
    public static final String[] COL_NAMES = new String[]{COMPUTER, MOUNTPNT, DETECTABLE, USED, FREE, CAPACITY, SIZE, LV_CAPACITY, OVERHEAD, SCAN_TIME, PROBE_TIME, DISCOVERED_TIME, TYPE, PATH};
    private static final int COMPUTER_COL = 0;
    private static final int MOUNTPNT_COL = 1;
    private static final int DETECTABLE_COL = 2;
    private static final int USED_COL = 3;
    private static final int FREE_COL = 4;
    private static final int CAPACITY_COL = 5;
    private static final int SIZE_COL = 6;
    private static final int LV_CAPACITY_COL = 7;
    private static final int OVERHEAD_COL = 8;
    private static final int SCAN_TIME_COL = 9;
    private static final int PROBE_TIME_COL = 10;
    private static final int DISCOVERED_TIME_COL = 11;
    private static final int TYPE_COL = 12;
    private static final int PATH_COL = 13;
    private Share[] shArray;
    private MutableLong[] mLong;
    private Date[] mDate;
    private Filesystem noFS = new Filesystem();
    private GuiReportReq grr;
    private int[] rendererArray;
    private int[] columnMap;
    public String[] colNames;
    private boolean batch;
    public int frozenRows;
    private boolean bHasTotalRow = false;
    private int rowCount;

    public LogicalVolumeAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.noFS.fsID = -2;
        this.noFS.fsComputerID = -2;
        this.noFS.fsGroupID = -2;
        this.noFS.fsLogicalDiskID = -2;
        this.noFS.fsLogDiskID = -2;
        this.noFS.fsMaxFiles = -2;
        this.noFS.fsUsedInodes = -2;
        this.noFS.fsFreeInodes = -2;
        this.noFS.fsPhysicalSize = -2L;
        this.noFS.fsCapacity = -2L;
        this.noFS.fsUsedSpace = -2L;
        this.noFS.fsFreeSpace = -2L;
        this.noFS.fsScanTime = 0L;
        this.noFS.fsType = (short)-1;
        this.noFS.fsUseCount = (short)-2;
        this.noFS.fsMountPoint = " ";
        this.noFS.fsDiscoveredTime = 0L;
        if (this.grr.reportSubtype != 21) {
            this.colNames = COL_NAMES;
            this.columnMap = null;
        } else {
            this.colNames = new String[7];
            this.colNames[0] = COMPUTER;
            this.colNames[1] = PATH;
            this.colNames[2] = DETECTABLE;
            this.colNames[3] = LV_CAPACITY;
            this.colNames[4] = OVERHEAD;
            this.colNames[5] = TYPE;
            this.colNames[6] = PROBE_TIME;
            this.columnMap = new int[7];
            this.columnMap[0] = 0;
            this.columnMap[1] = 13;
            this.columnMap[2] = 2;
            this.columnMap[3] = 7;
            this.columnMap[4] = 8;
            this.columnMap[5] = 12;
            this.columnMap[6] = 10;
        }
        this.frozenColumns = 2;
        int[] nArray = new int[COL_NAMES.length];
        nArray[3] = 7;
        nArray[4] = 7;
        nArray[5] = 7;
        nArray[6] = 7;
        nArray[7] = 7;
        nArray[8] = 7;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        if (this.grr.reportSubtype != 21) {
            this.rendererArray = nArray;
        } else {
            this.rendererArray = new int[this.columnMap.length];
            int n = 0;
            while (n < this.rendererArray.length) {
                this.rendererArray[n] = nArray[this.columnMap[n]];
                ++n;
            }
            nArray = null;
        }
        switch (this.grr.reportSubtype) {
            case 17: {
                this.firstColumn = 4;
                break;
            }
            case 18: {
                this.firstColumn = 10;
                break;
            }
            case 19: {
                this.firstColumn = 9;
                break;
            }
            case 37: {
                this.firstColumn = 11;
            }
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        if (this.bHasTotalRow) {
            this.shArray[0].shComputerName = MessageLog.getMessageNoID("STG4136L");
        }
        if (this.grr.reportSubtype == 2 || this.grr.reportSubtype == 20 || this.grr.reportSubtype == 21) {
            Arrays.sort(this.shArray, this.frozenRows, this.shArray.length, new Sorter());
        }
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.shArray = (Share[])objectArray;
        this.rowCount = this.shArray.length;
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.mLong = new MutableLong[this.rowCount];
        this.mDate = new Date[this.rowCount];
        int n = 0;
        while (n < this.rowCount) {
            this.mDate[n] = new Date();
            this.mLong[n] = new MutableLong();
            ++n;
        }
    }

    public void adjustData() {
        int n = 0;
        while (n < this.rowCount) {
            Share share = this.shArray[n];
            share.shLogicalDisk = (LogicalDisk)share.shResource;
            share.shFilesystem = share.shLogicalDisk.ldFilesystem;
            if (share.shFilesystem == null) {
                share.shFilesystem = this.noFS;
            } else {
                share.shFilesystem.fsPhysicalSize *= 512L;
                share.shFilesystem.fsCapacity *= 512L;
                share.shFilesystem.fsUsedSpace *= 512L;
                share.shFilesystem.fsFreeSpace *= 512L;
            }
            share.shLogicalDisk.ldCapacity *= 512L;
            share.shLogicalDisk.ldOverhead *= 512L;
            if (!this.batch) {
                share.shComputerName = GuiUtil.getComputer((int)share.shComputerID).gcTSName;
            }
            ++n;
        }
    }

    public void undo() {
        Share share = this.shArray[0];
        if (share.shFilesystem != this.noFS) {
            share.shFilesystem.fsPhysicalSize /= 512L;
            share.shFilesystem.fsCapacity /= 512L;
            share.shFilesystem.fsUsedSpace /= 512L;
            share.shFilesystem.fsFreeSpace /= 512L;
        }
        share.shLogicalDisk.ldCapacity /= 512L;
        share.shLogicalDisk.ldOverhead /= 512L;
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        int n = 12;
        if (this.columnMap != null) {
            n = -1;
            int n2 = 0;
            while (n2 < this.columnMap.length) {
                if (12 == this.columnMap[n2]) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (n >= 0) {
            columnDescriptorArray[n].cdValidValue = ColumnDescriptor.FSLV_TYPES;
        }
    }

    public Object getArray() {
        return this.shArray;
    }

    public int getNumberRows() {
        return this.shArray.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public boolean hasTotalsRow() {
        return this.bHasTotalRow;
    }

    private String displayedType(Share share) {
        String[] stringArray;
        int n;
        if (share.shFilesystem != this.noFS) {
            n = share.shFilesystem.fsType + 1;
            stringArray = Filesystem.TYPES;
        } else {
            n = share.shLogicalDisk.ldType;
            stringArray = LogicalDisk.TYPES;
        }
        String string = " ";
        try {
            string = stringArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return string;
    }

    public Object getCellData(int n, int n2) {
        int n3 = this.columnMap == null ? n2 : this.columnMap[n2];
        switch (n3) {
            case 0: {
                return this.shArray[n].shComputerName;
            }
            case 2: {
                if (this.bHasTotalRow && n > 0 || !this.bHasTotalRow) {
                    return Constants.isFSLVDetectable(this.shArray[n].shLogicalDisk.ldID, this.shArray[n].shRemovedTime) ? MessageLog.getMessageNoID("GUI0121T") : MessageLog.getMessageNoID("GUI0122T");
                }
                return " ";
            }
            case 13: {
                return this.shArray[n].shPath;
            }
            case 1: {
                return this.shArray[n].shFilesystem.fsMountPoint;
            }
            case 12: {
                return this.displayedType(this.shArray[n]);
            }
            case 6: {
                this.mLong[n].value = this.shArray[n].shFilesystem.fsPhysicalSize;
                return this.mLong[n];
            }
            case 5: {
                this.mLong[n].value = this.shArray[n].shFilesystem.fsCapacity;
                return this.mLong[n];
            }
            case 3: {
                this.mLong[n].value = this.shArray[n].shFilesystem.fsUsedSpace;
                return this.mLong[n];
            }
            case 4: {
                this.mLong[n].value = this.shArray[n].shFilesystem.fsFreeSpace;
                return this.mLong[n];
            }
            case 7: {
                this.mLong[n].value = this.shArray[n].shLogicalDisk.ldCapacity;
                return this.mLong[n];
            }
            case 8: {
                this.mLong[n].value = this.shArray[n].shLogicalDisk.ldOverhead;
                return this.mLong[n];
            }
            case 10: {
                this.mDate[n].setTime(this.shArray[n].shScanTime);
                if (this.mDate[n].getTime() < 0L) {
                    return NA;
                }
                return this.mDate[n];
            }
            case 9: {
                this.mDate[n].setTime(this.shArray[n].shFilesystem.fsScanTime);
                if (this.mDate[n].getTime() < 0L) {
                    return NA;
                }
                return this.mDate[n];
            }
            case 11: {
                this.mDate[n].setTime(this.shArray[n].shFilesystem.fsDiscoveredTime);
                if (this.mDate[n].getTime() < 0L) {
                    return NA;
                }
                return this.mDate[n];
            }
        }
        return null;
    }

    private void addTotal() {
        this.bHasTotalRow = true;
        Share[] shareArray = new Share[this.rowCount + 1];
        Share share = new Share();
        Filesystem filesystem = new Filesystem();
        LogicalDisk logicalDisk = new LogicalDisk();
        share.shResource = logicalDisk;
        logicalDisk.ldFilesystem = filesystem;
        share.shPath = "";
        filesystem.fsMountPoint = "";
        filesystem.fsType = (short)-2;
        filesystem.fsID = 777;
        shareArray[0] = share;
        int n = 0;
        while (n < this.rowCount) {
            LogicalDisk logicalDisk2 = (LogicalDisk)this.shArray[n].shResource;
            Filesystem filesystem2 = logicalDisk2.ldFilesystem;
            if (filesystem2 != null) {
                filesystem.fsPhysicalSize += filesystem2.fsPhysicalSize;
                filesystem.fsCapacity += filesystem2.fsCapacity;
                filesystem.fsUsedSpace += filesystem2.fsUsedSpace;
                filesystem.fsFreeSpace += filesystem2.fsFreeSpace;
            }
            logicalDisk.ldCapacity += logicalDisk2.ldCapacity;
            logicalDisk.ldOverhead += logicalDisk2.ldOverhead;
            shareArray[n + 1] = this.shArray[n];
            ++n;
        }
        this.shArray = shareArray;
        this.frozenRows = 1;
        ++this.rowCount;
    }

    public int[] getSelectedIDs() {
        if (this.grr.reportSubtype == 21) {
            return null;
        }
        int[] nArray = new int[this.shArray.length];
        int n = 0;
        while (n < this.shArray.length) {
            Share share = this.shArray[n];
            int n2 = share.shFilesystem != null ? share.shFilesystem.fsID : -1;
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    private class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object object, Object object2) {
            Share share = (Share)object;
            Share share2 = (Share)object2;
            int n = share.shComputerName.compareTo(share2.shComputerName);
            if (n > 0) {
                return 1;
            }
            if (n < 0) {
                return -1;
            }
            return share.shFilesystem.fsMountPoint.compareTo(share2.shFilesystem.fsMountPoint);
        }
    }
}

