/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class SectionedConfigParser {
    private String fileName;
    private String[] sectionNames;
    private String[][][] keywordValues;
    private BufferedReader reader;
    private StreamTokenizer tokenizer;
    private String[] keyValuePair = new String[2];
    private String currentSection;
    public static final int EOF = -1;

    public SectionedConfigParser(String string, String[] stringArray, String[][][] stringArray2) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "SectionedConfigParser", "fileName, sectionNames, keywordValues");
        }
        this.fileName = string;
        this.sectionNames = stringArray;
        this.keywordValues = stringArray2;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "SectionedConfigParser", fileNotFoundException);
            }
            this.throwException("GEN0131E", string, null);
        }
        this.tokenizer = new StreamTokenizer(bufferedReader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(47, 47);
        this.tokenizer.wordChars(92, 92);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.lowerCaseMode(false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "SectionedConfigParser");
        }
    }

    public int nextSection() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "nextSection", "");
        }
        try {
            int n;
            while (this.nextToken(false, 91) != -1) {
                this.nextToken(true, -3);
                this.currentSection = this.tokenizer.sval;
                this.nextToken(true, 93);
                n = 0;
                while (n < this.sectionNames.length) {
                    if (this.currentSection.equalsIgnoreCase(this.sectionNames[n])) {
                        this.parseSection(this.keywordValues[n]);
                        int n2 = n;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit(clazz.getName(), "nextSection", n2);
                        }
                        return n2;
                    }
                    ++n;
                }
                this.throwException("GEN0132E", this.currentSection, null);
            }
            n = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "nextSection", n);
            }
            return n;
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "nextSection", localizableException);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "nextSection");
            }
            throw localizableException;
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "nextSection", iOException);
            }
            Object[] objectArray = new Object[]{this.fileName};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "nextSection");
            }
            throw new NestableException("GEN0133E", objectArray, iOException);
        }
    }

    public void close() {
        block11: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry(clazz.getName(), "close", "");
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block11;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception(clazz.getName(), "close", iOException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "close");
        }
    }

    private void parseSection(String[][] stringArray) throws LocalizableException, IOException {
        while (this.getKeyValuePair()) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.keyValuePair[0].equalsIgnoreCase(stringArray[n][0])) {
                    stringArray[n][1] = this.keyValuePair[1];
                    break;
                }
                ++n;
            }
            if (n < stringArray.length) continue;
            this.throwException("GEN0134E", this.currentSection, this.keyValuePair[0]);
        }
    }

    private int nextToken(boolean bl, int n) throws LocalizableException, IOException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "nextToken", "tokenRequired, expectedTokenType");
        }
        if (this.tokenizer.ttype != -1) {
            this.tokenizer.nextToken();
        }
        if (this.tokenizer.ttype == -1) {
            if (bl) {
                this.throwException("GEN0135E", null, null);
            }
        } else {
            if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == 39) {
                this.tokenizer.ttype = -3;
            }
            if (n != 0 && n != this.tokenizer.ttype) {
                this.throwException("GEN0134E", this.currentSection, this.tokenizer.toString());
            }
        }
        int n2 = this.tokenizer.ttype;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "nextToken", n2);
        }
        return n2;
    }

    private boolean getKeyValuePair() throws LocalizableException, IOException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getKeyValuePair", "");
        }
        if (this.nextToken(false, 0) == -1) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "getKeyValuePair", bl);
            }
            return bl;
        }
        if (this.tokenizer.ttype == 91) {
            this.tokenizer.pushBack();
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "getKeyValuePair", bl);
            }
            return bl;
        }
        if (this.tokenizer.ttype != -3) {
            this.throwException("GEN0136E", this.tokenizer.toString(), null);
        }
        this.keyValuePair[0] = this.tokenizer.sval.toLowerCase();
        this.nextToken(true, 61);
        this.nextToken(true, -3);
        this.keyValuePair[1] = this.tokenizer.sval;
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SectionedConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "getKeyValuePair", bl);
        }
        return bl;
    }

    private void throwException(String string, String string2, String string3) throws LocalizableException {
        Object[] objectArray = new Object[]{this.fileName, string2, string3};
        throw new LocalizableException(string, objectArray);
    }
}

