/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.File;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.xmsg.IntlMessageFormat;
import org.eclipse.aperi.xmsg.MessageBundleManager;
import org.eclipse.aperi.xmsg.MessageLog;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final DecimalFormat dFmt;
    private static final DecimalFormat d0Fmt;
    private static final DecimalFormat d2Fmt;
    private static final String NA;
    private static final String MHZ;
    private static final String KB;
    private static final String MB;
    private static final String GB;
    private static final String TB;
    public static final String BUNDLE_SRC_EXTENSION_POINT_ID = "org.eclipse.aperi.common.guiMessageSources";
    private static final ResourceBundle defaultBundle;
    private static final MessageBundleManager manager;

    static {
        Class<?> clazz;
        dFmt = new DecimalFormat();
        d0Fmt = new DecimalFormat("###0");
        d2Fmt = new DecimalFormat("###0.00");
        NA = MessageLog.getMessageNoID("STG0019T");
        MHZ = MessageLog.getMessageNoID("GEN0186T");
        KB = MessageLog.getMessageNoID("GEN0188T");
        MB = MessageLog.getMessageNoID("GEN0189T");
        GB = MessageLog.getMessageNoID("GEN0190T");
        TB = MessageLog.getMessageNoID("GEN0191T");
        try {
            clazz = Class.forName("org.eclipse.aperi.xmsg.GuiResources");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        defaultBundle = ResourceBundle.getBundle(clazz.getName());
        manager = new MessageBundleManager(BUNDLE_SRC_EXTENSION_POINT_ID);
        manager.initialize();
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        return n == 0 || n == 1 && string.charAt(0) == ' ';
    }

    public static boolean stringsEqual(String string, String string2) {
        boolean bl = Util.isEmpty(string);
        boolean bl2 = Util.isEmpty(string2);
        if (bl || bl2) {
            return bl == bl2;
        }
        return string.equals(string2);
    }

    public static boolean stringStartsWith(String string, String string2) {
        boolean bl = Util.isEmpty(string);
        boolean bl2 = Util.isEmpty(string2);
        if (bl || bl2) {
            return false;
        }
        return string.startsWith(string2);
    }

    public static int compareStrings(String string, String string2) {
        boolean bl = Util.isEmpty(string);
        boolean bl2 = Util.isEmpty(string2);
        if (bl || bl2) {
            if (bl && bl2) {
                return 0;
            }
            if (bl) {
                return -1;
            }
            return 1;
        }
        return string.compareTo(string2);
    }

    public static boolean stringsEqualIgnoreCase(String string, String string2) {
        boolean bl = Util.isEmpty(string);
        boolean bl2 = Util.isEmpty(string2);
        if (bl || bl2) {
            return bl == bl2;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static String nextWord(String string, MutableInteger mutableInteger) {
        int n = mutableInteger.value;
        int n2 = string.length();
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n >= n2) {
            return null;
        }
        int n3 = n;
        while (n < n2 && !Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        mutableInteger.value = n;
        return string.substring(n3, n);
    }

    public static String convertTZ(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        String[] stringArray = TimeZone.getAvailableIDs(timeZone.getRawOffset());
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() == 3 && timeZone.useDaylightTime() == TimeZone.getTimeZone(stringArray[n]).useDaylightTime()) {
                return stringArray[n];
            }
            ++n;
        }
        return "GMT";
    }

    public static String getDotName(String string, String string2) {
        return Util.joinName(string, string2, '.');
    }

    public static String joinName(String string, String string2, String string3) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(80);
        boolean bl2 = string != null && !string.equals(" ");
        boolean bl3 = bl = string2 != null && !string2.equals(" ");
        if (bl2) {
            stringBuffer.append(string);
        }
        if (bl2 && bl) {
            stringBuffer.append(string3);
        }
        if (bl) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String joinName(String string, String string2, char c) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(80);
        boolean bl2 = string != null && !string.equals(" ");
        boolean bl3 = bl = string2 != null && !string2.equals(" ");
        if (bl2) {
            stringBuffer.append(string);
        }
        if (bl2 && bl) {
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String formatBytes(long l) {
        return Util.formatBytes(l, true);
    }

    public static String formatBytes(long l, boolean bl) {
        DecimalFormat decimalFormat = bl ? d2Fmt : d0Fmt;
        String string = new String();
        string = l < 0L ? NA : (l < 1024L ? new StringBuffer(String.valueOf(dFmt.format(l))).append("      ").toString() : ((double)l < 1048576.0 ? new StringBuffer(String.valueOf(decimalFormat.format((double)l / 1024.0))).append(" ").append(KB).toString() : ((double)l < 1.073741824E9 ? new StringBuffer(String.valueOf(decimalFormat.format((double)l / 1048576.0))).append(" ").append(MB).toString() : ((double)l < 1.099511627776E12 ? new StringBuffer(String.valueOf(decimalFormat.format((double)l / 1.073741824E9))).append(" ").append(GB).toString() : new StringBuffer(String.valueOf(decimalFormat.format((double)(l /= 0x100000L) / 1048576.0))).append(" ").append(TB).toString()))));
        return string;
    }

    public static String formatPrefBytes(long l, boolean bl) {
        DecimalFormat decimalFormat;
        DecimalFormat decimalFormat2 = decimalFormat = bl ? d2Fmt : d0Fmt;
        if (Variables.spaceUnits == 0) {
            return Util.formatBytes(l);
        }
        if (l < 0L) {
            return NA;
        }
        if (Variables.spaceUnits == 1) {
            return new StringBuffer(String.valueOf(decimalFormat.format((double)l / 1024.0))).append(" ").append(KB).toString();
        }
        if (Variables.spaceUnits == 2) {
            return new StringBuffer(String.valueOf(decimalFormat.format((double)l / 1048576.0))).append(" ").append(MB).toString();
        }
        if (Variables.spaceUnits == 3) {
            return new StringBuffer(String.valueOf(decimalFormat.format((double)l / 1.073741824E9))).append(" ").append(GB).toString();
        }
        return new StringBuffer(String.valueOf(decimalFormat.format((double)(l /= 0x100000L) / 1048576.0))).append(" ").append(TB).toString();
    }

    public static String formatPrefBytes(long l) {
        return Util.formatPrefBytes(l, true);
    }

    public static String formatHertz(int n) {
        String string = n <= 0 ? NA : new StringBuffer(String.valueOf(Integer.toString(n))).append(" ").append(MHZ).toString();
        return string;
    }

    public static void formatLine(String string, StringBuffer stringBuffer, Object[] objectArray) {
        int n = 0;
        while (n < string.length()) {
            int n2;
            char c = string.charAt(n);
            if (c == '{') {
                n2 = 0;
                while (Character.isDigit(string.charAt(++n))) {
                    n2 *= 10;
                    n2 += string.charAt(n) - 48;
                }
                Object object = objectArray[n2];
                if (object == null || object.equals("")) {
                    object = "<text unavailable>";
                }
                stringBuffer.append(object.toString());
            } else if (c == '[') {
                n2 = 0;
                while (Character.isDigit(string.charAt(++n))) {
                    n2 *= 10;
                    n2 += string.charAt(n) - 48;
                }
                stringBuffer.append(objectArray[n2].toString());
            } else if (c == '\'') {
                n2 = string.charAt(n + 1);
                if (n2 == 39) {
                    stringBuffer.append(c);
                    ++n;
                } else {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
    }

    public static void formatLine(String string, StringBuffer stringBuffer, Map<Integer, Object> map) {
        int n = 0;
        while (n < string.length()) {
            int n2;
            char c = string.charAt(n);
            if (c == '{') {
                n2 = 0;
                while (Character.isDigit(string.charAt(++n))) {
                    n2 *= 10;
                    n2 += string.charAt(n) - 48;
                }
                Object object = map.get(n2);
                if (object == null || object.equals("")) {
                    object = "<text unavailable>";
                }
                stringBuffer.append(object.toString());
            } else if (c == '[') {
                n2 = 0;
                while (Character.isDigit(string.charAt(++n))) {
                    n2 *= 10;
                    n2 += string.charAt(n) - 48;
                }
                stringBuffer.append(map.get(n2).toString());
            } else if (c == '\'') {
                n2 = string.charAt(n + 1);
                if (n2 == 39) {
                    stringBuffer.append(c);
                    ++n;
                } else {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
    }

    public static String formatDateTime(Date date) {
        return DateFormat.getDateTimeInstance(3, 3).format(date);
    }

    public static String formatTimeStamp(Date date) {
        return DateFormat.getDateTimeInstance(2, 0).format(date);
    }

    public static String formatTimeZone(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        int n = 3600000;
        int n2 = timeZone.getRawOffset();
        Integer n3 = new Integer(n2 / n);
        boolean bl = timeZone.useDaylightTime();
        String string2 = timeZone.getDisplayName(bl, 0);
        if (!bl) {
            String string3 = n3.toString();
            int n4 = string3.length();
            String[] stringArray = TimeZone.getAvailableIDs(n3 * n);
            int n5 = 0;
            while (n5 < stringArray.length) {
                String string4 = TimeZone.getTimeZone(stringArray[n5]).getDisplayName(bl, 0);
                if (string4.compareTo(string2) == 0) {
                    n5 = stringArray.length;
                } else if (n3 > 0 ? string2.indexOf(string3.substring(0, n4)) != -1 : string2.indexOf(string3.substring(1, n4)) != -1) {
                    n5 = stringArray.length;
                    string2 = string4;
                }
                ++n5;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static void breakIntoThree(String string, String[] stringArray) {
        Util.breakIntoTwo(string, stringArray);
        if (stringArray[1].length() == 1) {
            stringArray[2] = " ";
        } else {
            String string2 = stringArray[0];
            Util.breakIntoTwo(stringArray[1], stringArray);
            stringArray[2] = stringArray[1];
            stringArray[1] = stringArray[0];
            stringArray[0] = string2;
        }
    }

    public static void breakIntoTwo(String string, String[] stringArray) {
        if (string == null || string.length() == 0) {
            stringArray[0] = " ";
            stringArray[1] = " ";
        } else if (string.charAt(0) == '\n') {
            stringArray[0] = " ";
            stringArray[1] = string.length() < 2 ? " " : string.substring(1);
        } else {
            stringArray[0] = string;
            stringArray[1] = " ";
            int n = 1;
            while (n < string.length()) {
                if (string.charAt(n) == '\n') {
                    stringArray[0] = string.substring(0, n);
                    if (++n >= string.length()) break;
                    stringArray[1] = string.substring(n);
                    break;
                }
                ++n;
            }
        }
    }

    public static List splitLine(String string, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = string.length();
        boolean bl = true;
        while (true) {
            if (n < n2 && Character.isWhitespace(string.charAt(n))) {
                ++n;
                continue;
            }
            if (n >= n2) {
                bl = false;
            } else {
                int n3 = n + 1;
                while (n3 < n2 && !Character.isWhitespace(string.charAt(n3))) {
                    ++n3;
                }
                linkedList.add(string.substring(n, n3));
                n = n3;
            }
            if (!bl) break;
        }
        return linkedList;
    }

    public static String getString(String string) {
        String string2 = MessageLog.getMessageNoID(string);
        if (string2.equals("<text unavailable>")) {
            string2 = string;
        }
        return string2;
    }

    public static String getString(String string, String string2) {
        String[] stringArray = new String[]{string2};
        String string3 = Util.getString(string, stringArray);
        return string3;
    }

    public static String getString(String string, String string2, String string3) {
        String[] stringArray = new String[]{string2, string3};
        String string4 = Util.getString(string, stringArray);
        return string4;
    }

    public static String getString(String string, String[] stringArray) {
        String string2 = Util.getString(string);
        String string3 = IntlMessageFormat.format(string2, stringArray);
        return string3;
    }

    public static String getTranslatedName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        if (n > 8 && string.startsWith("Default.")) {
            int n2 = "Default".length() + 1;
            String string2 = string.substring(n2, n);
            StringBuffer stringBuffer = new StringBuffer("Default.");
            return stringBuffer.append(Util.getString(string2)).toString();
        }
        if (n > 8 && string.startsWith("DiskDefault.")) {
            int n3 = "DiskDefault".length() + 1;
            String string3 = string.substring(n3, n);
            StringBuffer stringBuffer = new StringBuffer("DiskDefault.");
            return stringBuffer.append(Util.getString(string3)).toString();
        }
        if (n > 8 && string.startsWith("FabricDefault.")) {
            int n4 = "FabricDefault".length() + 1;
            String string4 = string.substring(n4, n);
            StringBuffer stringBuffer = new StringBuffer("FabricDefault.");
            return stringBuffer.append(Util.getString(string4)).toString();
        }
        if (n > 8 && string.startsWith("TapeDefault.")) {
            int n5 = "TapeDefault".length() + 1;
            String string5 = string.substring(n5, n);
            StringBuffer stringBuffer = new StringBuffer("TapeDefault.");
            return stringBuffer.append(Util.getString(string5)).toString();
        }
        if (n <= 4) {
            return string;
        }
        String string6 = string.substring(0, 4);
        if (string6.equals("SQL_")) {
            return Util.getString(string);
        }
        return string;
    }

    public static void printKeyValuePair(PrintWriter printWriter, String string, String string2) {
        Util.printKeyValuePair(printWriter, string, string2, false);
    }

    public static void printKeyValuePair(PrintWriter printWriter, String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.setLength(0);
        stringBuffer.append(string);
        stringBuffer.append('=');
        if (bl) {
            stringBuffer.append('\"');
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string2);
        }
        printWriter.println(stringBuffer.toString());
    }

    public static String charToHex(String string, int n) {
        String string2;
        if (string == null) {
            return null;
        }
        char[] cArray = new char[n];
        try {
            string2 = Integer.toHexString(Integer.parseInt(string)).toUpperCase();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        int n2 = string2.length();
        cArray = new char[n];
        int n3 = n - n2;
        if (n3 < 0) {
            n = n2;
            n3 = 0;
        }
        int n4 = 0;
        int n5 = 0;
        if (n3 > 0) {
            n4 = 0;
            while (n4 < n3) {
                cArray[n4] = 48;
                ++n4;
            }
        }
        while (n4 < n) {
            cArray[n4] = string2.charAt(n5);
            ++n5;
            ++n4;
        }
        return String.valueOf(cArray);
    }

    public static String charHexToDecimal(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Integer.toString(Integer.parseInt(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean deleteTree(File file) {
        return Util.deleteTree(file, true);
    }

    private static boolean deleteTree(File file, boolean bl) {
        File[] fileArray;
        boolean bl2 = bl;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length != 0) {
            int n = 0;
            while (n < fileArray.length) {
                Util.deleteTree(fileArray[n], bl);
                ++n;
            }
        }
        if (!file.delete() || !bl2) {
            bl2 = false;
        }
        return bl2;
    }
}

