/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import com.ibm.log.Level;
import java.util.Properties;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.disk.DiskManagerConfiguration;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class DiskManagerConfigSvc {
    private static final String DM_CONFIG_GROUP = "DiskManager";
    private static DiskManagerConfigSvc stSingletongInstance = null;
    private IConfigService cConfigService = null;

    static {
        stSingletongInstance = new DiskManagerConfigSvc();
        stSingletongInstance.bindConfigService();
    }

    private DiskManagerConfigSvc() {
    }

    public static DiskManagerConfigSvc get() {
        return stSingletongInstance;
    }

    private void bindConfigService() {
        this.cConfigService = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
    }

    private String getConfValue(String string, String string2) {
        String string3 = null;
        try {
            string3 = this.cConfigService.getProperty(string, DM_CONFIG_GROUP);
        }
        catch (Exception exception) {
            ILogger iLogger = LogManagerFactory.getMessageLogger("aperi.logger.trace.DiskManager");
            iLogger.exception(Level.ERROR, this, "getConfValue", exception);
        }
        return string3 == null ? string2 : string3;
    }

    public static String getConfigValue(String string, String string2) {
        return DiskManagerConfigSvc.get().getConfValue(string, string2);
    }

    public static boolean getBooleanConfigValue(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = DiskManagerConfigSvc.get().getConfValue(string, null);
        if (string2 == null) {
            return bl2;
        }
        bl2 = Boolean.valueOf(string2);
        return bl2;
    }

    public static int getIntConfigValue(String string, int n) {
        int n2 = n;
        String string2 = DiskManagerConfigSvc.get().getConfValue(string, null);
        if (string2 == null) {
            return n2;
        }
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        return n2;
    }

    public static long getLongConfigValue(String string, long l) {
        long l2 = l;
        String string2 = DiskManagerConfigSvc.get().getConfValue(string, null);
        if (string2 == null) {
            return l2;
        }
        try {
            l2 = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = l;
        }
        return l2;
    }

    public void checkDefaultConfig() {
        try {
            Properties properties = this.cConfigService.getProperties(DM_CONFIG_GROUP);
            String string = null;
            int n = 0;
            while (n < DiskManagerConfiguration.DM_DEFAULT_CONFIG.length) {
                string = DiskManagerConfiguration.DM_DEFAULT_CONFIG[n][0];
                if (properties.getProperty(string) == null) {
                    this.cConfigService.setProperty(string, DM_CONFIG_GROUP, DiskManagerConfiguration.DM_DEFAULT_CONFIG[n][1]);
                }
                ++n;
            }
        }
        catch (RuntimeException runtimeException) {
            ILogger iLogger = LogManagerFactory.getMessageLogger("aperi.logger.trace.DiskManager");
            iLogger.exception(Level.ERROR, this, "checkdefaultConfig", runtimeException);
        }
    }
}

