/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrintFileChooser {
    private JFileChooser chooser;
    private JPanel subPanel;
    private JTextField nameField;
    private MyFileFilter fileFilter;
    private String suffix;
    private String description;
    static final String TITLE = MessageLog.getMessageNoID("GUI5007L");
    static final String SAVE = MessageLog.getMessageNoID("GUI5006L");
    static final String PDF_DESCRIPTION = MessageLog.getMessageNoID("GUI5096L");
    static final String HTML_DESCRIPTION = MessageLog.getMessageNoID("GUI5087L");
    static final String PS_DESCRIPTION = MessageLog.getMessageNoID("GUI5088L");
    static final String PCL_DESCRIPTION = MessageLog.getMessageNoID("GUI5093L");
    static final String CSV_DESCRIPTION = MessageLog.getMessageNoID("GUI5086L");
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public String getName(String string, String string2) {
        String string3 = null;
        if (string2.endsWith(".pdf")) {
            this.suffix = ".PDF";
            this.description = PDF_DESCRIPTION;
        } else if (string2.endsWith(".html")) {
            this.suffix = ".HTML";
            this.description = HTML_DESCRIPTION;
        } else if (string2.endsWith(".ps")) {
            this.suffix = ".PS";
            this.description = PS_DESCRIPTION;
        } else if (string2.endsWith(".csv")) {
            this.suffix = ".CSV";
            this.description = CSV_DESCRIPTION;
        } else {
            this.suffix = ".PCL";
            this.description = PCL_DESCRIPTION;
        }
        this.chooser = new JFileChooser();
        this.chooser.setDialogTitle(TITLE);
        this.chooser.setFileSelectionMode(0);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, Util.getString("COLON"));
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        string2 = stringBuffer.toString();
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.fileFilter = new MyFileFilter(this.suffix, this.description);
        this.chooser.addChoosableFileFilter(this.fileFilter);
        File file = new File(String.valueOf(string) + string2);
        this.chooser.setCurrentDirectory(file);
        this.chooser.setSelectedFile(file);
        int n = this.chooser.showDialog(this.guiMain.getFrame(), SAVE);
        if (n == 0) {
            try {
                File file2;
                string3 = this.chooser.getSelectedFile().getCanonicalPath();
                String string4 = string3.toUpperCase();
                String string5 = this.suffix.toUpperCase();
                if (!string4.endsWith(string5)) {
                    string3 = String.valueOf(string3) + this.suffix;
                }
                if ((file2 = new File(string3)).exists()) {
                    String string6 = MessageLog.getMessageNoID("GUI1622I", new Object[]{string3});
                    if (!GuiUtil.getConfirmation(this.guiMain.getFrame(), "TITLE", string6, false)) {
                        string3 = null;
                    }
                }
            }
            catch (IOException iOException) {}
        }
        return string3;
    }

    private class MyFileFilter
    extends FileFilter {
        private String suffix;
        private String description;

        public MyFileFilter(String string, String string2) {
            this.suffix = string;
            this.description = string2;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean accept(File file) {
            String string = file.getName().toUpperCase();
            return file.isDirectory() || string.endsWith(this.suffix);
        }
    }
}

