/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.agent.req.AgtStatusResp;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.AgentDDI;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.JobTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AgentInfo;
import org.eclipse.aperi.server.req.GuiInfoReq;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentData
extends JTabbedPane
implements ChangeListener,
GuiRequestor {
    private static GridBagLayout gridBag = new GridBagLayout();
    private static GridBagConstraints gbcFill_1 = new GridBagConstraints();
    private static GridBagConstraints gbcFill_2 = new GridBagConstraints();
    private static GridBagConstraints gbcLabel = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();
    private JPanel jTab = new JPanel(new BorderLayout());
    private String GENERAL = "  " + MessageLog.getMessageNoID("ADG0213L") + "  ";
    private String JOBS = "  " + MessageLog.getMessageNoID("ADG0214L") + "  ";
    private String DETAIL = "  " + MessageLog.getMessageNoID("ADG0240L") + "  ";
    private String INIT = MessageLog.getMessageNoID("ADG0234T");
    private String WAITING = MessageLog.getMessageNoID("ADG0235T");
    private String EXECUTING = MessageLog.getMessageNoID("ADG0236T");
    private String COMPLETED = MessageLog.getMessageNoID("ADG0237T");
    private String JAVA = MessageLog.getMessageNoID("ADG0238T");
    private String EXTERNAL = MessageLog.getMessageNoID("ADG0239T");
    private static final byte INIT_BYTE = 73;
    private static final byte WAIT_BYTE = 87;
    private static final byte EXEC_BYTE = 69;
    private static final byte COMP_BYTE = 67;
    public static final int GENERAL_INDEX = 0;
    public static final int DETAIL_INDEX = 1;
    public static final int JOBS_INDEX = 2;
    private static final Dimension DIM11 = new Dimension(1, 1);
    private AgentTreeNode node;
    private AgentDDI ddi;
    private AgtStatusResp asr;
    protected JobTable jt = null;
    private int reqType;
    private static int SERVER = 1;
    private static int AGENT = 2;
    private boolean generalTabCreated = false;
    private JPanel gPanel = new JPanel(gridBag);
    private JScrollPane gTab = new JScrollPane(this.gPanel);
    private JLabel gName = new JLabel();
    private JLabel gState = new JLabel();
    private JLabel gPort = new JLabel();
    private JLabel gHost = new JLabel();
    private JLabel gTime = new JLabel();
    private JLabel gZone = new JLabel();
    private JLabel gConnection = new JLabel();
    private JLabel gConsecutive = new JLabel();
    private boolean detailTabCreated = false;
    private JPanel dPanel = new JPanel(gridBag);
    private JScrollPane dTab = new JScrollPane(this.dPanel);
    private JLabel dName = new JLabel();
    private JLabel dHost = new JLabel();
    private JLabel dUpSince = new JLabel();
    private JLabel dUpTime = new JLabel();
    private JLabel dVMSize = new JLabel();
    private JLabel dManuf = new JLabel();
    private JLabel dOSType = new JLabel();
    private JLabel dCPUArchitecture = new JLabel();
    private JLabel dJobs = new JLabel();

    public AgentData(AgentTreeNode agentTreeNode, AgentDDI agentDDI, int n) {
        this.node = agentTreeNode;
        this.ddi = agentDDI;
        this.setPreferredSize(DIM11);
        this.addTab(this.GENERAL, this.gTab);
        this.addTab(this.DETAIL, this.dTab);
        this.addTab(this.JOBS, this.jTab);
        this.setToolTipTextAt(0, Util.getString("TOOLTIP_TAB_GENERAL"));
        this.setToolTipTextAt(1, Util.getString("TOOLTIP_TAB_DETAIL"));
        this.setToolTipTextAt(2, Util.getString("TOOLTIP_TAB_JOBS"));
        this.jTab.setPreferredSize(DIM11);
        if (n == 0) {
            this.stateChanged(null);
        } else {
            this.setSelectedIndex(n);
        }
        this.addChangeListener(this);
        AgentData.gbcFill_1.gridheight = 40;
        AgentData.gbcFill_1.weighty = 1.0;
        AgentData.gbcFill_1.ipadx = 60;
        AgentData.gbcFill_2.gridwidth = 4;
        AgentData.gbcFill_2.weightx = 1.0;
        AgentData.gbcLabel.anchor = 17;
        AgentData.gbcLast.anchor = 17;
        AgentData.gbcLast.gridwidth = 0;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.getSelectedIndex();
        switch (n) {
            case 2: {
                this.jt = new JobTable(this.node);
                this.jTab.removeAll();
                this.jTab.add((Component)this.jt, "Center");
                this.ddi.agentTab = 2;
                break;
            }
            case 1: {
                this.getStatusFromAgent();
                this.ddi.agentTab = 1;
                break;
            }
            case 0: {
                this.getStatusFromServer();
                this.ddi.agentTab = 0;
            }
        }
    }

    private void getStatusFromServer() {
        this.reqType = SERVER;
        Request request = new Request();
        ServerRequest.guiInfo(request, GuiInfoReq.AGENT_DETAIL, this.node.computerID);
        GuiClient.doRequest(this, request);
    }

    private void getStatusFromAgent() {
        this.reqType = AGENT;
        Request request = new Request();
        ServerRequest.agentJobs(request, this.node.computerID);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (this.reqType == SERVER) {
            this.createGeneralTab();
            if (s > 4) {
                Object var3_3 = null;
                this.gState.setText("    " + MessageLog.getMessageNoID("ADG0212T"));
                this.setEnabledAt(2, false);
                this.node.state = 0;
            } else {
                AgentInfo agentInfo = (AgentInfo)response.responseData;
                this.gName.setSize(20, 50);
                this.gName.setText(this.node.getUserObject().toString());
                boolean bl = false;
                if (agentInfo.upgradeRequired) {
                    bl = true;
                }
                if (agentInfo.state == 1) {
                    if (agentInfo.consecutiveErrors > 0) {
                        if (bl) {
                            this.gState.setText(Util.getString("TEXT_AGENTSTATE_UNREACHABLE_UPGRADE_NEEDED", this.gName.getText()));
                        } else {
                            this.gState.setText(Util.getString("TEXT_AGENTSTATE_UNREACHABLE", this.gName.getText()));
                        }
                        this.setEnabledAt(1, false);
                        this.setEnabledAt(2, false);
                        this.node.state = (byte)4;
                    } else {
                        if (bl) {
                            this.gState.setText(Util.getString("TEXT_AGENTSTATE_UP_UPGRADE_NEEDED", this.gName.getText()));
                        } else {
                            this.gState.setText(Util.getString("TEXT_AGENTSTATE_UP", this.gName.getText()));
                        }
                        this.setEnabledAt(1, true);
                        this.setEnabledAt(2, true);
                        this.node.state = agentInfo.upgradeRequired ? (byte)5 : (byte)1;
                    }
                } else if (agentInfo.state == 3) {
                    this.gState.setText(Util.getString("TEXT_AGENTSTATE_UPGRADING", this.gName.getText()));
                    this.setEnabledAt(1, false);
                    this.setEnabledAt(2, false);
                    this.node.state = (byte)3;
                } else if (agentInfo.state == 2) {
                    this.gState.setText(Util.getString("TEXT_AGENTSTATE_DEFECTED", this.gName.getText()));
                    this.setEnabledAt(1, false);
                    this.setEnabledAt(2, false);
                    this.node.state = (byte)2;
                } else {
                    if (bl) {
                        this.gState.setText(Util.getString("TEXT_AGENTSTATE_DOWN_UPGRADE_NEEDED", this.gName.getText()));
                    } else {
                        this.gState.setText(Util.getString("TEXT_AGENTSTATE_DOWN", this.gName.getText()));
                    }
                    this.setEnabledAt(1, false);
                    this.setEnabledAt(2, false);
                    this.node.state = 0;
                }
                this.gPort.setText(Integer.toString(agentInfo.listenerPort));
                this.gHost.setText(agentInfo.hostAddress);
                this.gTime.setText(DateFormat.getDateTimeInstance().format(new Date(agentInfo.timestamp)));
                if (agentInfo.timezone.getID().indexOf("Custom") == -1) {
                    this.gZone.setText(Util.formatTimeZone(agentInfo.timezone.getID()));
                } else {
                    this.gZone.setText(agentInfo.timezone.getDisplayName(agentInfo.timezone.useDaylightTime(), 0));
                }
                this.gConnection.setText(Short.toString(agentInfo.connectionErrors));
                this.gConsecutive.setText(Short.toString(agentInfo.consecutiveErrors));
            }
        } else {
            this.createDetailTab();
            if (s > 4) {
                this.asr = null;
                this.dName.setText(this.node.getUserObject().toString());
                this.dHost.setText(" ");
                this.dUpSince.setText(" ");
                this.dUpTime.setText(" ");
                this.dVMSize.setText(" ");
                this.dManuf.setText(" ");
                this.dOSType.setText(" ");
                this.dJobs.setText(" ");
            } else {
                this.asr = (AgtStatusResp)response.responseData;
                this.dName.setText(this.node.getUserObject().toString());
                this.dHost.setText(this.asr.hostName);
                this.dUpSince.setText(DateFormat.getDateTimeInstance().format(new Date(this.asr.upSince)));
                this.dUpTime.setText(GuiUtil.formatElapsed(this.asr.upTime, false));
                this.dVMSize.setText(Util.formatBytes(this.asr.vmSize));
                if (this.asr.manufacturer.toLowerCase().equals("unknown")) {
                    this.dManuf.setText(MessageLog.getMessageNoID("ADG0600T"));
                } else {
                    this.dManuf.setText(this.asr.manufacturer);
                }
                this.dOSType.setText(MessageLog.getMessageNoID(Constants.OSTYPES[this.asr.osType]));
                this.dCPUArchitecture.setText(Constants.getCPUArchDisplayName(this.asr.cpuArchitecture));
                this.dJobs.setText(Integer.toString(this.asr.jobs.size()));
            }
        }
    }

    private void createGeneralTab() {
        if (this.generalTabCreated) {
            return;
        }
        this.generalTabCreated = true;
        JLabel jLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0201L")) + "    ");
        JLabel jLabel2 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0121L")) + "    ");
        JLabel jLabel3 = new JLabel(" ");
        JLabel jLabel4 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0204L")) + "    ");
        JLabel jLabel5 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0205L")) + "    ");
        JLabel jLabel6 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0206L")) + "    ");
        JLabel jLabel7 = new JLabel(" ");
        JLabel jLabel8 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0207L")) + "    ");
        JLabel jLabel9 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0208L")) + "    ");
        JLabel jLabel10 = new JLabel(" ");
        JLabel jLabel11 = new JLabel(" ");
        JLabel jLabel12 = new JLabel("                  ");
        this.gPanel.add((Component)jLabel10, gbcFill_1);
        this.gPanel.add((Component)jLabel11, gbcFill_2);
        this.gPanel.add((Component)jLabel12, gbcLast);
        this.gPanel.add((Component)jLabel, gbcLabel);
        this.gPanel.add((Component)this.gState, gbcLast);
        this.gPanel.add((Component)jLabel2, gbcLabel);
        this.gPanel.add((Component)this.gPort, gbcLast);
        this.gPanel.add((Component)jLabel3, gbcLast);
        this.gPanel.add((Component)jLabel4, gbcLabel);
        this.gPanel.add((Component)this.gHost, gbcLast);
        this.gPanel.add((Component)jLabel5, gbcLabel);
        this.gPanel.add((Component)this.gTime, gbcLast);
        this.gPanel.add((Component)jLabel6, gbcLabel);
        this.gPanel.add((Component)this.gZone, gbcLast);
        this.gPanel.add((Component)jLabel7, gbcLast);
        this.gPanel.add((Component)jLabel8, gbcLabel);
        this.gPanel.add((Component)this.gConnection, gbcLast);
        this.gPanel.add((Component)jLabel9, gbcLabel);
        this.gPanel.add((Component)this.gConsecutive, gbcLast);
    }

    private void createDetailTab() {
        if (this.detailTabCreated) {
            return;
        }
        this.detailTabCreated = true;
        JLabel jLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0201L")) + "    ");
        JLabel jLabel2 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0013L")) + "    ");
        JLabel jLabel3 = new JLabel(" ");
        JLabel jLabel4 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0014L")) + "    ");
        JLabel jLabel5 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0241L")) + "    ");
        JLabel jLabel6 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0242L")) + "    ");
        JLabel jLabel7 = new JLabel(" ");
        JLabel jLabel8 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0243L")) + "    ");
        JLabel jLabel9 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0244L")) + "    ");
        JLabel jLabel10 = new JLabel(String.valueOf(MessageLog.getMessageNoID("GEN0218T")) + "    ");
        JLabel jLabel11 = new JLabel(" ");
        JLabel jLabel12 = new JLabel(String.valueOf(MessageLog.getMessageNoID("ADG0245L")) + "    ");
        JLabel jLabel13 = new JLabel(" ");
        JLabel jLabel14 = new JLabel(" ");
        JLabel jLabel15 = new JLabel("                  ");
        this.dPanel.add((Component)jLabel13, gbcFill_1);
        this.dPanel.add((Component)jLabel14, gbcFill_2);
        this.dPanel.add((Component)jLabel15, gbcLast);
        this.dPanel.add((Component)jLabel, gbcLabel);
        this.dPanel.add((Component)this.dName, gbcLast);
        this.dPanel.add((Component)jLabel2, gbcLabel);
        this.dPanel.add((Component)this.dHost, gbcLast);
        this.dPanel.add((Component)jLabel3, gbcLast);
        this.dPanel.add((Component)jLabel4, gbcLabel);
        this.dPanel.add((Component)this.dUpSince, gbcLast);
        this.dPanel.add((Component)jLabel5, gbcLabel);
        this.dPanel.add((Component)this.dUpTime, gbcLast);
        this.dPanel.add((Component)jLabel6, gbcLabel);
        this.dPanel.add((Component)this.dVMSize, gbcLast);
        this.dPanel.add((Component)jLabel7, gbcLast);
        this.dPanel.add((Component)jLabel8, gbcLabel);
        this.dPanel.add((Component)this.dManuf, gbcLast);
        this.dPanel.add((Component)jLabel9, gbcLabel);
        this.dPanel.add((Component)this.dOSType, gbcLast);
        this.dPanel.add((Component)jLabel10, gbcLabel);
        this.dPanel.add((Component)this.dCPUArchitecture, gbcLast);
        this.dPanel.add((Component)jLabel11, gbcLast);
        this.dPanel.add((Component)jLabel12, gbcLabel);
        this.dPanel.add((Component)this.dJobs, gbcLast);
    }
}

