/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.ConfigSettingsPanel;
import org.eclipse.aperi.gui.admin.LogFileRetentionPanel;
import org.eclipse.aperi.gui.admin.NetworkSettingsPanel;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.xmsg.MessageLog;

public class ConfigSettingsDDI
extends DataDisplayInfo
implements GuiRequestor,
ActionListener {
    public int badField;
    private GeneralException validationError;
    private ConfigSettings saved;
    private ConfigSettings settings;
    private ConfigSettingsPanel editor;
    private boolean notifyValidationError;
    private boolean closing;
    private String requestSubType;
    private String saveMsgID;

    public ConfigSettingsDDI(String string) {
        String string2;
        this.requestSubType = string;
        if (this.requestSubType.equals("org.eclipse.aperi.server.handler.server.ConfigSettingsHndlr.Retention")) {
            string2 = "GUI2080T";
            this.saveMsgID = "GUI2081T";
            this.helpID = "asco45";
        } else {
            string2 = "GUI2065T";
            this.saveMsgID = "GUI2067T";
            this.helpID = "asco5";
        }
        this.setDescription(MessageLog.getMessageNoID(string2));
        this.settings = null;
        this.validationError = null;
        this.closing = false;
    }

    private void getDataAndValidate() {
        this.settings = this.editor.getData();
        this.validationError = null;
        try {
            this.editor.validate(this.settings);
        }
        catch (GeneralException generalException) {
            this.validationError = generalException;
        }
    }

    public void panelToBeNulled() {
        this.getDataAndValidate();
        this.editor = null;
    }

    public void losingFocus() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this);
    }

    public boolean isEditable() {
        return true;
    }

    public boolean changesPending() {
        if (this.saved == null) {
            return true;
        }
        if (this.editor != null) {
            this.settings = this.editor.getData();
        }
        if (this.settings == null) {
            return false;
        }
        if (!Util.stringsEqual(this.settings.csTecServer, this.saved.csTecServer) || this.settings.csTecPort != this.saved.csTecPort || !this.settings.csSmtp.equals(this.saved.csSmtp) || this.settings.csDellogDays != this.saved.csDellogDays || this.settings.csRetainCopies != this.saved.csRetainCopies || this.settings.csRetainDays != this.saved.csRetainDays) {
            return true;
        }
        int n = 0;
        while (n < this.settings.csSnmp.length) {
            if (!this.settings.csSnmp[n].equals(this.saved.csSnmp[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void showAndAddListeners() {
        this.show();
        String string = MessageLog.getMessageNoID(this.saveMsgID);
        guiMain.setSaveActionEnabled(true, false);
        guiMain.setSaveActionToolTip(string);
        guiMain.addSaveActionListener(this);
    }

    public void sendRequest() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = this.requestSubType;
        request.requestData = this.settings;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void buildEditor() {
        this.editor = this.requestSubType.equals("org.eclipse.aperi.server.handler.server.ConfigSettingsHndlr.Retention") ? new LogFileRetentionPanel(this) : new NetworkSettingsPanel(this);
        this.panel = this.editor.getComponent(this.settings);
    }

    public void reDisplay() {
        if (this.settings == null) {
            this.sendRequest();
            return;
        }
        if (this.editor == null) {
            this.buildEditor();
            if (this.notifyValidationError) {
                this.editor.selectField(false);
                this.notifyValidationError = false;
            }
        }
        this.showAndAddListeners();
    }

    private void save() {
        boolean bl;
        boolean bl2 = bl = this.editor != null;
        if (bl) {
            this.getDataAndValidate();
        }
        if (this.validationError == null) {
            this.sendRequest();
        } else {
            this.closing = false;
            GuiUtil.displayException(this.validationError);
            if (bl) {
                this.editor.selectField(ConfigSettingsDDI.getCurrent() == this);
            } else {
                this.notifyValidationError = true;
            }
            this.reDisplay();
        }
    }

    public void saveAndClose() {
        this.closing = true;
        this.save();
    }

    public void handleResponse(short s, Response response) {
        boolean bl = this.closing;
        this.closing = false;
        if (s > 4) {
            return;
        }
        if (bl) {
            this.remove();
            return;
        }
        ConfigSettings configSettings = (ConfigSettings)response.responseData;
        if (this.settings == null) {
            this.settings = configSettings;
            this.buildEditor();
            this.showAndAddListeners();
        }
        if (this.settings != null) {
            this.saved = (ConfigSettings)this.settings.clone();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.save();
    }
}

