/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.InbandFabricAgentDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.InbandFabricAgentHBAInfo;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;

public class InbandFabricAgentPanel
extends JTabbedPane
implements ChangeListener,
GuiRequestor {
    private BorderLayout blayout = new BorderLayout();
    private static GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints gridBagConstraintsStatusLabel = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsStatus = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsIPAddressLabel = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsIPAddress = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsHostnameLabel = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsHostname = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsOSLabel = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsOS = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsHBATable = new GridBagConstraints();
    private JPanel gOuterPanel = new JPanel(new FlowLayout(3));
    private JPanel gPanel = new JPanel(gridBag);
    private JScrollPane gTab = new JScrollPane(this.gOuterPanel);
    private String node_name;
    private int node_id;
    private InbandFabricAgentDDI node_ddi;
    private JLabel gStatus;
    private JLabel gIPAddress;
    private JLabel gHostname;
    private JLabel gOSVersion;
    private JTable gHBATable;
    private static final int LEFT_VALUE_INSET = 20;
    private static final int LEFT_LABEL_INSET = 40;
    private boolean inbandFabricAgentDetailsTabCreated = false;

    InbandFabricAgentPanel() {
        this.addTab(FabricGuiUtil.getString("FabricInband_DetailsTab"), this.gTab);
        this.addChangeListener(this);
        this.gridBagConstraintsStatusLabel.gridx = 0;
        this.gridBagConstraintsStatusLabel.gridy = 0;
        this.gridBagConstraintsStatusLabel.anchor = 17;
        this.gridBagConstraintsStatusLabel.insets.left = 40;
        this.gridBagConstraintsStatusLabel.insets.top = 40;
        this.gridBagConstraintsStatus.gridx = 1;
        this.gridBagConstraintsStatus.gridy = 0;
        this.gridBagConstraintsStatus.anchor = 17;
        this.gridBagConstraintsStatus.insets.left = 20;
        this.gridBagConstraintsStatus.insets.top = 40;
        this.gridBagConstraintsIPAddressLabel.gridx = 0;
        this.gridBagConstraintsIPAddressLabel.gridy = 1;
        this.gridBagConstraintsIPAddressLabel.anchor = 17;
        this.gridBagConstraintsIPAddressLabel.insets.left = 40;
        this.gridBagConstraintsIPAddress.gridx = 1;
        this.gridBagConstraintsIPAddress.gridy = 1;
        this.gridBagConstraintsIPAddress.anchor = 17;
        this.gridBagConstraintsIPAddress.insets.left = 20;
        this.gridBagConstraintsHostnameLabel.gridx = 0;
        this.gridBagConstraintsHostnameLabel.gridy = 2;
        this.gridBagConstraintsHostnameLabel.anchor = 17;
        this.gridBagConstraintsHostnameLabel.insets.left = 40;
        this.gridBagConstraintsHostname.gridx = 1;
        this.gridBagConstraintsHostname.gridy = 2;
        this.gridBagConstraintsHostname.anchor = 17;
        this.gridBagConstraintsHostname.insets.left = 20;
        this.gridBagConstraintsOSLabel.gridx = 0;
        this.gridBagConstraintsOSLabel.gridy = 3;
        this.gridBagConstraintsOSLabel.anchor = 17;
        this.gridBagConstraintsOSLabel.insets.left = 40;
        this.gridBagConstraintsOS.gridx = 1;
        this.gridBagConstraintsOS.gridy = 3;
        this.gridBagConstraintsOS.anchor = 17;
        this.gridBagConstraintsOS.insets.left = 20;
        this.gridBagConstraintsHBATable.gridx = 0;
        this.gridBagConstraintsHBATable.gridy = 7;
        this.gridBagConstraintsHBATable.gridwidth = 2;
        this.gridBagConstraintsHBATable.insets.left = 40;
        this.gridBagConstraintsHBATable.insets.top = 20;
        this.createInbandFabricAgentDetailsTab();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent == null || changeEvent.getSource() == this) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
            request.userName = GuiUtil.getUserName();
            InbandFabricAgentInfo inbandFabricAgentInfo = new InbandFabricAgentInfo();
            request.requestData = inbandFabricAgentInfo;
            request.flags = (byte)4;
            inbandFabricAgentInfo.request_type = 1;
            inbandFabricAgentInfo.hostId = this.node_id;
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short s, Response response) {
        if (response != null) {
            InbandFabricAgentInfo inbandFabricAgentInfo = (InbandFabricAgentInfo)response.responseData;
            if (response.status == 0 && inbandFabricAgentInfo != null) {
                this.gStatus.setText(FabricGuiUtil.getInbandFabricAgentStatusString(inbandFabricAgentInfo.status));
                this.gIPAddress.setText(inbandFabricAgentInfo.ipaddress);
                this.gHostname.setText(inbandFabricAgentInfo.hostname);
                this.gOSVersion.setText(inbandFabricAgentInfo.OperatingSystemAndVersion);
                this.setTableData(inbandFabricAgentInfo);
                if (this.node_ddi != null) {
                    this.node_ddi.setNodeIconBasedOnStatusFromServer(inbandFabricAgentInfo.status);
                }
            }
        }
    }

    void setTableData(InbandFabricAgentInfo inbandFabricAgentInfo) {
        final Vector<String> vector = new Vector<String>();
        vector.add(FabricGuiUtil.getString("IFabricnband_Identifier"));
        vector.add(FabricGuiUtil.getString("FabricInband_Status"));
        vector.add(FabricGuiUtil.getString("FabricDetails_DriverVersion"));
        vector.add(FabricGuiUtil.getString("FabricDetails_FirmwareVersion"));
        vector.add(FabricGuiUtil.getString("FabricDetails_OptionROMVersion"));
        vector.add(FabricGuiUtil.getString("FabricDetails_HardwareVersion"));
        final Vector<Serializable> vector2 = new Vector<Serializable>();
        if (inbandFabricAgentInfo != null) {
            Serializable serializable;
            InbandFabricAgentHBAInfo inbandFabricAgentHBAInfo = null;
            while ((inbandFabricAgentHBAInfo = inbandFabricAgentInfo.getHBAInfo(inbandFabricAgentHBAInfo)) != null) {
                int n;
                try {
                    n = new Integer(inbandFabricAgentHBAInfo.status);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                serializable = new Vector<String>();
                ((Vector)serializable).add(inbandFabricAgentHBAInfo.identifier);
                ((Vector)serializable).add((String)FabricGuiUtil.getStatusString(n));
                ((Vector)serializable).add(inbandFabricAgentHBAInfo.version);
                ((Vector)serializable).add(inbandFabricAgentHBAInfo.firm_version);
                ((Vector)serializable).add(inbandFabricAgentHBAInfo.rom_version);
                ((Vector)serializable).add(inbandFabricAgentHBAInfo.hardware_version);
                vector2.add(serializable);
            }
            new Vector();
            if (vector2.size() < 1) {
                serializable = new JLabel();
                ((JLabel)serializable).setText(Util.getString("STG0020M"));
                this.gPanel.add((Component)serializable, this.gridBagConstraintsHBATable);
            } else {
                this.gHBATable.setModel(new AbstractTableModel(){

                    public String getColumnName(int n) {
                        return (String)vector.get(n);
                    }

                    public int getColumnCount() {
                        return vector.size();
                    }

                    public int getRowCount() {
                        return vector2.size();
                    }

                    public Object getValueAt(int n, int n2) {
                        return ((Vector)vector2.get(n)).get(n2);
                    }
                });
                this.gPanel.add((Component)this.gHBATable, this.gridBagConstraintsHBATable);
            }
        }
    }

    private void createInbandFabricAgentDetailsTab() {
        if (this.inbandFabricAgentDetailsTabCreated) {
            return;
        }
        this.inbandFabricAgentDetailsTabCreated = true;
        String string = FabricGuiUtil.getString("FabricInband_Status");
        JLabel jLabel = new JLabel(string);
        this.gStatus = new JLabel();
        this.gPanel.add((Component)jLabel, this.gridBagConstraintsStatusLabel);
        this.gPanel.add((Component)this.gStatus, this.gridBagConstraintsStatus);
        String string2 = FabricGuiUtil.getString("FabricInband_IPAddress");
        JLabel jLabel2 = new JLabel(string2);
        this.gIPAddress = new JLabel();
        this.gPanel.add((Component)jLabel2, this.gridBagConstraintsIPAddressLabel);
        this.gPanel.add((Component)this.gIPAddress, this.gridBagConstraintsIPAddress);
        String string3 = FabricGuiUtil.getString("FabricInband_Hostname");
        JLabel jLabel3 = new JLabel(string3);
        this.gHostname = new JLabel();
        this.gPanel.add((Component)jLabel3, this.gridBagConstraintsHostnameLabel);
        this.gPanel.add((Component)this.gHostname, this.gridBagConstraintsHostname);
        String string4 = FabricGuiUtil.getString("FabricInBand_OSVersion");
        JLabel jLabel4 = new JLabel(string4);
        this.gOSVersion = new JLabel();
        this.gPanel.add((Component)jLabel4, this.gridBagConstraintsOSLabel);
        this.gPanel.add((Component)this.gOSVersion, this.gridBagConstraintsOS);
        this.gHBATable = new JTable();
        this.gridBagConstraintsOSLabel.gridy = 6;
        this.gridBagConstraintsOSLabel.insets.top = 30;
        this.gPanel.add((Component)new JLabel(Util.getString("HBA_DATA_COLON")), this.gridBagConstraintsOSLabel);
        this.gOuterPanel.add(this.gPanel);
    }

    public void updateData(String string, int n, InbandFabricAgentDDI inbandFabricAgentDDI) {
        this.node_name = string;
        this.node_id = n;
        this.stateChanged(null);
        this.node_ddi = inbandFabricAgentDDI;
    }
}

