/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.agent.CimomAgentListDDI;
import org.eclipse.aperi.gui.admin.agent.DataAgentListDDI;
import org.eclipse.aperi.gui.admin.agent.InbandFabricAgentListDDI;
import org.eclipse.aperi.gui.admin.agent.OutOfBandFabricAgentListDDI;

public class AgentListTreeNode
extends BaseTreeNode {
    private int agentType = -1;
    private String panelTitle = null;

    public AgentListTreeNode(int n) {
        this.agentType = n;
        this.setAllowsChildren(false);
        switch (n) {
            case 6: {
                this.setUserObject(GuiUtil.getString("CIMOM_MGMT_LABEL"));
                this.panelTitle = GuiUtil.getString("CIMOM_AGENTS_LIST_PANEL_TITLE");
                break;
            }
            case 2: {
                this.setUserObject(GuiUtil.getString("DATA"));
                this.panelTitle = GuiUtil.getString("DATA_AGENTS_LIST_PANEL_TITLE");
                break;
            }
            case 7: {
                this.setUserObject(GuiUtil.getString("OUT_OF_BAND_FABRIC"));
                this.panelTitle = GuiUtil.getString("OUTBAND_AGENTS_LIST_PANEL_TITLE");
                break;
            }
            case 8: {
                this.setUserObject(GuiUtil.getString("INBAND_FABRIC"));
                this.panelTitle = GuiUtil.getString("INBAND_AGENTS_LIST_PANEL_TITLE");
                break;
            }
            default: {
                this.setUserObject(GuiUtil.getString("NA"));
            }
        }
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        if (this.ddi == null) {
            switch (this.agentType) {
                case 6: {
                    this.ddi = new CimomAgentListDDI(this.agentType, this.panelTitle);
                    break;
                }
                case 2: {
                    this.ddi = new DataAgentListDDI(this.agentType, this.panelTitle);
                    break;
                }
                case 8: {
                    this.ddi = new InbandFabricAgentListDDI(this.agentType, this.panelTitle);
                    break;
                }
                case 7: {
                    this.ddi = new OutOfBandFabricAgentListDDI(this.agentType, this.panelTitle);
                }
            }
            this.ddi.treeNode = this;
        }
        this.ddi.reDisplay();
    }
}

