/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.LogConfigDialog;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.admin.agent.AgentListPanel;
import org.eclipse.aperi.gui.admin.agent.DataAgentListDDI;
import org.eclipse.aperi.gui.admin.agent.DataAgentTableModel;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.server.req.UninstallAgentReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class DataAgentListPanel
extends AgentListPanel {
    private static final String lLog = "ADG0017L";
    private static final String lTracing = "ADG0304L";
    private static final String lConfig = "ADG0255L";
    private static final String lShutdown = "ADG0006L";
    private static final String lNormal = "ADG0007L";
    private static final String lImmediate = "ADG0009L";
    private static final String lAbort = "ADG0011L";
    private static final String lUninstall = "ADG0262L";
    private static final String lCheck = "ADG0288L";
    private static final String lEnable = "ADG0289L";
    private static final String lDisable = "ADG0290L";
    private JButton viewLogButton = null;
    private JButton configureTracingButton = null;
    private JButton readConfigButton = null;
    private JButton shutdownButton = null;
    private JButton checkButton = null;
    private JButton disableButton = null;
    private JButton enableButton = null;
    private JButton deleteButton = null;
    private GuiRequestor doNothingRequestor = new GuiRequestor(){

        public void handleResponse(short s, Response response) {
        }
    };

    public DataAgentListPanel(AgentListDDI agentListDDI) {
        super(agentListDDI);
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        this.viewLogButton = this.getButton(MessageLog.getMessageNoID(lLog));
        this.configureTracingButton = this.getButton(MessageLog.getMessageNoID(lTracing));
        this.readConfigButton = this.getButton(MessageLog.getMessageNoID(lConfig));
        this.shutdownButton = this.getButton(String.valueOf(MessageLog.getMessageNoID(lShutdown)) + "...");
        this.deleteButton = this.getButton(MessageLog.getMessageNoID(lUninstall));
        this.checkButton = this.getButton(MessageLog.getMessageNoID(lCheck));
        this.enableButton = this.getButton(MessageLog.getMessageNoID(lEnable));
        this.disableButton = this.getButton(MessageLog.getMessageNoID(lDisable));
        this.readConfigButton.setToolTipText(MessageLog.getMessageNoID("ADG0256T"));
        this.configureTracingButton.setToolTipText(MessageLog.getMessageNoID("ADG0305T"));
        this.viewLogButton.setToolTipText(MessageLog.getMessageNoID("ADG0260T"));
        this.shutdownButton.setToolTipText(MessageLog.getMessageNoID("ADG0016T"));
        this.deleteButton.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        this.checkButton.setToolTipText(MessageLog.getMessageNoID("ADG0291T"));
        this.enableButton.setToolTipText(MessageLog.getMessageNoID("ADG0293T"));
        this.disableButton.setToolTipText(MessageLog.getMessageNoID("ADG0292T"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.viewLogButton);
        jPanel2.add(this.configureTracingButton);
        jPanel2.add(this.readConfigButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.checkButton);
        jPanel3.add(this.shutdownButton);
        jPanel3.add(this.disableButton);
        jPanel3.add(this.enableButton);
        jPanel3.add(this.deleteButton);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    void disableAllButtons() {
        this.viewLogButton.setEnabled(false);
        this.configureTracingButton.setEnabled(false);
        this.readConfigButton.setEnabled(false);
        this.shutdownButton.setEnabled(false);
        this.checkButton.setEnabled(false);
        this.disableButton.setEnabled(false);
        this.enableButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    void chooseButtons(Object object) {
        boolean bl = object instanceof Vector && ((Vector)object).size() > 1;
        UserPreferences userPreferences = guiMain.getUserPrefs();
        if (bl) {
            this.viewLogButton.setEnabled(false);
            this.checkButton.setEnabled(false);
            this.configureTracingButton.setEnabled(false);
            this.readConfigButton.setEnabled(false);
            this.shutdownButton.setEnabled(false);
            this.disableButton.setEnabled(false);
            this.enableButton.setEnabled(false);
        } else {
            NameList nameList = object instanceof Vector ? (NameList)((Vector)object).get(0) : (NameList)object;
            byte by = nameList.nlState;
            boolean bl2 = by == 1;
            boolean bl3 = by == 5;
            boolean bl4 = by == 4;
            boolean bl5 = by == 0;
            this.viewLogButton.setEnabled(bl2 || bl3);
            this.checkButton.setEnabled(true);
            this.configureTracingButton.setEnabled(userPreferences.administrator && bl2);
            this.readConfigButton.setEnabled(userPreferences.administrator && (bl2 || bl3));
            this.shutdownButton.setEnabled(userPreferences.administrator && (bl2 || bl3));
            this.disableButton.setEnabled(userPreferences.administrator && (bl2 || bl3 || bl4));
            this.enableButton.setEnabled(userPreferences.administrator && bl5);
        }
        this.deleteButton.setEnabled(userPreferences.administrator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int[] nArray = this.getTable().getSelectedRows();
        NameList[] nameListArray = new NameList[nArray.length];
        int n = 0;
        while (n < nameListArray.length) {
            nameListArray[n] = (NameList)this.getDDI().elementAt(nArray[n]);
            ++n;
        }
        if (object == this.shutdownButton) {
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton(MessageLog.getMessageNoID(lNormal), true);
            jRadioButton.setActionCommand(lNormal);
            JRadioButton jRadioButton2 = new JRadioButton(MessageLog.getMessageNoID(lImmediate), false);
            jRadioButton2.setActionCommand(lImmediate);
            JRadioButton jRadioButton3 = new JRadioButton(MessageLog.getMessageNoID(lAbort), false);
            jRadioButton3.setActionCommand(lAbort);
            jRadioButton.setToolTipText(MessageLog.getMessageNoID("ADG0008T"));
            jRadioButton2.setToolTipText(MessageLog.getMessageNoID("ADG0010T"));
            jRadioButton3.setToolTipText(MessageLog.getMessageNoID("ADG0012T"));
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton3);
            JPanel jPanel = new JPanel(new GridLayout());
            jPanel.add(jRadioButton);
            jPanel.add(jRadioButton2);
            jPanel.add(jRadioButton3);
            int n2 = JOptionPane.showOptionDialog(guiMain.getFrame(), new Object[]{jPanel}, MessageLog.getMessageNoID(lShutdown), 2, -1, null, null, null);
            if (n2 != 0) return;
            String string = buttonGroup.getSelection().getActionCommand();
            if (string == lNormal) {
                this.stopAgent(nameListArray, (byte)1);
                return;
            } else if (string == lImmediate) {
                this.stopAgent(nameListArray, (byte)2);
                return;
            } else {
                if (string != lAbort) return;
                this.stopAgent(nameListArray, (byte)3);
            }
            return;
        } else if (object == this.viewLogButton) {
            this.log(nameListArray);
            return;
        } else if (object == this.configureTracingButton) {
            this.tracingConfig(nameListArray);
            return;
        } else if (object == this.readConfigButton) {
            this.config(nameListArray);
            return;
        } else if (object == this.checkButton) {
            this.checkAgent(nameListArray);
            return;
        } else if (object == this.disableButton) {
            this.disableAgent(nameListArray);
            return;
        } else if (object == this.enableButton) {
            this.enableAgent(nameListArray);
            return;
        } else if (object == this.deleteButton) {
            this.uninstallAgent(nameListArray);
            return;
        } else {
            if (object != this.refreshNowButton) return;
            this.getDDI().getData();
        }
    }

    private void log(NameList[] nameListArray) {
        AgentTreeNode agentTreeNode = (AgentTreeNode)((DataAgentListDDI)this.getDDI()).getTreeNode(nameListArray[0], false, false);
        new LogViewer(nameListArray[0].nlID, agentTreeNode);
    }

    private void tracingConfig(NameList[] nameListArray) {
        Request request = new Request();
        ServerRequest.agentGetTracingConfig(request, nameListArray[0].nlID, "org.eclipse.aperi.agent.svp.AgentSvp");
        GuiClient.doRequest(new ActionResponseHandler(nameListArray, 5), request);
    }

    private void config(NameList[] nameListArray) {
        Request request = new Request();
        ServerRequest.agentReadConfig(request, nameListArray[0].nlID);
        GuiClient.doRequest(this.doNothingRequestor, request);
    }

    private void stopAgent(NameList[] nameListArray, byte by) {
        String string = MessageLog.getMessageNoID("ADG0251T", this.getAgentName(nameListArray[0].nlID));
        String string2 = MessageLog.getMessageNoID("ADG0252T", this.getAgentName(nameListArray[0].nlID));
        String string3 = MessageLog.getMessageNoID("ADG0253L");
        String string4 = MessageLog.getMessageNoID("ADG0254L");
        Object[] objectArray = new String[]{string3, string4};
        int n = JOptionPane.showOptionDialog(guiMain.getFrame(), string2, string, 0, 2, null, objectArray, objectArray[0]);
        if (n == 1) {
            Request request = new Request();
            ServerRequest.agentStop(request, nameListArray[0].nlID, by);
            if (by == 1) {
            } else {
                new ActionResponseHandler(nameListArray, 0);
            }
            GuiClient.doRhetoricalRequest(request);
            nameListArray[0].nlState = 0;
            this.getTableModel().refreshAgent(nameListArray[0]);
        }
    }

    private void checkAgent(NameList[] nameListArray) {
        Request request = new Request();
        ServerRequest.agentStatus(request, nameListArray[0].nlID);
        GuiClient.doRequest(new ActionResponseHandler(nameListArray, 1), request);
    }

    private void enableAgent(NameList[] nameListArray) {
        Request request = new Request();
        ServerRequest.agentState(request, new ComputerID(nameListArray[0].nlID), (byte)1);
        GuiClient.doRequest(new ActionResponseHandler(nameListArray, 2), request);
    }

    private void disableAgent(NameList[] nameListArray) {
        Request request = new Request();
        ServerRequest.agentState(request, new ComputerID(nameListArray[0].nlID), (byte)0);
        GuiClient.doRequest(new ActionResponseHandler(nameListArray, 3), request);
    }

    private void uninstallAgent(NameList[] nameListArray) {
        String string = MessageLog.getMessageNoID("ADG0601T");
        String string2 = MessageLog.getMessageNoID("ADG0602T");
        String string3 = MessageLog.getMessageNoID("ADG0603T");
        String string4 = MessageLog.getMessageNoID("ADG0604L");
        String string5 = MessageLog.getMessageNoID("ADG0605L");
        TreeSet<Object> treeSet = new TreeSet<Object>();
        int n = 0;
        while (n < nameListArray.length) {
            treeSet.add(this.getAgentName(nameListArray[n].nlID));
            ++n;
        }
        JList<String> jList = new JList<String>(treeSet.toArray(new String[treeSet.size()]));
        int n2 = treeSet.size() < 6 ? treeSet.size() : 6;
        jList.setVisibleRowCount(n2);
        JScrollPane jScrollPane = new JScrollPane(jList);
        Object[] objectArray = new String[]{string4, string5};
        int n3 = JOptionPane.showOptionDialog(guiMain.getFrame(), new Object[]{string2, jScrollPane, string3}, string, 0, 2, null, objectArray, objectArray[0]);
        if (n3 == 1) {
            Request request = new Request();
            byte by = 0;
            ServerRequest.uninstallAgent(request, nameListArray[0].nlID, by);
            if (nameListArray.length > 1) {
                UninstallAgentReq[] uninstallAgentReqArray = new UninstallAgentReq[nameListArray.length];
                int n4 = 0;
                while (n4 < nameListArray.length) {
                    uninstallAgentReqArray[n4] = new UninstallAgentReq();
                    uninstallAgentReqArray[n4].computerID = nameListArray[n4].nlID;
                    uninstallAgentReqArray[n4].productCode = by;
                    ++n4;
                }
                request.requestData = uninstallAgentReqArray;
            }
            GuiClient.doRequest(new ActionResponseHandler(nameListArray, 4), request);
        }
    }

    private Object getAgentName(int n) {
        GComputer gComputer = GuiUtil.getComputer(n);
        return gComputer.gcTSName;
    }

    private DataAgentTableModel getTableModel() {
        return (DataAgentTableModel)this.getDDI().getTableModel();
    }

    private class ActionResponseHandler
    implements GuiRequestor {
        private NameList[] agents;
        private int action = 0;

        public ActionResponseHandler(NameList[] nameListArray, int n) {
            this.agents = nameListArray;
            this.action = n;
        }

        public void handleResponse(short s, Response response) {
            if (this.action == 0) {
                if (s <= 4) {
                    Request request = new Request();
                    ServerRequest.agentState(request, new ComputerID(this.agents[0].nlID), (byte)0);
                    GuiClient.doRequest(DataAgentListPanel.this.doNothingRequestor, request);
                }
            } else if (this.action > 0 && this.action < 4) {
                if (response != null && response.responseData != null && response.responseData instanceof Byte) {
                    this.agents[0].nlState = (Byte)response.responseData;
                    DataAgentListPanel.this.getTableModel().refreshAgent(this.agents[0]);
                }
                if (this.action == 1 && s < 4) {
                    String string = MessageLog.getMessageNoID("ADG0294M", DataAgentListPanel.this.getAgentName(this.agents[0].nlID));
                    JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                }
            } else if (this.action == 4) {
                if (s <= 4) {
                    DataAgentListPanel.this.getDDI().getData();
                    int n = 0;
                    while (n < this.agents.length) {
                        DataAgentListPanel.this.getDDI().getTreeNode(this.agents[n], false, true);
                        ++n;
                    }
                }
            } else if (this.action == 5) {
                if (s != 0) {
                    String string = MessageLog.getMessage("ADG0308E", DataAgentListPanel.this.getAgentName(this.agents[0].nlID));
                    JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0307L"), 0);
                } else {
                    HashMap hashMap = (HashMap)response.responseData;
                    String string = MessageLog.getMessageNoID("ADG0310L", DataAgentListPanel.this.getAgentName(this.agents[0].nlID));
                    LogConfigDialog logConfigDialog = new LogConfigDialog(string, this.agents[0].nlID, DataAgentListPanel.this.getAgentName(this.agents[0].nlID), "org.eclipse.aperi.agent.svp.AgentSvp");
                    logConfigDialog.setLocationRelativeTo(null);
                    logConfigDialog.show(hashMap, "org.eclipse.aperi.agent.svp.AgentSvp");
                }
            }
        }
    }
}

