/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;

public class RolesGridBagPanel
extends GridBagPanel {
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    HashMap model = new HashMap();
    private String NO_MAPPING = Util.getString("ROLES_CFG_NO_MAPPING");
    private DirtyListenerInterface dirtyListener;
    private static HashMap name2Type = new HashMap();
    private static HashMap type2Name = new HashMap();
    private static String[] typeNames;

    static {
        name2Type.put("Local", new Integer(RoleData.LOCAL_GROUP));
        name2Type.put("Domain", new Integer(RoleData.DOMAIN_GROUP));
        name2Type.put("Active Directory", new Integer(RoleData.ACTIVE_DIR_GROUP));
        name2Type.put("LDAP", new Integer(RoleData.LDAP_GROUP));
        typeNames = name2Type.keySet().toArray(new String[0]);
        Arrays.sort(typeNames);
        Iterator iterator = name2Type.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            type2Name.put(name2Type.get(k), k);
        }
    }

    private int type2Position(int n) {
        return Arrays.binarySearch(typeNames, (String)type2Name.get(new Integer(n)));
    }

    public RolesGridBagPanel(HashMap hashMap) {
        this.setTitle(Util.getString("ROLES_CFG_MAIN_TITLE"));
        this.buildPanel(hashMap);
    }

    private void buildPanel(HashMap hashMap) {
        ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        if (arrayList.contains(RoleChecker.APERI_ADMINISTRATOR)) {
            arrayList.remove(RoleChecker.APERI_ADMINISTRATOR);
            arrayList.add(0, RoleChecker.APERI_ADMINISTRATOR);
        }
        if (arrayList.contains(RoleChecker.APERI_SUPERUSER)) {
            arrayList.remove(RoleChecker.APERI_SUPERUSER);
            arrayList.add(0, RoleChecker.APERI_SUPERUSER);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.buildRow((RoleData)hashMap.get((String)iterator.next()));
        }
        this.createStretchBox();
    }

    private void buildRow(RoleData roleData) {
        RoleRow roleRow = new RoleRow();
        roleRow.groupMap = roleData;
        String string = roleData.getRoleName();
        String string2 = this.getGlobalizedRoleName(string);
        this.add(new JLabel(string2));
        roleRow.groupNameTextField = new JTextField();
        roleRow.groupNameTextField.setEditable(false);
        this.add((JComponent)roleRow.groupNameTextField, 21, 2);
        roleRow.groupTypeComboBox = new JComboBox<String>(typeNames);
        roleRow.groupTypeComboBox.setSelectedIndex(this.type2Position(roleData.getGroupType()));
        roleRow.groupTypeComboBox.setActionCommand(roleData.getRoleName());
        roleRow.groupTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RolesGridBagPanel.this.editTypeField(actionEvent.getActionCommand());
            }
        });
        this.model.put(roleData.getRoleName(), roleRow);
        this.setGroup(roleData.getRoleName(), roleData.getGroupName());
        this.setType(roleData.getRoleName(), roleData.getGroupType());
        JButton jButton = new JButton(Util.getString("ROLES_CFG_EDIT"));
        jButton.setActionCommand(string);
        boolean bl = true;
        int n = RoleChecker.getRoleID(string);
        if (n == RoleChecker.SUPERUSER && !this.capabilities.isSuperuser()) {
            bl = false;
        }
        if (bl) {
            jButton.setEnabled(true);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RolesGridBagPanel.this.editTextField(actionEvent.getActionCommand());
                }
            });
        } else {
            jButton.setEnabled(false);
        }
        this.add((JComponent)jButton, 21, 0);
        JButton jButton2 = new JButton(Util.getString("ROLES_CFG_DELETE"));
        if (bl) {
            jButton2.setEnabled(true);
            jButton2.setActionCommand(roleData.getRoleName());
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RolesGridBagPanel.this.deleteTextField(actionEvent.getActionCommand());
                }
            });
        } else {
            jButton2.setEnabled(false);
        }
        this.add((JComponent)jButton2, 21, 0);
        roleRow.allowDelete = bl;
        roleRow.deleteButton = jButton2;
        jButton2.setEnabled(bl && !this.getGroup(roleData.getRoleName()).equals(this.NO_MAPPING));
        this.newRow();
    }

    private String getGlobalizedRoleName(String string) {
        String string2 = null;
        if (string.equals(RoleChecker.APERI_SUPERUSER)) {
            string2 = Util.getString("ROLE_SUPERUSER");
        } else if (string.equals(RoleChecker.APERI_ADMINISTRATOR)) {
            string2 = Util.getString("ROLE_ADMIN");
        } else if (string.equals(RoleChecker.DISK_ADMINISTRATOR)) {
            string2 = Util.getString("ROLE_DISK_AD");
        } else if (string.equals(RoleChecker.DISK_OPERATOR)) {
            string2 = Util.getString("ROLE_DISK_OP");
        } else if (string.equals(RoleChecker.FABRIC_ADMINISTRATOR)) {
            string2 = Util.getString("ROLE_FABRIC_AD");
        } else if (string.equals(RoleChecker.FABRIC_OPERATOR)) {
            string2 = Util.getString("ROLE_FABRIC_OP");
        } else if (string.equals(RoleChecker.DATA_ADMINISTRATOR)) {
            string2 = Util.getString("ROLE_DATA_AD");
        } else if (string.equals(RoleChecker.DATA_OPERATOR)) {
            string2 = Util.getString("ROLE_DATA_OP");
        } else if (string.equals(RoleChecker.TAPE_ADMINISTRATOR)) {
            string2 = Util.getString("ROLE_TAPE_AD");
        } else if (string.equals(RoleChecker.TAPE_OPERATOR)) {
            string2 = Util.getString("ROLE_TAPE_OP");
        }
        return string2;
    }

    private void setGroup(String string, String string2) {
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 == null || string2.length() == 0 || string2.equalsIgnoreCase(this.NO_MAPPING)) {
            string2 = this.NO_MAPPING;
        }
        RoleRow roleRow = (RoleRow)this.model.get(string);
        roleRow.groupNameTextField.setText(string2);
        roleRow.groupMap.setGroupName(string2);
    }

    private void setType(String string, int n) {
        ((RoleRow)this.model.get((Object)string)).groupMap.setGroupType(n);
    }

    private RoleRow getRow(String string) {
        return (RoleRow)this.model.get(string);
    }

    private String getType(String string) {
        return (String)this.getRow((String)string).groupTypeComboBox.getSelectedItem();
    }

    private String getGroup(String string) {
        String string2 = this.getRow((String)string).groupNameTextField.getText();
        return string2 != null ? string2.trim() : null;
    }

    protected void editTypeField(String string) {
        this.setType(string, this.mapType(this.getType(string)));
        this.talkDirty(string);
    }

    private int mapType(String string) {
        return (Integer)name2Type.get(string);
    }

    protected void editTextField(String string) {
        String string2;
        String string3 = string2 = this.getGroup(string);
        String string4 = this.getGlobalizedRoleName(string);
        string2 = (String)JOptionPane.showInputDialog(this.guiMain.getFrame(), Util.getString("GUI8001I", string4), Util.getString("ROLES_CFG_EDIT_DIALOG"), 3, null, null, string2);
        if (string2 != null) {
            string2 = string2.trim();
            if (string.equals(RoleChecker.APERI_SUPERUSER) && !string3.equals(this.NO_MAPPING) && (string2.trim().length() == 0 || string2.equalsIgnoreCase(this.NO_MAPPING)) && !this.askConfirmDeleteSuperuser(string, string3)) {
                return;
            }
            this.setGroup(string, string2);
            this.getRow((String)string).deleteButton.setEnabled(this.getRow((String)string).allowDelete && !this.getGroup(string).equals(this.NO_MAPPING));
            if (!string3.equals(this.getGroup(string))) {
                this.talkDirty(string);
            }
        }
    }

    protected void deleteTextField(String string) {
        String string2 = this.getGroup(string);
        String string3 = this.getGlobalizedRoleName(string);
        if (!string2.equals(this.NO_MAPPING)) {
            boolean bl = true;
            if (string.equals(RoleChecker.APERI_SUPERUSER)) {
                bl = this.askConfirmDeleteSuperuser(string, string2);
            } else {
                int n = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), Util.getString("GUI8000I", string2, string3), Util.getString("ROLES_CFG_DELETE_DIALOG"), 0);
                boolean bl2 = bl = n == 0;
            }
            if (bl) {
                this.setGroup(string, null);
                this.getRow((String)string).deleteButton.setEnabled(false);
                this.talkDirty(string);
            }
        }
    }

    public HashMap getModel() {
        HashMap<String, RoleData> hashMap = new HashMap<String, RoleData>(this.model);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RoleRow roleRow = this.getRow(string);
            RoleData roleData = roleRow.groupMap;
            if (roleRow.groupNameTextField.getText().compareTo(this.NO_MAPPING) == 0) {
                roleData.setGroupName(null);
            } else {
                roleData.setGroupName(roleRow.groupNameTextField.getText());
            }
            roleData.setGroupType((Integer)name2Type.get(roleRow.groupTypeComboBox.getSelectedItem()));
            hashMap.put(string, roleData);
        }
        return hashMap;
    }

    private void talkDirty(String string) {
        if (this.dirtyListener != null) {
            this.dirtyListener.dirtyTalk(this, string);
        }
    }

    public void addDirtyListener(DirtyListenerInterface dirtyListenerInterface) {
        this.dirtyListener = dirtyListenerInterface;
    }

    public void removeDirtyListener(DirtyListenerInterface dirtyListenerInterface) {
        if (this.dirtyListener == this.dirtyListener) {
            this.dirtyListener = null;
        }
    }

    private boolean askConfirmDeleteSuperuser(String string, String string2) {
        String string3 = this.getGlobalizedRoleName(string);
        int n = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), Util.getString("GUI8218W", string2, string3), Util.getString("ROLES_CFG_MAIN_TITLE"), 0, 2);
        return n == 0;
    }

    public boolean validatePanel(Hashtable hashtable) {
        return true;
    }

    private static class RoleRow {
        RoleData groupMap;
        JTextField groupNameTextField;
        JComboBox groupTypeComboBox;
        JButton deleteButton;
        boolean allowDelete;

        private RoleRow() {
        }
    }
}

