/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.drives;

import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.tape.common.TapeLocation;
import org.eclipse.aperi.gui.tape.common.model.GUIDrive;
import org.eclipse.aperi.gui.tape.drives.DrivesDDI;

public class DrivesTableModel
extends BaseTableModel {
    private DrivesDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_DRIVE_LABEL"), Util.getString("TAPE_STATE_LABEL"), Util.getString("TAPE_NEEDS_CLEANING_LABEL"), Util.getString("TAPE_MOUNTS_LABEL"), Util.getString("TAPE_WWNN_LABEL"), Util.getString("TAPE_FIRMWARE_LABEL"), Util.getString("TAPE_LOCATION_LABEL"), Util.getString("TAPEMEDIATYPESSUPPORTED"), Util.getString("TAPE_CARTRIDGE_LABEL_LABEL")};
    private static final int DRIVES_NAME = 0;
    private static final int DRIVES_STATUS = 1;
    private static final int DRIVES_CLEANING = 2;
    private static final int DRIVES_MOUNTS = 3;
    private static final int DRIVES_WWPN = 4;
    private static final int DRIVES_FIRMWARE = 5;
    private static final int DRIVES_LOCATION = 6;
    private static final int DRIVES_MEDIA_TYPE_SUPPORTED = 7;
    private static final int DRIVES_CARTRIDGE_LABEL = 8;

    DrivesTableModel(DrivesDDI drivesDDI) {
        this.aDDI = drivesDDI;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getDrives().size();
    }

    public Object getTableDataItem(int n, int n2) {
        GUIDrive gUIDrive = (GUIDrive)this.aDDI.getDrives().elementAt(n);
        switch (n2) {
            case 0: {
                return gUIDrive.getName();
            }
            case 1: {
                JLabel jLabel = GUIEntityUtil.getEntityStateLabel(gUIDrive);
                return jLabel;
            }
            case 2: {
                if (!gUIDrive.isNeedsCleaning()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 3: {
                return new Long(gUIDrive.getMounts());
            }
            case 4: {
                return gUIDrive.getWwpn();
            }
            case 5: {
                return gUIDrive.getVersion();
            }
            case 6: {
                return new TapeLocation(gUIDrive.getLocation());
            }
            case 7: {
                return gUIDrive.getMediaTypeSupported();
            }
            case 8: {
                return gUIDrive.getCartridge_Label();
            }
        }
        return "";
    }
}

