/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLunGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphLunGroup2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL2Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL2Device;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup2Volume;

public class GraphModelOtherL2
extends GraphModel {
    private static final long serialVersionUID = -1358301715824843958L;
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType VOLUMEGROUP = new GraphScopedType(GraphVolumeGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelOtherL2(ID iD) {
        super(iD);
    }

    protected void initGroupByCapabilities() {
        int n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        Integer n2 = new Integer(n);
        this.groupByCapabilitiesH.put(SWGROUP, n2);
        n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM;
        n2 = new Integer(n);
        this.groupByCapabilitiesH.put(VOLUMEGROUP, n2);
    }

    public void applyScope() {
        Enumeration enumeration = this.enumerate(GraphOther.TYPE);
        while (enumeration.hasMoreElements()) {
            GraphOther graphOther = (GraphOther)enumeration.nextElement();
            GraphOther.ID iD = (GraphOther.ID)graphOther.getEntityID();
            Enumeration enumeration2 = this.associator(GraphOther2FCPort.TYPE, iD);
            while (enumeration2.hasMoreElements()) {
                GraphFCPort graphFCPort = (GraphFCPort)enumeration2.nextElement();
                graphFCPort.addScope("Focus");
            }
        }
    }

    public void applyGrouping(Hashtable hashtable) {
        this.groupFocus();
        this.groupSubviewConnectivityFCPortBySingleGroup();
        this.groupSubviewConnectivitySwitch(hashtable);
        this.groupSubviewConnectivity();
        this.groupSubviewDeviceLunBySingleGroup();
        this.groupSubviewDeviceVolume(hashtable);
        this.groupSubviewDevice();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        GraphOther.ID iD = (GraphOther.ID)((ID)this.modelID).getFocusEntityID();
        String string = "Focus";
        GraphOtherGroup graphOtherGroup = new GraphOtherGroup(string);
        GraphOtherGroup.ID iD2 = (GraphOtherGroup.ID)graphOtherGroup.getEntityID();
        graphOtherGroup.setIsHelper(Boolean.TRUE);
        this.put(graphOtherGroup);
        GraphOtherGroup2Other graphOtherGroup2Other = new GraphOtherGroup2Other(iD2.getID() + "+" + iD.getID());
        graphOtherGroup2Other.setOtherGroupID(iD2);
        graphOtherGroup2Other.setOtherID(iD);
        this.put(graphOtherGroup2Other);
    }

    private void groupSubviewConnectivityFCPortBySingleGroup() {
        Comparable<Integer> comparable;
        this.removeAll(GraphFCPortGroup.TYPE);
        this.removeAll(GraphFCPortGroup2FCPort.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphFCPort.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphFCPort)enumeration.nextElement();
            if (!((GraphEntity)comparable).containScope("Focus")) continue;
            vector.add(comparable);
        }
        comparable = GraphGroupingUtilities.GROUPBY_ALL;
        Hashtable hashtable = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphFCPortGroup graphFCPortGroup = new GraphFCPortGroup(string);
            GraphFCPortGroup.ID iD = (GraphFCPortGroup.ID)graphFCPortGroup.getEntityID();
            graphFCPortGroup.setDisplayName(graphGroupKey.getLabel());
            graphFCPortGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphFCPortGroup.setSortingValue(graphGroupKey);
            graphFCPortGroup.setGroupKey(graphGroupKey);
            this.put(graphFCPortGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphFCPort graphFCPort = (GraphFCPort)vector.elementAt(n);
                GraphFCPort.ID iD2 = (GraphFCPort.ID)graphFCPort.getEntityID();
                GraphFCPortGroup2FCPort graphFCPortGroup2FCPort = new GraphFCPortGroup2FCPort(iD.getID() + "+" + iD2.getID());
                graphFCPortGroup2FCPort.setFCPortGroupID(iD);
                graphFCPortGroup2FCPort.setFCPortID(iD2);
                this.put(graphFCPortGroup2FCPort);
                ++n;
            }
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphSwitchGroup.TYPE);
        this.removeAll(GraphSwitchGroup2Switch.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphSwitch.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphSwitch)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(SWGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphSwitchGroup graphSwitchGroup = new GraphSwitchGroup(string);
            GraphSwitchGroup.ID iD = (GraphSwitchGroup.ID)graphSwitchGroup.getEntityID();
            graphSwitchGroup.setDisplayName(graphGroupKey.getLabel());
            graphSwitchGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphSwitchGroup.setSortingValue(graphGroupKey);
            graphSwitchGroup.setGroupKey(graphGroupKey);
            this.put(graphSwitchGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphSwitch graphSwitch = (GraphSwitch)vector.elementAt(n);
                GraphSwitch.ID iD2 = (GraphSwitch.ID)graphSwitch.getEntityID();
                GraphSwitchGroup2Switch graphSwitchGroup2Switch = new GraphSwitchGroup2Switch(iD.getID() + "+" + iD2.getID());
                graphSwitchGroup2Switch.setSwitchGroupID(iD);
                graphSwitchGroup2Switch.setSwitchID(iD2);
                this.put(graphSwitchGroup2Switch);
                ++n;
            }
        }
    }

    private void groupSubviewConnectivity() {
        Object object;
        GraphSubviewOtherL2Connectivity graphSubviewOtherL2Connectivity = new GraphSubviewOtherL2Connectivity("Connectivity");
        GraphSubviewOtherL2Connectivity.ID cfr_ignored_0 = (GraphSubviewOtherL2Connectivity.ID)graphSubviewOtherL2Connectivity.getEntityID();
        graphSubviewOtherL2Connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(graphSubviewOtherL2Connectivity);
        Enumeration enumeration = this.enumerate(GraphFCPortGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            object = (GraphFCPortGroup)enumeration.nextElement();
            graphSubviewOtherL2Connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewOtherL2Connectivity.getHealthStatus(), ((GraphEntity)object).getHealthStatus()));
        }
        object = this.enumerate(GraphSwitchGroup.TYPE);
        while (object.hasMoreElements()) {
            GraphSwitchGroup graphSwitchGroup = (GraphSwitchGroup)object.nextElement();
            graphSubviewOtherL2Connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewOtherL2Connectivity.getHealthStatus(), graphSwitchGroup.getHealthStatus()));
        }
    }

    private void groupSubviewDeviceLunBySingleGroup() {
        Comparable<Integer> comparable;
        this.removeAll(GraphLunGroup.TYPE);
        this.removeAll(GraphLunGroup2Lun.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphLun.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphLun)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = GraphGroupingUtilities.GROUPBY_ALL;
        Hashtable hashtable = GraphGroupingUtilities.applyGrouping(vector, comparable, this);
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphLunGroup graphLunGroup = new GraphLunGroup(string);
            GraphLunGroup.ID iD = (GraphLunGroup.ID)graphLunGroup.getEntityID();
            graphLunGroup.setDisplayName(graphGroupKey.getLabel());
            graphLunGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphLunGroup.setSortingValue(graphGroupKey);
            graphLunGroup.setGroupKey(graphGroupKey);
            this.put(graphLunGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphLun graphLun = (GraphLun)vector.elementAt(n);
                GraphLun.ID iD2 = (GraphLun.ID)graphLun.getEntityID();
                GraphLunGroup2Lun graphLunGroup2Lun = new GraphLunGroup2Lun(iD.getID() + "+" + iD2.getID());
                graphLunGroup2Lun.setLunGroupID(iD);
                graphLunGroup2Lun.setLunID(iD2);
                this.put(graphLunGroup2Lun);
                ++n;
            }
        }
    }

    private void groupSubviewDeviceVolume(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphVolumeGroup.TYPE);
        this.removeAll(GraphVolumeGroup2Volume.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphVolume.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphVolume)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(VOLUMEGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphVolumeGroup graphVolumeGroup = new GraphVolumeGroup(string);
            GraphVolumeGroup.ID iD = (GraphVolumeGroup.ID)graphVolumeGroup.getEntityID();
            graphVolumeGroup.setDisplayName(graphGroupKey.getLabel());
            graphVolumeGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphVolumeGroup.setSortingValue(graphGroupKey);
            graphVolumeGroup.setGroupKey(graphGroupKey);
            this.put(graphVolumeGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphVolume graphVolume = (GraphVolume)vector.elementAt(n);
                GraphVolume.ID iD2 = (GraphVolume.ID)graphVolume.getEntityID();
                GraphVolumeGroup2Volume graphVolumeGroup2Volume = new GraphVolumeGroup2Volume(iD.getID() + "+" + iD2.getID());
                graphVolumeGroup2Volume.setVolumeGroupID(iD);
                graphVolumeGroup2Volume.setVolumeID(iD2);
                this.put(graphVolumeGroup2Volume);
                ++n;
            }
        }
    }

    private void groupSubviewDevice() {
        Object object;
        GraphSubviewOtherL2Device graphSubviewOtherL2Device = new GraphSubviewOtherL2Device("Device");
        GraphSubviewOtherL2Device.ID cfr_ignored_0 = (GraphSubviewOtherL2Device.ID)graphSubviewOtherL2Device.getEntityID();
        graphSubviewOtherL2Device.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_DEVICE"));
        this.put(graphSubviewOtherL2Device);
        Enumeration enumeration = this.enumerate(GraphLunGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            object = (GraphLunGroup)enumeration.nextElement();
            graphSubviewOtherL2Device.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewOtherL2Device.getHealthStatus(), ((GraphEntity)object).getHealthStatus()));
        }
        object = this.enumerate(GraphVolumeGroup.TYPE);
        while (object.hasMoreElements()) {
            GraphVolumeGroup graphVolumeGroup = (GraphVolumeGroup)object.nextElement();
            graphSubviewOtherL2Device.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewOtherL2Device.getHealthStatus(), graphVolumeGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int n) {
        Object object;
        GraphFCPort.ID iD;
        GraphEntity graphEntity;
        Comparable<Boolean> comparable;
        Object object2;
        Object object3;
        Comparable comparable2;
        Object object4;
        Object object5;
        GraphEntity.ID iD2;
        GraphEntity graphEntity2;
        Enumeration enumeration = this.enumerate(GraphOtherGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            graphEntity2 = (GraphOtherGroup)enumeration.nextElement();
            iD2 = (GraphOtherGroup.ID)graphEntity2.getEntityID();
            Enumeration enumeration2 = this.associator(GraphOtherGroup2Other.TYPE, iD2);
            while (enumeration2.hasMoreElements()) {
                object5 = (GraphOther)enumeration2.nextElement();
                ((GraphEntity)object5).setIsFilterable(Boolean.FALSE);
            }
            graphEntity2.setIsFilterable(Boolean.FALSE);
        }
        enumeration = this.enumerate(GraphFCPortGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            graphEntity2 = (GraphFCPortGroup)enumeration.nextElement();
            iD2 = (GraphFCPortGroup.ID)graphEntity2.getEntityID();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            object4 = this.associator(GraphFCPortGroup2FCPort.TYPE, iD2);
            while (object4.hasMoreElements()) {
                comparable2 = (GraphFCPort)object4.nextElement();
                object3 = (GraphFCPort.ID)((GraphEntity)comparable2).getEntityID();
                object2 = this.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object3);
                if (object2.hasMoreElements()) {
                    ++n2;
                    if (n == 0) {
                        comparable = Boolean.FALSE;
                    } else if (GraphModelUtilities.isAbnormal((GraphEntity)comparable2)) {
                        comparable = Boolean.FALSE;
                    } else {
                        comparable = Boolean.TRUE;
                        if (n == 1) {
                            GraphSwitch graphSwitch;
                            graphEntity = (GraphFCPort2FCPort)object2.nextElement();
                            if (GraphModelUtilities.isAbnormal(graphEntity)) {
                                comparable = Boolean.FALSE;
                            }
                            if ((iD = ((GraphFCPort2FCPort)graphEntity).getFCPort1ID()).equals(object3)) {
                                iD = ((GraphFCPort2FCPort)graphEntity).getFCPort2ID();
                            }
                            if ((object = this.associator(GraphSwitch2FCPort.TYPE, iD)).hasMoreElements() && GraphModelUtilities.isAbnormal(graphSwitch = (GraphSwitch)object.nextElement())) {
                                comparable = Boolean.FALSE;
                            }
                        }
                    }
                    if (!((Boolean)comparable).booleanValue()) {
                        ++n3;
                    }
                } else {
                    ++n4;
                    comparable = n == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal((GraphEntity)comparable2) ? Boolean.FALSE : Boolean.TRUE);
                    if (!((Boolean)comparable).booleanValue()) {
                        ++n5;
                    }
                }
                ((GraphEntity)comparable2).setIsFilterable((Boolean)comparable);
            }
            ((GraphFCPortGroup)graphEntity2).setNumOfFCPortsInUse(new Integer(n2));
            ((GraphFCPortGroup)graphEntity2).setNumOfAbnormalFCPortsInUse(new Integer(n3));
            ((GraphFCPortGroup)graphEntity2).setNumOfFCPortsEmpty(new Integer(n4));
            ((GraphFCPortGroup)graphEntity2).setNumOfAbnormalFCPortsEmpty(new Integer(n5));
            graphEntity2.setIsFilterable(n3 + n5 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration = this.enumerate(GraphSwitchGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            graphEntity2 = (GraphSwitchGroup)enumeration.nextElement();
            iD2 = (GraphSwitchGroup.ID)graphEntity2.getEntityID();
            int n6 = 0;
            int n7 = 0;
            Enumeration enumeration3 = this.associator(GraphSwitchGroup2Switch.TYPE, iD2);
            while (enumeration3.hasMoreElements()) {
                GraphSwitch graphSwitch = (GraphSwitch)enumeration3.nextElement();
                object4 = (GraphSwitch.ID)graphSwitch.getEntityID();
                ++n6;
                if (n == 0) {
                    comparable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(graphSwitch)) {
                    comparable2 = Boolean.FALSE;
                } else {
                    comparable2 = Boolean.TRUE;
                    if (n == 1) {
                        object3 = this.associatorID(GraphSwitch2FCPort.TYPE, (GraphEntity.ID)object4);
                        while (object3.hasMoreElements()) {
                            comparable = (GraphFCPort.ID)object3.nextElement();
                            object2 = this.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)comparable);
                            if (!object2.hasMoreElements()) continue;
                            graphEntity = (GraphFCPort2FCPort)object2.nextElement();
                            if (GraphModelUtilities.isAbnormal(graphEntity)) {
                                comparable2 = Boolean.FALSE;
                                break;
                            }
                            iD = ((GraphFCPort2FCPort)graphEntity).getFCPort1ID();
                            if (iD.equals(comparable)) {
                                iD = ((GraphFCPort2FCPort)graphEntity).getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal((GraphEntity)(object = (GraphFCPort)this.get(iD)))) continue;
                            comparable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                graphSwitch.setIsFilterable((Boolean)comparable2);
                if (((Boolean)comparable2).booleanValue()) continue;
                ++n7;
            }
            ((GraphSwitchGroup)graphEntity2).setNumOfSwitches(new Integer(n6));
            ((GraphSwitchGroup)graphEntity2).setNumOfAbnormalSwitches(new Integer(n7));
            graphEntity2.setIsFilterable(n7 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration = this.enumerate(GraphLunGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            graphEntity2 = (GraphLunGroup)enumeration.nextElement();
            iD2 = (GraphLunGroup.ID)graphEntity2.getEntityID();
            int n8 = 0;
            int n9 = 0;
            Enumeration enumeration4 = this.associator(GraphLunGroup2Lun.TYPE, iD2);
            while (enumeration4.hasMoreElements()) {
                GraphLun graphLun = (GraphLun)enumeration4.nextElement();
                object4 = (GraphLun.ID)graphLun.getEntityID();
                ++n8;
                if (n == 0) {
                    comparable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(graphLun)) {
                    comparable2 = Boolean.FALSE;
                } else {
                    comparable2 = Boolean.TRUE;
                    if (n == 1) {
                        object3 = this.reference(GraphVolume2Lun.TYPE, (GraphEntity.ID)object4);
                        while (object3.hasMoreElements()) {
                            comparable = (GraphVolume2Lun)object3.nextElement();
                            if (GraphModelUtilities.isAbnormal((GraphEntity)comparable)) {
                                comparable2 = Boolean.FALSE;
                                break;
                            }
                            object2 = ((GraphVolume2Lun)comparable).getVolumeID();
                            graphEntity = (GraphVolume)this.get((GraphEntity.ID)object2);
                            if (!GraphModelUtilities.isAbnormal(graphEntity)) continue;
                            comparable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                graphLun.setIsFilterable((Boolean)comparable2);
                if (((Boolean)comparable2).booleanValue()) continue;
                ++n9;
            }
            ((GraphLunGroup)graphEntity2).setNumOfLuns(new Integer(n8));
            ((GraphLunGroup)graphEntity2).setNumOfAbnormalLuns(new Integer(n9));
            graphEntity2.setIsFilterable(n9 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration = this.enumerate(GraphVolumeGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            graphEntity2 = (GraphVolumeGroup)enumeration.nextElement();
            iD2 = (GraphVolumeGroup.ID)graphEntity2.getEntityID();
            int n10 = 0;
            int n11 = 0;
            Enumeration enumeration5 = this.associator(GraphVolumeGroup2Volume.TYPE, iD2);
            while (enumeration5.hasMoreElements()) {
                GraphVolume graphVolume = (GraphVolume)enumeration5.nextElement();
                object4 = (GraphVolume.ID)graphVolume.getEntityID();
                ++n10;
                if (n == 0) {
                    comparable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(graphVolume)) {
                    comparable2 = Boolean.FALSE;
                } else {
                    comparable2 = Boolean.TRUE;
                    if (n == 1) {
                        object3 = this.reference(GraphVolume2Lun.TYPE, (GraphEntity.ID)object4);
                        while (object3.hasMoreElements()) {
                            comparable = (GraphVolume2Lun)object3.nextElement();
                            if (GraphModelUtilities.isAbnormal(comparable)) {
                                comparable2 = Boolean.FALSE;
                                break;
                            }
                            object2 = ((GraphVolume2Lun)comparable).getLunID();
                            graphEntity = (GraphLun)this.get((GraphEntity.ID)object2);
                            if (!GraphModelUtilities.isAbnormal(graphEntity)) continue;
                            comparable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                graphVolume.setIsFilterable((Boolean)comparable2);
                if (((Boolean)comparable2).booleanValue()) continue;
                ++n11;
            }
            ((GraphVolumeGroup)graphEntity2).setNumOfVolumes(new Integer(n10));
            ((GraphVolumeGroup)graphEntity2).setNumOfAbnormalVolumes(new Integer(n11));
            graphEntity2.setIsFilterable(n11 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration = this.enumerate(GraphSubviewOtherL2Connectivity.TYPE);
        while (enumeration.hasMoreElements()) {
            graphEntity2 = (GraphSubviewOtherL2Connectivity)enumeration.nextElement();
            int n12 = 0;
            int n13 = 0;
            object5 = this.enumerate(GraphFCPortGroup.TYPE);
            while (object5.hasMoreElements()) {
                GraphFCPortGroup graphFCPortGroup = (GraphFCPortGroup)object5.nextElement();
                n12 += graphFCPortGroup.getNumOfFCPortsInUse() + graphFCPortGroup.getNumOfFCPortsEmpty();
                n13 += graphFCPortGroup.getNumOfAbnormalFCPortsInUse() + graphFCPortGroup.getNumOfAbnormalFCPortsEmpty();
            }
            ((GraphSubviewOtherL2Connectivity)graphEntity2).setNumOfFCPorts(new Integer(n12));
            ((GraphSubviewOtherL2Connectivity)graphEntity2).setNumOfAbnormalFCPorts(new Integer(n13));
            n12 = 0;
            n13 = 0;
            object5 = this.enumerate(GraphSwitchGroup.TYPE);
            while (object5.hasMoreElements()) {
                GraphSwitchGroup graphSwitchGroup = (GraphSwitchGroup)object5.nextElement();
                n12 += graphSwitchGroup.getNumOfSwitches().intValue();
                n13 += graphSwitchGroup.getNumOfAbnormalSwitches().intValue();
            }
            ((GraphSubviewOtherL2Connectivity)graphEntity2).setNumOfSwitches(new Integer(n12));
            ((GraphSubviewOtherL2Connectivity)graphEntity2).setNumOfAbnormalSwitches(new Integer(n13));
            graphEntity2.setIsFilterable(Boolean.FALSE);
        }
        enumeration = this.enumerate(GraphSubviewOtherL2Device.TYPE);
        while (enumeration.hasMoreElements()) {
            graphEntity2 = (GraphSubviewOtherL2Device)enumeration.nextElement();
            int n14 = 0;
            int n15 = 0;
            object5 = this.enumerate(GraphLunGroup.TYPE);
            while (object5.hasMoreElements()) {
                GraphLunGroup graphLunGroup = (GraphLunGroup)object5.nextElement();
                n14 += graphLunGroup.getNumOfLuns().intValue();
                n15 += graphLunGroup.getNumOfAbnormalLuns().intValue();
            }
            ((GraphSubviewOtherL2Device)graphEntity2).setNumOfLuns(new Integer(n14));
            ((GraphSubviewOtherL2Device)graphEntity2).setNumOfAbnormalLuns(new Integer(n15));
            n14 = 0;
            n15 = 0;
            object5 = this.enumerate(GraphVolumeGroup.TYPE);
            while (object5.hasMoreElements()) {
                GraphVolumeGroup graphVolumeGroup = (GraphVolumeGroup)object5.nextElement();
                n14 += graphVolumeGroup.getNumOfVolumes().intValue();
                n15 += graphVolumeGroup.getNumOfAbnormalVolumes().intValue();
            }
            ((GraphSubviewOtherL2Device)graphEntity2).setNumOfVolumes(new Integer(n14));
            ((GraphSubviewOtherL2Device)graphEntity2).setNumOfAbnormalVolumes(new Integer(n15));
            graphEntity2.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        private static final long serialVersionUID = -4244906403445311481L;

        public ID(GraphOther graphOther) {
            super("OtherL2", graphOther.getEntityID());
        }
    }
}

