/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTable;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.JTopoTableConnectionL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTableConnectionL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTableZone;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOverview;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public abstract class AbstractJTopoTabular
extends AbstractJTopoBase {
    protected static final String TABLE_OVERVIEW = GuiUtil.getString("TOPO_LABEL_ENTITY_TOPOLOGY");
    protected static final String TABLE_FABRIC = GuiUtil.getString("TOPO_LABEL_ENTITY_FABRIC");
    protected static final String TABLE_COMPUTER = GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTER");
    protected static final String TABLE_SWITCH = GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH");
    protected static final String TABLE_SUBSYSTEM = GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEM");
    protected static final String TABLE_TAPELIBRARY = GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARY");
    protected static final String TABLE_OTHER = String.valueOf(GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER")) + "/" + GuiUtil.getString("TOPO_LABEL_ENTITY_UNKNOWN");
    protected static final String TABLE_HBA = GuiUtil.getString("TOPO_LABEL_ENTITY_HBA");
    protected static final String TABLE_FCPORT = GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT");
    protected static final String TABLE_DISK = GuiUtil.getString("TOPO_LABEL_ENTITY_DISK");
    protected static final String TABLE_POOL = GuiUtil.getString("TOPO_LABEL_ENTITY_POOL");
    protected static final String TABLE_VOLUME = GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUME");
    protected static final String TABLE_LOGICALVOLUME = GuiUtil.getString("TOPO_LABEL_ENTITY_LOGICALVOLUME");
    protected static final String TABLE_LUN = GuiUtil.getString("TOPO_LABEL_ENTITY_LUN");
    protected static final String TABLE_FILESYSTEM = GuiUtil.getString("TOPO_LABEL_ENTITY_FILESYSTEM");
    protected static final String TABLE_TABLESPACE = GuiUtil.getString("TOPO_LABEL_ENTITY_TABLESPACE");
    protected static final String TABLE_TAPEDRIVE = GuiUtil.getString("TOPO_LABEL_ENTITY_TAPEDRIVE");
    protected static final String TABLE_MEDIACHANGER = GuiUtil.getString("TOPO_LABEL_ENTITY_MEDIACHANGER");
    protected static final String TABLE_CONNECTION = GuiUtil.getString("TOPO_LABEL_ENTITY_CONNECTION");
    protected static final String TABLE_ZONE = GuiUtil.getString("TOPO_LABEL_ENTITY_ZONE");
    protected ControllerView controllerView;
    protected GraphModel dataModel;
    protected JTabbedPane tabbedPane;
    protected JPanel actionP;
    protected JComboBox actionCBDefault;
    protected JComboBox actionCBConnection;
    protected JComboBox actionCBZone;
    protected Action actionExandAll;
    protected Action actionCollapseAll;
    protected Action actionCloseView;
    protected Action actionCloseAllViews;
    protected Action actionClearHighlights;
    protected Action actionRefreshView;
    protected Action actionRefreshAllViews;
    protected Action actionGlobalSetting;
    protected Action actionRefreshSetting;
    protected JComboBox locateCB;

    protected AbstractJTopoTabular() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(LineBorder.createGrayLineBorder());
        jPanel.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.actionP = new JPanel();
        this.actionP.setLayout(new FlowLayout(0));
        jPanel.add((Component)this.actionP, "West");
        JLabel jLabel = new JLabel(String.valueOf(GuiUtil.getString("TOPO_LABEL_TABULAR_ACTION")) + ": ");
        this.actionP.add(jLabel);
        this.actionExandAll = new Action_ExpandAll();
        this.actionCollapseAll = new Action_CollapseAll();
        this.actionCloseView = new Action_CloseView();
        this.actionCloseAllViews = new Action_CloseAllViews();
        this.actionClearHighlights = new Action_ClearHighlights();
        this.actionRefreshView = new Action_RefreshView();
        this.actionRefreshAllViews = new Action_RefreshAllViews();
        this.actionGlobalSetting = new Action_GlobalSetting();
        this.actionRefreshSetting = new Action_RefreshSetting();
        this.actionCBDefault = new JComboBox();
        this.actionP.add(this.actionCBDefault);
        this.actionCBDefault.addActionListener(new AL_ActionCB());
        Serializable serializable = this.actionCBDefault.getActionMap();
        ((ActionMap)serializable).put(this.actionExandAll.getValue("Name"), this.actionExandAll);
        ((ActionMap)serializable).put(this.actionCollapseAll.getValue("Name"), this.actionCollapseAll);
        ((ActionMap)serializable).put(this.actionCloseView.getValue("Name"), this.actionCloseView);
        ((ActionMap)serializable).put(this.actionCloseAllViews.getValue("Name"), this.actionCloseAllViews);
        ((ActionMap)serializable).put(this.actionClearHighlights.getValue("Name"), this.actionClearHighlights);
        ((ActionMap)serializable).put(this.actionRefreshView.getValue("Name"), this.actionRefreshView);
        ((ActionMap)serializable).put(this.actionRefreshAllViews.getValue("Name"), this.actionRefreshAllViews);
        ((ActionMap)serializable).put(this.actionGlobalSetting.getValue("Name"), this.actionGlobalSetting);
        ((ActionMap)serializable).put(this.actionRefreshSetting.getValue("Name"), this.actionRefreshSetting);
        this.actionCBConnection = new JComboBox();
        this.actionP.add(this.actionCBConnection);
        this.actionCBConnection.addActionListener(new AL_ActionCB());
        serializable = this.actionCBConnection.getActionMap();
        ((ActionMap)serializable).put(this.actionCloseView.getValue("Name"), this.actionCloseView);
        ((ActionMap)serializable).put(this.actionCloseAllViews.getValue("Name"), this.actionCloseAllViews);
        ((ActionMap)serializable).put(this.actionClearHighlights.getValue("Name"), this.actionClearHighlights);
        ((ActionMap)serializable).put(this.actionRefreshView.getValue("Name"), this.actionRefreshView);
        ((ActionMap)serializable).put(this.actionRefreshAllViews.getValue("Name"), this.actionRefreshAllViews);
        ((ActionMap)serializable).put(this.actionGlobalSetting.getValue("Name"), this.actionGlobalSetting);
        ((ActionMap)serializable).put(this.actionRefreshSetting.getValue("Name"), this.actionRefreshSetting);
        this.actionCBZone = new JComboBox();
        this.actionP.add(this.actionCBZone);
        this.actionCBZone.addActionListener(new AL_ActionCB());
        serializable = this.actionCBZone.getActionMap();
        ((ActionMap)serializable).put(this.actionExandAll.getValue("Name"), this.actionExandAll);
        ((ActionMap)serializable).put(this.actionCollapseAll.getValue("Name"), this.actionCollapseAll);
        ((ActionMap)serializable).put(this.actionCloseView.getValue("Name"), this.actionCloseView);
        ((ActionMap)serializable).put(this.actionCloseAllViews.getValue("Name"), this.actionCloseAllViews);
        ((ActionMap)serializable).put(this.actionClearHighlights.getValue("Name"), this.actionClearHighlights);
        ((ActionMap)serializable).put(this.actionRefreshView.getValue("Name"), this.actionRefreshView);
        ((ActionMap)serializable).put(this.actionRefreshAllViews.getValue("Name"), this.actionRefreshAllViews);
        ((ActionMap)serializable).put(this.actionGlobalSetting.getValue("Name"), this.actionGlobalSetting);
        ((ActionMap)serializable).put(this.actionRefreshSetting.getValue("Name"), this.actionRefreshSetting);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new FlowLayout(0));
        jPanel.add((Component)serializable, "East");
        JLabel jLabel2 = new JLabel(String.valueOf(GuiUtil.getString("TOPO_LABEL_TABULAR_LOCATE")) + ": ");
        ((Container)serializable).add(jLabel2);
        this.locateCB = new JComboBox();
        this.locateCB.setEditable(true);
        this.locateCB.setFont(TopoResource.FONT_PLAIN);
        this.locateCB.addActionListener(new Action_Locate());
        ((Container)serializable).add(this.locateCB);
        JButton jButton = new JButton(GuiUtil.getString("TOPO_LABEL_TABULAR_LOCATE_GO"));
        jButton.addActionListener(new Action_Locate_Find());
        ((Container)serializable).add(jButton);
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new CL_TabSelected());
        this.updateActionDropdownList(null);
        this.addGlobalActionForConnectionTable();
        this.addGlobalActionForZoneTable();
    }

    private void initState() {
        this.controllerView = null;
        this.dataModel = null;
        if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public void resetState() {
        this.initState();
    }

    protected void reattach() {
    }

    public ControllerView getControllerView() {
        return this.controllerView;
    }

    public void setSessionModel(ControllerView controllerView) {
        this.controllerView = controllerView;
        TopoSetting topoSetting = controllerView.getControllerApp().getTopoSetting();
        this.setOverlayHealthEnabled(topoSetting.isOverlayHealthEnabled());
        this.setOverlayPerfEnabled(topoSetting.isOverlayPerfEnabled());
    }

    public GraphModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel graphModel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("AbstractJTopoTabular, setDataModel()");
        }
        if (graphModel == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("AbstractJTopoTabular.setModel(), dataModel=null");
            }
            return;
        }
        this.dataModel = graphModel;
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
            abstractJTopoTable.setDataModel(graphModel);
            ++n;
        }
        this.updateContainer();
    }

    public JComboBox getActionCBDefault() {
        return this.actionCBDefault;
    }

    public JComboBox getActionCBConnection() {
        return this.actionCBConnection;
    }

    public JComboBox getActionCBZone() {
        return this.actionCBZone;
    }

    protected void applySelection(ControllerView.SelectionDelta selectionDelta) {
        int n = -1;
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.tabbedPane.getTabCount()) {
            boolean bl2;
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n2);
            if (!(abstractJTopoTable instanceof JTopoTableZone) && (bl2 = abstractJTopoTable.applySelection(selectionDelta))) {
                if (n == -1) {
                    n = n2;
                }
                if (this.tabbedPane.getSelectedIndex() == n2) {
                    bl = true;
                }
            }
            ++n2;
        }
        if (n != -1 && !bl) {
            this.tabbedPane.setSelectedIndex(n);
        }
        this.updateActionDropdownList(selectionDelta.getClickedEntityID());
    }

    protected void applyHighlight(ControllerView.HighlightDelta highlightDelta) {
    }

    protected void applyLocate(ControllerView.LocateDelta locateDelta) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
            abstractJTopoTable.applyLocate(locateDelta);
            ++n;
        }
    }

    protected void setShowConnectionEnabled(boolean bl) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
            abstractJTopoTable.setShowConnectionEnabled(bl);
            ++n;
        }
    }

    protected void setShowZoneEnabled(boolean bl) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            String string = this.tabbedPane.getTitleAt(n);
            if (string.equals(TABLE_ZONE)) {
                int n2;
                this.tabbedPane.setEnabledAt(n, bl);
                if (!bl && (n2 = this.tabbedPane.getSelectedIndex()) == n) {
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
            ++n;
        }
    }

    public void setOverlayHealthEnabled(boolean bl) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
            abstractJTopoTable.setOverlayHealthEnabled(bl);
            ++n;
        }
    }

    public void setOverlayPerfEnabled(boolean bl) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
            abstractJTopoTable.setOverlayPerfEnabled(bl);
            ++n;
        }
    }

    public void setFilteringLevel(int n) {
        int n2 = 0;
        while (n2 < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n2);
            abstractJTopoTable.setFilteringLevel(n);
            ++n2;
        }
    }

    public void setPinList(PinList pinList) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
            abstractJTopoTable.setPinnedList(pinList);
            ++n;
        }
    }

    public abstract AbstractJTopoTable findTable(GraphEntity.ID var1);

    public DefaultTopoTableModel.MemberNode getFirstMember(GraphEntity.ID iD) {
        DefaultTopoTableModel.MemberNode memberNode = null;
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
            DefaultTopoTableModel defaultTopoTableModel = abstractJTopoTable.getTableModel();
            memberNode = defaultTopoTableModel.findMemberNode(iD);
            if (memberNode != null) break;
            ++n;
        }
        return memberNode;
    }

    public Vector getAllMembers(GraphEntity.ID iD) {
        Vector<DefaultTopoTableModel.MemberNode> vector = new Vector<DefaultTopoTableModel.MemberNode>();
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
            DefaultTopoTableModel defaultTopoTableModel = abstractJTopoTable.getTableModel();
            DefaultTopoTableModel.MemberNode memberNode = defaultTopoTableModel.findMemberNode(iD);
            if (memberNode != null) {
                vector.add(memberNode);
            }
            ++n;
        }
        return vector;
    }

    public void updateActionDropdownList(GraphEntity.ID iD) {
        ActionMap actionMap = this.actionCBDefault.getActionMap();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.actionCBDefault.getModel();
        defaultComboBoxModel.removeAllElements();
        DefaultTopoTableModel.MemberNode memberNode = this.getFirstMember(iD);
        if (memberNode != null) {
            if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
                Object object;
                Object object2;
                Serializable serializable;
                Vector vector = new Vector();
                int n = 0;
                while (n < this.tabbedPane.getTabCount()) {
                    serializable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
                    object2 = serializable.getTableModel();
                    object = ((DefaultTopoTableModel)object2).getRootNode();
                    this.updateActionDropdownList_groupSelectedHelper((DefaultTopoTableModel.GroupNode)object, vector);
                    ++n;
                }
                if (vector.size() == 1) {
                    DefaultTopoTableModel.GroupNode groupNode = (DefaultTopoTableModel.GroupNode)vector.elementAt(0);
                    serializable = groupNode.getRef();
                    if (serializable instanceof GraphComputerGroup.ID || serializable instanceof GraphSwitchGroup.ID || serializable instanceof GraphSubsystemGroup.ID || serializable instanceof GraphTapeLibraryGroup.ID || serializable instanceof GraphOtherGroup.ID) {
                        object2 = new Action_OpenDetailView(groupNode);
                        actionMap.put(object2.getValue("Name"), (Action)object2);
                        defaultComboBoxModel.addElement(object2.getValue("Name"));
                    }
                    if (serializable instanceof GraphFabric.ID) {
                        object2 = new Action_LaunchDetailPanel(groupNode);
                        actionMap.put(object2.getValue("Name"), (Action)object2);
                        defaultComboBoxModel.addElement(object2.getValue("Name"));
                    }
                }
                if (vector.size() > 0) {
                    boolean bl = true;
                    new Vector();
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        object2 = (DefaultTopoTableModel.MemberNode)vector.elementAt(n2);
                        object = ((DefaultTopoTableModel.MemberNode)object2).getRef();
                        GraphEntity graphEntity = this.dataModel.get((GraphEntity.ID)object);
                        if (!(graphEntity instanceof GraphFabric) || !GraphModelConstant.STATUS_MISSING.equals(graphEntity.getHealthStatus())) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    if (bl && vector.size() > 0) {
                        Action_RemoveMissingEntity action_RemoveMissingEntity = new Action_RemoveMissingEntity(vector);
                        actionMap.put(action_RemoveMissingEntity.getValue("Name"), action_RemoveMissingEntity);
                        defaultComboBoxModel.addElement(action_RemoveMissingEntity.getValue("Name"));
                    }
                }
            } else {
                Object object;
                Object object3;
                Serializable serializable;
                Vector vector = new Vector();
                int n = 0;
                while (n < this.tabbedPane.getTabCount()) {
                    serializable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n);
                    object3 = serializable.getTableModel();
                    object = ((DefaultTopoTableModel)object3).getRootNode();
                    this.updateActionDropdownList_memberSelectedHelper((DefaultTopoTableModel.GroupNode)object, vector);
                    ++n;
                }
                if (vector.size() == 1) {
                    DefaultTopoTableModel.MemberNode memberNode2 = (DefaultTopoTableModel.MemberNode)vector.elementAt(0);
                    serializable = memberNode2.getRef();
                    if (serializable instanceof GraphFabric.ID || serializable instanceof GraphSwitch.ID || serializable instanceof GraphSubsystem.ID || serializable instanceof GraphTapeLibrary.ID || serializable instanceof GraphComputer.ID || serializable instanceof GraphOther.ID || serializable instanceof GraphFabricSummary.ID || serializable instanceof GraphComputerSummary.ID || serializable instanceof GraphSwitchSummary.ID || serializable instanceof GraphStorageSummary.ID || serializable instanceof GraphOtherSummary.ID) {
                        object3 = new Action_OpenDetailView(memberNode2);
                        actionMap.put(object3.getValue("Name"), (Action)object3);
                        defaultComboBoxModel.addElement(object3.getValue("Name"));
                    }
                    if (serializable instanceof GraphFabric.ID || serializable instanceof GraphSwitch.ID || serializable instanceof GraphSubsystem.ID || serializable instanceof GraphTapeLibrary.ID || serializable instanceof GraphComputer.ID || serializable instanceof GraphOther.ID) {
                        object3 = new Action_LaunchDetailPanel(memberNode2);
                        actionMap.put(object3.getValue("Name"), (Action)object3);
                        defaultComboBoxModel.addElement(object3.getValue("Name"));
                    }
                    if (serializable instanceof GraphSwitch.ID || serializable instanceof GraphSubsystem.ID || serializable instanceof GraphTapeLibrary.ID) {
                        object3 = new Action_LaunchElementManager(memberNode2);
                        actionMap.put(object3.getValue("Name"), (Action)object3);
                        defaultComboBoxModel.addElement(object3.getValue("Name"));
                    }
                }
                if (vector.size() > 0) {
                    Comparable comparable;
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        object3 = (DefaultTopoTableModel.MemberNode)vector.elementAt(n3);
                        object = ((DefaultTopoTableModel.MemberNode)object3).getRef();
                        if (!(object instanceof GraphSwitch.ID || object instanceof GraphSubsystem.ID || object instanceof GraphTapeLibrary.ID || object instanceof GraphComputer.ID || object instanceof GraphOther.ID)) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl && vector.size() > 0) {
                        n3 = 1;
                        int n4 = 0;
                        while (n4 < vector.size()) {
                            object = (DefaultTopoTableModel.MemberNode)vector.elementAt(n4);
                            comparable = ((DefaultTopoTableModel.MemberNode)object).getRef();
                            if (this.controllerView.getControllerApp().getPinList().isInPinList((GraphEntity.ID)comparable)) {
                                n3 = 0;
                                break;
                            }
                            ++n4;
                        }
                        object3 = new Action_Pin(vector, n3 != 0);
                        actionMap.put(object3.getValue("Name"), (Action)object3);
                        defaultComboBoxModel.addElement(object3.getValue("Name"));
                    }
                    bl = true;
                    n3 = 0;
                    while (n3 < vector.size()) {
                        object3 = (DefaultTopoTableModel.MemberNode)vector.elementAt(n3);
                        object = ((DefaultTopoTableModel.MemberNode)object3).getRef();
                        comparable = this.dataModel.get((GraphEntity.ID)object);
                        if (!((comparable instanceof GraphSwitch || comparable instanceof GraphSubsystem || comparable instanceof GraphTapeLibrary || comparable instanceof GraphComputer || comparable instanceof GraphOther || comparable instanceof GraphFabric) && GraphModelConstant.STATUS_MISSING.equals(((GraphEntity)comparable).getHealthStatus()))) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl && vector.size() > 0) {
                        Action_RemoveMissingEntity action_RemoveMissingEntity = new Action_RemoveMissingEntity(vector);
                        actionMap.put(action_RemoveMissingEntity.getValue("Name"), action_RemoveMissingEntity);
                        defaultComboBoxModel.addElement(action_RemoveMissingEntity.getValue("Name"));
                    }
                }
            }
        }
        this.addGlobalActionForDefaultTable();
    }

    protected void updateActionDropdownList_groupSelectedHelper(DefaultTopoTableModel.GroupNode groupNode, Vector vector) {
        Vector vector2 = groupNode.getMemberVector();
        int n = 0;
        while (n < vector2.size()) {
            DefaultTopoTableModel.MemberNode memberNode = (DefaultTopoTableModel.MemberNode)vector2.elementAt(n);
            if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
                DefaultTopoTableModel.GroupNode groupNode2 = (DefaultTopoTableModel.GroupNode)memberNode;
                if (groupNode2.isSelected()) {
                    vector.add(groupNode2);
                }
                this.updateActionDropdownList_groupSelectedHelper(groupNode2, vector);
            }
            ++n;
        }
    }

    protected void updateActionDropdownList_memberSelectedHelper(DefaultTopoTableModel.GroupNode groupNode, Vector vector) {
        Vector vector2 = groupNode.getMemberVector();
        int n = 0;
        while (n < vector2.size()) {
            DefaultTopoTableModel.MemberNode memberNode = (DefaultTopoTableModel.MemberNode)vector2.elementAt(n);
            if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
                DefaultTopoTableModel.GroupNode groupNode2 = (DefaultTopoTableModel.GroupNode)memberNode;
                this.updateActionDropdownList_memberSelectedHelper(groupNode2, vector);
            } else if (memberNode.isSelected()) {
                vector.add(memberNode);
            }
            ++n;
        }
    }

    protected void addGlobalActionForDefaultTable() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.actionCBDefault.getModel();
        defaultComboBoxModel.addElement(this.actionExandAll.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionCollapseAll.getValue("Name"));
        if (!(this instanceof JTopoTabularOverview)) {
            defaultComboBoxModel.addElement(this.actionCloseView.getValue("Name"));
        }
        defaultComboBoxModel.addElement(this.actionCloseAllViews.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionClearHighlights.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshView.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshAllViews.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionGlobalSetting.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshSetting.getValue("Name"));
    }

    protected void addGlobalActionForConnectionTable() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.actionCBConnection.getModel();
        defaultComboBoxModel.addElement(this.actionCloseView.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionCloseAllViews.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionClearHighlights.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshView.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshAllViews.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionGlobalSetting.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshSetting.getValue("Name"));
    }

    protected void addGlobalActionForZoneTable() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.actionCBZone.getModel();
        defaultComboBoxModel.addElement(this.actionExandAll.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionCollapseAll.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionCloseView.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionCloseAllViews.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionClearHighlights.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshView.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshAllViews.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionGlobalSetting.getValue("Name"));
        defaultComboBoxModel.addElement(this.actionRefreshSetting.getValue("Name"));
    }

    public void locate(String string) {
        ControllerView.LocateDelta locateDelta = new ControllerView.LocateDelta(string, this.controllerView.getLocate());
        if (string == null) {
            locateDelta.removeAll();
        } else {
            int n = -1;
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.tabbedPane.getTabCount()) {
                AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)this.tabbedPane.getComponentAt(n2);
                boolean bl2 = abstractJTopoTable.locate(locateDelta, string);
                if (bl2) {
                    if (n == -1) {
                        n = n2;
                    }
                    if (this.tabbedPane.getSelectedIndex() == n2) {
                        bl = true;
                    }
                }
                ++n2;
            }
            if (!bl && n != -1) {
                this.tabbedPane.setSelectedIndex(n);
            }
        }
        this.controllerView.updateLocate(locateDelta);
    }

    public void openView(DefaultTopoTableModel.MemberNode memberNode) {
        GraphEntity.ID iD = memberNode.getRef();
        GraphEntity graphEntity = this.dataModel.get(iD);
        Vector<GraphEntity.ID> vector = null;
        if (graphEntity instanceof GraphComputerGroup || graphEntity instanceof GraphSwitchGroup || graphEntity instanceof GraphSubsystemGroup || graphEntity instanceof GraphTapeLibraryGroup || graphEntity instanceof GraphOtherGroup) {
            Vector vector2 = ((DefaultTopoTableModel.GroupNode)memberNode).getMemberVector();
            vector = new Vector<GraphEntity.ID>();
            int n = 0;
            while (n < vector2.size()) {
                DefaultTopoTableModel.MemberNode memberNode2 = (DefaultTopoTableModel.MemberNode)vector2.elementAt(n);
                GraphEntity.ID iD2 = memberNode2.getRef();
                vector.add(iD2);
                ++n;
            }
        }
        this.controllerView.getControllerApp().openView(graphEntity, vector);
    }

    protected class AL_ActionCB
    implements ActionListener {
        private Object oldItem = null;

        protected AL_ActionCB() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (this.oldItem != object) {
                this.oldItem = object;
            } else {
                ActionMap actionMap = jComboBox.getActionMap();
                Action action = actionMap.get(object);
                if (action != null) {
                    action.actionPerformed(actionEvent);
                }
            }
        }
    }

    protected class Action_OpenDetailView
    extends AbstractAction {
        private DefaultTopoTableModel.MemberNode member;

        public Action_OpenDetailView(DefaultTopoTableModel.MemberNode memberNode) {
            this.member = memberNode;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_OPEN"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractJTopoTabular.this.openView(this.member);
        }
    }

    protected class Action_Pin
    extends AbstractAction {
        private Vector memberV;
        private boolean pinned;

        public Action_Pin(Vector vector, boolean bl) {
            this.memberV = vector;
            this.pinned = bl;
            if (bl) {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_PINNED"));
            } else {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_UNPINNED"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Vector<GraphEntity.ID> vector = new Vector<GraphEntity.ID>();
            int n = 0;
            while (n < this.memberV.size()) {
                object = (DefaultTopoTableModel.MemberNode)this.memberV.elementAt(n);
                GraphEntity.ID iD = ((DefaultTopoTableModel.MemberNode)object).getRef();
                vector.add(iD);
                ++n;
            }
            ControllerApp controllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            object = controllerApp.getPinList();
            if (this.pinned) {
                ((PinList)object).addPins(vector);
            } else {
                ((PinList)object).removePins(vector);
            }
        }
    }

    protected class Action_LaunchDetailPanel
    extends AbstractAction {
        private DefaultTopoTableModel.MemberNode member;

        public Action_LaunchDetailPanel(DefaultTopoTableModel.MemberNode memberNode) {
            this.member = memberNode;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_DETAIL"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphEntity.ID iD = this.member.getRef();
            ControllerApp controllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            controllerApp.launchDetailPanel(iD);
        }
    }

    protected class Action_LaunchElementManager
    extends AbstractAction {
        private DefaultTopoTableModel.MemberNode member;

        public Action_LaunchElementManager(DefaultTopoTableModel.MemberNode memberNode) {
            this.member = memberNode;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_ELEMENTMANAGER"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphEntity.ID iD = this.member.getRef();
            GraphEntity graphEntity = AbstractJTopoTabular.this.dataModel.get(iD);
            ControllerApp controllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            controllerApp.launchElementManager(graphEntity);
        }
    }

    protected class Action_RemoveMissingEntity
    extends AbstractAction {
        private Vector memberV;

        public Action_RemoveMissingEntity(Vector vector) {
            this.memberV = vector;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_REMOVE"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector<GraphEntity> vector = new Vector<GraphEntity>();
            int n = 0;
            while (n < this.memberV.size()) {
                DefaultTopoTableModel.MemberNode memberNode = (DefaultTopoTableModel.MemberNode)this.memberV.elementAt(n);
                GraphEntity.ID iD = memberNode.getRef();
                GraphEntity graphEntity = AbstractJTopoTabular.this.dataModel.get(iD);
                vector.add(graphEntity);
                ++n;
            }
            ControllerApp controllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            controllerApp.removeMissingEntity(vector);
        }
    }

    protected class Action_ExpandAll
    extends AbstractAction {
        public Action_ExpandAll() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_EXPANDALL"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < AbstractJTopoTabular.this.tabbedPane.getTabCount()) {
                AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)AbstractJTopoTabular.this.tabbedPane.getComponentAt(n);
                abstractJTopoTable.expandAll();
                ++n;
            }
        }
    }

    protected class Action_CollapseAll
    extends AbstractAction {
        public Action_CollapseAll() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_COLLAPSEALL"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < AbstractJTopoTabular.this.tabbedPane.getTabCount()) {
                AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)AbstractJTopoTabular.this.tabbedPane.getComponentAt(n);
                abstractJTopoTable.collapseAll();
                ++n;
            }
        }
    }

    protected class Action_RefreshView
    extends AbstractAction {
        public Action_RefreshView() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHTHISVIEW"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphModel.ID iD = AbstractJTopoTabular.this.dataModel.getModelID();
            ControllerApp controllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            controllerApp.refreshView(iD);
        }
    }

    protected class Action_RefreshAllViews
    extends AbstractAction {
        public Action_RefreshAllViews() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHALLVIEWS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerApp controllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            controllerApp.refreshAllViews();
        }
    }

    protected class Action_CloseView
    extends AbstractAction {
        public Action_CloseView() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLOSETHISVIEW"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphModel.ID iD = AbstractJTopoTabular.this.dataModel.getModelID();
            ControllerApp controllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            controllerApp.closeView(iD);
        }
    }

    protected class Action_CloseAllViews
    extends AbstractAction {
        public Action_CloseAllViews() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLOSEALLVIEWS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerApp controllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            controllerApp.closeAllViews();
        }
    }

    protected class Action_ClearHighlights
    extends AbstractAction {
        public Action_ClearHighlights() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLEARHIGHLIGHTS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControllerView.HighlightDelta highlightDelta = new ControllerView.HighlightDelta(AbstractJTopoTabular.this.controllerView.getHighlight());
            highlightDelta.removeAll();
            AbstractJTopoTabular.this.controllerView.updateHighlight(highlightDelta);
            ControllerView.LocateDelta locateDelta = new ControllerView.LocateDelta(null, AbstractJTopoTabular.this.controllerView.getLocate());
            locateDelta.removeAll();
            AbstractJTopoTabular.this.controllerView.updateLocate(locateDelta);
        }
    }

    protected class Action_GlobalSetting
    extends AbstractAction {
        public Action_GlobalSetting() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_GLOBALSETTINGS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTopoApp jTopoApp = AbstractJTopoTabular.this.controllerView.getControllerApp().getTopoApp();
            jTopoApp.showGlobalSettingDialog();
        }
    }

    protected class Action_RefreshSetting
    extends AbstractAction {
        public Action_RefreshSetting() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHSETTINGS"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTopoApp jTopoApp = AbstractJTopoTabular.this.controllerView.getControllerApp().getTopoApp();
            jTopoApp.showRefreshSettingDialog();
        }
    }

    protected class Action_Print
    extends AbstractAction {
        public Action_Print() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_PRINT"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class Action_PrintPreview
    extends AbstractAction {
        public Action_PrintPreview() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_PRINTPREVIEW"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class CL_TabSelected
    implements ChangeListener {
        protected CL_TabSelected() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractJTopoTable abstractJTopoTable = (AbstractJTopoTable)AbstractJTopoTabular.this.tabbedPane.getSelectedComponent();
            if (abstractJTopoTable instanceof JTopoTableConnectionL1 || abstractJTopoTable instanceof JTopoTableConnectionL2) {
                AbstractJTopoTabular.this.actionCBDefault.setVisible(false);
                AbstractJTopoTabular.this.actionCBConnection.setVisible(true);
                AbstractJTopoTabular.this.actionCBZone.setVisible(false);
            } else if (abstractJTopoTable instanceof JTopoTableZone) {
                AbstractJTopoTabular.this.actionCBDefault.setVisible(false);
                AbstractJTopoTabular.this.actionCBConnection.setVisible(false);
                AbstractJTopoTabular.this.actionCBZone.setVisible(true);
            } else {
                AbstractJTopoTabular.this.actionCBDefault.setVisible(true);
                AbstractJTopoTabular.this.actionCBConnection.setVisible(false);
                AbstractJTopoTabular.this.actionCBZone.setVisible(false);
            }
        }
    }

    protected class Action_Locate
    implements ActionListener {
        protected Action_Locate() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)AbstractJTopoTabular.this.locateCB.getSelectedItem();
            if (string == null) {
                AbstractJTopoTabular.this.locate(null);
                return;
            }
            if ((string = string.trim()).equals("")) {
                AbstractJTopoTabular.this.locate(null);
                return;
            }
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)AbstractJTopoTabular.this.locateCB.getModel();
            int n = defaultComboBoxModel.getIndexOf(string);
            if (n != -1) {
                defaultComboBoxModel.removeElementAt(n);
            }
            defaultComboBoxModel.insertElementAt(string, 0);
            AbstractJTopoTabular.this.locateCB.setSelectedIndex(0);
            string = string.toLowerCase();
            AbstractJTopoTabular.this.controllerView.setLocate(string);
        }
    }

    protected class Action_Locate_Find
    implements ActionListener {
        protected Action_Locate_Find() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)AbstractJTopoTabular.this.locateCB.getSelectedItem();
            if (string != null && string.length() != 0) {
                string = string.toLowerCase();
            }
            AbstractJTopoTabular.this.controllerView.setLocate(string);
        }
    }
}

