/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.sanmgmt.Variables;

public class DBConnection
implements PooledConnection,
Cloneable {
    static final String className;
    private boolean supportsGeneratedKeys;
    private Connection connection;
    private String schema;
    private boolean closed = false;
    private boolean transactionActive = false;
    private Vector activeSql = new Vector();
    private Hashtable psCache = new Hashtable();
    private static PrintStream debug;
    static String traceFile;
    static int traceFileSize;
    private static boolean traceStatements;
    private static Object[] patterns;
    private static PrintWriter traceOut;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.database.DBConnection");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        debug = null;
        traceFile = "dbtrace.log";
        traceFileSize = 10000000;
        String string = String.valueOf(Variables.getBaseDirectory()) + File.separator + "log";
        Object object = new File(string);
        if (((File)object).exists() && ((File)object).canWrite()) {
            traceFile = String.valueOf(string) + File.separator + traceFile;
        }
        try {
            debug = new PrintStream(new FileOutputStream(traceFile, true), true);
        }
        catch (Throwable throwable) {}
        traceStatements = false;
        patterns = null;
        traceOut = null;
        string = System.getProperty("tpc.dbtrace.statement.file");
        if (string != null) {
            try {
                String string2;
                object = new BufferedReader(new FileReader(string));
                Vector<Pattern> vector = new Vector<Pattern>();
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    vector.add(Pattern.compile(string2));
                }
                ((BufferedReader)object).close();
                patterns = vector.toArray();
                traceOut = new PrintWriter(new FileWriter(String.valueOf(string) + ".out"));
                System.err.println("DBTRACE: PreparedStatement tracing turned on. Input file = " + string + ", Output File = " + string + ".out");
                traceStatements = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public DBConnection(Connection connection) {
        this.connection = connection;
        try {
            this.supportsGeneratedKeys = connection.getMetaData().supportsGetGeneratedKeys();
        }
        catch (Throwable throwable) {
            this.supportsGeneratedKeys = false;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void setSchema(String string) {
        this.schema = string;
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            String string2 = databaseMetaData.getDatabaseProductName();
            Statement statement = this.connection.createStatement();
            if (string2.startsWith("DB2")) {
                statement.executeUpdate("set current schema = " + string);
                statement.close();
            } else if (string2.startsWith("Oracle")) {
                statement.executeUpdate("alter session set current_schema=" + string);
                statement.close();
            }
        }
        catch (Exception exception) {}
    }

    public String getSchema() {
        return this.schema;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.connection.setAutoCommit(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.connection.setReadOnly(bl);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.connection.setTransactionIsolation(n);
    }

    public void commit() throws SQLException {
        if (this.connection != null) {
            this.transactionActive = false;
            this.activeSql.clear();
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null) {
            this.transactionActive = false;
            this.activeSql.clear();
            this.connection.rollback();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws SQLException {
        if (this.closed) {
            DBConnection.debugPrintException(new Exception("Multiple invocations of DBConnection.close() detected"));
            throw new SQLException("Closed connection is being closed again");
        }
        try {
            this.drainPsCache();
            this.connection.commit();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.closed = true;
            if (this.connection == null) throw throwable;
            DBConnPoolDataSource.returnConnection(this);
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.closed = true;
            if (this.connection == null) return;
            DBConnPoolDataSource.returnConnection(this);
            return;
        }
    }

    public void clear() {
        this.closed = false;
        this.activeSql.clear();
    }

    public synchronized boolean isClosed() throws SQLException {
        if (this.closed) {
            return true;
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                this.closed = true;
                DBConnPoolDataSource.returnConnection(this);
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isClosedReal() throws SQLException {
        if (this.connection != null) {
            return this.connection.isClosed();
        }
        return true;
    }

    protected void closeReal() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public DBPreparedStatement prepareStatement(String string) throws SQLException {
        DBPreparedStatement dBPreparedStatement = null;
        if (traceStatements) {
            try {
                int n = 0;
                while (n < patterns.length) {
                    if (((Pattern)patterns[n]).matcher(string).matches()) {
                        Exception exception = new Exception("PrepareStatement called for: " + string);
                        exception.printStackTrace(traceOut);
                        traceOut.flush();
                        break;
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(string, 1004, 1007);
        dBPreparedStatement = new DBPreparedStatement(preparedStatement, this);
        dBPreparedStatement.setSql(string);
        this.addToPsCache(dBPreparedStatement);
        return dBPreparedStatement;
    }

    public DBPreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        DBPreparedStatement dBPreparedStatement = null;
        if (traceStatements) {
            try {
                int n = 0;
                while (n < patterns.length) {
                    if (((Pattern)patterns[n]).matcher(string).matches()) {
                        Exception exception = new Exception("PrepareStatement called for: " + string);
                        exception.printStackTrace(traceOut);
                        traceOut.flush();
                        break;
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = bl ? this.connection.prepareStatement(string) : this.connection.prepareStatement(string, 1004, 1007);
        if (preparedStatement != null) {
            dBPreparedStatement = new DBPreparedStatement(preparedStatement, this);
            dBPreparedStatement.setSql(string);
            this.addToPsCache(dBPreparedStatement);
        }
        return dBPreparedStatement;
    }

    public synchronized void addToPsCache(DBPreparedStatement dBPreparedStatement) {
        if (dBPreparedStatement != null) {
            this.psCache.put(dBPreparedStatement, new Exception("DBPreparedStatement created"));
        }
    }

    public synchronized void removeFromPsCache(DBPreparedStatement dBPreparedStatement) {
        if (dBPreparedStatement != null) {
            this.psCache.remove(dBPreparedStatement);
        }
    }

    public synchronized void drainPsCache() {
        if (this.psCache.size() > 0) {
            Enumeration enumeration = this.psCache.keys();
            while (enumeration.hasMoreElements()) {
                DBPreparedStatement dBPreparedStatement = (DBPreparedStatement)enumeration.nextElement();
                try {
                    dBPreparedStatement.close();
                }
                catch (Exception exception) {}
            }
            this.psCache.clear();
        }
    }

    public synchronized void printOpenStatements(PrintWriter printWriter) {
        DBConnection.debugPrintExceptions(printWriter, "Open statements from " + this, this.psCache.elements());
    }

    public synchronized void printActiveTransaction(PrintWriter printWriter) {
        DBConnection.debugPrintln(printWriter, "Transaction active = " + this.transactionActive);
        if (this.transactionActive) {
            int n = 0;
            while (n < this.activeSql.size()) {
                DBConnection.debugPrintln(printWriter, (String)this.activeSql.get(n));
                ++n;
            }
        }
    }

    public static synchronized void debugPrintln(String string) {
        if (debug == null) {
            return;
        }
        if (string != null) {
            debug.println(String.valueOf(new Date().toString()) + " " + string);
        }
    }

    public static synchronized void debugPrintln(PrintWriter printWriter, String string) {
        if (printWriter == null) {
            return;
        }
        if (string != null) {
            printWriter.println(String.valueOf(new Date().toString()) + " " + string);
        }
    }

    public static synchronized void debugPrintException(Exception exception) {
        if (debug == null) {
            return;
        }
        if (exception != null) {
            DBConnection.debugPrintln("");
            exception.printStackTrace(debug);
        }
    }

    public static synchronized void debugPrintException(PrintWriter printWriter, Exception exception) {
        if (printWriter == null) {
            return;
        }
        if (exception != null) {
            DBConnection.debugPrintln(printWriter, "");
            exception.printStackTrace(printWriter);
        }
    }

    public static synchronized void debugPrintExceptions(String string, Enumeration enumeration) {
        if (debug == null) {
            return;
        }
        if (string != null) {
            debug.println(String.valueOf(new Date().toString()) + " " + string);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof Exception)) continue;
                DBConnection.debugPrintException((Exception)e);
            }
        }
    }

    public static synchronized void debugPrintExceptions(PrintWriter printWriter, String string, Enumeration enumeration) {
        if (printWriter == null) {
            return;
        }
        if (string != null) {
            printWriter.println(String.valueOf(new Date().toString()) + " " + string);
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            printWriter.println("  None");
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof Exception)) continue;
                DBConnection.debugPrintException(printWriter, (Exception)e);
            }
        }
    }

    public static synchronized void checkTraceFileSize() {
        try {
            File file = new File(traceFile);
            if (file.length() > (long)traceFileSize) {
                debug = new PrintStream(new FileOutputStream(traceFile, false), true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Object clone() {
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return dBConnection;
    }

    protected synchronized void setTransactionActive(String string) {
        if (string != null) {
            this.transactionActive = true;
            this.activeSql.add(string);
        }
    }
}

