/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_StorageExtentToDBMapper
extends DBAttributeMapper {
    public static final String sELEMENTNAME = "elementname";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sSYSTEMCREATIONCLASSNAME = "systemcreationclassname";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sDEVICEID = "deviceid";
    public static final String sNAME = "name";
    public static final String sBLOCKSIZE = "blocksize";
    public static final String sNUMBEROFBLOCKS = "numberofblocks";
    public static final String sCONSUMABLEBLOCKS = "consumableblocks";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sCAPACITY = "capacity";
    public static final String sFREECAPACITY = "freecapacity";
    public static final String sSUBSYSTEMID = "ref_toplevelsystem_id";
    public static final String sSTORAGEPOOLID = "ref_storagepool_id";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "CIM_StorageExtent";
        String string2 = "1.0.2";
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        string2 = "1.0.3";
        DBAttributeMapper.RegistrationData registrationData2 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        string2 = "1.1.0";
        DBAttributeMapper.RegistrationData registrationData3 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData, registrationData2, registrationData3};
    }

    public SMISCIM_StorageExtentToDBMapper() {
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMCREATIONCLASSNAME, new MapperInfo(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMNAME, new MapperInfo(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")));
        ColumnInfo columnInfo = StorageExtent.getColumnInfo("SUBSYSTEM_ID");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = StorageExtent.getColumnInfo("STORAGE_EXTENT_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put(sSUBSYSTEMID, mapperInfo);
        ColumnInfo columnInfo3 = StorageExtent.getColumnInfo("DEVICE_ID");
        columnInfo3.setIsPrimaryKey();
        MapperInfo mapperInfo2 = new MapperInfo(columnInfo3);
        mapperInfo2.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put(sDEVICEID, mapperInfo2);
        this.m_htAttribToMapperInfo.put(sNAME, new MapperInfo(StorageExtent.getColumnInfo("NAME")));
        this.m_htAttribToMapperInfo.put("DISPLAY_NAME".toLowerCase(), new MapperInfo(StorageExtent.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put(sBLOCKSIZE, new MapperInfo(StorageExtent.getColumnInfo("BLOCK_SIZE")));
        this.m_htAttribToMapperInfo.put(sNUMBEROFBLOCKS, new MapperInfo(StorageExtent.getColumnInfo("NUM_OF_BLOCKS")));
        this.m_htAttribToMapperInfo.put(sCONSUMABLEBLOCKS, new MapperInfo(StorageExtent.getColumnInfo("CONSUMABLE_BLOCKS")));
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(StorageExtent.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_dataConverter.addCalculationDataConversion(sCAPACITY, "/", "512");
        this.m_htAttribToMapperInfo.put(sCAPACITY, new MapperInfo(StorageExtent.getColumnInfo("TOTAL_CAPACITY")));
        this.m_dataConverter.addCalculationDataConversion(sFREECAPACITY, "/", "512");
        this.m_htAttribToMapperInfo.put(sFREECAPACITY, new MapperInfo(StorageExtent.getColumnInfo("FREE_SPACE")));
        this.m_htAttribToMapperInfo.put(sSTORAGEPOOLID, new MapperInfo(StorageExtent.getColumnInfo("POOL_ID")));
        this.m_htAttribToMapperInfo.put(sELEMENTNAME, new MapperInfo(StorageExtent.getColumnInfo("ELEMENT_NAME")));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        String string2;
        long l;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        String string3 = (String)hashtable.get(sCAPACITY);
        String string4 = (String)hashtable.get(sBLOCKSIZE);
        String string5 = (String)hashtable.get(sNUMBEROFBLOCKS);
        if (string3 == null && string4 != null && string5 != null) {
            try {
                long l2 = Long.parseLong((String)hashtable.get(sBLOCKSIZE));
                l = Long.parseLong((String)hashtable.get(sNUMBEROFBLOCKS));
                string3 = Long.toString(l2 * l);
                hashtable.put(sCAPACITY, string3);
            }
            catch (Exception exception) {
                this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", exception, "Wasn't able to calculate Extent Capacity");
            }
        }
        String string6 = (String)hashtable.get(sFREECAPACITY);
        String string7 = (String)hashtable.get(sCONSUMABLEBLOCKS);
        if (string6 == null && string4 != null && string7 != null) {
            try {
                l = Long.parseLong((String)hashtable.get(sBLOCKSIZE));
                long l3 = Long.parseLong((String)hashtable.get(sCONSUMABLEBLOCKS));
                string6 = Long.toString(l * l3);
                hashtable.put(sFREECAPACITY, string6);
            }
            catch (Exception exception) {
                this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", exception, "Wasn't able to calculate Extent FreeCapacity");
            }
        }
        String string8 = (String)hashtable.get("DISPLAY_NAME".toLowerCase());
        String string9 = (String)hashtable.get(sNAME);
        if (string8 == null && string9 != null) {
            hashtable.put("DISPLAY_NAME".toLowerCase(), string9);
        }
        if ((string2 = (String)hashtable.get(sOPERATIONALSTATUS)) != null) {
            object = SMISCIM_StorageExtentToDBMapper.processArrayvalues(string2);
            if ((string2 = DBConstants.convertOperationalstatusArrayToBitValue((Vector)object)) != null) {
                hashtable.put(sOPERATIONALSTATUS, string2);
            } else {
                hashtable.remove(sOPERATIONALSTATUS);
            }
        }
        object = super.persist(dBConnection, hashtable, string);
        ((MapperResult)object).addKeyReference("ref_device_id", StorageExtent.getColumnInfo("DEVICE_ID"));
        ((MapperResult)object).addKeyReference(sSUBSYSTEMID, StorageExtent.getColumnInfo("SUBSYSTEM_ID"));
        ((MapperResult)object).addKeyReference("ref_storageextent_id", StorageExtent.getColumnInfo("STORAGE_EXTENT_ID"));
        if (hashtable.get("ref_storagevolume_id") != null) {
            Hashtable hashtable2 = ((MapperResult)object).getAllRows();
            String string10 = (String)((Hashtable)hashtable2.get(StorageExtent.getTablename())).get(StorageExtent.getColumnInfo("STORAGE_EXTENT_ID"));
            hashtable.put("ref_storageextent_id", string10);
            SMISVolume2ExtentToDBMapper sMISVolume2ExtentToDBMapper = new SMISVolume2ExtentToDBMapper();
            ((MapperResult)object).addMapperResult(sMISVolume2ExtentToDBMapper.persist(dBConnection, hashtable, string));
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", object);
        return object;
    }

    private class SMISVolume2ExtentToDBMapper
    extends DBAttributeMapper {
        public SMISVolume2ExtentToDBMapper() {
            ColumnInfo columnInfo = Volume2extent.getColumnInfo("VOLUME_ID");
            columnInfo.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storagevolume_id", new MapperInfo(columnInfo));
            ColumnInfo columnInfo2 = Volume2extent.getColumnInfo("STORAGE_EXTENT_ID");
            columnInfo2.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storageextent_id", new MapperInfo(columnInfo2));
            this.m_htAttribToMapperInfo.put("extentcount", new MapperInfo(Volume2extent.getColumnInfo("TOTAL_NUM_EXTENTS")));
        }
    }
}

