/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.AuditConfigRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;

public class AuditConfigHandler {
    public static void handle(Request request, Response response) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.logging.AuditConfigHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz2.getName(), "handle", "request, response");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.logging.AuditConfigRequest");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (RequestChecker.isDesiredType(clazz, request, response)) {
            AuditConfigRequest auditConfigRequest = (AuditConfigRequest)request.requestData;
            try {
                if (auditConfigRequest.doSet) {
                    TraceLoggerFactory.setAuditConfig(auditConfigRequest.configMap, auditConfigRequest.requestCode);
                } else {
                    response.responseData = TraceLoggerFactory.getAuditConfig(auditConfigRequest.requestCode);
                }
                response.status = 0;
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.logging.AuditConfigHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception(clazz3.getName(), "handle", localizableException);
                }
                response.errorMessage = localizableException.getMessage();
                response.status = (short)12;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.logging.AuditConfigHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz4.getName(), "handle");
        }
    }
}

