/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.report.bulk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.aperi.report.bulk.BulkDefinitions;

public class BulkUnloader {
    public static Connection connection;
    public static ZipOutputStream zipOut;
    public static String descr;

    public static void main(String[] stringArray) {
        try {
            BulkDefinitions.processArgs("Loader", stringArray);
        }
        catch (Exception exception) {
            System.err.println("Could not process args: " + exception.getLocalizedMessage());
        }
        try {
            Class.forName(BulkDefinitions.jdbcDriver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.print("Could not find JDBC driver class: " + classNotFoundException.getLocalizedMessage());
            return;
        }
        try {
            connection = DriverManager.getConnection(BulkDefinitions.jdbcUrl, BulkDefinitions.jdbcUser, BulkDefinitions.jdbcPassword);
            BulkDefinitions.setSchema("Aperi", connection);
        }
        catch (SQLException sQLException) {
            System.err.print(sQLException.getLocalizedMessage());
            return;
        }
        try {
            File file = new File(BulkDefinitions.zip);
            if (file.exists()) {
                if (!file.isFile()) {
                    System.err.print("File " + BulkDefinitions.zip + " exists and is not a plain file.");
                    return;
                }
                if (!file.delete()) {
                    System.err.print("File " + BulkDefinitions.zip + " exists and cannot be deleted.");
                    return;
                }
            }
            zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(BulkDefinitions.zip)));
        }
        catch (Exception exception) {
            System.err.print(exception.getLocalizedMessage());
            return;
        }
        try {
            BulkUnloader.zipRepository(BulkDefinitions.repository, connection, zipOut);
        }
        catch (Exception exception) {
            System.err.print("Bulk unload failed: " + exception.getLocalizedMessage());
            return;
        }
        try {
            zipOut.close();
        }
        catch (Exception exception) {
            System.err.print("Zip file could not be finalized: " + exception.getLocalizedMessage());
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {}
        BulkDefinitions.postProcessing();
    }

    private static void zipRepository(String string, Connection connection, ZipOutputStream zipOutputStream) throws IOException {
        BulkUnloader.zipItUp(string, "", connection, zipOutputStream);
    }

    private static void zipItUp(String string, String string2, Connection connection, ZipOutputStream zipOutputStream) throws IOException {
        File file = new File(string);
        if (!file.isDirectory() || !file.canRead()) {
            throw new RuntimeException("Report repository directory " + string + " cannot be scanned.");
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(String.valueOf(file.getPath()) + "/" + stringArray[n]);
            if (file2.isDirectory() && !stringArray[n].matches("documents")) {
                BulkUnloader.zipItUp(file2.getPath(), String.valueOf(string2.length() == 0 ? "" : String.valueOf(string2) + "/") + stringArray[n], connection, zipOutputStream);
            } else if (file2.isFile() && stringArray[n].matches(".*\\.rptdesign")) {
                BulkUnloader.props2ZipFile(BulkUnloader.getReport(file2.getName(), string2, connection), String.valueOf(string2.length() == 0 ? "" : String.valueOf(string2) + "/") + file2.getName().substring(0, file2.getName().lastIndexOf(46)) + ".properties", zipOutputStream);
                BulkUnloader.report2ZipFile(file2, String.valueOf(string2.length() == 0 ? "" : String.valueOf(string2) + "/") + stringArray[n], zipOutputStream);
            }
            ++n;
        }
    }

    private static void props2ZipFile(Properties properties, String string, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(string));
        PrintWriter printWriter = new PrintWriter(zipOutputStream);
        properties.list(printWriter);
        printWriter.flush();
    }

    private static void report2ZipFile(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        System.out.println("Processing Report: " + file.getPath() + "\t" + file.length() + " bytes");
        ++BulkDefinitions.reportsProcessed;
        zipOutputStream.putNextEntry(new ZipEntry(string));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        while ((n = bufferedInputStream.read(BulkDefinitions.data, 0, 4096)) != -1) {
            zipOutputStream.write(BulkDefinitions.data, 0, n);
            BulkDefinitions.bytesProcessed += n;
        }
        bufferedInputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getReport(String string, String string2, Connection connection) {
        Properties properties = new Properties();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = connection.prepareStatement("SELECT NAME, PATH, TITLE, ROLES, DESCRIPTION, CREATOR, CREATION_DATE, EDITOR, EDIT_DATE from T_BIRT_DESCR where NAME=? and PATH=?");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet == null) throw new RuntimeException("Record for report: " + string + " at: " + string2 + " not found");
                if (!resultSet.next()) throw new RuntimeException("Record for report: " + string + " at: " + string2 + " not found");
                properties.put("name", resultSet.getString("name"));
                properties.put("path", resultSet.getString("path"));
                properties.put("title", resultSet.getString("title"));
                properties.put("roles", resultSet.getString("roles"));
                properties.put("description", resultSet.getString("description"));
                properties.put("creator", resultSet.getString("creator"));
                properties.put("creation_date", resultSet.getString("creation_date"));
                properties.put("editor", resultSet.getString("editor"));
                properties.put("edit_date", resultSet.getString("edit_date"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection == null) throw throwable;
                connection.commit();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (Exception exception) {
            return properties;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (connection == null) return properties;
        connection.commit();
        return properties;
    }
}

