/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import com.ibm.log.util.MessageCatalog;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import org.apache.soap.SOAPException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;

public class Cli {
    protected static transient ILogger msgLogger = null;
    protected static transient ILogger traceLogger = null;
    static String url = null;
    static final String TRACE_NAME = "aperi.logger.trace.TSNMServiceManager";
    static final String MESSAGE_NAME = "aperi.logger.message.TSNMServiceManager";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManagerText";
    MessageCatalog MsgCat = new MessageCatalog("org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager");
    static final String PROTOCOL_ERROR = "SOAP-ENV:Protocol";
    static final String CLIENT_ERROR = "SOAP-ENV:Client";
    static final String AUTH_FAILED = "HTTP Status 401";
    static final String CONNECTION_FAILED = "Error opening socket: Connection refused: connect";

    static {
        String string = System.getProperty("tsnm.localPort", "8443");
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            url = String.valueOf(string2) + ":" + string;
        }
        catch (Exception exception) {
            Class<?> clazz;
            Class<?> clazz2;
            String string3 = "Cli.static()";
            try {
                clazz2 = Class.forName("org.eclipse.aperi.sanmgmt.middleware.data.Cli");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            msgLogger.message(IRecordType.TYPE_ERR, clazz2, string3, "TSNMServiceManagerCli_CaughtException", exception.toString());
            try {
                clazz = Class.forName("org.eclipse.aperi.sanmgmt.middleware.data.Cli");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            msgLogger.exception(IRecordType.TYPE_ERR, clazz, string3, exception);
        }
    }

    public static void main(String[] stringArray) {
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(BUNDLENAME);
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.sanmgmt.middleware.data.Cli");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.entry(IRecordType.TYPE_ENTRY, clazz, "main");
        }
        Cli cli = new Cli();
        cli.execute(stringArray);
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.sanmgmt.middleware.data.Cli");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.exit(IRecordType.TYPE_EXIT, clazz, "main");
        }
    }

    public void execute(String[] stringArray) {
        block24: {
            String string = null;
            String string2 = null;
            boolean bl = false;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, this, "execute");
            }
            int n = 0;
            while (n < stringArray.length && stringArray[n].startsWith("-")) {
                String string3;
                if ((string3 = stringArray[n++]).equals("-debug") | string3.equals("-d")) {
                    bl = true;
                    continue;
                }
                if (string3.equals("-url")) {
                    if (n < stringArray.length) {
                        url = stringArray[n++];
                        continue;
                    }
                    System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_no_host_arg"));
                    msgLogger.message(IRecordType.TYPE_ERR, this, "execute", "TSNMServiceManagerCli_no_host_arg");
                    System.exit(1);
                    continue;
                }
                if (string3.equals("-u") | string3.equals("-user")) {
                    string = stringArray[n++];
                    continue;
                }
                if (!(string3.equals("-p") | string3.equals("-password"))) continue;
                string2 = stringArray[n++];
            }
            if (stringArray.length < n + 2 | string == null | string2 == null) {
                System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_IncorrectParms"));
                msgLogger.message(IRecordType.TYPE_ERR, this, "execute", "TSNMServiceManagerCli_IncorrectParms");
                System.exit(1);
            }
            String string4 = stringArray[n++];
            String string5 = stringArray[n++];
            String[] stringArray2 = new String[stringArray.length - n];
            int n2 = 0;
            while (n2 < stringArray.length - n) {
                stringArray2[n2] = stringArray[n + n2];
                ++n2;
            }
            if (bl) {
                try {
                    String string6 = System.getProperty("tsnm.protocol");
                    System.out.println("Protocol set to " + string6);
                }
                catch (Exception exception) {}
                System.out.print("url=" + url + ", service=" + string4 + ", method=" + string5 + ", params=");
                String string7 = "url=" + url + ", service=" + string4 + ", method=" + string5 + ", params=";
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    System.out.print("\"" + stringArray2[n3] + "\" ");
                    string7 = String.valueOf(string7) + "\"" + stringArray2[n3] + "\" ";
                    ++n3;
                }
                System.out.println("\n");
                msgLogger.text(IRecordType.TYPE_WARN, this, "execute", string7);
            }
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                ICliDispatcher iCliDispatcher = (ICliDispatcher)ConnectorClient.getService((String)url, clazz, (String)string4, (String)string, (String)string2);
                System.out.println(iCliDispatcher.dispatch(string5, stringArray2));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof UndeclaredThrowableException) {
                    throwable2 = ((UndeclaredThrowableException)throwable).getUndeclaredThrowable();
                    if (throwable2 instanceof SOAPException) {
                        String string8 = ((SOAPException)throwable2).getFaultCode();
                        String string9 = throwable2.getMessage();
                        if (PROTOCOL_ERROR.equals(string8) && string9.indexOf(AUTH_FAILED) != -1) {
                            System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_LoginFailed"));
                        } else if (CLIENT_ERROR.equals(string8) && string9.indexOf(CONNECTION_FAILED) != -1) {
                            System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_ConnectFailed"));
                        } else {
                            System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_CommandFailed"));
                            traceLogger.message(IRecordType.TYPE_ERR, (Object)this, "execute", "TSNMServiceManagerCli_InvokeErr", throwable2.toString());
                        }
                    }
                } else {
                    System.err.println(this.MsgCat.getMessage("TSNMServiceManagerCli_CommandFailed"));
                    traceLogger.message(IRecordType.TYPE_ERR, (Object)this, "execute", "TSNMServiceManagerCli_InvokeErr", throwable.toString());
                }
                if (!bl) break block24;
                System.out.println("\n");
                throwable2.printStackTrace();
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this, "execute");
        }
    }
}

