/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.model.attribute.DateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;

public final class ValueFormatter {
    private static final String sNegativeZero = "-0.";

    public static final String format(Object oValue, FormatSpecifier fs, ULocale lcl, Object oCachedJavaFormatter) throws ChartException {
        if (oValue == null) {
            return null;
        }
        if (oValue instanceof String) {
            return (String)oValue;
        }
        if (fs == null) {
            if (oCachedJavaFormatter != null) {
                if (oValue instanceof Double) {
                    if (oCachedJavaFormatter instanceof DecimalFormat) {
                        double dValue = (Double)oValue;
                        String sValue = ((DecimalFormat)oCachedJavaFormatter).format(((Double)oValue).doubleValue());
                        return ValueFormatter.correctNumber(sValue, dValue);
                    }
                } else if (oValue instanceof NumberDataElement) {
                    if (oCachedJavaFormatter instanceof DecimalFormat) {
                        double dValue = ((NumberDataElement)oValue).getValue();
                        String sValue = ((DecimalFormat)oCachedJavaFormatter).format(dValue);
                        return ValueFormatter.correctNumber(sValue, dValue);
                    }
                } else if (oValue instanceof Calendar) {
                    if (oCachedJavaFormatter instanceof IDateFormatWrapper) {
                        return ((IDateFormatWrapper)oCachedJavaFormatter).format(((Calendar)oValue).getTime());
                    }
                } else if (oValue instanceof DateTimeDataElement && oCachedJavaFormatter instanceof DateFormat) {
                    return ((DateFormat)oCachedJavaFormatter).format((Object)((DateTimeDataElement)oValue).getValueAsCalendar());
                }
            } else {
                if (oValue instanceof Double) {
                    return NumberFormat.getInstance((ULocale)lcl).format(((Double)oValue).doubleValue());
                }
                if (oValue instanceof NumberDataElement) {
                    return NumberFormat.getInstance((ULocale)lcl).format(((NumberDataElement)oValue).getValue());
                }
                if (oValue instanceof Calendar) {
                    return DateFormat.getInstance().format(oValue);
                }
                if (oValue instanceof DateTimeDataElement) {
                    return DateFormat.getInstance().format((Object)((DateTimeDataElement)oValue).getValueAsCalendar());
                }
            }
        } else {
            if (NumberFormatSpecifier.class.isInstance(fs)) {
                NumberFormatSpecifier nfs = (NumberFormatSpecifier)fs;
                double dValue = ValueFormatter.asPrimitiveDouble(oValue, lcl);
                return ValueFormatter.correctNumber(nfs.format(dValue, lcl), dValue);
            }
            if (JavaNumberFormatSpecifier.class.isInstance(fs)) {
                JavaNumberFormatSpecifier nfs = (JavaNumberFormatSpecifier)fs;
                double dValue = ValueFormatter.asPrimitiveDouble(oValue, lcl);
                return ValueFormatter.correctNumber(nfs.format(dValue, lcl), dValue);
            }
            if (FractionNumberFormatSpecifier.class.isInstance(fs)) {
                FractionNumberFormatSpecifier fnfs = (FractionNumberFormatSpecifier)fs;
                double dValue = ValueFormatter.asPrimitiveDouble(oValue, lcl);
                return ValueFormatter.correctNumber(fnfs.format(dValue, lcl), dValue);
            }
            if (DateFormatSpecifier.class.isInstance(fs)) {
                DateFormatSpecifier dfs = (DateFormatSpecifier)fs;
                return dfs.format(ValueFormatter.asCalendar(oValue, lcl), lcl);
            }
            if (JavaDateFormatSpecifier.class.isInstance(fs)) {
                JavaDateFormatSpecifier jdfs = (JavaDateFormatSpecifier)fs;
                return jdfs.format(ValueFormatter.asCalendar(oValue, lcl), lcl);
            }
            if (oValue instanceof Double) {
                return NumberFormat.getInstance((ULocale)lcl).format(((Double)oValue).doubleValue());
            }
            if (oValue instanceof NumberDataElement) {
                return NumberFormat.getInstance((ULocale)lcl).format(((NumberDataElement)oValue).getValue());
            }
            if (oValue instanceof Calendar) {
                return DateFormat.getInstance().format(oValue);
            }
            if (oValue instanceof DateTimeDataElement) {
                return DateFormat.getInstance().format((Object)((DateTimeDataElement)oValue).getValueAsCalendar());
            }
        }
        return oValue.toString();
    }

    private static final double asPrimitiveDouble(Object o, ULocale lcl) throws ChartException {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof NumberDataElement) {
            return ((NumberDataElement)o).getValue();
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.convert.double", new Object[]{o}, Messages.getResourceBundle(lcl));
    }

    private static final Calendar asCalendar(Object o, ULocale lcl) throws ChartException {
        if (o instanceof Calendar) {
            return (Calendar)o;
        }
        if (o instanceof DateTimeDataElement) {
            return ((DateTimeDataElement)o).getValueAsCalendar();
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.convert.calendar", new Object[]{o}, Messages.getResourceBundle(lcl));
    }

    public static final String correctNumber(String sValue, double dValue) {
        int n = sValue.length() - sNegativeZero.length();
        StringBuffer sb = new StringBuffer(sNegativeZero);
        for (int i = 0; i < n; ++i) {
            sb.append('0');
        }
        if (sValue.equals(sb.toString())) {
            return sb.substring(1);
        }
        return sValue;
    }
}

