/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import com.ibm.icu.util.ULocale;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.i18n.JdbcResourceHandle;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class JDBCException
extends OdaException {
    private static final long serialVersionUID = -3923215393730764306L;
    public static final int ERROR_JDBC = 101;
    private static Logger logger;
    private String errorCode;
    private Object[] argv;
    private static JdbcResourceHandle resourceHandle;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JDBCException(String errorCode, int vendorCode) {
        super(errorCode, null, vendorCode);
        this.errorCode = errorCode;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, JDBCException.class.getName(), "JDBCException", errorCode);
        }
    }

    public JDBCException(String errorCode, SQLException cause) {
        super("JDBCException", cause == null ? "" : cause.getSQLState(), 101);
        this.initCause(cause);
        this.errorCode = errorCode;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, JDBCException.class.getName(), "JDBCException", errorCode);
            JDBCException.logSQLException(logger, Level.FINE, cause);
        }
    }

    public JDBCException(String errorCode, SQLException cause, Object argv) {
        super("JDBCException", cause == null ? "" : cause.getSQLState(), 101);
        this.initCause(cause);
        this.errorCode = errorCode;
        this.argv = new Object[]{argv};
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, JDBCException.class.getName(), "JDBCException", errorCode);
            JDBCException.logSQLException(logger, Level.FINE, cause);
        }
    }

    public JDBCException(String errorCode, SQLException cause, Object[] argv) {
        super("JDBCException", cause == null ? "" : cause.getSQLState(), 101);
        this.initCause(cause);
        this.errorCode = errorCode;
        this.argv = argv;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, JDBCException.class.getName(), "JDBCException", errorCode);
            JDBCException.logSQLException(logger, Level.FINE, cause);
        }
    }

    public String getMessage() {
        String extraMsg;
        String msg = this.argv == null ? resourceHandle.getMessage(this.errorCode) : resourceHandle.getMessage(this.errorCode, this.argv);
        Throwable cause = this.getCause();
        if (cause != null && (extraMsg = cause instanceof SQLException ? JDBCException.getSQLExceptionMesssage((SQLException)cause) : cause.getLocalizedMessage()) != null && extraMsg.length() > 0) {
            msg = msg + "\n" + extraMsg;
        }
        return msg;
    }

    public static void logSQLException(Logger logger, Level logLevel, SQLException sqlException) {
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        int count = 1;
        for (SQLException e = sqlException; e != null; e = e.getNextException()) {
            logger.log(logLevel, "SQL Exception #" + count, e);
            if (++count > 50) break;
        }
    }

    public static String getSQLExceptionMesssage(SQLException sqlException) {
        if (!$assertionsDisabled && sqlException == null) {
            throw new AssertionError();
        }
        String msg = new String();
        int count = 1;
        for (SQLException e = sqlException; e != null; e = e.getNextException()) {
            msg = msg + "SQL error #" + count + ": " + e.getLocalizedMessage() + "\n";
            if (++count > 50) break;
        }
        return msg;
    }

    static {
        $assertionsDisabled = !JDBCException.class.desiredAssertionStatus();
        logger = Logger.getLogger(Connection.class.getName());
        resourceHandle = new JdbcResourceHandle(ULocale.getDefault());
    }
}

