/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.oda.OdaException;

public final class SPParameterPositionUtil {
    private char[] parameterDefnChars;
    private char escaper;

    public SPParameterPositionUtil(String sqlTxt, char escaper) throws OdaException {
        this.escaper = escaper;
        this.parameterDefnChars = this.getParameterDefinitionChars(sqlTxt, escaper);
    }

    public boolean hasNonDefaultParameter() {
        boolean nextDelimiterValid = true;
        for (int i = 0; i < this.parameterDefnChars.length; ++i) {
            if (i > 0 && this.parameterDefnChars[i - 1] == this.escaper) continue;
            if ('\"' == this.parameterDefnChars[i]) {
                boolean bl = nextDelimiterValid = !nextDelimiterValid;
            }
            if (!nextDelimiterValid || '?' != this.parameterDefnChars[i]) continue;
            return true;
        }
        return false;
    }

    public int[] getParameterPositions() {
        int nextPosition = 1;
        ArrayList<Integer> result = new ArrayList<Integer>();
        boolean nextDelimiterValid = true;
        for (int i = 0; i < this.parameterDefnChars.length; ++i) {
            if (i > 0 && this.parameterDefnChars[i - 1] == this.escaper) continue;
            if ('\"' == this.parameterDefnChars[i]) {
                boolean bl = nextDelimiterValid = !nextDelimiterValid;
            }
            if (!nextDelimiterValid) continue;
            if ('?' == this.parameterDefnChars[i]) {
                result.add(new Integer(nextPosition));
            }
            if (',' != this.parameterDefnChars[i]) continue;
            ++nextPosition;
        }
        int[] rt = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            rt[i] = new Integer(result.get(i).toString());
        }
        return rt;
    }

    private char[] getParameterDefinitionChars(String sqlTxt, char escaper) throws OdaException {
        char[] temp = sqlTxt.toCharArray();
        int startPoint = -1;
        int endPoint = -1;
        boolean validBracket = true;
        for (int i = temp.length - 1; i >= 0; --i) {
            if (i > 0 && temp[i - 1] == escaper) continue;
            if (validBracket) {
                if (')' == temp[i] && endPoint == -1) {
                    endPoint = i;
                }
                if ('(' == temp[i]) {
                    startPoint = i;
                    break;
                }
            }
            if ('\"' != temp[i]) continue;
            validBracket = !validBracket;
        }
        if (startPoint == -1 && endPoint == -1) {
            return new char[0];
        }
        if (startPoint >= endPoint || startPoint == -1) {
            throw new OdaException("Illegal SP call");
        }
        return sqlTxt.substring(startPoint, endPoint).toCharArray();
    }
}

