/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.data.oda.jdbc.SQLToken;

public class SQLFormatter {
    private static final int CHAR_EOL = 0;
    private static final int CHAR_COMMENTS = 1;
    private static final int CHAR_SQL_STR = 2;

    public static String formatQueryText(String text) {
        List tokens;
        if (text == null) {
            return null;
        }
        try {
            tokens = SQLFormatter.parse(text);
        }
        catch (IOException e) {
            return text;
        }
        StringBuffer textBuffer = new StringBuffer();
        for (int i = 0; i < tokens.size(); ++i) {
            if (((SQLToken)tokens.get(i)).getType() == 0) {
                textBuffer.append(' ');
                continue;
            }
            if (((SQLToken)tokens.get(i)).getType() == 1) continue;
            textBuffer.append(((SQLToken)tokens.get(i)).getValue());
        }
        return textBuffer.toString();
    }

    private static List parse(String text) throws IOException {
        ArrayList<SQLToken> tokenList = new ArrayList<SQLToken>();
        StringReader reader = new StringReader(text);
        try {
            int i;
            int startPosition = 0;
            int endPosition = -1;
            StringBuffer sqlText = new StringBuffer();
            while ((i = reader.read()) != -1) {
                int next;
                if (i == 10) {
                    startPosition = SQLFormatter.saveSQLText(tokenList, startPosition, sqlText);
                    tokenList.add(new SQLToken(0, '\n', startPosition));
                    ++startPosition;
                    continue;
                }
                if (i == 34 || i == 39) {
                    sqlText.append((char)i);
                    SQLFormatter.readNextQuote(sqlText, reader, i);
                    continue;
                }
                if (i == 45) {
                    next = reader.read();
                    if (next == 45) {
                        startPosition = SQLFormatter.saveSQLText(tokenList, startPosition, sqlText);
                        StringBuffer value = SQLFormatter.readHyphensComments(reader);
                        endPosition = startPosition + value.length() + 2;
                        tokenList.add(new SQLToken(1, value.toString(), startPosition, endPosition));
                        startPosition = endPosition;
                        continue;
                    }
                    sqlText.append((char)i);
                    sqlText.append((char)next);
                    continue;
                }
                if (i == 47) {
                    next = reader.read();
                    if (next == 42) {
                        StringBuffer cmtBuf = new StringBuffer();
                        if (SQLFormatter.isMultiLineComments(cmtBuf, reader)) {
                            startPosition = SQLFormatter.saveSQLText(tokenList, startPosition, sqlText);
                            endPosition = startPosition + cmtBuf.toString().length() + 2;
                            tokenList.add(new SQLToken(1, cmtBuf.toString(), startPosition, endPosition));
                            startPosition = endPosition;
                            continue;
                        }
                        sqlText.append("/");
                        sqlText.append("*");
                        sqlText.append(cmtBuf.toString());
                        continue;
                    }
                    sqlText.append("/");
                    sqlText.append((char)next);
                    continue;
                }
                sqlText.append((char)i);
            }
            SQLFormatter.saveSQLText(tokenList, startPosition, sqlText);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tokenList;
    }

    private static int saveSQLText(List tokenList, int startPosition, StringBuffer sqlText) {
        if (sqlText.toString().length() > 0) {
            tokenList.add(new SQLToken(2, sqlText.toString(), startPosition, startPosition + sqlText.toString().length()));
            startPosition += sqlText.toString().length();
            sqlText.delete(0, sqlText.toString().length());
        }
        return startPosition;
    }

    private static StringBuffer readHyphensComments(StringReader reader) throws IOException {
        int i = -1;
        StringBuffer str = new StringBuffer();
        while ((i = reader.read()) != 10 && i != -1) {
            str.append((char)i);
        }
        return str;
    }

    private static boolean isMultiLineComments(StringBuffer cmtBuf, StringReader reader) throws IOException {
        int i = -1;
        boolean isComments = false;
        while ((i = reader.read()) != -1) {
            if (i == 42) {
                int next = reader.read();
                if (next == 47) {
                    isComments = true;
                    break;
                }
                cmtBuf.append((char)i);
                cmtBuf.append((char)next);
                continue;
            }
            cmtBuf.append((char)i);
        }
        return isComments;
    }

    private static StringBuffer readNextQuote(StringBuffer strBuf, StringReader reader, int quote) throws IOException {
        int i = -1;
        while ((i = reader.read()) != -1) {
            if (i != quote) {
                strBuf.append((char)i);
                continue;
            }
            strBuf.append((char)quote);
            break;
        }
        return strBuf;
    }
}

