/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.discovery.snmp.scanner.data.Entity;
import org.eclipse.aperi.discovery.snmp.scanner.data.Parameter;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.MissingUniqueIdException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;
import org.eclipse.aperi.snmp.SnmpSocketException;

public class CiscoMDSScanner
extends SNMPScanner {
    static ILogger msgLogger;
    static ILogger traceLogger;
    private static final String className;
    private static final String SCANNERNAME = "CiscoMDS";
    private int WWNSIZE = 16;
    private static final String OUTBAND_TOPOLOGY_SCANNER = "OutbandCiscoScanner:";
    private String result = new String();
    private Vector sanList = new Vector();
    private Vector portListWwn = new Vector();
    private Vector physicalSwitchList = new Vector();
    private Vector portMembershipList = new Vector();
    private Vector localIeList = new Vector();
    private Vector vsanList = new Vector();
    private Vector ieList = new Vector();
    private Vector portList = new Vector();
    private Vector atpList = new Vector();
    private Vector nodeList = new Vector();
    private Vector attachedNodeList = new Vector();
    private Vector bladeOperStat = new Vector();
    private Vector bladeList = new Vector();
    private Vector avantiNodeList = new Vector();
    private Vector avantiPortList = new Vector();
    private Vector avantiInterfaceList = new Vector();
    private Vector avantiClusterList = new Vector();
    private Hashtable vSanAtpHash = new Hashtable();
    private Hashtable attachedPortHash = new Hashtable();
    private String ipAddress;
    private Vector portTrunkList = new Vector();
    private Vector vsanVector = new Vector();
    private Vector avantiClusterNodeList = new Vector();

    static {
        Class<?> clazz;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SNMPScanner");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SNMPScanner");
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.CiscoMDSScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    private void setPortTypeValue(Vector vector) {
        String string = "setPortTypeValue";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                int n3;
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Type")) {
                    String string2 = parameter.getValue();
                    if (string2.equals("1")) {
                        parameter.setValue("auto");
                    } else if (string2.equals("2")) {
                        parameter.setValue("F_Port");
                    } else if (string2.equals("3")) {
                        parameter.setValue("FL_PORT");
                    } else if (string2.equals("4")) {
                        parameter.setValue("E_PORT");
                    } else if (string2.equals("5")) {
                        parameter.setValue("B_PORT");
                    } else if (string2.equals("6")) {
                        parameter.setValue("FX_PORT");
                    } else if (string2.equals("7")) {
                        parameter.setValue("SD_PORT");
                    } else if (string2.equals("8")) {
                        parameter.setValue("TL_PORT");
                    } else if (string2.equals("9")) {
                        parameter.setValue("N_PORT");
                    } else if (string2.equals("10")) {
                        parameter.setValue("NL_PORT");
                    } else if (string2.equals("11")) {
                        parameter.setValue("NX_PORT");
                    } else if (string2.equals("12")) {
                        parameter.setValue("TE_PORT");
                    } else if (string2.equals("13")) {
                        parameter.setValue("FV_PORT");
                    }
                } else if (parameter.getName().equals("State")) {
                    if (parameter.getValue().equals("1")) {
                        parameter.setValue("Unknown");
                    } else if (parameter.getValue().equals("2")) {
                        parameter.setValue("Online");
                    } else if (parameter.getValue().equals("3")) {
                        parameter.setValue("Offline");
                    } else if (parameter.getValue().equals("4")) {
                        parameter.setValue("Testing");
                    } else if (parameter.getValue().equals("5")) {
                        parameter.setValue("Failed");
                    }
                } else if (parameter.getName().equals("Physical Port Number") && (n3 = Integer.parseInt(parameter.getValue())) >> 24 == 1) {
                    int n4 = (n3 >> 19 & 0x1F) + 1;
                    int n5 = (n3 >> 12 & 0x7F) + 1;
                    if (n5 < 10) {
                        parameter.setValue(String.valueOf(n4) + "0" + n5);
                    } else {
                        parameter.setValue(new String(String.valueOf(n4) + n5));
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setAttachedPortType(Vector vector) {
        String string = "setAttachedPortType";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Type")) {
                    String string2 = parameter.getValue();
                    if (string2.equals("0")) {
                        parameter.setValue("unknown");
                    } else if (string2.equals("01")) {
                        parameter.setValue("N_Port");
                    } else if (string2.equals("02")) {
                        parameter.setValue("NL_PORT");
                    } else if (string2.equals("03")) {
                        parameter.setValue("F/NL_Port");
                    } else if (string2.equals("7F")) {
                        parameter.setValue("Nx_PORT");
                    } else if (string2.equals("81")) {
                        parameter.setValue("F_Port");
                    } else if (string2.equals("82")) {
                        parameter.setValue("FL_PORT");
                    } else if (string2.equals("84")) {
                        parameter.setValue("E_Port");
                    } else if (string2.equals("85")) {
                        parameter.setValue("B_PORT");
                    } else if (string2.equals("FF")) {
                        parameter.setValue("TL_PORT");
                    } else if (string2.equals("FE")) {
                        parameter.setValue("TE_Port");
                    } else if (string2.equals("FD")) {
                        parameter.setValue("SD_PORT");
                    } else if (string2.equals("FC")) {
                        parameter.setValue("FV_Port");
                    } else if (string2.equals("FB")) {
                        parameter.setValue("NV_PORT");
                    } else if (string2.equals("31")) {
                        parameter.setValue("Unavailable");
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setConnUnitAttributes(Vector vector) {
        String string = null;
        String string2 = null;
        int n = 0;
        String[] stringArray = new String[3];
        String string3 = "setConnUnitAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n3);
                if (parameter.getName().equals("Type")) {
                    string = parameter.getValue();
                    if (string.equals("1")) {
                        parameter.setValue("Unknown");
                    } else if (string.equals("2")) {
                        parameter.setValue("Other");
                    } else if (string.equals("3")) {
                        parameter.setValue("Switch");
                    } else if (string.equals("4")) {
                        parameter.setValue("Hub");
                    } else if (string.equals("5")) {
                        parameter.setValue("Bridge");
                    }
                } else if (parameter.getName().equals("Vendor ID")) {
                    string = parameter.getValue().substring(8);
                    int n4 = 0;
                    while (n4 < 3) {
                        n = string.indexOf("00");
                        string2 = string.substring(0, n);
                        stringArray[n4] = CiscoMDSScanner.convertHexStringToAscii(string2);
                        string2 = string.substring(n + 2);
                        string = string2.toString();
                        ++n4;
                    }
                    if (stringArray[0] != null) {
                        parameter.setValue(stringArray[0]);
                    }
                    if (stringArray[1] != null) {
                        entity.addParameter("Model", stringArray[1]);
                    }
                    if (stringArray[2] != null) {
                        entity.addParameter("Release Code", stringArray[2]);
                    }
                }
                ++n3;
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    public String getMgmtServerHeader(String string, String string2, String string3) {
        String string4 = "getMgmtServerHeader";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4);
        }
        String string5 = new String();
        Entity entity = new Entity();
        this.scanId = OUTBAND_TOPOLOGY_SCANNER + string3;
        string5 = string5.concat(entity.setDocType(SCANNERNAME));
        string5 = string5.concat(entity.setXmlHeader(string, string2, this.scanId, "5.0.0"));
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        return string5;
    }

    private void convertVector2TreeMap(Vector vector, TreeMap treeMap, String string) {
        String string2 = "convertVector2TreeMap";
        boolean bl = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals(string)) {
                    String string3 = parameter.getValue();
                    Entity entity2 = (Entity)treeMap.get(string3);
                    if (entity2 != null) {
                        int n3 = 0;
                        while (n3 < entity2.getParameterList().size()) {
                            String string4;
                            Parameter parameter2 = (Parameter)entity2.getParameterList().elementAt(n3);
                            if (parameter2.getName().equals("State") && (string4 = parameter2.getValue()).equals("2")) {
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (!bl) {
                        treeMap.put(parameter.getValue(), entity);
                    } else {
                        bl = false;
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    private Vector getPortList(Vector vector, Vector vector2) {
        String string = "getPortList";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        Vector<Entity> vector3 = new Vector<Entity>();
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        this.convertVector2TreeMap(vector, treeMap, "WWN");
        this.convertVector2TreeMap(vector2, treeMap2, "WWN");
        Iterator iterator = treeMap2.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Entity entity = (Entity)treeMap2.get(k);
            if (entity != null) {
                Entity entity2 = (Entity)treeMap.get(k);
                if (entity2 == null) {
                    vector3.add(entity);
                    continue;
                }
                int n = 0;
                while (n < entity2.getParameterList().size()) {
                    Parameter parameter = (Parameter)entity2.getParameterList().elementAt(n);
                    if (!parameter.getName().equals("WWN")) {
                        entity.addParameter(parameter.getName(), parameter.getValue());
                    }
                    ++n;
                }
                vector3.add(entity);
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Received empty wwnEntity" + vector2);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector3;
    }

    public Response invoke(String string, String[] stringArray) throws SnmpSocketException, UnknownHostException, Exception, MissingUniqueIdException {
        String string2;
        Vector vector = new Vector();
        String string3 = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string3, "CiscoInvoke: " + string + " on target = " + stringArray[0] + ", @ " + Calendar.getInstance().getTime());
        }
        this.switchIpAddress = stringArray[0];
        String[] stringArray2 = new String[]{this.CISCODMPRINCIPALSWITCHWWN};
        String[] stringArray3 = new String[]{this.CISCOVSANNAME, this.CISCOVSANOPERSTATE, this.CISCOVSANADMINSTATE};
        String[] stringArray4 = new String[]{this.CISCOFCSMGMTADDR, this.CISCOFCSMGMTADDRLISTINDEX};
        String[] stringArray5 = new String[]{this.CISCOFCFEELEMENTNAME, this.SYSNAME, this.SYSLOCATION, this.SYSDESCR, this.SYSCONTACT, this.SYSOBJECTID};
        String[] stringArray6 = new String[]{this.CISCODMLOCALSWITCHWWN, this.CISCODMDOMAINID, this.CISCODMSTATE};
        String[] stringArray7 = new String[]{this.CISCOFCSDOMAINID, this.CISCOFCSIETYPE, this.CISCOFCSIELOGICALNAME, this.CISCOFCSIEINFOLIST, this.CISCOFCSMGMTID};
        String[] stringArray8 = new String[]{this.CISCOFCSPORTTYPE, this.CISCOFCSPORTSTATE, this.CISCOFCSPHYSICALPORTNUMBER, this.CISCOFCSPORTATTACHPORTNAMEINDEX};
        String[] stringArray9 = new String[]{this.CISCOFCIFWWN};
        String[] stringArray10 = new String[]{this.CISCOFCSATTACHPORTNAME};
        String[] stringArray11 = new String[]{this.CISCOVSANIFENTRY};
        String[] stringArray12 = new String[]{this.CISCOFCIFTRUNKOPERSTATUS};
        String[] stringArray13 = new String[]{this.CISCOFCNSNODENAME, this.CISCOFCNSFABRICPORTNAME, this.CISCOFCNSPORTNAME};
        String[] stringArray14 = new String[]{this.CEFCMODULEOPERSTATUS};
        String[] stringArray15 = new String[]{this.ENTPHYSICALNAME, this.ENTPHYSICALPARENTRELPOS, this.ENTPHYSICALMODELNAME, this.ENTPHYSICALSERIALNUM, this.ENTPHYSICALFIRMWAREREV, this.ENTPHYSICALMFGNAME};
        String[] stringArray16 = new String[]{this.CAINTERFACENWWN};
        String[] stringArray17 = new String[]{this.IFOPERSTATUS, this.IFDESCR};
        String[] stringArray18 = new String[]{this.CANPORTPWWN, this.CANPORTSTATE};
        String[] stringArray19 = new String[]{this.FCNAMESERVERSYMBOLICNODENAME};
        String[] stringArray20 = new String[]{this.FCNAMESERVERSYMBOLICNODENAME, this.CISCOFCNSNODENAME};
        Response response = null;
        InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
        String string4 = inetAddress.getHostAddress();
        this.setIpAddress(string4);
        this.result = this.getMgmtServerHeader(stringArray[0], string, string4);
        this.setScanType(6);
        if (this.isCiscoMdsSwitch(string4) == 1) {
            this.physicalSwitchList = this.runProcess(stringArray[0], stringArray5);
            this.sanList = this.runProcess(stringArray[0], stringArray2);
            this.vsanList = this.runProcess(stringArray[0], stringArray3);
            this.setVSanId(this.vsanList);
            this.refreshCiscoFcsMib(string4, this.getVsanId(this.vsanList));
            this.localIeList = this.runProcess(stringArray[0], stringArray6);
            this.ieList = this.runProcess(stringArray[0], stringArray7);
            this.portMembershipList = this.runProcess(stringArray[0], stringArray11);
            this.portTrunkList = this.runProcess(stringArray[0], stringArray12);
            vector = this.runProcess(stringArray[0], stringArray8);
            this.portListWwn = this.runProcess(stringArray[0], stringArray9);
            this.atpList = this.runProcess(stringArray[0], stringArray10);
            this.attachedNodeList = this.runProcess(stringArray[0], stringArray13);
            this.bladeOperStat = this.runProcess(stringArray[0], stringArray14);
            this.bladeList = this.runProcess(stringArray[0], stringArray15);
            this.avantiNodeList = this.runProcess(stringArray[0], stringArray16);
            this.avantiInterfaceList = this.runProcess(stringArray[0], stringArray17);
            this.avantiPortList = this.runProcess(stringArray[0], stringArray18);
            this.avantiClusterList = this.runProcess(stringArray[0], stringArray19);
            this.avantiClusterNodeList = this.runProcess(stringArray[0], stringArray20);
            this.ProcessPortListOther(vector);
            this.createAttachPortIndexMap(vector);
            this.portList = this.getPortList(vector, this.portListWwn);
            this.removeSuspendedVswitch(this.localIeList);
            string2 = "http://" + string4;
            String string5 = "snmp://" + string4;
            this.hardcodeValue(this.vsanList, "PhysicalInfrastructure", "False");
            this.hardcodeValue(this.physicalSwitchList, "Management URL Address", string2);
            this.hardcodeValue(this.physicalSwitchList, "Management SNMP Address", string5);
            this.hardcodeValue(this.physicalSwitchList, "IP Address", string4);
            this.hardcodeValue(this.ieList, "Management URL Address", string2);
            this.hardcodeValue(this.ieList, "Management SNMP Address", string5);
            this.hardcodeValue(this.physicalSwitchList, "Type", "Switch");
            if (this.sanList.isEmpty()) {
                throw new MissingUniqueIdException();
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string3, "Physical switch list = " + this.physicalSwitchList + "San List = " + this.sanList + " vsan list = " + this.vsanList + " localIeList = " + this.localIeList + " ie List = " + this.ieList + " port membership list = " + this.portMembershipList + " port list other = " + vector + " port list WWN = " + this.portListWwn + " port list = " + this.portList + " Attached port list = " + this.atpList + " Attached node list = " + this.attachedNodeList);
            }
        } else {
            response = new Response(Response.RETURN_CODE_ERROR, "");
            return response;
        }
        this.result.concat(this.topologyXmlGenerator());
        response = this.processXMLDeltaScan(this.scanId, this.result, 0, "MibQueryEngine");
        if (response.getHeader() == null) {
            string2 = new Header();
            response.setHeader((Header)string2);
        }
        response.getHeader().setScannerId(this.scanId);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string3, "Cisco MDS XML = " + response);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string3, "CiscoComplete: " + string + " on target = " + stringArray[0] + ", @ " + Calendar.getInstance().getTime());
        }
        return response;
    }

    private void removeSuspendedVswitch(Vector vector) {
        String string = "removeSuspendedVswitch";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                String string2;
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().startsWith("State") && (string2 = parameter.getValue()).equals("12")) {
                    vector.remove(n);
                    --n;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private Vector getVsanId(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        String string = "getVsanId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().startsWith("VSAN ID")) {
                    String string2 = parameter.getValue();
                    vector2.addElement(string2);
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector2;
    }

    private void ProcessPortListOther(Vector vector) {
        String string = null;
        String string2 = "ProcessPortListOther";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n = this.CISCOFCSPORTATTACHPORTNAMEINDEX.length();
        int n2 = 0;
        while (n2 < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n3);
                if (parameter.getName().startsWith(this.CISCOFCSPORTATTACHPORTNAMEINDEX)) {
                    parameter.getValue();
                    String string3 = parameter.getName();
                    String string4 = string3.substring(n + 1);
                    int n4 = string4.indexOf(".");
                    string = string4.substring(n4 + 1);
                    entity.addParameter("WWN", this.convertDecimalWWNToHexWWN(string));
                }
                ++n3;
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    private void setIpAddress(String string) {
        this.ipAddress = string;
    }

    private String getIpAddress() {
        return this.ipAddress;
    }

    private void createAttachPortIndexMap(Vector vector) {
        String string = null;
        String string2 = null;
        String string3 = "createAttachPortIndexMap";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n = this.CISCOFCSPORTATTACHPORTNAMEINDEX.length();
        int n2 = 0;
        while (n2 < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n3);
                if (parameter.getName().startsWith(this.CISCOFCSPORTATTACHPORTNAMEINDEX)) {
                    string = parameter.getValue();
                    if (!string.equals("0")) {
                        String string4 = parameter.getName().substring(n + 1);
                        int n4 = string4.indexOf(".");
                        string2 = string4.substring(0, n4);
                        this.vSanAtpHash.put(string, string2);
                    }
                    parameter.setName("Index");
                }
                ++n3;
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    private String convertport2WWN(String string, Vector vector) {
        boolean bl = false;
        String string2 = null;
        String string3 = "convertport2WWN";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Physical Port Number")) {
                    if (parameter.getValue().equals(string)) {
                        bl = true;
                    }
                } else if (parameter.getName().equals("WWN")) {
                    string2 = parameter.getValue();
                }
                ++n2;
            }
            if (bl) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
                }
                return string2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return null;
    }

    private void hardcodeValue(Vector vector, String string, String string2) {
        String string3 = "hardcodeValue";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n = 0;
        while (n < vector.size()) {
            ((Entity)vector.elementAt(n)).addParameter(string, string2);
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    private String getSubstring(String string) {
        String string2 = "getSubString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter= " + string));
        }
        if (string.length() >= this.WWNSIZE && this.isZeroSubstring(string)) {
            String string3 = string.substring(0, 16);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return string3;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string;
    }

    private boolean isZeroSubstring(String string) {
        String string2 = "isZeroSubstring";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter= " + string));
        }
        String string3 = string.substring(16, string.length());
        boolean bl = true;
        int n = 0;
        while (n < string3.length()) {
            if (string3.charAt(n) != '0') {
                bl = false;
                break;
            }
            bl = true;
            ++n;
        }
        if (bl) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return false;
    }

    private void resetUniqueId(Vector vector) {
        String string = "resetUniqueId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Entity's Unique ID Value = " + entity.getUniqueId());
            }
            String string2 = this.getSubstring(entity.getUniqueId());
            entity.setUniqueId(string2);
            Vector vector2 = entity.getParameterList();
            int n2 = 0;
            while (n2 < vector2.size()) {
                String string3;
                Parameter parameter = (Parameter)vector2.elementAt(n2);
                String string4 = parameter.getValue();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Parameter Value = " + string4);
                }
                if ((string3 = this.getSubstring(string4)) != null) {
                    parameter.setValue(string3);
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private boolean removedUnidentifiedPorts(Vector vector) {
        boolean bl = false;
        String string = "removedUnidentifiedPorts";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            Entity entity = (Entity)vector.elementAt(n);
            String string2 = entity.getUniqueId();
            if (string2.equals("0000000000000000") || string2.equals("                ") || string2.equals("")) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Removing unidentified port entity from scan data for target " + this.switchIpAddress + "\n" + entity.toString());
                }
                vector.removeElementAt(n);
                bl = true;
            }
            --n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    private void setPortContainsPortXrefs(Vector vector, Vector vector2, Hashtable hashtable) throws Exception {
        Entity entity;
        int n = 0;
        String string = "setPortContainsPortXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            entity = (Entity)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < entity.getParameterList().size()) {
                if (entity.getParamNameAt(n3).equals("Index")) {
                    n = Integer.parseInt(entity.getParamValueAt(n3));
                    entity.getParameterList().remove(n3);
                    break;
                }
                ++n3;
            }
            if (n != 0) {
                String string2 = new String(String.valueOf(this.CISCOFCSATTACHPORTNAME) + "." + n + ".");
                Vector vector3 = this.createTrunkConnection(string2, vector2, hashtable, this.attachedPortHash);
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    entity.addXrefs(entity.getUniqueId(), (String)enumeration.nextElement());
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            entity = (Entity)vector2.elementAt(n2);
            int n4 = entity.getParameterList().size();
            if (n4 < 2) {
                vector2.removeElementAt(n2);
                --n2;
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private String topologyXmlGenerator() {
        String string;
        block8: {
            string = "topologyXmlGenerator: targetIP=" + this.switchIpAddress;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            try {
                this.resetUniqueId(this.sanList);
                this.resetUniqueId(this.vsanList);
                this.resetUniqueId(this.ieList);
                this.resetUniqueId(this.portList);
                this.resetUniqueId(this.atpList);
                this.resetUniqueId(this.localIeList);
                this.resetUniqueId(this.portMembershipList);
                this.resetUniqueId(this.physicalSwitchList);
                this.resetUniqueId(this.attachedNodeList);
                this.setAvantiUniqueId(this.bladeOperStat, this.CEFCMODULEOPERSTATUS);
                this.setAvantiUniqueId(this.bladeList, this.ENTPHYSICALNAME);
                this.mergeLists(this.bladeOperStat, this.bladeList);
                this.setAvantiIds(this.bladeOperStat, "Blade");
                this.setAvantiUniqueId(this.avantiNodeList, this.CAINTERFACENWWN);
                this.setAvantiUniqueId(this.avantiInterfaceList, this.IFOPERSTATUS);
                this.mergeLists(this.avantiNodeList, this.avantiInterfaceList);
                this.addNode2PortXref(this.avantiNodeList, this.avantiPortList);
                this.addBlade2NodeXref(this.bladeOperStat, this.avantiNodeList);
                this.setAvantiIds(this.avantiNodeList, "WWN", "FcNode");
                this.addVportToVsan(this.avantiPortList, this.attachedPortHash);
                this.parseAvantiPortParams(this.avantiPortList, this.CANPORTPWWN);
                this.parseAvantiClusterParams(this.avantiClusterList, this.FCNAMESERVERSYMBOLICNODENAME);
                this.addCluster2NodeXref(this.avantiClusterList, this.avantiClusterNodeList);
                this.setAvantiPortStateAndMode(this.avantiPortList);
                this.setAvantiNodeStatus(this.avantiNodeList);
                this.setBladeStatus(this.bladeOperStat);
                boolean bl = this.removedUnidentifiedPorts(this.portList);
                boolean bl2 = this.removedUnidentifiedPorts(this.atpList);
                if (bl2 || bl) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "AdvancedTopologyScanner_unidentifiedPortRemoved");
                }
                this.setVSanId(this.localIeList);
                this.setVSanId(this.sanList);
                this.setVsanFabricAttributes(this.sanList, this.vsanList);
                this.generateFabricName(this.sanList);
                this.portMembershipList.addAll(this.portTrunkList);
                this.addVswitch2PortXref(this.localIeList, this.portMembershipList);
                this.replaceDomainIdWithWWN(this.ieList);
                this.removeNonlocalSwitches(this.localIeList, this.ieList);
                this.addXrefVsan2Vswitch(this.vsanList, this.localIeList);
                this.setPortContainsPortXrefs(this.portList, this.atpList, this.vSanAtpHash);
                this.createTrunkConnection(this.CISCOFCSATTACHPORTNAME, this.atpList, this.vSanAtpHash, this.attachedPortHash);
                Vector vector = this.FilterSwitchPorts(this.atpList);
                this.hardcodeValue(this.sanList, "Type", "Fabric");
                this.hardcodeValue(this.sanList, "PhysicalInfrastructure", "True");
                this.setConnUnitAttributes(this.ieList);
                this.setPortTypeValue(this.portList);
                this.setAttachedPortType(this.atpList);
                this.setNodeXml(this.attachedNodeList, this.portListWwn);
                Vector vector2 = this.mergeMultiPortNodes(this.attachedNodeList);
                this.removeSuspendedVsans(this.vsanList);
                int n = 0;
                while (n < this.sanList.size()) {
                    this.iEntity = (Entity)this.sanList.elementAt(n);
                    this.result = this.result.concat(this.iEntity.toXml());
                    this.result = this.result.concat(this.iEntity.toIdXml(new Vector[]{this.vsanList, this.physicalSwitchList, vector}));
                    ++n;
                }
                this.printVsanXml(this.vsanList, this.attachedPortHash);
                n = 0;
                while (n < this.physicalSwitchList.size()) {
                    this.iEntity = (Entity)this.physicalSwitchList.elementAt(n);
                    this.result = this.result.concat(this.iEntity.toXml());
                    this.result = this.result.concat(this.iEntity.toIdXml(new Vector[]{this.ieList, this.bladeOperStat}));
                    ++n;
                }
                Vector vector3 = this.removeDuplicateAttachportEntry(this.atpList);
                this.result = this.result.concat(this.iEntity.composeXml(new Vector[]{this.ieList, this.portList, vector3}));
                this.result = this.result.concat(this.iEntity.composeXml(new Vector[]{this.bladeOperStat, this.avantiNodeList, this.avantiPortList, this.avantiClusterList}));
                this.result = this.result.concat(this.iEntity.composeXml(new Vector[]{vector2}));
                this.result = this.result.concat(this.iEntity.endResultXml(SCANNERNAME));
            }
            catch (Exception exception) {
                if (msgLogger != null && msgLogger.isLogging()) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "AdvancedTopologyScanner_TopolgoyXmlGeneratorError");
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return this.result;
    }

    private void replaceDomainIdWithWWN(Vector vector) {
        String string = "replaceDomainIdWithWWN";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                String string2 = parameter.getName();
                if (string2.startsWith(this.CISCOFCSDOMAINID)) {
                    int n3 = this.CISCOFCSDOMAINID.length();
                    String string3 = string2.substring(n3 + 1);
                    n3 = string3.indexOf(".");
                    String string4 = string3.substring(n3 + 1);
                    String string5 = this.convertDecimalWWNToHexWWN(string4);
                    parameter.setName("Domain");
                    entity.addParameter("WWN", string5);
                    entity.setUniqueId(string5);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private String convertDecimalWWNToHexWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "convertDecimalWWNToHexWWN";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n = 0;
        int n2 = 0;
        String string3 = String.valueOf(string) + ".";
        n = string3.indexOf(".");
        String string4 = string3.substring(n2, n);
        while (n != -1) {
            int n3 = Integer.parseInt(string4);
            String string5 = Integer.toHexString(n3);
            if (string5.length() < 2) {
                string5 = "0" + string5;
            }
            stringBuffer.append(string5.toUpperCase());
            n2 = n + 1;
            n = string3.indexOf(".", n2);
            string4 = n != -1 ? string3.substring(n2, n) : string3.substring(n2);
        }
        String string6 = stringBuffer.toString();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string6;
    }

    private Vector FilterSwitchPorts(Vector vector) {
        String string = "FilterSwitchPorts";
        Vector vector2 = new Vector();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                String string2 = entity.getParamNameAt(n2);
                if (string2.equals("Type")) {
                    String string3 = entity.getParamValueAt(n2);
                    if (string3.equals("84") || string3.equals("FE")) break;
                    vector2.add(vector.elementAt(n));
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector2;
    }

    private void removeSuspendedVsans(Vector vector) {
        String string = "removeSuspendedVsans";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                String string2;
                String string3 = entity.getParamNameAt(n2);
                if (string3.equals("Active") && (string2 = entity.getParamValueAt(n2)).equals("False")) {
                    vector.remove(n);
                    --n;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private Vector removeDuplicateAttachportEntry(Vector vector) {
        Vector<Entity> vector2 = new Vector<Entity>();
        String string = "removeDuplicateAttachportEntry";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (!vector2.contains(entity)) {
                vector2.addElement(entity);
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector2;
    }

    private Vector createTrunkConnection(String string, Vector vector, Hashtable hashtable, Hashtable hashtable2) {
        Vector<String> vector2 = new Vector<String>();
        String string2 = null;
        String string3 = "createTrunkConnection";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = entity.getParameterList().size();
            int n3 = 0;
            while (n3 < n2) {
                String string4 = entity.getParamNameAt(n3);
                if (string4.startsWith(string)) {
                    int n4;
                    String string5;
                    String string6;
                    String string7;
                    String string8 = entity.getParamValueAt(n3);
                    string2 = string8.substring(0, 16);
                    String string9 = string8.substring(22);
                    entity.addParameter("WWN", string2);
                    entity.addParameter("Type", string9);
                    entity.setUniqueId(string2);
                    vector2.add(string2);
                    if (!string9.equals("84") && !string9.equals("FE") && (string7 = (String)hashtable.get(string6 = (string5 = string4.substring(this.CISCOFCSATTACHPORTNAME.length() + 1)).substring(0, n4 = string5.indexOf(".")))) != null) {
                        Vector<String> vector3 = (Vector<String>)hashtable2.get(string7);
                        if (vector3 == null) {
                            vector3 = new Vector<String>();
                            vector3.add(string2);
                        } else if (!vector3.contains(string2)) {
                            vector3.add(string2);
                        }
                        hashtable2.put(string7, vector3);
                    }
                    entity.getParameterList().remove(0);
                }
                ++n3;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return vector2;
    }

    private void printVsanXml(Vector vector, Hashtable hashtable) {
        String string = "printVsanXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                String string2 = parameter.getName();
                if (string2.equals("VSAN ID")) {
                    Vector vector2 = (Vector)hashtable.get(parameter.getValue());
                    this.result = this.result.concat(entity.toXml());
                    this.result = this.result.concat(entity.toIdXml(entity));
                    this.result = vector2 != null ? this.result.concat(entity.toIdXml(vector2, "FcPort")) : this.result.concat(entity.endEntityXml());
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private Vector mergeMultiPortNodes(Vector vector) throws Exception {
        String string = "mergeMultiPortNodes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        Vector<Entity> vector2 = new Vector<Entity>();
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (vector2.contains(entity)) {
                int n2 = 0;
                while (n2 < vector2.size()) {
                    Entity entity2 = (Entity)vector2.elementAt(n2);
                    if (entity.equals(entity2)) {
                        Hashtable hashtable = entity.getXrefs();
                        Vector vector3 = (Vector)hashtable.get(entity.getUniqueId());
                        int n3 = 0;
                        while (n3 < vector3.size()) {
                            entity2.addXrefs(entity2.getUniqueId(), (String)vector3.elementAt(n3));
                            ++n3;
                        }
                        break;
                    }
                    ++n2;
                }
            } else {
                vector2.addElement(entity);
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector2;
    }

    private void setNodeXml(Vector vector, Vector vector2) throws Exception {
        boolean bl = false;
        String string = null;
        String string2 = "setNodeXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        TreeMap treeMap = new TreeMap();
        this.convertVector2TreeMap(vector2, treeMap, "WWN");
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                String string3 = parameter.getName();
                if (string3.startsWith(this.CISCOFCNSFABRICPORTNAME)) {
                    String string4 = parameter.getValue();
                    if (treeMap.get(string4) != null) {
                        bl = true;
                        entity.getParameterList().remove(n2);
                        --n2;
                    } else {
                        vector.remove(n);
                        --n;
                    }
                } else if (string3.startsWith(this.CISCOFCNSPORTNAME)) {
                    string = parameter.getValue();
                    entity.getParameterList().remove(n2);
                    --n2;
                }
                ++n2;
            }
            if (bl) {
                entity.addXrefs(entity.getUniqueId(), string);
                bl = false;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    private void addVswitch2PortXref(Vector vector, Vector vector2) throws Exception {
        String string;
        Parameter parameter;
        int n;
        Entity entity;
        Hashtable hashtable = new Hashtable();
        Vector vector3 = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = "addVswitch2PortXref";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4);
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            entity = (Entity)vector2.elementAt(n2);
            n = 0;
            while (n < entity.getParameterList().size()) {
                block13: {
                    block15: {
                        block14: {
                            String string5;
                            int n3;
                            parameter = (Parameter)entity.getParameterList().elementAt(n);
                            string = parameter.getName();
                            if (string.startsWith(this.CISCOVSANIFENTRY)) {
                                n3 = this.CISCOVSANIFENTRY.length();
                                string5 = string.substring(n3 + 1);
                                string3 = this.convertport2WWN(string5, this.portListWwn);
                                string2 = parameter.getValue();
                                bl = true;
                            } else if (string.startsWith(this.CISCOFCIFTRUNKOPERSTATUS) && parameter.getValue().equals("1")) {
                                n3 = this.CISCOFCIFTRUNKOPERSTATUS.length();
                                string5 = string.substring(n3 + 1);
                                int n4 = string5.indexOf(".");
                                string2 = string5.substring(n4 + 1);
                                string3 = this.convertport2WWN(string5.substring(0, n4), this.portListWwn);
                                bl = true;
                            }
                            if (!bl) break block13;
                            bl = false;
                            vector3 = (Vector)hashtable.get(string2);
                            if (vector3 != null) break block14;
                            vector3 = new Vector();
                            break block15;
                        }
                        if (vector3.contains(string3)) break block13;
                    }
                    vector3.add(string3);
                    hashtable.put(string2, vector3);
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector.size()) {
            entity = (Entity)vector.elementAt(n2);
            n = 0;
            while (n < entity.getParameterList().size()) {
                parameter = (Parameter)entity.getParameterList().elementAt(n);
                if (parameter.getName().equals("VSAN ID") && (vector3 = (Vector)hashtable.get(string = parameter.getValue())) != null) {
                    entity.addXrefs(entity.getUniqueId(), vector3);
                }
                ++n;
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    private void addXrefVsan2Vswitch(Vector vector, Vector vector2) throws Exception {
        Parameter parameter;
        int n;
        Entity entity;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        String string2 = null;
        String string3 = "addXrefVsan2Vswitch";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            entity = (Entity)vector2.elementAt(n2);
            n = 0;
            while (n < entity.getParameterList().size()) {
                parameter = (Parameter)entity.getParameterList().elementAt(n);
                if (parameter.getName().equals("VSAN ID")) {
                    string = parameter.getValue();
                } else if (parameter.getName().equals("WWN")) {
                    string2 = parameter.getValue();
                }
                ++n;
            }
            hashtable.put(string, string2);
            ++n2;
        }
        n2 = 0;
        while (n2 < vector.size()) {
            entity = (Entity)vector.elementAt(n2);
            n = 0;
            while (n < entity.getParameterList().size()) {
                parameter = (Parameter)entity.getParameterList().elementAt(n);
                if (parameter.getName().equals("VSAN ID")) {
                    string = parameter.getValue();
                    string2 = (String)hashtable.get(string);
                    if (string2 == null) break;
                    entity.addXrefs(entity.getUniqueId(), string2);
                    break;
                }
                ++n;
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    private void removeNonlocalSwitches(Vector vector, Vector vector2) throws Exception {
        Object object;
        Object object2;
        Entity entity;
        Hashtable hashtable = new Hashtable();
        String string = "removeNonlocalSwitches";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            entity = (Entity)vector.elementAt(n);
            String string2 = entity.getUniqueId();
            object2 = entity.getXrefs();
            if (object2 != null) {
                object = ((Hashtable)object2).get(string2);
                if (object != null) {
                    hashtable.put(string2, object);
                } else {
                    hashtable.put(string2, new Vector());
                }
            }
            ++n;
        }
        n = 0;
        while (n < vector2.size()) {
            entity = (Entity)vector2.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                object2 = (Parameter)entity.getParameterList().elementAt(n2);
                if (((Parameter)object2).getName().equals("WWN")) {
                    object = ((Parameter)object2).getValue();
                    Vector vector3 = (Vector)hashtable.get(object);
                    if (vector3 == null) {
                        vector2.remove(n);
                        --n;
                        break;
                    }
                    if (!vector3.isEmpty()) {
                        int n3 = 0;
                        while (n3 < ((Vector)vector3.elementAt(0)).size()) {
                            if ((String)((Vector)vector3.elementAt(0)).elementAt(n3) != null) {
                                entity.addXrefs(Integer.toString(n3), (String)((Vector)vector3.elementAt(0)).elementAt(n3));
                            }
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setVSanId(Vector vector) {
        int n = 0;
        String string = "setVSanId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < entity.getParameterList().size()) {
                String string2;
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n3);
                String string3 = parameter.getName();
                if (string3.startsWith(this.CISCODMLOCALSWITCHWWN) || string3.startsWith(this.CISCODMPRINCIPALSWITCHWWN)) {
                    n = string3.startsWith(this.CISCODMLOCALSWITCHWWN) ? this.CISCODMLOCALSWITCHWWN.length() : this.CISCODMPRINCIPALSWITCHWWN.length();
                    string2 = string3.substring(n + 1);
                    entity.addParameter("VSAN ID", string2);
                    parameter.setName("WWN");
                } else if (string3.startsWith(this.CISCOVSANNAME)) {
                    n = this.CISCOVSANNAME.length();
                    string2 = string3.substring(n + 1);
                    entity.addParameter("VSAN ID", string2);
                    parameter.setName("Name");
                }
                ++n3;
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setVsanFabricAttributes(Vector vector, Vector vector2) {
        String string;
        Parameter parameter;
        int n;
        Entity entity;
        String string2 = null;
        String string3 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string4 = "setVsanFabricAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            entity = (Entity)vector.elementAt(n2);
            n = 0;
            while (n < entity.getParameterList().size()) {
                parameter = (Parameter)entity.getParameterList().elementAt(n);
                string = parameter.getName();
                if (string.equals("WWN")) {
                    string2 = parameter.getValue();
                } else if (string.equals("VSAN ID")) {
                    string3 = parameter.getValue();
                }
                ++n;
            }
            if (string3.equals("1")) {
            }
            hashtable.put(string3, string2);
            ++n2;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            entity = (Entity)vector2.elementAt(n2);
            n = 0;
            while (n < entity.getParameterList().size()) {
                parameter = (Parameter)entity.getParameterList().elementAt(n);
                if (parameter.getName().equals("VSAN ID")) {
                    string3 = parameter.getValue();
                    if (string3.equals("4094")) {
                        string = "7000000000000000";
                        entity.setUniqueId(string);
                        entity.addParameter("WWN", string);
                    } else {
                        string2 = (String)hashtable.get(string3);
                        if (string2 != null) {
                            entity.addParameter("WWN", string2);
                            entity.setUniqueId(string2);
                        }
                    }
                } else if (parameter.getName().equals("State")) {
                    string = parameter.getValue();
                    if (string.equals("1")) {
                        parameter.setValue("Up");
                    } else if (string.equals("2")) {
                        parameter.setValue("Down");
                    }
                } else if (parameter.getName().equals("Active")) {
                    string = parameter.getValue();
                    if (string.equals("1")) {
                        parameter.setValue("True");
                    } else if (string.equals("2")) {
                        parameter.setValue("False");
                    }
                }
                ++n;
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    private void generateFabricName(Vector vector) {
        Object object;
        String string = "generateFabricName";
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        Vector vector6 = new Vector();
        TreeMap treeMap = new TreeMap();
        boolean bl = false;
        String string2 = this.getIpAddress();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "ENTERED: Enter generateFabricName for switch " + string2 + ", @ " + Calendar.getInstance().getTime());
        }
        vector2.add(string2);
        this.queryRetryCount = 0;
        int n = 0;
        while (n < vector2.size()) {
            block40: {
                object = (String)vector2.get(n);
                try {
                    SNMPConfig.setRetries((String)object, 1);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "START: Getting Management Address list index for " + (String)object + ", @ " + Calendar.getInstance().getTime());
                    }
                    vector3 = this.runProcess((String)object, new String[]{this.CISCOFCSMGMTADDRLISTINDEX});
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "COMPLETED: Getting Management Address list index for " + (String)object + ", @ " + Calendar.getInstance().getTime());
                    }
                }
                catch (Exception exception) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block40;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Warning: " + exception.getMessage());
                }
            }
            if (vector3.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Failed to get management address list index of switch " + (String)object);
                }
            } else {
                block41: {
                    try {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "START: Getting Management Addresses of attached devices to switch " + (String)object + ", @ " + Calendar.getInstance().getTime());
                        }
                        vector4 = this.runProcess((String)object, new String[]{this.CISCOFCSMGMTADDR});
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "COMPLETED: Getting Management Addresses of attached devices to switch " + (String)object + ", @ " + Calendar.getInstance().getTime());
                        }
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block41;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Warning: " + exception.getMessage());
                    }
                }
                if (vector4.isEmpty()) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Failed to get management addresses of devices connected to switch " + (String)object);
                    }
                } else {
                    block42: {
                        try {
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "START: Getting Physical Switch WWN for switch connected to " + (String)object + ", @ " + Calendar.getInstance().getTime());
                            }
                            vector5 = this.runProcess((String)object, new String[]{this.CISCOFCFEELEMENTNAME});
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "COMPLETED: Getting Physical Switch WWN for switch connected to " + (String)object + ", @ " + Calendar.getInstance().getTime());
                            }
                        }
                        catch (Exception exception) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block42;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Warning: " + exception.getMessage());
                        }
                    }
                    if (vector5.isEmpty()) {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Failed to get physical switch WWN of switch " + (String)object);
                        }
                    } else {
                        vector6.addElement(vector5.elementAt(0));
                        int n2 = 0;
                        while (n2 < vector3.size()) {
                            Entity entity = (Entity)vector3.get(n2);
                            String string3 = entity.getParamValueAt(0);
                            if (string3 != null) {
                                String string4 = String.valueOf(this.CISCOFCSMGMTADDR) + "." + string3 + ".1";
                                int n3 = 0;
                                while (n3 < vector4.size()) {
                                    Entity entity2 = (Entity)vector4.elementAt(n3);
                                    int n4 = 0;
                                    while (n4 < entity2.getParameterList().size()) {
                                        Parameter parameter = (Parameter)entity2.getParameterList().elementAt(n4);
                                        if (parameter.getName().equals(string4)) {
                                            String string5 = parameter.getValue();
                                            int n5 = string5.indexOf("//");
                                            if (n5 == -1) {
                                                if (traceLogger != null && traceLogger.isLogging()) {
                                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Bad management address : + " + string5);
                                                }
                                            } else {
                                                int n6 = string5.indexOf("/", n5 += 2);
                                                if (n6 == -1) {
                                                    if (traceLogger != null && traceLogger.isLogging()) {
                                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Bad management address : + " + string5);
                                                    }
                                                } else {
                                                    String string6 = string5.substring(n5, n6);
                                                    if (string6 != null && !vector2.contains(string6)) {
                                                        vector2.add(string6);
                                                    }
                                                    vector4.remove(n3);
                                                    bl = true;
                                                    break;
                                                }
                                            }
                                        }
                                        ++n4;
                                    }
                                    if (bl) {
                                        bl = false;
                                        break;
                                    }
                                    ++n3;
                                }
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++n;
        }
        this.convertVector2TreeMap(vector6, treeMap, "WWN");
        String string7 = "3" + ((String)treeMap.firstKey()).substring(1);
        vector.removeAllElements();
        if (string7 != null) {
            object = new Entity();
            ((Entity)object).addParameter("Name", string7);
            ((Entity)object).setUniqueId(string7);
            ((Entity)object).setName("San");
            vector.add(object);
        } else if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Could not find VSAN 1.");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "EXIT: Exited generateFabricName for switch " + string2 + ", @ " + Calendar.getInstance().getTime());
        }
        this.queryRetryCount = 2;
    }

    public String getScannerHeader(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = "getScannerHeader";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string5);
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            string3 = inetAddress.getHostAddress();
            string4 = this.getMgmtServerHeader(string2, string, string3);
            string4 = string4.concat("</CiscoMDSXml>");
        }
        catch (Exception exception) {}
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
        }
        return string4;
    }

    public Response getScannerHeaderResponse(int n, String string, String string2) {
        InetAddress inetAddress;
        String string3 = null;
        String string4 = null;
        String string5 = "getScannerHeaderResponse";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string5);
        }
        try {
            inetAddress = InetAddress.getByName(string2);
            string3 = inetAddress.getHostAddress();
            string4 = this.getMgmtServerHeader(string2, string, string3);
            string4 = string4.concat("</CiscoMDSXml>");
        }
        catch (Exception exception) {}
        inetAddress = this.processXMLDeltaScan(this.scanId, string4, n, "MibQueryEngine");
        if (inetAddress.getHeader() == null) {
            Header header = new Header();
            inetAddress.setHeader(header);
        }
        inetAddress.getHeader().setScannerId(this.scanId);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
        }
        return inetAddress;
    }

    private Vector runProcess(String string, String[] stringArray) throws SnmpSocketException, UnknownHostException, Exception {
        String string2 = "runProcess";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        Vector vector = new Vector();
        boolean bl = false;
        int n = this.queryRetryCount + 1;
        int n2 = 0;
        while (n2 < n) {
            vector = this.runSnmpQuery(string, stringArray);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "--------> AdvTop:: runProcess: " + string + " counter =" + n2);
            }
            if (!this.ERROR_FLAG) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new Exception("Unable to contact the host " + string + " after " + n + " attempts!");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return vector;
    }

    private String parseOIDInstance(String string, String string2) {
        String string3 = null;
        String string4 = "parseOIDString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4);
        }
        if (string != null && string2 != null) {
            int n = string2.length();
            int n2 = string.length();
            if (string.startsWith(string2) && n2 > n) {
                int n3 = string.indexOf(".", n + 1);
                string3 = n3 != -1 ? string.substring(n + 1, n3) : string.substring(n + 1);
            }
        } else if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string4, " One or more input parameters to this method may be null");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        return string3;
    }

    private void setAvantiUniqueId(Vector vector, String string) {
        String string2 = null;
        String string3 = "setAvantiUniqueId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            String string4 = entity.getName();
            if (string4 != null) {
                string2 = this.parseOIDInstance(string4, string);
                if (string2 != null) {
                    entity.setUniqueId(string2);
                } else {
                    entity.setUniqueId("");
                }
            } else if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string3, " Entity name is null");
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    private void setAvantiIds(Vector vector, String string, String string2) {
        String string3 = null;
        String string4 = "setAvantiIds";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null) {
                int n2 = 0;
                while (n2 < entity.getParameterList().size()) {
                    String string5 = entity.getParamNameAt(n2);
                    if (string5 != null && string5.startsWith(string)) {
                        string3 = entity.getParamValueAt(n2);
                        if (string3 != null) {
                            entity.setUniqueId(string3);
                            break;
                        }
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string4, " param value is null");
                        }
                    }
                    ++n2;
                }
                entity.setName(string2);
            } else if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string4, " Entity object is null");
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    private void mergeLists(Vector vector, Vector vector2) {
        TreeMap treeMap;
        String string = "mergeLists";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if ((treeMap = this.convertVector2TreeMap(vector2)) != null) {
            int n = 0;
            while (n < vector.size()) {
                Entity entity = (Entity)vector.elementAt(n);
                String string2 = entity.getUniqueId();
                Entity entity2 = (Entity)treeMap.get(string2);
                if (entity2 != null) {
                    int n2 = 0;
                    while (n2 < entity2.getParameterList().size()) {
                        String string3 = entity2.getParamNameAt(n2);
                        if (string3.startsWith("Name")) {
                            entity.addParameter("Type", entity2.getParamValueAt(n2));
                        } else {
                            entity.addParameter(string3, entity2.getParamValueAt(n2));
                        }
                        ++n2;
                    }
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Entity list is null");
                }
                ++n;
            }
        } else if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Entity tree is null");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void getAvantiOIDNames(Vector vector) {
        String string = "getAvantiOIDNames";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
    }

    private TreeMap convertVector2TreeMap(Vector vector) {
        String string = "convertVector2TreeMap";
        TreeMap<String, Entity> treeMap = new TreeMap<String, Entity>();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            String string2 = entity.getUniqueId();
            treeMap.put(string2, entity);
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return treeMap;
    }

    private void setAvantiIds(Vector vector, String string) {
        String string2 = "setAvantiIds";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null) {
                int n2 = 0;
                while (n2 < entity.getParameterList().size()) {
                    string5 = entity.getParamNameAt(n2);
                    if (string5 != null && string5.equals("Vendor")) {
                        string4 = entity.getParamValueAt(n2);
                    } else if (string5 != null && string5.equals("Serial Number")) {
                        string3 = entity.getParamValueAt(n2);
                    }
                    if (string3 != null && string4 != null) break;
                    ++n2;
                }
                if (string3 == null || string4 == null || string3.length() == 0 || string4.length() == 0) {
                    vector.remove(n);
                    --n;
                } else {
                    entity.setName(string);
                    String string6 = String.valueOf(string4) + ":" + string3;
                    entity.setUniqueId(string6);
                }
            } else if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, " Entity object is null");
            }
            string5 = null;
            string4 = null;
            string3 = null;
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    private void addBlade2NodeXref(Vector vector, Vector vector2) {
        Object object;
        Entity entity;
        String string = "addBlade2NodeXref";
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        Vector<String> vector3 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.convertVector2TreeMap(vector, treeMap, "Slot");
        this.getSlotFromIfIndex(vector2);
        int n = 0;
        while (n < vector2.size()) {
            entity = (Entity)vector2.elementAt(n);
            if (entity != null) {
                object = entity.getUniqueId();
                if (object != null) {
                    int n2 = 0;
                    while (n2 < entity.getParameterList().size()) {
                        String string2 = entity.getParamNameAt(n2);
                        if (string2 != null && string2.equals("WWN")) {
                            String string3 = entity.getParamValueAt(n2);
                            if (treeMap2.containsKey(object) && string3 != null) {
                                vector3 = (Vector<String>)treeMap2.get(object);
                                treeMap2.remove(object);
                            } else if (!treeMap2.containsKey(object) && string3 != null) {
                                vector3 = new Vector<String>();
                            }
                            if (vector3 != null) {
                                vector3.add(string3);
                                treeMap2.put(object, vector3);
                            } else if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Map value is null");
                            }
                        }
                        ++n2;
                    }
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Key is null");
                }
            } else if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Entity is null");
            }
            ++n;
        }
        while (!treeMap2.isEmpty()) {
            String string4 = (String)treeMap2.firstKey();
            if (string4 != null) {
                entity = (Entity)treeMap.get(string4);
                if (entity != null) {
                    object = (Vector)treeMap2.get(string4);
                    if (object != null) {
                        try {
                            entity.addXrefs(string4, (Vector)object);
                        }
                        catch (Exception exception) {
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Failed to add blade to node Cross reference for " + string4 + " --> " + object);
                            }
                        }
                    } else if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " nodeValue is null");
                    }
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " bladeEntity is null");
                }
                treeMap2.remove(string4);
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) break;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " nodeKey is null");
            break;
        }
        this.convertMap2List(treeMap, vector);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void convertMap2List(TreeMap treeMap, Vector vector) {
        String string = "convertMap2List";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        vector.removeAllElements();
        while (!treeMap.isEmpty()) {
            String string2 = (String)treeMap.firstKey();
            if (string2 != null) {
                Entity entity = (Entity)treeMap.get(string2);
                if (entity != null) {
                    vector.add(entity);
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " entity is null");
                }
                treeMap.remove(string2);
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) break;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Key is null");
            break;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void getSlotFromIfIndex(Vector vector) {
        String string = "getSlotFromIfIndex";
        int n = 0;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n2);
            String string2 = entity.getUniqueId();
            if (string2 != null) {
                int n3 = Integer.parseInt(string2);
                if (n3 >> 24 == 12) {
                    n = (n3 >> 19 & 0x1F) + 1;
                    int cfr_ignored_0 = (n3 >> 12 & 0x7F) + 1;
                }
                entity.setUniqueId(Integer.toString(n));
            } else if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Entity name is null");
            }
            ++n2;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void parseAvantiPortParams(Vector vector, String string) {
        String string2 = "parseAvantiPortParams";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null) {
                int n2;
                int n3;
                String string3;
                String string4;
                String string5 = entity.getName();
                if (string5 != null && string5.startsWith(string) && (string4 = string5.substring(string.length() + 1)) != null && (string3 = string4.substring(n3 = string4.indexOf(".") + 1)) != null && (n2 = string3.indexOf(".") + 1) > 1) {
                    String string6 = string3.substring(0, n2 - 1);
                    String string7 = string3.substring(n2);
                    if (string6 != null) {
                        entity.addParameter("Mode", string6);
                    }
                    if (string7 != null && !this.vsanVector.contains(string7) && string6.startsWith("3")) {
                        this.vsanVector.add(string7);
                    }
                }
                entity.setName("FcPort");
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseAvantiClusterParams(Vector var1_1, String var2_2) {
        var3_3 = "parseAvantiClusterParams";
        if (CiscoMDSScanner.traceLogger != null && CiscoMDSScanner.traceLogger.isLogging()) {
            CiscoMDSScanner.traceLogger.entry(IRecordType.TYPE_API, (Object)CiscoMDSScanner.className, var3_3);
        }
        var4_4 = 0;
        while (var4_4 < var1_1.size()) {
            var5_5 = (Entity)var1_1.elementAt(var4_4);
            if (var5_5 == null || (var6_6 = var5_5.getName()) == null || !var6_6.startsWith(var2_2) || (var7_7 = var6_6.substring(var2_2.length() + 1)) == null || (var8_8 = var7_7.indexOf(".")) < 0 || (var9_9 = var7_7.substring(0, var8_8)) == null || !this.vsanVector.contains(var9_9)) ** GOTO lbl-1000
            this.vsanVector.remove(var9_9);
            var10_10 = var5_5.getParamValueAt(0);
            var5_5.getParameterList().remove(0);
            if (var10_10 == null || var10_10.length() <= 0 || (var11_11 = CiscoMDSScanner.convertHexStringToAscii(var10_10)) == null || (var12_12 = var11_11.indexOf(":")) < 0) ** GOTO lbl-1000
            var13_13 = var11_11.substring(0, var12_12);
            var14_14 = var11_11.substring(var12_12 + 1);
            var15_15 = null;
            if (var13_13 != null && var14_14 != null) {
                var12_12 = var14_14.indexOf(":");
                var15_15 = var12_12 < 1 ? var14_14 : var14_14.substring(0, var12_12 - 1);
                var5_5.addParameter("ID", var13_13);
                if (var15_15 != null) {
                    var5_5.addParameter("Name", var15_15);
                }
                var5_5.setName("Cluster");
                var5_5.setUniqueId(var13_13);
            } else lbl-1000:
            // 3 sources

            {
                var1_1.remove(var4_4);
                --var4_4;
            }
            ++var4_4;
        }
        if (CiscoMDSScanner.traceLogger != null && CiscoMDSScanner.traceLogger.isLogging()) {
            CiscoMDSScanner.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)CiscoMDSScanner.className, var3_3);
        }
    }

    private void addNode2PortXref(Vector vector, Vector vector2) {
        String string = "addNode2PortXref";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            String string2;
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null && (string2 = entity.getUniqueId()) != null) {
                int n2 = 0;
                while (n2 < vector2.size()) {
                    block8: {
                        String string3;
                        String string4;
                        Entity entity2 = (Entity)vector2.elementAt(n2);
                        if (entity2 != null && (string4 = entity2.getName()) != null && string4.indexOf(string2) != -1 && (string3 = entity2.getUniqueId()) != null) {
                            try {
                                entity.addXrefs(string2, string3);
                            }
                            catch (Exception exception) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Failed to create node to port relationship.");
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void addCluster2NodeXref(Vector vector, Vector vector2) {
        String string = "addCluster2NodeXref";
        String string2 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            String string3;
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null && (string3 = entity.getUniqueId()) != null) {
                int n2 = 0;
                while (n2 < vector2.size()) {
                    int n3;
                    int n4;
                    String string4;
                    String string5;
                    Entity entity2 = (Entity)vector2.elementAt(n2);
                    if (entity2 != null && (string5 = entity2.getUniqueId()) != null && string5.length() > 1 && (string4 = CiscoMDSScanner.convertHexStringToAscii(string5)) != null && (n4 = string4.indexOf(":")) != -1 && (string2 = (n3 = string4.indexOf(":", n4 + 1)) != -1 ? string4.substring(0, n3) : string4) != null && string2.startsWith(string3)) {
                        int n5 = 0;
                        while (n5 < entity2.getParameterList().size()) {
                            String string6 = entity2.getParamNameAt(n5);
                            if (string6 != null && string6.startsWith("WWN") && (string6 = entity2.getParamValueAt(n5)) != null) {
                                block10: {
                                    try {
                                        entity.addXrefs(string3, string6);
                                    }
                                    catch (Exception exception) {
                                        if (traceLogger == null || !traceLogger.isLogging()) break block10;
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, " Failed to create node to port relationship.");
                                    }
                                }
                                vector2.remove(n2);
                                --n2;
                                break;
                            }
                            ++n5;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setAvantiPortStateAndMode(Vector vector) {
        String string = "setAvantiPortStateAndMode";
        String string2 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null) {
                int n2 = 0;
                while (n2 < entity.getParameterList().size()) {
                    Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                    if (parameter != null) {
                        if (parameter.getName().equals("Mode")) {
                            string2 = parameter.getValue();
                            if (string2 != null) {
                                if (string2.equals("1")) {
                                    parameter.setValue("Initiator");
                                } else if (string2.equals("2")) {
                                    parameter.setValue("Target");
                                } else if (string2.equals("3")) {
                                    parameter.setValue("Mgmt");
                                }
                            }
                        } else if (parameter.getName().equals("State") && (string2 = parameter.getValue()) != null) {
                            if (string2.equals("1")) {
                                parameter.setValue("Up");
                            } else if (string2.equals("2")) {
                                parameter.setValue("Down");
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setAvantiNodeStatus(Vector vector) {
        String string = "setAvantiNodeStatus";
        String string2 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null) {
                int n2 = 0;
                while (n2 < entity.getParameterList().size()) {
                    Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                    if (parameter != null && parameter.getName().equals("Interface Status") && (string2 = parameter.getValue()) != null) {
                        if (string2.equals("1")) {
                            parameter.setValue("Up");
                        } else if (string2.equals("2")) {
                            parameter.setValue("Down");
                        } else if (string2.equals("3")) {
                            parameter.setValue("Testing");
                        } else if (string2.equals("4")) {
                            parameter.setValue("Unknown");
                        } else if (string2.equals("5")) {
                            parameter.setValue("Dormant");
                        } else if (string2.equals("6")) {
                            parameter.setValue("NotPresent");
                        } else if (string2.equals("7")) {
                            parameter.setValue("LowerLayerDown");
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void setBladeStatus(Vector vector) {
        String string = "setBladeStatus";
        String string2 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null) {
                int n2 = 0;
                while (n2 < entity.getParameterList().size()) {
                    Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                    if (parameter != null && parameter.getName().equals("Status") && (string2 = parameter.getValue()) != null) {
                        if (string2.equals("1")) {
                            parameter.setValue("Unknown");
                        } else if (string2.equals("2")) {
                            parameter.setValue("OK");
                        } else if (string2.equals("3")) {
                            parameter.setValue("Disabled");
                        } else if (string2.equals("4")) {
                            parameter.setValue("OkButDiagFailed");
                        } else if (string2.equals("5")) {
                            parameter.setValue("Boot");
                        } else if (string2.equals("6")) {
                            parameter.setValue("SelfTest");
                        } else if (string2.equals("7")) {
                            parameter.setValue("Failed");
                        } else if (string2.equals("8")) {
                            parameter.setValue("Missing");
                        } else if (string2.equals("9")) {
                            parameter.setValue("MismatchWithParent");
                        } else if (string2.equals("10")) {
                            parameter.setValue("MismatchConfig");
                        } else if (string2.equals("11")) {
                            parameter.setValue("DiagFailed");
                        } else if (string2.equals("12")) {
                            parameter.setValue("Dormant");
                        } else if (string2.equals("13")) {
                            parameter.setValue("OutOfServiceAdmin");
                        } else if (string2.equals("14")) {
                            parameter.setValue("OutOfServiceEnvTemp");
                        } else if (string2.equals("15")) {
                            parameter.setValue("PoweredDown");
                        } else if (string2.equals("16")) {
                            parameter.setValue("PoweredUp");
                        } else if (string2.equals("17")) {
                            parameter.setValue("PowerDenied");
                        } else if (string2.equals("18")) {
                            parameter.setValue("PowerCycled");
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void addVportToVsan(Vector vector, Hashtable hashtable) {
        String string = "addVportsToVsan";
        Vector<String> vector2 = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (entity != null) {
                String string2;
                int n2;
                String string3 = entity.getUniqueId();
                String string4 = entity.getName();
                if (string4 != null && string3 != null && (n2 = string4.lastIndexOf(".")) != -1 && (string2 = string4.substring(n2 + 1)) != null) {
                    vector2 = (Vector<String>)hashtable.get(string2);
                    if (vector2 == null) {
                        vector2 = new Vector<String>();
                    }
                    vector2.add(string3);
                    hashtable.put(string2, vector2);
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }
}

