/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.tsanm;

import org.eclipse.aperi.Router;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;
import org.eclipse.aperi.sanmgmt.subagent.scanner.interfaces.IScanner;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.KeyedJobQueue;
import org.eclipse.aperi.util.queue.QueueController;

public class InbandScanner
extends Thread {
    private Thread thread = null;
    private boolean shutdown = false;
    public static String className;
    public static String queueName;
    public static final String MESSAGE_NAME = "aperi.logger.message.InbandScanner";
    public static final String TRACE_NAME = "aperi.logger.trace.InbandScanner";
    public static String MSG_FILE;
    public static final String TopologyScanner = "Topology";
    public static final String AttributeScanner = "AttributePEOnly";
    public static ILogger msgLogger;
    public static ILogger traceLogger;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.tsanm.InbandScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        queueName = "Inband Scanner";
        MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public InbandScanner() {
        this.setName(String.valueOf(queueName) + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new KeyedJobQueue(true));
        this.start();
    }

    public void run() {
        boolean bl = false;
        String string = "run";
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            block23: {
                if (traceLogger != null && traceLogger.isLogging()) {
                    bl = true;
                }
                if (Configuration.debug && bl) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, String.valueOf(queueName) + ": waiting for a job.");
                }
                JobInfo jobInfo = QueueController.getInstance().getNextJob(queueName);
                if (this.shutdown) continue;
                if (jobInfo == null) {
                    if (!bl) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, String.valueOf(queueName) + ":Error - got a NULL job from the queue");
                    continue;
                }
                String string2 = (String)jobInfo.getRequest().getData();
                String cfr_ignored_0 = jobInfo.getTarget()[0];
                if (jobInfo.getTarget().length > 1) {
                    String cfr_ignored_1 = jobInfo.getTarget()[1];
                }
                ILogger iLogger = null;
                Request request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
                if (request != null) {
                    iLogger = request.getJobLogger();
                }
                try {
                    Object object;
                    org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response response;
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.sanmgmt.subagent.scanner.interfaces.IScanner");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    IScanner iScanner = (IScanner)ConnectorClient.getService((String)jobInfo.getTarget()[0], clazz, (String)"SANAgentScanner");
                    if (iLogger != null) {
                        iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string, "InbandScanner_invoke", (Object[])new String[]{string2, jobInfo.getTarget()[0]});
                    }
                    if (bl) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "about to invoke the scan on scanner= " + string2 + " and Target=  " + jobInfo.getTarget()[0]);
                    }
                    if ((response = iScanner.invoke(string2, jobInfo.getTarget()[0], "MibQueryEngine")).getHeader() == null) {
                        object = new Header();
                        response.setHeader((Header)object);
                    }
                    response.getHeader().setScannerName(string2);
                    response.getHeader().setAgentAddress(jobInfo.getTarget()[0]);
                    response.getHeader().setScannerId(jobInfo.getRequestId());
                    object = response.getHeader().getType();
                    if (object == null || ((String)object).length() == 0) {
                        if (string2.equalsIgnoreCase(AttributeScanner)) {
                            response.getHeader().setType("PE");
                        } else {
                            response.getHeader().setType("");
                        }
                    }
                    if (response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                        jobInfo.setResponse((Response)new ObjectResponse((Object)response, jobInfo));
                    }
                    jobInfo.setReturnCode(response.getReturnCode());
                    jobInfo.complete(response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK);
                    if (iLogger != null) {
                        if (response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                            iLogger.message(IRecordType.TYPE_INFO, (Object)this, string, "InbandScanner_Successful", (Object)string2, (Object)jobInfo.getTarget()[0]);
                        } else {
                            iLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandScanner_Failed", (Object[])new String[]{string2, jobInfo.getTarget()[0], new Integer(response.getReturnCode()).toString()});
                        }
                    }
                }
                catch (Exception exception) {
                    new org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response(org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_ERROR, "Query Engine Detected Error:" + exception);
                    jobInfo.setReturnCode(100);
                    jobInfo.complete(false);
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandScanHandler_invokeScannerFailure", (Object)string2, (Object)jobInfo.getTarget()[0]);
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    if (iLogger != null) {
                        iLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandScanHandler_UnknownHostException", (Object)string2, (Object)jobInfo.getTarget()[0]);
                        iLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    }
                    if (bl) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    new org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response(org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_ERROR, "Query Engine Detected Error (throwable):" + throwable);
                    jobInfo.setReturnCode(100);
                    jobInfo.complete(false);
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandScanHandler_invokeScannerFailure", (Object)string2, (Object)jobInfo.getTarget()[0]);
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, throwable);
                    if (!bl) break block23;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, throwable);
                }
            }
            if (!Configuration.debug || !bl) continue;
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, String.valueOf(queueName) + ": finishing job.");
        }
    }

    public void shutdown() {
        String string;
        block5: {
            string = "shutdown";
            this.shutdown = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread.join(30000L);
                    this.thread = null;
                }
                catch (Exception exception) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    if (traceLogger == null || !traceLogger.isLogging()) break block5;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }
}

