/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.tsanm;

import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.IScanner;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.KeyedJobQueue;
import org.eclipse.aperi.util.queue.QueueController;

public class OutbandScanner
extends Thread {
    private boolean shutdown = false;
    private static SNMPConfig config;
    private Thread thread = null;
    public static String queueName;
    public static final String MESSAGE_NAME = "aperi.logger.message.SNMPScanner";
    public static final String TRACE_NAME = "aperi.logger.trace.SNMPScanner";
    public static String MSG_FILE;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    public static final String TopologyScanner;
    public static final String CiscoMDSScanner;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        queueName = "SNMP Scanner";
        MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
        msgLogger = null;
        traceLogger = null;
        try {
            clazz3 = Class.forName("org.eclipse.aperi.discovery.tsanm.OutbandScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz3.getName();
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        try {
            clazz2 = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.TopologyScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TopologyScanner = clazz2.getName();
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.CiscoMDSScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CiscoMDSScanner = clazz.getName();
    }

    public OutbandScanner() {
        this.setName(String.valueOf(queueName) + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new KeyedJobQueue(true));
        this.start();
    }

    public void run() {
        boolean bl = false;
        String string = "run";
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            if (traceLogger != null && traceLogger.isLogging()) {
                bl = true;
            }
            if (bl) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, String.valueOf(queueName) + ": waiting for a job.");
            }
            JobInfo jobInfo = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) continue;
            if (jobInfo == null) {
                if (!bl) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, String.valueOf(queueName) + ":Error - got a NULL job from the queue");
                continue;
            }
            try {
                org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response response;
                ILogger iLogger = null;
                Request request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
                if (request != null) {
                    iLogger = request.getJobLogger();
                }
                Hashtable hashtable = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = jobInfo.getResourceId();
                if (jobInfo.getRequest().getData() instanceof Hashtable) {
                    hashtable = (Hashtable)jobInfo.getRequest().getData();
                    string2 = (String)hashtable.get("SCANNER");
                    string3 = (String)hashtable.get("SNMP Community");
                    string4 = (String)hashtable.get("SNMP Write Community");
                } else if (jobInfo.getRequest().getData() instanceof String) {
                    string2 = (String)jobInfo.getRequest().getData();
                } else {
                    if (iLogger != null) {
                        iLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "OutbandScanner_Failed", new Object[]{string2, jobInfo.getTarget()[0], new Integer(999)});
                    }
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "OutbandScanner_Failed", new Object[]{string2, jobInfo.getTarget()[0], new Integer(999)});
                    if (bl) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string, "The job request data format is unknown for Job " + jobInfo.toString() + ".");
                    }
                }
                String string6 = string2;
                int n = string2.lastIndexOf(".");
                if (n > -1) {
                    string6 = string2.substring(n + 1);
                }
                IScanner iScanner = null;
                try {
                    response = Class.forName(string2);
                    iScanner = (IScanner)response.newInstance();
                }
                catch (Throwable throwable) {
                    if (iLogger != null) {
                        iLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, throwable);
                    }
                    if (bl) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, throwable);
                    }
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, throwable);
                    if (bl) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, throwable);
                    }
                    jobInfo.setReturnCode(101);
                    jobInfo.complete(false);
                    continue;
                }
                if (iLogger != null) {
                    iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string, "OutbandScanner_invoke", (Object[])new String[]{string6, jobInfo.getTarget()[0]});
                }
                if (bl) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, String.valueOf(queueName) + ": invoking " + string2 + " on " + jobInfo.getTarget()[0]);
                }
                if (iScanner == null) {
                    if (iLogger != null) {
                        iLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string, "OutbandScanner_invokeErrNullScanner", (Object[])new String[]{string6});
                    }
                    if (bl) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Scanner " + string2 + " not valid.");
                    }
                    jobInfo.setReturnCode(101);
                    jobInfo.complete(false);
                } else {
                    try {
                        if (string2.equals(TopologyScanner) || CiscoMDSScanner.equals(string2)) {
                            config = (SNMPConfig)SnmpV1API.getConfig();
                            config.setSnmpCommunityName(string5, string3);
                            config.setSnmpWriteCommunityName(string5, string4);
                        }
                        if ((response = iScanner.invoke(string2, jobInfo.getTarget())).getHeader() == null) {
                            Header header = new Header();
                            response.setHeader(header);
                        }
                        response.getHeader().setScannerName(string2);
                        response.getHeader().setAgentAddress(jobInfo.getTarget()[0]);
                        response.getHeader().setScannerId(jobInfo.getRequestId());
                        response.getHeader().setType("");
                        if (response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                            jobInfo.setResponse((Response)new ObjectResponse((Object)response, jobInfo));
                        }
                        jobInfo.setReturnCode(response.getReturnCode());
                        if (iLogger != null) {
                            if (response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                                iLogger.message(IRecordType.TYPE_INFO, (Object)this, string, "OutbandScanner_Successful", (Object)string6, (Object)jobInfo.getTarget()[0]);
                            } else {
                                iLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "OutbandScanner_Failed", (Object[])new String[]{string6, jobInfo.getTarget()[0], new Integer(response.getReturnCode()).toString()});
                            }
                        }
                        jobInfo.complete(response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK);
                    }
                    catch (Exception exception) {
                        if (iLogger != null) {
                            iLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "OutbandScanHandler_UnknownHostException", (Object)string6, (Object)jobInfo.getTarget()[0]);
                            iLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                            if (bl) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                            }
                        }
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "OutbandScanHandler_UnknownHostException", (Object)string6, (Object)jobInfo.getTarget()[0]);
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                        if (bl) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                        }
                        jobInfo.setReturnCode(100);
                        jobInfo.complete(false);
                    }
                }
            }
            catch (Throwable throwable) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, throwable);
                if (bl) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, throwable);
                }
                jobInfo.setReturnCode(99);
                jobInfo.complete(false);
            }
            if (!bl) continue;
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, String.valueOf(queueName) + ": finishing job.");
        }
    }

    public void shutdown() {
        String string;
        block5: {
            string = "shutdown";
            this.shutdown = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread.join(30000L);
                    this.thread = null;
                }
                catch (Exception exception) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    if (traceLogger == null || !traceLogger.isLogging()) break block5;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }
}

