/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleGroupElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class GroupPropertyHandle {
    protected ElementPropertyDefn propDefn = null;
    protected GroupElementHandle handle = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    GroupPropertyHandle(GroupElementHandle handle, ElementPropertyDefn propDefn) {
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(handle instanceof SimpleGroupElementHandle)) {
            throw new AssertionError();
        }
        this.handle = handle;
        this.propDefn = propDefn;
    }

    public final boolean shareSameValue() {
        Iterator iter = this.handle.getElements().iterator();
        if (!iter.hasNext()) {
            return false;
        }
        DesignElementHandle elemHandle = (DesignElementHandle)iter.next();
        Object baseValue = null;
        baseValue = this.propDefn.getTypeCode() == 16 ? elemHandle.getProperty(this.propDefn.getName()) : elemHandle.getStringProperty(this.propDefn.getName());
        while (iter.hasNext()) {
            elemHandle = (DesignElementHandle)iter.next();
            Object value = null;
            value = this.propDefn.getTypeCode() == 16 ? elemHandle.getProperty(this.propDefn.getName()) : elemHandle.getStringProperty(this.propDefn.getName());
            if (!(baseValue == null ? value != null : !baseValue.equals(value))) continue;
            return false;
        }
        return true;
    }

    public String getStringValue() {
        if (!this.shareSameValue()) {
            return null;
        }
        List elements = this.handle.getElements();
        return ((DesignElementHandle)elements.get(0)).getStringProperty(this.propDefn.getName());
    }

    public String getLocalStringValue() {
        Object value = this.getLocalValue();
        if (value == null) {
            return null;
        }
        DesignElementHandle element = (DesignElementHandle)this.handle.getElements().get(0);
        String localValue = this.propDefn.getStringValue(element.getEffectiveModule(), value);
        return localValue;
    }

    protected Object getLocalValue() {
        if (!this.shareSameValue()) {
            return null;
        }
        List elements = this.handle.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            DesignElementHandle element = (DesignElementHandle)elements.get(i);
            Object value = element.getElement().getLocalProperty(element.getModule(), this.propDefn);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String getDisplayValue() {
        if (!this.shareSameValue()) {
            return null;
        }
        List elements = this.handle.getElements();
        return ((DesignElementHandle)elements.get(0)).getDisplayProperty(this.propDefn.getName());
    }

    public void setValue(Object value) throws SemanticException {
        if (!$assertionsDisabled && this.handle.getModule() == null) {
            throw new AssertionError();
        }
        ActivityStack actStack = this.handle.getModule().getActivityStack();
        actStack.startTrans();
        try {
            Iterator iter = this.handle.getElements().iterator();
            while (iter.hasNext()) {
                DesignElementHandle elemHandle = (DesignElementHandle)iter.next();
                elemHandle.setProperty(this.propDefn.getName(), value);
            }
        }
        catch (SemanticException e) {
            actStack.rollback();
            throw e;
        }
        actStack.commit();
    }

    public void setStringValue(String value) throws SemanticException {
        this.setValue(value);
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.propDefn;
    }

    public void clearValue() throws SemanticException {
        this.setValue(null);
    }

    public List getReferenceableElementList() {
        List elements = this.handle.getElements();
        if (elements == null || elements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle element = (DesignElementHandle)elements.get(0);
        PropertyHandle propHandle = element.getPropertyHandle(this.propDefn.getName());
        List retList = propHandle.getReferenceableElementList();
        return ModelUtil.sortElementsByName(retList);
    }

    public boolean equals(Object target) {
        if (!(target instanceof PropertyHandle) && !(target instanceof GroupPropertyHandle)) {
            return false;
        }
        if (target instanceof PropertyHandle) {
            DesignElementHandle targetElement = ((PropertyHandle)target).getElementHandle();
            IPropertyDefn targetPropDefn = ((PropertyHandle)target).getDefn();
            return this.handle.isInGroup(targetElement) && targetPropDefn == this.propDefn;
        }
        GroupPropertyHandle propHandle = (GroupPropertyHandle)target;
        return propHandle.handle == this.handle && propHandle.propDefn == this.getPropertyDefn();
    }

    public boolean isVisible() {
        return this.handle.isPropertyVisible(this.propDefn.getName());
    }

    public boolean isReadOnly() {
        return this.handle.isPropertyReadOnly(this.propDefn.getName());
    }

    static {
        $assertionsDisabled = !GroupPropertyHandle.class.desiredAssertionStatus();
    }
}

