/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.StructRefValue;

abstract class AbstractLibraryRecord
extends SimpleRecord {
    protected Module module;
    protected Library library;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractLibraryRecord(Module module, Library library) {
        this.module = module;
        this.library = library;
    }

    AbstractLibraryRecord(Module module) {
        this.module = module;
    }

    public DesignElement getTarget() {
        return this.module;
    }

    public void updateReferenceableClients(List librariesToUpdate) {
        int size = librariesToUpdate.size();
        List libraries = this.module.getLibraries();
        for (int i = 0; i < size; ++i) {
            this.updateReferenceableClients((Library)libraries.get(i));
        }
    }

    public void updateReferenceableClients(Library library) {
        this.updateReferenceableClients(library, 0);
        List images = library.getListProperty(library, "images");
        if (images == null || images.isEmpty()) {
            return;
        }
        boolean sendEvent = false;
        for (int i = 0; i < images.size(); ++i) {
            Object client;
            int j;
            EmbeddedImage image = (EmbeddedImage)images.get(i);
            List clients = image.getClientStructures();
            if (clients == null || clients.isEmpty()) continue;
            for (j = 0; j < clients.size(); ++j) {
                client = (Structure)clients.get(j);
                StructRefValue value = (StructRefValue)((Structure)client).getLocalProperty(this.module, "libReference");
                if (!$assertionsDisabled && value == null) {
                    throw new AssertionError();
                }
                value.unresolved(value.getName());
                image.dropClientStructure((Structure)client);
                sendEvent = true;
            }
            clients = image.getClientList();
            if (clients == null || clients.isEmpty()) continue;
            for (j = 0; j < clients.size(); ++j) {
                client = (BackRef)clients.get(j);
                DesignElement element = ((BackRef)client).getElement();
                StructRefValue value = (StructRefValue)element.getLocalProperty(this.module, ((BackRef)client).getPropertyName());
                if (!$assertionsDisabled && value == null) {
                    throw new AssertionError();
                }
                value.unresolved(value.getName());
                image.dropClient(element);
                element.broadcast(new PropertyEvent(this.module, ((BackRef)client).getPropertyName()));
            }
        }
        if (sendEvent) {
            this.module.broadcast(new PropertyEvent(this.module, "images"));
        }
    }

    private void updateReferenceableClients(DesignElement target, int slotId) {
        ContainerSlot slot = target.getSlot(slotId);
        Iterator iter = slot.iterator();
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            if (!$assertionsDisabled && !(element instanceof ReferenceableElement)) {
                throw new AssertionError();
            }
            ReferenceableElement referenceableElement = (ReferenceableElement)element;
            referenceableElement.updateClientReferences();
            if (!(referenceableElement instanceof Theme)) continue;
            this.updateReferenceableClients(referenceableElement, 0);
        }
    }

    static {
        $assertionsDisabled = !AbstractLibraryRecord.class.desiredAssertionStatus();
    }
}

