/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentReplaceEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.validators.ValidationExecutor;

public class ContentReplaceRecord
extends SimpleRecord {
    protected DesignElement container = null;
    protected final DesignElement newElement;
    protected final DesignElement oldElement;
    protected int slotID = 0;
    protected final Module module;
    protected int posn;
    protected ContainerSlot slot = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ContentReplaceRecord(Module module, DesignElement containerObj, int theSlot, DesignElement oldElement, DesignElement newElement) {
        this.module = module;
        this.oldElement = oldElement;
        this.newElement = newElement;
        this.slotID = theSlot;
        this.container = containerObj;
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        this.slot = this.container.getSlot(theSlot);
        if (!$assertionsDisabled && this.slot == null) {
            throw new AssertionError();
        }
        this.posn = this.slot.findPosn(oldElement);
        if (!$assertionsDisabled && this.posn == -1) {
            throw new AssertionError();
        }
        this.label = ModelMessages.getMessage("Message.ReplaceElement");
    }

    protected void perform(boolean undo) {
        if (undo) {
            this.replace(this.newElement, this.oldElement);
        } else {
            this.replace(this.oldElement, this.newElement);
        }
    }

    private void replace(DesignElement oldElement, DesignElement newElement) {
        this.slot.remove(oldElement);
        if (oldElement.getRoot() != null) {
            this.module.manageId(oldElement, false);
        }
        oldElement.setContainer(null, -1);
        this.slot.insert(newElement, this.posn);
        newElement.setContainer(this.container, this.slotID);
        if (newElement.getRoot() != null) {
            this.module.manageId(newElement, true);
        }
    }

    public DesignElement getTarget() {
        return this.container;
    }

    public NotificationEvent getEvent() {
        return null;
    }

    private boolean isSelector(DesignElement content) {
        if (!(content instanceof StyleElement)) {
            return false;
        }
        return MetaDataDictionary.getInstance().getPredefinedStyle(content.getName()) != null;
    }

    public List getValidators() {
        SlotDefn slotDefn = (SlotDefn)this.container.getDefn().getSlot(this.slotID);
        List list = ValidationExecutor.getValidationNodes(this.container, slotDefn.getTriggerDefnSet(), false);
        if (this.state != 2) {
            ElementDefn contentDefn = (ElementDefn)this.newElement.getDefn();
            list.addAll(ValidationExecutor.getValidationNodes(this.newElement, contentDefn.getTriggerDefnSet(), false));
        } else {
            ElementDefn contentDefn = (ElementDefn)this.oldElement.getDefn();
            list.addAll(ValidationExecutor.getValidationNodes(this.oldElement, contentDefn.getTriggerDefnSet(), false));
        }
        return list;
    }

    protected List getPostTasks() {
        ReportItem compoundElement;
        ArrayList<RecordTask> retValue = new ArrayList<RecordTask>();
        retValue.addAll(super.getPostTasks());
        if ((this.container instanceof TableItem || this.container instanceof TableGroup || this.container instanceof TableRow) && (compoundElement = LayoutUtil.getCompoundContainer(this.container)) != null) {
            retValue.add(new LayoutRecordTask(this.module, compoundElement));
        }
        NotificationEvent event = null;
        event = this.getContainerEvent();
        retValue.add(new NotificationRecordTask(this.container, event));
        if (this.state != 2) {
            if (this.isSelector(this.newElement)) {
                retValue.add(new NotificationRecordTask(this.newElement, event, this.container.getRoot()));
            }
        } else if (this.isSelector(this.oldElement)) {
            retValue.add(new NotificationRecordTask(this.oldElement, event, this.container.getRoot()));
        }
        return retValue;
    }

    protected NotificationEvent getContainerEvent() {
        ContentReplaceEvent event = null;
        event = this.state != 2 ? new ContentReplaceEvent(this.container, this.oldElement, this.newElement, this.slotID) : new ContentReplaceEvent(this.container, this.newElement, this.oldElement, this.slotID);
        if (this.state == 1) {
            event.setSender(this.sender);
        }
        return event;
    }

    static {
        $assertionsDisabled = !ContentReplaceRecord.class.desiredAssertionStatus();
    }
}

