/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.validators.ThemeStyleNameValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IThemeModel;

public class Theme
extends ReferenceableElement
implements IThemeModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public Theme() {
        this.initSlots();
    }

    public Theme(String theName) {
        super(theName);
        this.initSlots();
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitTheme(this);
    }

    public String getElementName() {
        return "Theme";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ThemeHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ThemeHandle(module, this);
        }
        return (ThemeHandle)this.handle;
    }

    public ContainerSlot getSlot(int slot) {
        if (!$assertionsDisabled && slot != 0) {
            throw new AssertionError();
        }
        return this.slots[0];
    }

    protected void adjustDeliveryPath(NotificationEvent ev) {
        ev.setDeliveryPath(4);
    }

    public StyleElement findStyle(String styleName) {
        StyleElement style = null;
        for (int i = 0; i < this.slots[0].getCount(); ++i) {
            StyleElement tmpStyle = (StyleElement)this.slots[0].getContent(i);
            if (!tmpStyle.getName().equalsIgnoreCase(styleName)) continue;
            style = tmpStyle;
            break;
        }
        return style;
    }

    protected List checkContent(Module module, DesignElement tmpContainer, int slotId, DesignElement content) {
        List tmpErrors = super.checkContent(module, tmpContainer, slotId, content);
        if (!tmpErrors.isEmpty()) {
            return tmpErrors;
        }
        tmpErrors.addAll(ThemeStyleNameValidator.getInstance().validateForAddingStyle((ThemeHandle)this.getHandle(module), content.getName()));
        return tmpErrors;
    }

    static {
        $assertionsDisabled = !Theme.class.desiredAssertionStatus();
    }
}

