/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.server;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.internal.server.BiModalSSLSocketListener;
import org.eclipse.aperi.connector.internal.server.BiModalSocketListener;
import org.eclipse.aperi.connector.log.LogHelper;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ServletActivator
implements BundleActivator {
    private HttpServer server;

    public void start(BundleContext bundleContext) throws Exception {
        Class<?> clazz;
        String string = "start";
        LogHelper.traceEntry(this.getClass(), string);
        this.server = new HttpServer();
        SocketListener socketListener = this.createListener(bundleContext);
        if (socketListener != null) {
            this.server.addListener((HttpListener)socketListener);
        } else {
            LogHelper.log("CNT016W", this.getClass(), string);
        }
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.setAutoInitializeServlets(true);
        try {
            clazz = Class.forName("org.eclipse.equinox.http.servlet.HttpServiceServlet");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ServletHolder servletHolder = servletHandler.addServlet("/*", clazz.getName());
        servletHolder.setInitOrder(0);
        HttpContext httpContext = this.createHttpContext(bundleContext);
        httpContext.addHandler((HttpHandler)servletHandler);
        this.server.addContext(httpContext);
        this.server.start();
        LogHelper.log("CNT002I", this.getClass(), string);
        LogHelper.traceExit(this.getClass(), string);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.server.stop();
    }

    private SocketListener createListener(BundleContext bundleContext) {
        String string = "createListener";
        LogHelper.traceEntry(this.getClass(), string);
        BiModalSocketListener biModalSocketListener = null;
        int n = 80;
        String string2 = Config.getProperty("org.osgi.service.http.port");
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                LogHelper.trace("The property -Dorg.osgi.service.http.port should be a number: " + string2, this.getClass(), string);
                LogHelper.traceException(numberFormatException, this.getClass(), string);
            }
        }
        if (n > 0) {
            String string3 = Config.getProperty("connector.ssl.enabled");
            if (string3 == null || "false".equals(string3)) {
                biModalSocketListener = new BiModalSocketListener();
            } else {
                biModalSocketListener = new BiModalSSLSocketListener();
                LogHelper.log("CNT015I", this.getClass(), string);
            }
            biModalSocketListener.setPort(n);
            String string4 = biModalSocketListener.getHost();
            try {
                if (string4 == null) {
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(string4);
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 0;
                    while (n2 < inetAddressArray.length) {
                        if (n2 > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(inetAddressArray[n2].getHostName());
                        ++n2;
                    }
                    string4 = stringBuffer.toString();
                }
            }
            catch (UnknownHostException unknownHostException) {
                LogHelper.traceException(unknownHostException, this.getClass(), string);
            }
            LogHelper.log("CNT001I", this.getClass(), string, new String[]{"" + n, string4});
        } else {
            LogHelper.trace("The property -Dorg.osgi.service.http.port returned a value < 0, it returned a value of " + n, this.getClass(), string);
        }
        return biModalSocketListener;
    }

    private HttpContext createHttpContext(BundleContext bundleContext) {
        String string = "/";
        HttpContext httpContext = new HttpContext();
        httpContext.setClassLoader(this.getClass().getClassLoader());
        httpContext.setContextPath(string);
        File file = new File(bundleContext.getDataFile(""), Config.getProperty("connector.dir.data"));
        file.mkdir();
        httpContext.setTempDirectory(file);
        return httpContext;
    }
}

