/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.xml.i18n.Messages;
import org.eclipse.birt.report.data.oda.xml.impl.DataSetMetaData;
import org.eclipse.birt.report.data.oda.xml.impl.Query;
import org.eclipse.birt.report.data.oda.xml.util.XMLDataInputStreamCreator;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection
implements IConnection {
    private XMLDataInputStreamCreator is;
    private boolean isOpen;
    private Map appContext;

    public void open(Properties connProperties) throws OdaException {
        if (this.isOpen) {
            return;
        }
        String file = (String)connProperties.get("FILELIST");
        if (this.appContext != null && this.appContext.get("org.eclipse.birt.report.data.oda.xml.inputStream") != null && this.appContext.get("org.eclipse.birt.report.data.oda.xml.inputStream") instanceof InputStream) {
            this.is = XMLDataInputStreamCreator.getCreator((InputStream)this.appContext.get("org.eclipse.birt.report.data.oda.xml.inputStream"));
        } else if (file != null) {
            this.is = XMLDataInputStreamCreator.getCreator(file);
        } else {
            throw new OdaException(Messages.getString("Connection.PropertiesMissing"));
        }
        this.isOpen = true;
    }

    public void close() throws OdaException {
        this.isOpen = false;
        try {
            Object closeInputStream;
            if (this.appContext != null && this.appContext.get("org.eclipse.birt.report.data.oda.xml.inputStream") != null && (closeInputStream = this.appContext.get("org.eclipse.birt.report.data.oda.xml.closeInputStream")) != null && closeInputStream.toString().equalsIgnoreCase("true")) {
                this.closeInputStreamFromAppContext();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.appContext = null;
    }

    private void closeInputStreamFromAppContext() throws IOException {
        ((InputStream)this.appContext.get("org.eclipse.birt.report.data.oda.xml.inputStream")).close();
    }

    public boolean isOpen() throws OdaException {
        return this.isOpen;
    }

    public void setAppContext(Object context) throws OdaException {
        if (!(context instanceof Map)) {
            throw new OdaException(Messages.getString("Connection.InvalidAppContext"));
        }
        this.appContext = (Map)context;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        return new Query(this.is);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws OdaException {
        throw new UnsupportedOperationException();
    }
}

