/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import org.eclipse.aperi.control.ThreadPool;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ControlThread
extends Thread {
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className;
    private ThreadPool controlThreadPool;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.ControlThread");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    ControlThread(ThreadPool threadPool, int n) {
        String string = "ControlThread";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        this.controlThreadPool = threadPool;
        this.setName(String.valueOf(threadPool.getControllerName()) + " thread " + n);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void run() {
        String string = "run";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        Runnable runnable = this.controlThreadPool.getNextJob();
        while (runnable != null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Running job...");
            }
            runnable.run();
            runnable = this.controlThreadPool.getNextJob();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }
}

