/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.MemoryHandler;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class LevelMemoryHandler
extends MemoryHandler {
    static final long serialVersionUID = 6680067691832199251L;
    private Level level = Level.ERROR;

    public LevelMemoryHandler() {
    }

    public LevelMemoryHandler(String string) {
        super(string);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("level", this.getLevel().getName());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("level");
        if (string != null) {
            this.setLevel(Level.getLevel(string));
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setLevel");
            LogUtil.errorMsg(string);
        }
    }

    public synchronized void process(LogEvent logEvent) {
        if (logEvent != null) {
            if (this.convertExceptions) {
                logEvent.convertException();
            }
            this.queue.enqueue(logEvent);
            Level level = logEvent.getLevel();
            if (!level.equals(Level.OFF) && level.getValue() >= this.getLevel().getValue()) {
                this.close();
            }
        }
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", level=" + this.getLevel();
    }
}

