/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.LogEvent;
import com.ibm.log.util.ISO8601DateFormat;
import java.util.Date;

public class TivTraceFormatter
extends Formatter {
    public static final char RECORD_SEPARATOR = '\u001e';
    public static final char FIELD_SEPARATOR = '\u001f';
    public static final String SUBFIELD_SEPARATOR = " - ";
    private static ISO8601DateFormat dateFmt = new ISO8601DateFormat();

    public TivTraceFormatter(String string) {
        super(string);
    }

    public TivTraceFormatter() {
    }

    public String format(LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = null;
        stringBuffer.append('\u001e');
        Date date = new Date(logEvent.getTimeStamp());
        stringBuffer.append("[" + dateFmt.format(date) + "]");
        stringBuffer.append(SUBFIELD_SEPARATOR);
        stringBuffer.append(this.getLevelStr(logEvent.getLevel().getValue()));
        logEvent.getLevel();
        stringBuffer.append(SUBFIELD_SEPARATOR);
        stringBuffer.append(this.getShortServerName(logEvent.getServer()));
        stringBuffer.append(SUBFIELD_SEPARATOR);
        string = logEvent.getThreadName();
        stringBuffer.append(string == null ? "" : string);
        stringBuffer.append(SUBFIELD_SEPARATOR);
        string = logEvent.getLoggingClass();
        stringBuffer.append(string == null ? "" : string);
        stringBuffer.append(".");
        string = logEvent.getLoggingMethod();
        stringBuffer.append(string == null ? "" : string);
        stringBuffer.append(SUBFIELD_SEPARATOR);
        string = logEvent.getMessageId();
        stringBuffer.append(string == null ? "" : string);
        stringBuffer.append(this.getText(logEvent));
        stringBuffer.append(this.lineSep);
        return stringBuffer.toString();
    }

    private String getShortServerName(String string) {
        int n = string.indexOf(".");
        return string.substring(0, n == -1 ? string.length() : n);
    }

    protected String getLevelStr(int n) {
        switch (n) {
            case 7000: {
                return "ERROR";
            }
            case 6000: {
                return "ERROR";
            }
            case 5000: {
                return "WARN ";
            }
            case 4000: {
                return "INFO ";
            }
            case 3000: {
                return " MIN ";
            }
            case 2000: {
                return " MID ";
            }
            case 1000: {
                return " MAX ";
            }
        }
        return "OTHER";
    }

    protected String getText(LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.getMessage(logEvent));
        String string = logEvent.getStackTrace();
        if (string != null) {
            String string2 = logEvent.getText();
            if (string2 != null) {
                stringBuffer.append(this.lineSep);
                stringBuffer.append("  ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

