/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.Handler;
import com.ibm.log.LogComponent;
import com.ibm.log.LogEventFormatter;
import com.ibm.log.LogEventListener;
import com.ibm.log.LogEventProducer;
import com.ibm.log.cmd.CommandServer;
import com.ibm.log.cmd.LogCmdServer;
import com.ibm.log.mgr.ConfigChangeEvent;
import com.ibm.log.mgr.ConfigChangeListener;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.LogManagerConfig;
import com.ibm.log.mgr.LogPermission;
import com.ibm.log.util.ErrorProtocol;
import com.ibm.log.util.LogUtil;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogManager
implements ConfigChangeListener {
    protected static final Object mgrLock = new Object();
    protected static final Object objLock = new Object();
    protected CommandServer commandServer = null;
    private DataStore dataStore = null;
    protected Hashtable fullConfig = new Hashtable();
    protected static LogManager mgr = null;
    private boolean sysPropNoLogCmdServer = false;
    private boolean factoryNoLogCmdServer = false;
    private String port;
    private boolean cfgPermission = false;

    protected static final void verifyLogConfigPermission() throws AccessControlException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LogPermission("config", null));
        }
    }

    protected final boolean hasLogConfigPermission() {
        return this.cfgPermission;
    }

    public static LogManager getManager() {
        return LogManager.getManager(null, true);
    }

    public static LogManager getManager(boolean bl) {
        return LogManager.getManager(null, bl);
    }

    public static LogManager getManager(DataStore dataStore) {
        return LogManager.getManager(dataStore, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogManager getManager(DataStore dataStore, boolean bl) {
        Object object = mgrLock;
        synchronized (object) {
            if (mgr == null) {
                mgr = new LogManager(dataStore, bl);
            } else {
                LogManager.verifyLogConfigPermission();
            }
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogManager getManagerWithMergedDataStore(DataStore dataStore, boolean bl) {
        Object object = mgrLock;
        synchronized (object) {
            if (mgr == null) {
                mgr = new LogManager(dataStore, bl);
            } else {
                LogManager.verifyLogConfigPermission();
                DataStore dataStore2 = mgr.getDataStore();
                if (dataStore2 == null) {
                    mgr.setDataStore(dataStore);
                } else if (dataStore != null) {
                    Enumeration enumeration = dataStore.getConfig();
                    DataStoreConfig dataStoreConfig = null;
                    String string = null;
                    while (enumeration.hasMoreElements()) {
                        dataStoreConfig = (DataStoreConfig)enumeration.nextElement();
                        string = dataStoreConfig.getProperty("name");
                        if (dataStore2.containsConfig(string)) {
                            if (string.equals("/")) continue;
                            String string2 = LogUtil.getLogMsg("WARN_CFG_NOT_MERGED", string);
                            LogUtil.errorMsg(string2);
                            continue;
                        }
                        dataStore2.addConfig(dataStoreConfig);
                    }
                }
            }
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteManager() {
        LogManager.verifyLogConfigPermission();
        Object object = mgrLock;
        synchronized (object) {
            if (mgr != null) {
                mgr.stopCommandServer();
                mgr = null;
            }
        }
    }

    protected LogManager() throws AccessControlException {
        LogManager.verifyLogConfigPermission();
        this.cfgPermission = true;
    }

    protected LogManager(DataStore dataStore, boolean bl) throws AccessControlException {
        LogManager.verifyLogConfigPermission();
        this.cfgPermission = true;
        boolean bl2 = this.factoryNoLogCmdServer = !bl;
        if (dataStore != null) {
            this.setDataStore(dataStore);
        }
        this.startCommandServer();
    }

    protected LogManager(DataStore dataStore) throws AccessControlException {
        this(dataStore, true);
    }

    public DataStore getDataStore() {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        if (dataStore != null) {
            if (this.dataStore != null) {
                this.dataStore.removeConfigChangeListener(this);
            }
            this.dataStore = dataStore;
            this.dataStore.addConfigChangeListener(this);
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDataStore");
            LogUtil.errorMsg(string);
        }
    }

    public CommandServer getCommandServer() {
        return this.commandServer;
    }

    public void setCommandServer(CommandServer commandServer) {
        if (commandServer != null) {
            this.commandServer = commandServer;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setCommandServer");
            LogUtil.errorMsg(string);
        }
    }

    private void getSystemProperties() throws AccessControlException {
        String string;
        String string2;
        Object object;
        if (this.dataStore != null && this.dataStore.containsConfig("jlog")) {
            object = this.dataStore.getConfig("jlog");
            string2 = ((Properties)object).getProperty("logCmdPort");
            string = ((Properties)object).getProperty("noLogCmd");
            if (string != null) {
                this.sysPropNoLogCmdServer = Boolean.valueOf(string);
            }
            if (string2 != null) {
                this.port = string2;
            }
        }
        if ((object = System.getSecurityManager()) == null) {
            string2 = System.getProperty("jlog.noLogCmd");
            string = System.getProperty("jlog.logCmdPort");
            if (string2 != null) {
                this.sysPropNoLogCmdServer = Boolean.valueOf(string2);
            }
            if (string != null) {
                this.port = string;
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("jlog.noLogCmd");
                    String string2 = System.getProperty("jlog.logCmdPort");
                    if (string != null) {
                        LogManager.this.sysPropNoLogCmdServer = Boolean.valueOf(string);
                    }
                    if (string2 != null) {
                        LogManager.this.port = string2;
                    }
                    return null;
                }
            });
        }
    }

    protected void startCommandServer() throws AccessControlException {
        this.getSystemProperties();
        if (!this.sysPropNoLogCmdServer && !this.factoryNoLogCmdServer) {
            SecurityManager securityManager;
            int n = 9992;
            if (this.port != null) {
                try {
                    n = Integer.parseInt(this.port);
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_CMD_SERVER_PORT", this.port));
                }
            }
            if ((securityManager = System.getSecurityManager()) == null) {
                this.commandServer = new LogCmdServer(n);
            } else {
                final int n2 = n;
                LogCmdServer logCmdServer = (LogCmdServer)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new LogCmdServer(n2);
                    }
                });
                this.commandServer = logCmdServer;
            }
            this.commandServer.start();
        }
    }

    protected void stopCommandServer() {
        if (this.commandServer != null) {
            this.commandServer.stop();
        }
    }

    public LogEventProducer getLogger(String string) throws IllegalArgumentException, IllegalStateException {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        LogEventProducer logEventProducer = null;
        LogComponent logComponent = this.getObject(string);
        if (logComponent instanceof LogEventProducer) {
            logEventProducer = (LogEventProducer)logComponent;
        }
        return logEventProducer;
    }

    public void returnLogger(LogEventProducer logEventProducer) {
        this.returnObject(logEventProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogComponent getObject(String string) throws IllegalArgumentException, IllegalStateException {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        DataStore dataStore = this.getDataStore();
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException(LogUtil.getLogMsg("ERR_OBJECT_NAME"));
        }
        if (dataStore == null) {
            throw new IllegalStateException(LogUtil.getLogMsg("ERR_NO_DATA_STORE"));
        }
        LogComponent logComponent = null;
        Object object = objLock;
        synchronized (object) {
            DataStoreConfig dataStoreConfig;
            LogManagerConfig logManagerConfig = (LogManagerConfig)this.fullConfig.get(string);
            if (logManagerConfig == null) {
                logManagerConfig = new LogManagerConfig();
            }
            if ((logComponent = logManagerConfig.getObject()) == null && (dataStoreConfig = dataStore.getConfig(string)) != null) {
                final String string2 = dataStoreConfig.getProperty("className");
                if (string2 != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager == null) {
                        logComponent = (LogComponent)LogUtil.createObject(string2);
                        if (logComponent != null) {
                            logComponent.setConfig(dataStoreConfig);
                        }
                    } else {
                        try {
                            logComponent = (LogComponent)AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    LogComponent logComponent = (LogComponent)LogUtil.createObject(string2);
                                    if (logComponent != null) {
                                        logComponent.setConfig(dataStoreConfig);
                                    }
                                    return logComponent;
                                }
                            });
                        }
                        catch (AccessControlException accessControlException) {
                            String string3 = LogUtil.getLogMsg("ERR_INVALID_PERMISSION", string, accessControlException.getMessage());
                            LogUtil.errorMsg(string3);
                            logComponent = null;
                        }
                    }
                    if (logComponent != null) {
                        if (logComponent instanceof LogEventProducer) {
                            this.addListeners((LogEventProducer)logComponent, dataStoreConfig);
                        }
                        if (logComponent instanceof Handler) {
                            this.addFormatter((Handler)logComponent, dataStoreConfig);
                            this.addErrorProtocol((Handler)logComponent, dataStoreConfig);
                        }
                        logManagerConfig.setObject(logComponent);
                        this.fullConfig.put(string, logManagerConfig);
                    }
                } else {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_MISSING_CLASS_NAME", string));
                }
            }
            if (logComponent != null) {
                logManagerConfig.incrementInUseCount();
            }
        }
        return logComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(LogComponent logComponent) {
        if (logComponent != null) {
            Object object = objLock;
            synchronized (object) {
                String string = logComponent.getName();
                LogManagerConfig logManagerConfig = (LogManagerConfig)this.fullConfig.get(string);
                if (logManagerConfig != null && logManagerConfig.decrementInUseCount() == 0) {
                    if (logComponent instanceof LogEventProducer) {
                        this.removeListeners((LogEventProducer)logComponent);
                    }
                    if (logComponent instanceof Handler) {
                        ((Handler)logComponent).close();
                        this.removeFormatter((Handler)logComponent);
                        this.removeErrorProtocol((Handler)logComponent);
                    }
                    logComponent = null;
                    logManagerConfig.setObject(null);
                    this.fullConfig.remove(string);
                }
            }
        }
    }

    protected void addListeners(LogEventProducer logEventProducer, Properties properties) {
        if (logEventProducer != null) {
            LogEventListener logEventListener;
            String string = properties.getProperty("listenerNames");
            Vector<LogEventListener> vector = new Vector<LogEventListener>();
            LogEventListener[] logEventListenerArray = logEventProducer.getLogEventListeners();
            if (logEventListenerArray != null) {
                int n = 0;
                while (n < logEventListenerArray.length) {
                    vector.addElement(logEventListenerArray[n]);
                    ++n;
                }
            }
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    logEventListener = (LogEventListener)this.getObject(string2);
                    if (logEventListener == null) continue;
                    if (vector.contains(logEventListener)) {
                        this.returnObject(logEventListener);
                        vector.removeElement(logEventListener);
                        continue;
                    }
                    logEventProducer.addLogEventListener(logEventListener);
                }
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                logEventListener = (LogEventListener)enumeration.nextElement();
                logEventProducer.removeLogEventListener(logEventListener);
                this.returnObject(logEventListener);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".addLogEventListeners");
            LogUtil.errorMsg(string);
        }
    }

    protected void removeListeners(LogEventProducer logEventProducer) {
        LogEventListener[] logEventListenerArray = logEventProducer.getLogEventListeners();
        int n = 0;
        while (n < logEventListenerArray.length) {
            this.returnObject(logEventListenerArray[n]);
            ++n;
        }
    }

    protected void addFormatter(Handler handler, Properties properties) {
        if (handler != null) {
            LogEventFormatter logEventFormatter;
            String string = properties.getProperty("formatterName");
            if (string != null && (logEventFormatter = (LogEventFormatter)this.getObject(string)) != null) {
                handler.setFormatter(logEventFormatter);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".addFormatter");
            LogUtil.errorMsg(string);
        }
    }

    protected void removeFormatter(Handler handler) {
        this.returnObject(handler.getFormatter());
    }

    protected void addErrorProtocol(Handler handler, Properties properties) {
        if (handler != null) {
            ErrorProtocol errorProtocol;
            String string = properties.getProperty("errorProtocolName");
            if (string != null && (errorProtocol = (ErrorProtocol)this.getObject(string)) != null) {
                handler.setErrorProtocol(errorProtocol);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".addErrorProtocol");
            LogUtil.errorMsg(string);
        }
    }

    protected void removeErrorProtocol(Handler handler) {
        this.returnObject(handler.getErrorProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChange(ConfigChangeEvent configChangeEvent) {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        final Properties properties = configChangeEvent.getConfig();
        String string = properties.getProperty("name");
        if (string != null) {
            Object object = objLock;
            synchronized (object) {
                LogComponent logComponent;
                LogManagerConfig logManagerConfig = (LogManagerConfig)this.fullConfig.get(string);
                if (logManagerConfig != null && (logComponent = logManagerConfig.getObject()) != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager == null) {
                        logComponent.setConfig(properties);
                    } else {
                        try {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    logComponent.setConfig(properties);
                                    return null;
                                }
                            });
                        }
                        catch (AccessControlException accessControlException) {
                            String string2 = LogUtil.getLogMsg("ERR_INVALID_PERMISSION", string, accessControlException.getMessage());
                            LogUtil.errorMsg(string2);
                            throw accessControlException;
                        }
                    }
                    if (logComponent instanceof LogEventProducer) {
                        this.addListeners((LogEventProducer)logComponent, properties);
                    }
                    if (logComponent instanceof Handler) {
                        this.addFormatter((Handler)logComponent, properties);
                        this.addErrorProtocol((Handler)logComponent, properties);
                    }
                }
            }
        }
        String string3 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".configChange");
        LogUtil.errorMsg(string3);
    }

    protected void finalize() throws Throwable {
        Object object;
        Vector<LogComponent> vector = new Vector<LogComponent>();
        Enumeration<Object> enumeration = this.fullConfig.elements();
        while (enumeration.hasMoreElements()) {
            object = (LogManagerConfig)enumeration.nextElement();
            vector.add(((LogManagerConfig)object).getObject());
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (LogComponent)enumeration.nextElement();
            if (object == null) continue;
            this.returnObject((LogComponent)object);
        }
        super.finalize();
    }
}

