/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.monitor.CIMOMListener;
import org.eclipse.aperi.monitor.CIMOMRegistrator;
import org.eclipse.aperi.monitor.DataSource;
import org.eclipse.aperi.monitor.DataSourceEventProcessor;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.client.CIMEnumeration;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;
import org.sblim.wbem.client.indications.CIMEventDispatcher;
import org.sblim.wbem.client.indications.CIMIndicationHandler;
import org.sblim.wbem.client.indications.CIMIndicationListenertList;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.http.HttpConnectionHandler;
import org.sblim.wbem.http.HttpContentHandler;
import org.sblim.wbem.http.HttpServerConnection;

public class CIMOMEventProcessor
implements DataSourceEventProcessor {
    private static String CIM_INDICATION_HDL;
    private static String CIM_SYSTEM;
    private static String CIM_INDICATIONHDL_NAME;
    private static String CIM_INDI_SUBSCRIPTION;
    private static String CIM_INDI_FILTER;
    private static String CIM_DYNAMIC;
    private static String CIM_COMPUTER_SYSTEM;
    private static String CIM_SYSTEM_CLASS;
    private static CIMIndicationListenertList indicationClient;
    private static String className;
    private static Map indicationMap;
    private static CIMOMListener newListener;
    private static HttpServerConnection indicationServer;
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    private static String CONF_LOCAL_ADDRESS;
    private static String CONF_EXCLUDED_CIMOM;
    private static String DEV_SERVER_GROUP;
    private static IConfigService cConfigService;

    static {
        Class<?> clazz;
        CIM_INDICATION_HDL = "CIM_ListenerDestinationCIMXML";
        CIM_SYSTEM = "TPC Listener Destination";
        CIM_INDICATIONHDL_NAME = "CIM Indication Handler";
        CIM_INDI_SUBSCRIPTION = "CIM_IndicationSubscription";
        CIM_INDI_FILTER = "CIM_IndicationFilter";
        CIM_DYNAMIC = "TPC Dynamic";
        CIM_COMPUTER_SYSTEM = "CIM_ComputerSystem";
        CIM_SYSTEM_CLASS = "CIM_System";
        indicationClient = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.CIMOMEventProcessor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        indicationMap = Collections.synchronizedMap(new HashMap());
        newListener = null;
        indicationServer = null;
        msgLogger = null;
        traceLogger = null;
        CONF_LOCAL_ADDRESS = "System.LocalIPAddress";
        CONF_EXCLUDED_CIMOM = "Indication.ExcludedCIMOMs";
        DEV_SERVER_GROUP = "DeviceServer";
        cConfigService = null;
        cConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
    }

    public CIMOMEventProcessor(EventCorrelatorFactory eventCorrelatorFactory) throws IOException {
        if (indicationClient == null) {
            indicationClient = new CIMIndicationListenertList();
        }
        if (newListener == null) {
            newListener = new CIMOMListener(eventCorrelatorFactory);
        }
        if (indicationServer == null) {
            CIMEventDispatcher cIMEventDispatcher = new CIMEventDispatcher(indicationClient);
            CIMIndicationHandler cIMIndicationHandler = new CIMIndicationHandler(cIMEventDispatcher);
            indicationServer = new HttpServerConnection(new HttpConnectionHandler((HttpContentHandler)cIMIndicationHandler), 0);
            indicationServer.setName("CIMListener - Http Server");
            indicationServer.start();
            indicationClient.addListener((CIMListener)newListener);
        }
        if (msgLogger == null) {
            msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SanEventCorrelatorFactory");
            msgLogger.setMessageFile(LogConstants.MSG_FILE);
        }
        if (traceLogger == null) {
            traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SanEventCorrelatorFactory");
        }
    }

    private static boolean isContainedInExclusionList(ArrayList arrayList, String string) {
        String string2 = "isContainedInExclusionList";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)arrayList, (Object)string);
        }
        if (string == null) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "service url was null");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return false;
        }
        if (arrayList == null) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "exclusion list was null");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return false;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (string.indexOf((String)iterator.next()) < 0) continue;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "service url " + string + " was found in exclusion list");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "service url " + string + " was not found in exclusion list");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return false;
    }

    public boolean addDataSource(DataSource dataSource) throws Exception {
        boolean bl;
        String string;
        block12: {
            RegisteredCimom registeredCimom;
            block11: {
                block10: {
                    string = "addDataSource";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
                    }
                    if (dataSource.getType() != 1) {
                        throw new Exception("Invalid data source type " + dataSource.getType());
                    }
                    bl = false;
                    registeredCimom = (RegisteredCimom)dataSource.getIdentifier();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "CIMOM = " + registeredCimom.toString());
                    }
                    if (indicationMap.get(registeredCimom.getServiceUrl()) == null) break block10;
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                    }
                    return true;
                }
                ArrayList arrayList = this.getExcludedCimomsList();
                if (!CIMOMEventProcessor.isContainedInExclusionList(arrayList, registeredCimom.getServiceUrl())) break block11;
                String string2 = "The cimom with serviceURL " + registeredCimom.getServiceUrl() + " was excluded from indication subscription.";
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, string2);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                }
                return true;
            }
            try {
                Object[] objectArray = new Object[]{"register", registeredCimom};
                JobInfo jobInfo = new JobInfo();
                jobInfo.setDiscoverRequest(new Integer(ServiceUtils.getJobIdentifier((boolean)true, (int)2)).toString());
                jobInfo.setResourceQueue(CIMOMRegistrator.queueName);
                jobInfo.setRequestId(objectArray.toString());
                jobInfo.setRequest((Response)new ObjectResponse((Object)objectArray, jobInfo));
                JobEngine.getInstance().addJob(jobInfo);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!traceLogger.isLogging()) break block12;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    private ArrayList getExcludedCimomsList() {
        String string;
        ArrayList<String> arrayList;
        String string2;
        block9: {
            string2 = "getExcludedCimomsList";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            }
            arrayList = new ArrayList<String>();
            string = null;
            try {
                string = cConfigService.getProperty(CONF_EXCLUDED_CIMOM, DEV_SERVER_GROUP);
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block9;
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "excluded cimoms list might not be defined");
            }
        }
        if (string != null && string.trim().length() > 0) {
            String[] stringArray = string.split(";");
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "found " + stringArray[n] + " in excluded cimoms list");
                }
                ++n;
            }
        } else if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string2, "excluded cimoms list is empty");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return arrayList;
    }

    public boolean removeDataSource(DataSource dataSource) throws Exception {
        ArrayList arrayList;
        String string = "removeDataSource";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (dataSource.getType() != 1) {
            throw new Exception("Invalid data source type " + dataSource.getType());
        }
        RegisteredCimom registeredCimom = (RegisteredCimom)dataSource.getIdentifier();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "CIMOM = " + registeredCimom.toString());
        }
        if (CIMOMEventProcessor.isContainedInExclusionList(arrayList = this.getExcludedCimomsList(), registeredCimom.getServiceUrl())) {
            String string2 = "The cimom with serviceURL " + registeredCimom.getServiceUrl() + " was excluded from indication unsubscription.";
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, string2);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return true;
        }
        Object[] objectArray = new Object[]{"deregister", registeredCimom};
        JobInfo jobInfo = new JobInfo();
        jobInfo.setDiscoverRequest(new Integer(ServiceUtils.getJobIdentifier((boolean)true, (int)2)).toString());
        jobInfo.setResourceQueue(CIMOMRegistrator.queueName);
        jobInfo.setRequestId(objectArray.toString());
        jobInfo.setRequest((Response)new ObjectResponse((Object)objectArray, jobInfo));
        JobEngine.getInstance().addJob(jobInfo);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean subscribe(CIMClientWrapper cIMClientWrapper, CIMInstance cIMInstance, String string) {
        Object object;
        CIMObjectPath cIMObjectPath;
        Vector<Object> vector;
        boolean bl;
        String string2;
        block33: {
            string2 = "subscribe";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            }
            bl = false;
            if (cIMInstance == null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                }
                return bl;
            }
            vector = new Vector<Object>();
            try {
                if (string.toLowerCase().indexOf("ibm") > 0) {
                    cIMObjectPath = new CIMObjectPath("IBMTS_IndicationFilter", string);
                    object = (CIMEnumeration)cIMClientWrapper.enumerateInstanceNames(cIMObjectPath);
                    if (object != null && object.hasMoreElements()) {
                        while (object.hasMoreElements()) {
                            vector.add(object.nextElement());
                        }
                    }
                    object.close();
                }
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block33;
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, string2, (Throwable)exception);
            }
        }
        cIMObjectPath = new Vector();
        if (vector != null && vector.size() == 0) {
            try {
                object = new Vector();
                ((Vector)object).add("CIM_ProcessIndication");
                ((Vector)object).add("CIM_InstCreation");
                ((Vector)object).add("CIM_InstModification");
                ((Vector)object).add("CIM_InstDeletion");
                CIMClass cIMClass = this.getClassWrapper(cIMClientWrapper, CIM_INDI_FILTER, string);
                int n = 0;
                while (n < ((Vector)object).size()) {
                    CIMInstance cIMInstance2 = this.createIndicationFilterInstance(cIMClientWrapper, string, (String)((Vector)object).elementAt(n), cIMClass);
                    cIMObjectPath.add(cIMInstance2);
                    ++n;
                }
            }
            catch (Exception exception) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, string2, (Throwable)exception);
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                }
                return bl;
            }
        }
        try {
            object = this.createInstanceWrapper(cIMClientWrapper, cIMInstance.getObjectPath(), cIMInstance);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)string2, "handler = " + cIMInstance);
            }
            if (vector != null && vector.size() == 0) {
                int n = 0;
                while (n < cIMObjectPath.size()) {
                    CIMObjectPath cIMObjectPath2 = this.createInstanceWrapper(cIMClientWrapper, ((CIMInstance)cIMObjectPath.elementAt(n)).getObjectPath(), (CIMInstance)cIMObjectPath.elementAt(n));
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_INFO, (Object)string2, "filter = " + cIMObjectPath.elementAt(n));
                    }
                    vector.add(cIMObjectPath2);
                    ++n;
                }
            }
            Vector<CIMInstance> vector2 = new Vector<CIMInstance>();
            try {
                CIMClass cIMClass = this.getClassWrapper(cIMClientWrapper, CIM_INDI_SUBSCRIPTION, string);
                int n = 0;
                while (n < vector.size()) {
                    CIMInstance cIMInstance3 = this.createIndicationSubscriptionInstance(cIMClientWrapper, string, (CIMObjectPath)object, (CIMObjectPath)vector.elementAt(n), cIMClass);
                    vector2.add(cIMInstance3);
                    ++n;
                }
            }
            catch (Exception exception) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, string2, (Throwable)exception);
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                }
                return bl;
            }
            int n = 0;
            while (true) {
                if (n >= vector2.size()) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                    }
                    return bl;
                }
                try {
                    this.createInstanceWrapper(cIMClientWrapper, ((CIMInstance)vector2.elementAt(n)).getObjectPath(), (CIMInstance)vector2.elementAt(n));
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_INFO, (Object)string2, "subscription = " + vector2.elementAt(n));
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    if (exception.getMessage().toLowerCase().indexOf("cim_err_not_supported") != -1) {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.entry(IRecordType.TYPE_INFO, (Object)string2, "subscription not supported = " + vector2.elementAt(n));
                        }
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ERROR, (Object)string2, "subscription failed = " + vector2.elementAt(n));
                    }
                    return false;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, string2, (Throwable)exception);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return false;
        }
    }

    private boolean unsubscribe(CIMClientWrapper cIMClientWrapper, String string) {
        String string2 = "unsubscribe";
        try {
            CIMClass cIMClass = this.getClassWrapper(cIMClientWrapper, CIM_INDICATION_HDL, string);
            CIMObjectPath cIMObjectPath = this.createIndicationHandlerInstance(cIMClientWrapper, string, 0, cIMClass).getObjectPath();
            return this.unsubscribe(cIMClientWrapper, string, cIMObjectPath);
        }
        catch (Exception exception) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, string2, (Throwable)exception);
            }
            return false;
        }
    }

    private boolean unsubscribe(CIMClientWrapper cIMClientWrapper, String string, CIMObjectPath cIMObjectPath) {
        return this.unsubscribe(cIMClientWrapper, string, cIMObjectPath, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean unsubscribe(CIMClientWrapper cIMClientWrapper, String string, CIMObjectPath cIMObjectPath, boolean bl) {
        String string2;
        block30: {
            string2 = "unsubscribe";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            }
            try {
                Vector<Object> vector;
                Vector<Object> vector2;
                block27: {
                    CIMObjectPath cIMObjectPath2;
                    CIMInstance cIMInstance;
                    String string3 = new String();
                    if (bl) {
                        cIMObjectPath.removeKey("SystemName");
                        string3 = cIMClientWrapper.getNameSpace().getHost();
                        try {
                            string3 = InetAddress.getByName(string3).getCanonicalHostName();
                        }
                        catch (Exception exception) {
                            return true;
                        }
                        int n = string3.indexOf(".");
                        if (n == -1) {
                            return true;
                        }
                        string3 = string3.substring(0, n);
                        cIMObjectPath.addKey(new CIMProperty("SystemName", new CIMValue((Object)string3, CIMDataType.getPredefinedType((int)8))));
                    }
                    Vector<String> vector3 = new Vector<String>();
                    vector3.add("CIM_InstCreation");
                    vector3.add("CIM_InstModification");
                    vector3.add("CIM_InstDeletion");
                    vector3.add("CIM_ProcessIndication");
                    CIMClass cIMClass = this.getClassWrapper(cIMClientWrapper, CIM_INDI_FILTER, string);
                    vector2 = new Vector<Object>();
                    int n = 0;
                    while (n < vector3.size()) {
                        cIMInstance = this.createIndicationFilterInstance(cIMClientWrapper, string, (String)vector3.elementAt(n), cIMClass);
                        cIMObjectPath2 = cIMInstance.getObjectPath();
                        if (bl) {
                            cIMObjectPath2.removeKey("SystemName");
                            cIMObjectPath2.addKey(new CIMProperty("SystemName", new CIMValue((Object)string3, CIMDataType.getPredefinedType((int)8))));
                        }
                        vector2.add(cIMObjectPath2);
                        ++n;
                    }
                    vector = new Vector<Object>();
                    try {
                        cIMInstance = (CIMEnumeration)cIMClientWrapper.associatorNames(cIMObjectPath, CIM_INDI_SUBSCRIPTION, CIM_INDI_FILTER, null, null);
                        while (cIMInstance != null && cIMInstance.hasMoreElements()) {
                            vector2.add(cIMInstance.nextElement());
                        }
                        cIMInstance.close();
                        cIMObjectPath2 = (CIMEnumeration)cIMClientWrapper.referenceNames(cIMObjectPath);
                        while (cIMObjectPath2 != null && cIMObjectPath2.hasMoreElements()) {
                            vector.add(cIMObjectPath2.nextElement());
                        }
                        cIMObjectPath2.close();
                    }
                    catch (Exception exception) {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.message(IRecordType.TYPE_WARNING, (Object)className, string2, "Get no Subscriptions for this handler (" + exception.getMessage() + ")");
                        }
                        if (!(exception.getCause() instanceof SocketTimeoutException)) break block27;
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                        }
                        return false;
                    }
                }
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        block28: {
                            try {
                                this.deleteInstanceWrapper(cIMClientWrapper, (CIMObjectPath)vector.elementAt(n));
                            }
                            catch (Exception exception) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block28;
                                traceLogger.message(IRecordType.TYPE_INFO, (Object)className, string2, "Subscription not instanciated");
                            }
                        }
                        ++n;
                    }
                }
                int n = 0;
                while (n < vector2.size()) {
                    block29: {
                        try {
                            this.deleteInstanceWrapper(cIMClientWrapper, (CIMObjectPath)vector2.elementAt(n));
                        }
                        catch (Exception exception) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block29;
                            traceLogger.message(IRecordType.TYPE_INFO, (Object)className, string2, "Filter not instanciated");
                        }
                    }
                    ++n;
                }
                try {
                    this.deleteInstanceWrapper(cIMClientWrapper, cIMObjectPath);
                }
                catch (Exception exception) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.message(IRecordType.TYPE_INFO, (Object)className, string2, "Handler not instanciated");
                    }
                }
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block30;
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, string2, (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        if (!bl) {
            return this.unsubscribe(cIMClientWrapper, string, cIMObjectPath, true);
        }
        return true;
    }

    protected boolean registerIndicationListener(RegisteredCimom registeredCimom) throws UnknownHostException, CIMException {
        boolean bl;
        String string = "registerIndicationListener";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        String string2 = registeredCimom.getInteropSchemaNamespace();
        registeredCimom.getServiceUrl();
        CIMClientWrapper cIMClientWrapper = this.createCimClient(registeredCimom);
        if (cIMClientWrapper == null) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_INFO, (Object)string, "CIM Client was not created");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return false;
        }
        this.setupVectors(cIMClientWrapper);
        CIMInstance cIMInstance = null;
        CIMClass cIMClass = null;
        try {
            cIMClass = this.getClassWrapper(cIMClientWrapper, CIM_INDICATION_HDL, string2);
        }
        catch (Exception exception) {
            traceLogger.exit(IRecordType.TYPE_INFO, (Object)string, "CIM Class was not created");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            return false;
        }
        cIMInstance = this.isOldIBMCimom(cIMClientWrapper, string2) ? this.createIndicationHandlerInstance(cIMClientWrapper, string2, 0, cIMClass) : this.createIndicationHandlerInstance(cIMClientWrapper, string2, registeredCimom.getRegCimomId(), cIMClass);
        if (cIMInstance == null) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "Invalid destination instance");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return false;
        }
        if (this.unsubscribe(cIMClientWrapper, string2)) {
            if (!this.subscribe(cIMClientWrapper, cIMInstance, string2)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "Subscribe failed");
                }
                this.unsubscribe(cIMClientWrapper, string2);
                bl = false;
            } else {
                indicationMap.put(registeredCimom.getServiceUrl(), cIMClientWrapper);
                bl = true;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            indicationMap.remove(registeredCimom.getServiceUrl());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    private CIMClass getClassWrapper(CIMClientWrapper cIMClientWrapper, String string, String string2) throws Exception {
        return this.getClassWrapper(cIMClientWrapper, string, string2, 0);
    }

    private CIMClass getClassWrapper(CIMClientWrapper cIMClientWrapper, String string, String string2, int n) throws Exception {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string, string2);
            CIMClass cIMClass = cIMClientWrapper.getClass(cIMObjectPath, false, null);
            if (cIMClass != null) {
                return cIMClass;
            }
            if (n < 4) {
                return this.getClassWrapper(cIMClientWrapper, string, string2, ++n);
            }
            throw new Exception("Got no CIMClass. Not able to create the instance!");
        }
        catch (CIMException cIMException) {
            if (cIMException.getMessage().toLowerCase().indexOf("cim_err_failed") != -1 && n < 4) {
                return this.getClassWrapper(cIMClientWrapper, string, string2, ++n);
            }
            throw cIMException;
        }
    }

    private CIMObjectPath createInstanceWrapper(CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
        return this.createInstanceWrapper(cIMClientWrapper, cIMObjectPath, cIMInstance, 0);
    }

    private CIMObjectPath createInstanceWrapper(CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, int n) {
        try {
            return cIMClientWrapper.createInstance(cIMObjectPath, cIMInstance, null);
        }
        catch (CIMException cIMException) {
            if (cIMException.getMessage().toLowerCase().indexOf("cim_err_failed") != -1 && n < 4) {
                return this.createInstanceWrapper(cIMClientWrapper, cIMObjectPath, cIMInstance, ++n);
            }
            if (cIMException.getMessage().toLowerCase().indexOf("cim_err_already_exists") != -1 && n > 0) {
                return cIMInstance.getObjectPath();
            }
            throw cIMException;
        }
        catch (DiskManagerTimeoutException diskManagerTimeoutException) {
            throw new CIMException("IBM_ERR_TIMED_OUT");
        }
    }

    private void deleteInstanceWrapper(CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath) {
        this.deleteInstanceWrapper(cIMClientWrapper, cIMObjectPath, 0);
    }

    private void deleteInstanceWrapper(CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath, int n) {
        try {
            cIMClientWrapper.deleteInstance(cIMObjectPath, null);
        }
        catch (CIMException cIMException) {
            if (cIMException.getMessage().toLowerCase().indexOf("cim_err_failed") != -1 && n < 4) {
                this.deleteInstanceWrapper(cIMClientWrapper, cIMObjectPath, ++n);
            }
            throw cIMException;
        }
        catch (DiskManagerTimeoutException diskManagerTimeoutException) {
            throw new CIMException("IBM_ERR_TIMED_OUT");
        }
    }

    private boolean isOldIBMCimom(CIMClientWrapper cIMClientWrapper, String string) {
        block14: {
            if (string.toLowerCase().indexOf("ibm") > 0) {
                String string2;
                block17: {
                    block16: {
                        block15: {
                            String string3;
                            CIMInstance cIMInstance;
                            block12: {
                                String string4;
                                block13: {
                                    try {
                                        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMTS_ObjectManager", string);
                                        CIMEnumeration cIMEnumeration = (CIMEnumeration)cIMClientWrapper.enumerateInstances(cIMObjectPath);
                                        cIMInstance = null;
                                        if (cIMEnumeration != null && cIMEnumeration.hasMoreElements()) {
                                            cIMInstance = (CIMInstance)cIMEnumeration.nextElement();
                                        }
                                        cIMEnumeration.close();
                                        string3 = (String)cIMInstance.getProperty("ElementName").getValue().getValue();
                                        if (string3.indexOf("ESS") == -1) break block12;
                                        string4 = (String)cIMInstance.getProperty("Version").getValue().getValue();
                                        if (!string4.startsWith("1.2.")) break block13;
                                        return true;
                                    }
                                    catch (Exception exception) {
                                        return false;
                                    }
                                }
                                if (string4.startsWith("5.1.0.")) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
                                    String string5 = stringTokenizer.nextToken();
                                    string5 = stringTokenizer.nextToken();
                                    string5 = stringTokenizer.nextToken();
                                    string5 = stringTokenizer.nextToken();
                                    if (Integer.parseInt(string5) < 18) {
                                        return true;
                                    }
                                }
                                return false;
                            }
                            if (string3.indexOf("SVC") == -1) break block14;
                            string2 = (String)cIMInstance.getProperty("Version").getValue().getValue();
                            if (!string2.startsWith("1.2.")) break block15;
                            return true;
                        }
                        if (!string2.startsWith("2.1.0.2")) break block16;
                        return true;
                    }
                    if (!string2.startsWith("2.1.0.1")) break block17;
                    return true;
                }
                return string2.startsWith("2.1.0.0");
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void setupVectors(CIMClientWrapper var1_1) throws CIMException {
        var2_2 = "setupVectors";
        if (CIMOMEventProcessor.traceLogger != null && CIMOMEventProcessor.traceLogger.isLogging()) {
            CIMOMEventProcessor.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)CIMOMEventProcessor.className, var2_2);
        }
        var3_3 = new String[]{"CIM_ProcessIndication"};
        var4_4 = 0;
        while (var4_4 < var3_3.length) {
            var5_5 = null;
            try {
                var5_5 = (CIMEnumeration)var1_1.enumerateClasses(new CIMObjectPath(var3_3[var4_4]), true, true, false, false);
                ** GOTO lbl22
            }
            catch (Exception v0) {
                try {
                    var5_5 = (CIMEnumeration)var1_1.enumerateClasses(new CIMObjectPath(var3_3[var4_4]), null);
                    if (true) ** GOTO lbl22
                }
                catch (DiskManagerTimeoutException v1) {
                    throw new CIMException("IBM_ERR_TIMED_OUT");
                }
            }
            do {
                var6_6 = (CIMClass)var5_5.nextElement();
                if (CIMOMEventProcessor.traceLogger != null && CIMOMEventProcessor.traceLogger.isLogging()) {
                    CIMOMEventProcessor.traceLogger.entry(IRecordType.TYPE_INFO, (Object)var2_2, "Adding " + var6_6.getName() + " to " + var3_3[var4_4]);
                }
                CIMOMListener.addToProcessIndicationVector(var6_6.getName());
lbl22:
                // 3 sources

            } while (var5_5 != null && var5_5.hasMoreElements());
            try {
                if (var5_5 != null) {
                    var5_5.close();
                }
            }
            catch (Exception v2) {}
            ++var4_4;
        }
        if (CIMOMEventProcessor.traceLogger != null && CIMOMEventProcessor.traceLogger.isLogging()) {
            CIMOMEventProcessor.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)CIMOMEventProcessor.className, var2_2);
        }
    }

    protected boolean deregisterIndicationListener(RegisteredCimom registeredCimom) {
        CIMClientWrapper cIMClientWrapper;
        String string = "deregisterIndicationListener";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if ((cIMClientWrapper = (CIMClientWrapper)indicationMap.remove(registeredCimom.getServiceUrl())) == null) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)string, "Invalid CIMOM reference");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return false;
        }
        try {
            cIMClientWrapper.close();
            cIMClientWrapper = this.createCimClient(registeredCimom);
            this.unsubscribe(cIMClientWrapper, registeredCimom.getInteropSchemaNamespace());
        }
        catch (Exception exception) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, string, (Throwable)exception);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return false;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    private CIMInstance createIndicationHandlerInstance(CIMClientWrapper cIMClientWrapper, String string, int n, CIMClass cIMClass) throws UnknownHostException, CIMException {
        String string2 = "createIndicationHandlerInstance";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        String string3 = CIMOMEventProcessor.getValidLocalIP();
        int n2 = indicationServer.getPort();
        String string4 = cIMClientWrapper.getNameSpace().getHost();
        try {
            string4 = InetAddress.getByName(string4).getCanonicalHostName();
        }
        catch (Exception exception) {}
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)CIM_INDICATION_HDL, CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)CIM_COMPUTER_SYSTEM, CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("Name", new CIMValue((Object)(String.valueOf(CIM_SYSTEM) + " for " + string3), CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)string4, CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("PersistenceType", new CIMValue((Object)new UnsignedInt16(3), CIMDataType.getPredefinedType((int)2)));
        if (n == 0) {
            cIMInstance.setProperty("Destination", new CIMValue((Object)("http://" + string3 + ":" + n2), CIMDataType.getPredefinedType((int)8)));
        } else {
            cIMInstance.setProperty("Destination", new CIMValue((Object)("http://" + string3 + ":" + n2 + "/" + n), CIMDataType.getPredefinedType((int)8)));
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return cIMInstance;
    }

    private CIMInstance createIndicationFilterInstance(CIMClientWrapper cIMClientWrapper, String string, String string2, CIMClass cIMClass) throws UnknownHostException, CIMException {
        String string3 = "createIndicationFilterInstance";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        String string4 = CIMOMEventProcessor.getValidLocalIP();
        String string5 = cIMClientWrapper.getNameSpace().getHost();
        try {
            string5 = InetAddress.getByName(string5).getCanonicalHostName();
        }
        catch (Exception exception) {}
        CIMInstance cIMInstance = cIMClass.newInstance();
        String string6 = "SELECT * FROM " + string2;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)string3, "Filter: " + string6);
        }
        cIMInstance.setProperty("Query", new CIMValue((Object)string6, CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("QueryLanguage", new CIMValue((Object)"WQL", CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)string5, CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("Name", new CIMValue((Object)(String.valueOf(string2) + " for " + string4), CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("Description", new CIMValue((Object)CIM_DYNAMIC, CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)CIM_INDI_FILTER, CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)CIM_COMPUTER_SYSTEM, CIMDataType.getPredefinedType((int)8)));
        cIMInstance.setProperty("SourceNamespace", new CIMValue((Object)string, CIMDataType.getPredefinedType((int)8)));
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return cIMInstance;
    }

    public static String getValidLocalIP() throws UnknownHostException {
        String string;
        String string2 = cConfigService.getProperty(CONF_LOCAL_ADDRESS, DEV_SERVER_GROUP);
        boolean bl = true;
        if (string2 != null && !string2.equalsIgnoreCase("NOT SET")) {
            if (CIMOMEventProcessor.validateIP(string2)) {
                return string2;
            }
            bl = false;
        }
        String string3 = InetAddress.getLocalHost().getHostName();
        InetAddress inetAddress = null;
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string3);
        int n = 0;
        while (n < inetAddressArray.length) {
            InetAddress inetAddress2 = inetAddressArray[n];
            if (!inetAddress2.isMulticastAddress() && !inetAddress2.isLoopbackAddress()) {
                inetAddress = inetAddress2;
                break;
            }
            ++n;
        }
        String string4 = string = inetAddress != null ? inetAddress.getHostAddress() : InetAddress.getLocalHost().getHostAddress();
        if (!bl) {
            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, "getValidLocalIP", "IP Address configured in DB: " + string2 + " is not valid. Using " + string);
        }
        return string;
    }

    private static boolean validateIP(String string) {
        try {
            InetAddress.getByName(string);
        }
        catch (Exception exception) {
            traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, "validateIP", (Throwable)exception);
            return false;
        }
        return true;
    }

    private CIMInstance createIndicationSubscriptionInstance(CIMClientWrapper cIMClientWrapper, String string, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, CIMClass cIMClass) throws UnknownHostException, CIMException {
        String string2 = "createIndicationSubscriptionInstance";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("Filter", new CIMValue((Object)cIMObjectPath2, CIMDataType.getPredefinedType((int)14)));
        cIMInstance.setProperty("Handler", new CIMValue((Object)cIMObjectPath, CIMDataType.getPredefinedType((int)14)));
        cIMInstance.setProperty("OnFatalErrorPolicy", new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2)));
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return cIMInstance;
    }

    private CIMClientWrapper createCimClient(RegisteredCimom registeredCimom) {
        String string = registeredCimom.getUserId();
        String string2 = registeredCimom.getPassword();
        String string3 = registeredCimom.getServiceUrl();
        String string4 = registeredCimom.getInteropSchemaNamespace();
        String string5 = "createCimClient";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string5);
        }
        CIMClientWrapper cIMClientWrapper = null;
        try {
            new CIMNameSpace(string3, string4);
            if (string == null) {
                string = "";
            }
            new UserPrincipal(string);
            string2 = string2 == null ? "" : SRMCrypto.decrypt((String)string2);
            new PasswordCredential(string2.toCharArray());
            CIMObjectPath cIMObjectPath = null;
            CIMEnumeration cIMEnumeration = null;
            String string6 = "CIM_RegisteredProfile";
            cIMClientWrapper = new CIMClientWrapper(string, string2, string3, string4);
            cIMObjectPath = new CIMObjectPath(string6, string4);
            cIMEnumeration = (CIMEnumeration)cIMClientWrapper.enumClass(cIMObjectPath, false, null);
            cIMEnumeration.close();
        }
        catch (Exception exception) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, string5, (Throwable)exception);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
            }
            return null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
        }
        return cIMClientWrapper;
    }

    public void exit() {
        indicationServer.close();
        indicationServer = null;
    }
}

