/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.dataservernotification;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;

public class Notifier {
    private static String dataServer = null;
    private static int dataPort = -1;
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;

    public Notifier() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.entry(IRecordType.TYPE_ENTRY, clazz, "Notifier");
        }
        if (dataServer == null) {
            Notifier.getDataServer();
        }
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.exit(IRecordType.TYPE_EXIT, clazz, "Notifier");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void getDataServer() {
        block29: {
            block26: {
                if (Notifier.traceLogger.isLogging()) {
                    try {
                        v0 = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                    Notifier.traceLogger.entry(IRecordType.TYPE_ENTRY, v0, "getDataServer");
                }
                var0 = null;
                var1_1 = null;
                try {
                    block25: {
                        try {
                            var2_2 = DBConnPoolDataSource.getInstance();
                            var0 = (DBConnection)var2_2.getPooledConnection();
                            var3_4 = new Hashtable<ColumnInfo, String>();
                            var3_4.put(Server.getColumnInfo((String)"SERVER_TYPE"), "0");
                            var1_1 = Server.getCursor((DBConnection)var0, var3_4, null);
                            if (var1_1.next()) {
                                var4_5 = var1_1.getAttributes();
                                Notifier.dataServer = var4_5.getServerName();
                                Notifier.dataPort = var4_5.getPortNumber();
                            }
                        }
                        catch (SQLException var2_3) {
                            try {
                                v2 = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
                            }
                            catch (ClassNotFoundException v3) {
                                throw new NoClassDefFoundError(v3.getMessage());
                            }
                            Notifier.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, v2, "getDataServer", (Throwable)var2_3);
                            if (!Notifier.traceLogger.isLogging()) break block25;
                            try {
                                v4 = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
                            }
                            catch (ClassNotFoundException v5) {
                                throw new NoClassDefFoundError(v5.getMessage());
                            }
                            Notifier.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, v4, "getDataServer", (Throwable)var2_3);
                        }
                    }
                    var5_8 = null;
                    if (var1_1 == null) break block26;
                }
                catch (Throwable var6_6) {
                    var5_7 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (SQLException v6) {}
                    }
                    if (var0 == null) throw var6_6;
                    try {
                        var0.close();
                        throw var6_6;
                    }
                    catch (SQLException var7_9) {
                        if (Notifier.traceLogger.isLogging() == false) throw var6_6;
                        try {
                            v7 = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
                        }
                        catch (ClassNotFoundException v8) {
                            throw new NoClassDefFoundError(v8.getMessage());
                        }
                        Notifier.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, v7, "getDataServer", (Throwable)var7_9);
                    }
                    throw var6_6;
                }
                try {}
                catch (SQLException v9) {}
                var1_1.close();
            }
            if (var0 == null) break block29;
            ** try [egrp 6[TRYBLOCK] [7 : 228->235)] { 
lbl73:
            // 1 sources

            var0.close();
            break block29;
lbl75:
            // 1 sources

            catch (SQLException var7_10) {
                if (!Notifier.traceLogger.isLogging()) break block29;
                try {}
                catch (ClassNotFoundException v10) {
                    throw new NoClassDefFoundError(v10.getMessage());
                }
                Notifier.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier"), "getDataServer", (Throwable)var7_10);
            }
        }
        if (Notifier.traceLogger.isLogging() == false) return;
        try {
            v11 = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
        }
        catch (ClassNotFoundException v12) {
            throw new NoClassDefFoundError(v12.getMessage());
        }
        Notifier.traceLogger.exit(IRecordType.TYPE_EXIT, v11, "getDataServer");
    }

    private static SocketTransceiver getTransceiver() {
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.entry(IRecordType.TYPE_ENTRY, clazz, "getTransceiver");
        }
        SocketTransceiver socketTransceiver = null;
        Socket socket = null;
        if (dataServer != null) {
            block20: {
                try {
                    socket = SocketRegistry.connect((String)dataServer, (int)dataPort);
                    socketTransceiver = new SocketTransceiver(socket, dataServer);
                }
                catch (UnknownHostException unknownHostException) {
                    Class<?> clazz;
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, clazz2, "getTransceiver", (Throwable)unknownHostException);
                    if (!traceLogger.isLogging()) break block20;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, clazz, "getTransceiver", (Throwable)unknownHostException);
                }
            }
            if (socketTransceiver == null && socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        } else if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.text(IRecordType.TYPE_WARNING, clazz, "getTransceiver", "NO DATA SERVER");
        }
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.exit(IRecordType.TYPE_EXIT, clazz, "getTransceiver", (Object)socketTransceiver);
        }
        return socketTransceiver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendRequest(Request request) {
        boolean bl;
        String string;
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.entry(IRecordType.TYPE_ENTRY, clazz, "sendRequest");
        }
        SocketTransceiver socketTransceiver = Notifier.getTransceiver();
        int n = 4;
        if (socketTransceiver != null) {
            try {
                block17: {
                    try {
                        Response response = socketTransceiver.transmitRequest(request, null);
                        if (response == null) {
                            n = 12;
                            string = "Unknown error encountered - no response received";
                            break block17;
                        }
                        n = response.status;
                        string = response.errorMessage;
                    }
                    catch (Exception exception) {
                        n = 12;
                        string = "Unable to connect to the Data server.  Please ensure that the server is up and running.";
                    }
                }
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                socketTransceiver.close();
                throw throwable;
            }
            socketTransceiver.close();
        } else {
            n = 4;
            string = "NO CONNECTION TO DATA SERVER";
        }
        boolean bl2 = bl = n == 0;
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            if (n > 0) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                traceLogger.text(IRecordType.TYPE_WARN, clazz2, "sendRequest", string);
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.exit(IRecordType.TYPE_EXIT, clazz, "sendRequest", bl);
        }
        return bl;
    }

    public boolean sendAlert(Alert alert) {
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.entry(IRecordType.TYPE_ENTRY, clazz, "sendAlert");
        }
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.GenerateAlertHndlr";
        request.requestData = alert;
        boolean bl = this.sendRequest(request);
        if (traceLogger.isLogging()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.monitor.dataservernotification.Notifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            traceLogger.exit(IRecordType.TYPE_EXIT, clazz, "sendAlert", bl);
        }
        return bl;
    }
}

