/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class NodeAlertPopulator
implements IPopulator {
    public static final String deviceType = "node";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.NodeAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public NodeAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getNodeData(string3, hashtable, hashtable2)) {
            String string4 = ((String)hashtable.get("HLDType")).trim();
            String string5 = ((String)hashtable.get("HLDUniqueId")).trim();
            String string6 = "TPC_NEW_DEVICE_EVENT";
            short s = this.determineAlertCondition(string4, string6);
            int n = this.determineResourceId(string3, string5);
            short s2 = this.determineResourceType(string4);
            int n2 = -1;
            n2 = s == 106 ? EventDBAccessor.getAlertIDByCondition(s) : this.getAlertId(s2, n, s, string3);
            if (n2 > 0) {
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n2;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s;
                if (this.isSvcNode(string4)) {
                    alertDefinition.aldProductID = (short)3;
                    alertDefinition.aldType = (short)20;
                }
                int n3 = 1;
                int n4 = EventDBAccessor.getComputerId(n3);
                int n5 = 104;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                hashtable.put("eventType", string6);
                hashtable2.put("eventType", string6);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string8 = this.getPEValue(n6, hashtable);
                    if (string8 == null) {
                        string8 = "";
                    }
                    hashtable3.put(nArray2[n6], string8);
                    ++n6;
                }
                String string9 = "PhysicalEntityEvent";
                int n7 = 0;
                while (n7 < peTecSlotNames.length) {
                    string7 = (String)hashtable2.get(peTecSlotNames[n7]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(peTecSlotNames[n7], string7);
                    ++n7;
                }
                String string10 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string10);
                string7 = "msgid";
                Object[] objectArray = null;
                if (string4.equals(deviceType) || string4.equals("")) {
                    string7 = "ALR4000I";
                    String string11 = (String)hashtable.get("label");
                    if (string11 == null) {
                        string11 = "";
                    }
                    objectArray = new Object[]{string11};
                } else {
                    String string12;
                    String string13;
                    string7 = "ALR4005I";
                    String string14 = (String)hashtable.get("HLDType");
                    if (string14 == null) {
                        string14 = "";
                    }
                    if ((string13 = (String)hashtable.get("HLDLabel")) == null) {
                        string13 = "";
                    }
                    if ((string12 = (String)hashtable.get("label")) == null) {
                        string12 = "";
                    }
                    objectArray = new Object[]{string14, string13, string12};
                }
                fabricAlert = new FabricAlert(n4, n, s2, alertDefinition, nArray, n5, hashtable3, string9, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: node" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: node" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getNodeData(string3, hashtable, hashtable2)) {
            String string4 = ((String)hashtable.get("HLDType")).trim();
            String string5 = ((String)hashtable.get("HLDUniqueId")).trim();
            String string6 = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short s = this.determineAlertCondition(string4, string6);
            int n3 = this.determineResourceId(string3, string5);
            short s2 = this.determineResourceType(string4);
            int n4 = this.getAlertId(s2, n3, s, string3);
            if (n4 > 0) {
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s;
                if (this.isSvcNode(string4)) {
                    alertDefinition.aldProductID = (short)3;
                    alertDefinition.aldType = (short)20;
                }
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 101;
                if (n == 1) {
                    n7 = 112;
                }
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string8 = n == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                hashtable.put("eventType", string8);
                hashtable2.put("eventType", string8);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string9 = this.getPEValue(n8, hashtable);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable3.put(nArray2[n8], string9);
                    ++n8;
                }
                String string10 = "PhysicalEntityEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string7 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string7);
                    ++n9;
                }
                String string11 = n == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(hashtable4, string11);
                string7 = "msgid";
                Object[] objectArray = null;
                if (string4.equals(deviceType) || string4.equals("")) {
                    String string12;
                    string7 = "ALR4001W";
                    if (n == 1) {
                        string7 = "ALR4002I";
                    }
                    if ((string12 = (String)hashtable.get("label")) == null) {
                        string12 = "";
                    }
                    objectArray = new Object[]{string12};
                } else {
                    String string13;
                    String string14;
                    String string15;
                    string7 = "ALR4006W";
                    if (n == 1) {
                        string7 = "ALR4007I";
                    }
                    if ((string15 = (String)hashtable.get("HLDType")) == null) {
                        string15 = "";
                    }
                    if ((string14 = (String)hashtable.get("HLDLabel")) == null) {
                        string14 = "";
                    }
                    if ((string13 = (String)hashtable.get("label")) == null) {
                        string13 = "";
                    }
                    objectArray = new Object[]{string15, string14, string13};
                }
                fabricAlert = new FabricAlert(n6, n3, s2, alertDefinition, nArray, n7, hashtable3, string10, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: node" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: node" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getNodeData(string3, hashtable, hashtable2)) {
            String string4 = ((String)hashtable.get("HLDType")).trim();
            String string5 = ((String)hashtable.get("HLDUniqueId")).trim();
            String string6 = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
            int n3 = this.determineResourceId(string3, string5);
            short s = this.determineResourceType(string4);
            short s2 = -1;
            s2 = s == 78 ? (n2 == 0 ? (short)138 : 137) : (n2 == 0 ? (short)134 : 133);
            int n4 = this.getAlertId(s, n3, s2, string3);
            if (n4 > 0) {
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s2;
                if (this.isSvcNode(string4)) {
                    alertDefinition.aldProductID = (short)3;
                    alertDefinition.aldType = (short)20;
                }
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 116;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                hashtable.put("eventType", string6);
                hashtable2.put("eventType", string6);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string8 = this.getPEValue(n8, hashtable);
                    if (string8 == null) {
                        string8 = "";
                    }
                    hashtable3.put(nArray2[n8], string8);
                    ++n8;
                }
                String string9 = "PEOperationalStatusChangeEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string7 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string7);
                    ++n9;
                }
                String string10 = "MINOR";
                this.addCommonTecAttributes(hashtable4, string10);
                this.addOperationalStatusData(hashtable3, hashtable4, n, n2);
                string7 = null;
                Object[] objectArray = null;
                if (string4.equals(deviceType) || string4.equals("")) {
                    String string11;
                    string7 = "ALR4003W";
                    if (n2 == 0) {
                        string7 = "ALR4004I";
                    }
                    if ((string11 = (String)hashtable.get("label")) == null) {
                        string11 = "";
                    }
                    objectArray = new Object[]{string11};
                } else {
                    String string12;
                    String string13;
                    String string14;
                    string7 = "ALR4008W";
                    if (n2 == 0) {
                        string7 = "ALR4009I";
                    }
                    if ((string14 = (String)hashtable.get("HLDType")) == null) {
                        string14 = "";
                    }
                    if ((string13 = (String)hashtable.get("HLDLabel")) == null) {
                        string13 = "";
                    }
                    if ((string12 = (String)hashtable.get("label")) == null) {
                        string12 = "";
                    }
                    objectArray = new Object[]{string14, string13, string12};
                }
                fabricAlert = new FabricAlert(n6, n3, s, alertDefinition, nArray, n7, hashtable3, string9, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: node" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: node" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    private void addOperationalStatusData(Hashtable hashtable, Hashtable hashtable2, int n, int n2) {
        hashtable.put(MIBConstants.BTAOldStatus, "" + n);
        hashtable.put(MIBConstants.BTANewStatus, "" + n2);
        hashtable2.put("oldStatus", "" + n);
        hashtable2.put("oldStatus", "" + n2);
    }

    private short determineAlertCondition(String string, String string2) {
        int n = -1;
        if (string.equals(deviceType)) {
            if (string2.equals("TPC_NEW_DEVICE_EVENT")) {
                n = 106;
            } else if (string2.equals("TPC_DEVICE_STATE_CHANGE_EVENT")) {
                n = 101;
            } else if (string2.equals("TPC_PROPERTY_CHANGE_EVENT")) {
                n = 102;
            }
        } else if (string.equals("pe")) {
            n = 102;
        } else if (string.equals("host")) {
            n = 174;
        } else if (string.equals("subsystem")) {
            if (string2.equals("TPC_NEW_DEVICE_EVENT")) {
                n = 136;
            } else if (string2.equals("TPC_DEVICE_STATE_CHANGE_EVENT")) {
                n = 135;
            } else if (string2.equals("TPC_PROPERTY_CHANGE_EVENT")) {
                n = 123;
            }
        }
        return (short)n;
    }

    private short determineResourceType(String string) {
        int n = 138;
        if (string.equals("subsystem")) {
            n = 78;
        } else if (string.equals("host")) {
            n = 1;
        } else if (string.equals("pe")) {
            n = 139;
        }
        return (short)n;
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private int determineResourceId(String string, String string2) {
        int n = -1;
        n = string2 == null || string2.equals("") ? Integer.parseInt(string) : Integer.parseInt(string2);
        return n;
    }

    private String getPEValue(int n, Hashtable hashtable) {
        if (peVarNames[n].equals("description")) {
            return peVarNames[n];
        }
        if (peVarNames[n].equals("messageId")) {
            return peVarNames[n];
        }
        return (String)hashtable.get(peVarNames[n]);
    }

    private int getAlertId(short s, int n, short s2, String string) {
        int n2 = -1;
        n2 = EventDBAccessor.getAlertIDByResource(s, n, s2);
        if (n2 <= 0) {
            String string2 = EventDBAccessor.getFabricIdForNode(string);
            if (string2 != null && !string2.equals("")) {
                n2 = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(string2), s2);
            }
            if (n2 <= 0) {
                n2 = s == 138 ? EventDBAccessor.getAlertIDByResource((short)129, -1, s2) : EventDBAccessor.getAlertIDByResource(s, -1, s2);
            }
        }
        return n2;
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    private boolean isSvcNode(String string) {
        String string2 = "isSvcNode";
        boolean bl = false;
        if (string.equals("subsystem")) {
            bl = true;
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "Alert for SVC Node processed.");
            }
        }
        return bl;
    }
}

