/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class PerEntAlertPopulator
implements IPopulator {
    public static final String deviceType = "pe";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.PerEntAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public PerEntAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getPEData(string3, hashtable, hashtable2)) {
            String string4 = (String)hashtable.get("HLDType");
            String string5 = "TPC_NEW_DEVICE_EVENT";
            short s = this.determineAlertCondition(string4, string5);
            int n = Integer.parseInt(string3);
            short s2 = this.determineResourceType(string4);
            int n2 = -1;
            n2 = s == 106 ? EventDBAccessor.getAlertIDByCondition(s) : this.getAlertId(s2, n, s, string3);
            if (n2 > 0) {
                String string6;
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n2;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s;
                int n3 = 1;
                int n4 = EventDBAccessor.getComputerId(n3);
                int n5 = 104;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                hashtable.put("eventType", string5);
                hashtable2.put("eventType", string5);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string8 = this.getPEValue(n6, hashtable);
                    if (string8 == null) {
                        string8 = "";
                    }
                    hashtable3.put(nArray2[n6], string8);
                    ++n6;
                }
                String string9 = "PhysicalEntityEvent";
                int n7 = 0;
                while (n7 < peTecSlotNames.length) {
                    string7 = (String)hashtable2.get(peTecSlotNames[n7]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(peTecSlotNames[n7], string7);
                    ++n7;
                }
                String string10 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string10);
                string7 = "ALR4037I";
                Object[] objectArray = null;
                String string11 = (String)hashtable.get("type");
                if (string11 == null) {
                    string11 = "";
                }
                if ((string6 = (String)hashtable.get("HLDLabel")) == null) {
                    string6 = "";
                }
                objectArray = new Object[]{string11, string6};
                fabricAlert = new FabricAlert(n4, n, s2, alertDefinition, nArray, n5, hashtable3, string9, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: pe" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: pe" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getPEData(string3, hashtable, hashtable2)) {
            String string4 = (String)hashtable.get("HLDType");
            String string5 = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short s = this.determineAlertCondition(string4, string5);
            int n3 = Integer.parseInt(string3);
            short s2 = this.determineResourceType(string4);
            int n4 = this.getAlertId(s2, n3, s, string3);
            if (n4 > 0) {
                String string6;
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s;
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 101;
                if (n == 1) {
                    n7 = 112;
                }
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string8 = n == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                hashtable.put("eventType", string8);
                hashtable2.put("eventType", string8);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string9 = this.getPEValue(n8, hashtable);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable3.put(nArray2[n8], string9);
                    ++n8;
                }
                String string10 = "PhysicalEntityEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string7 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string7);
                    ++n9;
                }
                String string11 = n == 0 ? "CRITICAL" : "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string11);
                string7 = "ALR4038W";
                if (n == 1) {
                    string7 = "ALR4039I";
                }
                Object[] objectArray = null;
                String string12 = (String)hashtable.get("type");
                if (string12 == null) {
                    string12 = "";
                }
                if ((string6 = (String)hashtable.get("HLDLabel")) == null) {
                    string6 = "";
                }
                objectArray = new Object[]{string12, string6};
                fabricAlert = new FabricAlert(n6, n3, s2, alertDefinition, nArray, n7, hashtable3, string10, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: pe" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: pe" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        String string2 = "populatePropertyChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        String string4 = "FIRMWARE_REVISION";
        String string5 = (String)hashtable.get(string4);
        String string6 = (String)hashtable2.get(string4);
        if (string5 == null || string6 == null) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "Error populating PE Properties, " + string4 + " value is null - old Value=" + string5 + ", new Value=" + string6);
            }
            return null;
        }
        if (EventDBAccessor.getPEData(string3, hashtable3, hashtable4)) {
            String string7 = (String)hashtable3.get("HLDType");
            String string8 = "TPC_PROPERTY_CHANGE_EVENT";
            short s = 177;
            int n = Integer.parseInt(string);
            short s2 = this.determineResourceType(string7);
            int n2 = this.getAlertId(s2, n, s, string3);
            if (n2 > 0) {
                String string9;
                String string10;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n2;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldCondition = s;
                int n3 = 1;
                int n4 = EventDBAccessor.getComputerId(n3);
                int n5 = 102;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable5 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable6 = new Hashtable<String, String>();
                hashtable3.put("eventType", string8);
                hashtable4.put("eventType", string8);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string11 = this.getPEValue(n6, hashtable3);
                    if (string11 == null) {
                        string11 = "";
                    }
                    hashtable5.put(nArray2[n6], string11);
                    ++n6;
                }
                String string12 = "PEAttributeModifiedEvent";
                int n7 = 0;
                while (n7 < peTecSlotNames.length) {
                    string10 = (String)hashtable4.get(peTecSlotNames[n7]);
                    if (string10 == null) {
                        string10 = "";
                    }
                    hashtable6.put(peTecSlotNames[n7], string10);
                    ++n7;
                }
                String string13 = "MINOR";
                this.addCommonTecAttributes(hashtable6, string13);
                this.addAttributeData(hashtable5, hashtable6, string4, string5, string6);
                string10 = "ALR4040W";
                Object[] objectArray = null;
                String string14 = (String)hashtable3.get("type");
                if (string14 == null) {
                    string14 = "";
                }
                if ((string9 = (String)hashtable3.get("HLDLabel")) == null) {
                    string9 = "";
                }
                objectArray = new Object[]{string14, string9, string5, string6};
                fabricAlert = new FabricAlert(n4, n, s2, alertDefinition, nArray, n5, hashtable5, string12, hashtable6, string10, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: pe" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: pe" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    private short determineResourceType(String string) {
        short s = -1;
        s = string.equals("subsystem") ? (short)78 : 139;
        return s;
    }

    private short determineAlertCondition(String string, String string2) {
        int n = -1;
        if (string2.equals("TPC_NEW_DEVICE_EVENT")) {
            n = 106;
            if (string.equals("subsystem")) {
                n = 64;
            }
        } else if (string2.equals("TPC_DEVICE_STATE_CHANGE_EVENT")) {
            n = 101;
            if (string.equals("subsystem")) {
                n = 65;
            }
        } else if (string2.equals("TPC_PROPERTY_CHANGE_EVENT")) {
            n = 177;
            if (string.equals("subsystem")) {
                n = 123;
            }
        }
        return (short)n;
    }

    private void addAttributeData(Hashtable hashtable, Hashtable hashtable2, String string, String string2, String string3) {
        hashtable.put(MIBConstants.BTAAttributeName, string);
        hashtable.put(MIBConstants.BTAOldAttributeValue, string2);
        hashtable.put(MIBConstants.BTANewAttributeValue, string3);
        hashtable2.put("attributeName", string);
        hashtable2.put("oldValue", string2);
        hashtable2.put("newValue", string3);
    }

    private void addOperationalStatusData(Hashtable hashtable, Hashtable hashtable2, int n, int n2) {
        hashtable.put(MIBConstants.BTAOldStatus, "" + n);
        hashtable.put(MIBConstants.BTANewStatus, "" + n2);
        hashtable2.put("oldStatus", "" + n);
        hashtable2.put("oldStatus", "" + n2);
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private String getPEValue(int n, Hashtable hashtable) {
        if (peVarNames[n].equals("description")) {
            return peVarNames[n];
        }
        if (peVarNames[n].equals("messageId")) {
            return peVarNames[n];
        }
        return (String)hashtable.get(peVarNames[n]);
    }

    private int getAlertId(short s, int n, short s2, String string) {
        int n2 = -1;
        n2 = EventDBAccessor.getAlertIDByResource(s, n, s2);
        if (n2 <= 0) {
            String string2 = EventDBAccessor.getFabricIdForPE(string);
            if (string2 != null && !string2.equals("")) {
                n2 = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(string2), s2);
            }
            if (n2 <= 0) {
                n2 = s == 139 ? EventDBAccessor.getAlertIDByResource((short)129, -1, s2) : EventDBAccessor.getAlertIDByResource(s, -1, s2);
            }
        }
        return n2;
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

