/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import com.tivoli.tec.event_delivery.TECEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class SRMTECEvent
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger;
    protected transient ILogger traceLogger;
    static final String TRACE_NAME = "tpc.eventTrace";
    static final String MESSAGE_NAME = "tpc.eventLog";
    public static final String className;
    public String tecEventClass;
    public Hashtable tecAttributes;
    public String tecHostName;
    public String tecMessage;
    public String tecMessageId;
    public String tecSeverity;
    public String tecComponent;
    public String tecFunction;
    public String tecIPAddress;
    private long creationTime;
    public static final String EVENT_CLASS = "eventClass";
    public static final String HOSTNAME = "hostname";
    public static final String ORIGIN = "origin";
    public static final String SOURCE = "source";
    public static final String SUB_SOURCE = "sub_source";
    public static final String MSG = "msg";
    public static final String MSG_ID = "messageId";
    public static final String SEVERITY = "severity";
    public static final String FATAL = "FATAL";
    public static final String CRITICAL = "CRITICAL";
    public static final String WARNING = "WARNING";
    public static final String HARMLESS = "HARMLESS";
    public static final String MINOR = "MINOR";
    public static final String UNKNOWN = "UNKNOWN";
    private TECEvent tecEvent;
    public String tecSpecial;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.tivoli.tec.event_delivery.TECEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public SRMTECEvent() {
        block6: {
            this.msgLogger = null;
            this.traceLogger = null;
            this.tecEventClass = "ServiceEvent";
            this.tecAttributes = null;
            this.tecHostName = null;
            this.tecMessage = null;
            this.tecMessageId = null;
            this.tecSeverity = HARMLESS;
            this.tecComponent = null;
            this.tecFunction = null;
            this.tecIPAddress = null;
            this.creationTime = 0L;
            this.tecEvent = null;
            this.tecSpecial = "'";
            this.creationTime = System.currentTimeMillis();
            this.traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "SRMTECEvent");
            }
            this.msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
            try {
                String string = InetAddress.getLocalHost().getHostAddress();
                String string2 = InetAddress.getByName(string).getHostName();
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "SRMTECEvent", "The TEC host name is " + string2 + " and the IP address is " + string + ".");
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SRMTECEvent", (Throwable)unknownHostException);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SRMTECEvent", (Throwable)unknownHostException);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "SRMTECEvent");
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getHostName() {
        return this.tecHostName;
    }

    public void setHostName(String string) {
        this.tecHostName = string;
    }

    public void setTECAttributes(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Hashtable hashtable) throws IllegalArgumentException {
        block6: {
            try {
                this.tecEventClass = string;
                this.tecHostName = string2;
                this.tecIPAddress = string3;
                this.tecComponent = string4;
                this.tecFunction = string5;
                this.tecMessageId = string6;
                this.tecMessage = string7;
                this.tecSeverity = string8;
                this.tecAttributes = new Hashtable();
                if (hashtable != null) {
                    this.tecAttributes.putAll(hashtable);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setTECAttributes", (Throwable)nullPointerException);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setTECAttributes", (Throwable)nullPointerException);
            }
        }
        try {
            this.loadDataToTECEvent();
        }
        catch (Exception exception) {}
    }

    public String getSerializetTECEvent() {
        if (this.tecEvent != null) {
            return this.tecEvent.toString();
        }
        return null;
    }

    public String toString() {
        return "SRMTECEvent (" + new Date(this.creationTime) + "): " + className;
    }

    private void logEvent(SRMTECEvent sRMTECEvent) throws IOException, JMSException {
        this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, "logEvent", "SANEventService_logEvent", (Object)sRMTECEvent);
    }

    private void loadDataToTECEvent() throws IllegalArgumentException {
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "loadTECEvent");
        }
        try {
            this.tecEvent = new TECEvent();
            this.setGeneralTECValues();
        }
        catch (Exception exception) {
            this.tecEvent = null;
            throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
        }
        if (this.tecEventClass.equals("PhysicalEntityEvent")) {
            try {
                this.tecEvent.setSlot("uniqueId", this.verifyValue("uniqueId", (String)this.tecAttributes.get("uniqueId")));
                this.tecEvent.setSlot("entityType", this.verifyValue("entityType", (String)this.tecAttributes.get("entityType")));
                this.tecEvent.setSlot("label", this.verifyValue("label", (String)this.tecAttributes.get("HLDLabel")));
                this.tecEvent.setSlot("type", this.verifyValue("type", (String)this.tecAttributes.get("type")));
                this.tecEvent.setSlot("highLevelDevice", this.verifyValue("highLevelDevice", (String)this.tecAttributes.get("highLevelDevice")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
            }
            catch (NullPointerException nullPointerException) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)nullPointerException);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("PhysicalRelationshipEvent")) {
            try {
                this.tecEvent.setSlot("uniqueId", this.verifyValue("uniqueId", (String)this.tecAttributes.get("uniqueId")));
                this.tecEvent.setSlot("entityType", this.verifyValue("entityType", (String)this.tecAttributes.get("entityType")));
                this.tecEvent.setSlot("toObjectUniqueId", this.verifyValue("toObjectHLDUniqueId", (String)this.tecAttributes.get("toObjectHLDUniqueId")));
                this.tecEvent.setSlot("toObjectLabel", this.verifyValue("toObjectHLDLabel", (String)this.tecAttributes.get("toObjectHLDLabel")));
                this.tecEvent.setSlot("toObjectType", this.verifyValue("toObjectHLDType", (String)this.tecAttributes.get("toObjectHLDType")));
                this.tecEvent.setSlot("toHighLevelDevice", this.verifyValue("toHighLevelDevice", (String)this.tecAttributes.get("toHighLevelDevice")));
                this.tecEvent.setSlot("fromObjectUniqueId", this.verifyValue("fromObjectHLDUniqueId", (String)this.tecAttributes.get("fromObjectHLDUniqueId")));
                this.tecEvent.setSlot("fromObjectLabel", this.verifyValue("fromObjectHLDLabel", (String)this.tecAttributes.get("fromObjectHLDLabel")));
                this.tecEvent.setSlot("fromObjectType", this.verifyValue("fromObjectHLDType", (String)this.tecAttributes.get("fromObjectHLDType")));
                this.tecEvent.setSlot("fromHighLevelDevice", this.verifyValue("fromHighLevelDevice", (String)this.tecAttributes.get("fromHighLevelDevice")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
            }
            catch (NullPointerException nullPointerException) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)nullPointerException);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("LogicalEntityEvent")) {
            try {
                this.tecEvent.setSlot("uniqueId", this.verifyValue("uniqueId", (String)this.tecAttributes.get("uniqueId")));
                this.tecEvent.setSlot("entityType", this.verifyValue("entityType", (String)this.tecAttributes.get("entityType")));
                this.tecEvent.setSlot("label", this.verifyValue("label", (String)this.tecAttributes.get("label")));
                this.tecEvent.setSlot("type", this.verifyValue("type", (String)this.tecAttributes.get("type")));
                this.tecEvent.setSlot("highLevelDevice", this.verifyValue("highLevelDevice", (String)this.tecAttributes.get("highLevelDevice")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
            }
            catch (NullPointerException nullPointerException) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)nullPointerException);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("LogicalRelationshipEvent")) {
            try {
                this.tecEvent.setSlot("uniqueId", this.verifyValue("uniqueId", (String)this.tecAttributes.get("uniqueId")));
                this.tecEvent.setSlot("entityType", this.verifyValue("entityType", (String)this.tecAttributes.get("entityType")));
                this.tecEvent.setSlot("toObjectUniqueId", this.verifyValue("toObjectUniqueId", (String)this.tecAttributes.get("toObjectUniqueId")));
                this.tecEvent.setSlot("toObjectLabel", this.verifyValue("toObjectLabel", (String)this.tecAttributes.get("toObjectLabel")));
                this.tecEvent.setSlot("toObjectType", this.verifyValue("toObjectType", (String)this.tecAttributes.get("toObjectType")));
                this.tecEvent.setSlot("toHighLevelDevice", this.verifyValue("toHighLevelDevice", (String)this.tecAttributes.get("toHighLevelDevice")));
                this.tecEvent.setSlot("fromObjectUniqueId", this.verifyValue("fromObjectUniqueId", (String)this.tecAttributes.get("fromObjectUniqueId")));
                this.tecEvent.setSlot("fromObjectLabel", this.verifyValue("fromObjectLabel", (String)this.tecAttributes.get("fromObjectLabel")));
                this.tecEvent.setSlot("fromObjectType", this.verifyValue("fromObjectType", (String)this.tecAttributes.get("fromObjectType")));
                this.tecEvent.setSlot("fromHighLevelDevice", this.verifyValue("fromHighLevelDevice", (String)this.tecAttributes.get("fromHighLevelDevice")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
            }
            catch (NullPointerException nullPointerException) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)nullPointerException);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("SANManagerStatusEvent")) {
            try {
                this.tecEvent.setSlot("actionPerformed", this.verifyValue("actionPerformed", (String)this.tecAttributes.get("actionPerformed")));
            }
            catch (NullPointerException nullPointerException) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)nullPointerException);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("SANRegionEvent")) {
            try {
                this.tecEvent.setSlot("SANName", this.verifyValue("SANName", (String)this.tecAttributes.get("SANName")));
                this.tecEvent.setSlot("zoneName", this.verifyValue("zoneName", (String)this.tecAttributes.get("zoneName")));
                this.tecEvent.setSlot("state", this.verifyValue("state", (String)this.tecAttributes.get("state")));
                this.tecEvent.setSlot("eventType", this.verifyValue("eventType", (String)this.tecAttributes.get("eventType")));
                this.tecEvent.setSlot("zoneSetName", this.verifyValue("zoneSetName", (String)this.tecAttributes.get("zoneSetName")));
                this.tecEvent.setSlot("active", this.verifyValue("active", (String)this.tecAttributes.get("active")));
            }
            catch (NullPointerException nullPointerException) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)nullPointerException);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.tecEventClass.equals("ServiceEvent")) {
            try {
                this.tecEvent.setSlot("serviceName", this.verifyValue("serviceName", (String)this.tecAttributes.get("serviceName")));
                this.tecEvent.setSlot("serviceState", this.verifyValue("serviceState", (String)this.tecAttributes.get("serviceState")));
            }
            catch (NullPointerException nullPointerException) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "loadTECEvent", (Throwable)nullPointerException);
                this.tecEvent = null;
                throw new IllegalArgumentException("Can't populate TECEvent with empty string arguments.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "loadTECEvent", (Object)("Failed to create a TEC event: not a valid TECEvent type " + this.tecEventClass));
        }
        throw new IllegalArgumentException("Failed to create a TEC event: not a valid TECEvent type " + this.tecEventClass);
    }

    private void setGeneralTECValues() {
        this.tecEvent.setClassName(this.tecEventClass);
        this.tecEvent.setSlot(HOSTNAME, String.valueOf(this.tecSpecial) + this.tecHostName + this.tecSpecial);
        this.tecEvent.setSlot(ORIGIN, String.valueOf(this.tecSpecial) + this.tecIPAddress + this.tecSpecial);
        this.tecEvent.setSlot(SOURCE, String.valueOf(this.tecSpecial) + this.tecComponent + this.tecSpecial);
        this.tecEvent.setSlot(SUB_SOURCE, String.valueOf(this.tecSpecial) + this.tecFunction + this.tecSpecial);
        this.tecEvent.setSlot(MSG, String.valueOf(this.tecSpecial) + this.tecMessage + this.tecSpecial);
        this.tecEvent.setSlot(MSG_ID, String.valueOf(this.tecSpecial) + this.tecMessageId + this.tecSpecial);
        this.tecEvent.setSlot(SEVERITY, String.valueOf(this.tecSpecial) + this.tecSeverity + this.tecSpecial);
    }

    public Hashtable getTECAttributes() throws NullPointerException {
        return this.tecAttributes;
    }

    public String getTECComponent() {
        return this.tecComponent;
    }

    public String getTECFunction() {
        return this.tecFunction;
    }

    public String getTECIPAddress() {
        return this.tecIPAddress;
    }

    public String getTECMessage() {
        return this.tecMessage;
    }

    public String getTECMessageId() {
        return this.tecMessageId;
    }

    public String getTECSeverity() {
        return this.tecSeverity;
    }

    public String getTECEventClass() {
        return this.tecEventClass;
    }

    public void setTECComponent(String string) {
        this.tecComponent = string;
    }

    public void setTECFunction(String string) {
        this.tecFunction = string;
    }

    public void setTECIPAddress(String string) {
        this.tecIPAddress = string;
    }

    public void setTECMessage(String string) {
        this.tecMessage = string;
    }

    public void setTECMessageId(String string) {
        this.tecMessageId = string;
    }

    public void setTECSeverity(String string) {
        this.tecSeverity = string;
    }

    public void setTECEventClass(String string) {
        this.tecEventClass = string;
    }

    private String verifyValue(String string, String string2) {
        String string3 = "verifyValue";
        String string4 = string2;
        if (string4 != null) {
            return String.valueOf(this.tecSpecial) + string4 + this.tecSpecial;
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string3, "Null value found for TEC attribute " + string);
        }
        String string5 = "";
        return string5;
    }
}

