/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ConnectionManager {
    static ILogger msgLogger = EventCorrelatorFactory.msgLogger;
    static ILogger traceLogger = EventCorrelatorFactory.traceLogger;
    private static Hashtable registration = new Hashtable();
    private static DatagramSocket msgSocket = null;
    public static int registrationPeriod = 300;

    private ConnectionManager() {
    }

    public static synchronized void addListener(DatagramPacket datagramPacket) {
        block2: {
            String string = new String(datagramPacket.getData(), 0, datagramPacket.getLength());
            try {
                int n = string.indexOf(58);
                Integer.valueOf(string.substring(0, n));
                Integer n2 = Integer.valueOf(string.substring(n + 1, string.length()));
                registration.put(n2, new Date());
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"ConnectionManager", "addListener", (Throwable)exception, "Registration message," + string + ", not in expected <version>:<udp port> format.");
            }
        }
    }

    public static synchronized void clearListeners() {
        registration.clear();
    }

    public static synchronized void outputToListeners(byte[] byArray, int n) {
        block10: {
            try {
                if (msgSocket == null) {
                    msgSocket = new DatagramSocket();
                }
                Date date = new Date();
                Iterator iterator = registration.keySet().iterator();
                while (iterator.hasNext()) {
                    try {
                        int n2 = (Integer)iterator.next();
                        Date date2 = (Date)registration.get(new Integer(n2));
                        if ((date.getTime() - date2.getTime()) / 1000L > (long)(registrationPeriod * 60)) {
                            iterator.remove();
                            continue;
                        }
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, InetAddress.getLocalHost(), n2);
                        msgSocket.send(datagramPacket);
                    }
                    catch (IOException iOException) {
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"ConnectionManager", "outputToListeners", (Throwable)iOException, "Problem occurred while trying to send a packet over UDP socket: " + msgSocket + ".");
                        }
                        try {
                            if (msgSocket == null) continue;
                            msgSocket.close();
                            msgSocket = null;
                        }
                        catch (Exception exception) {
                            msgSocket = null;
                            if (!traceLogger.isLogging()) continue;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"ConnectionManager", "outputToListeners", (Throwable)exception, "An error occurred when trying to close the socket which had just had an error when attempting to send a packet.");
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) break block10;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"ConnectionManager", "outputToListeners", (Throwable)exception, "Unable to create UDP socket over which to forward SNMP msgs.");
            }
        }
    }
}

