/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.snmp.SnmpMonitor;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.SnmpV2Trap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.V2TrapFilter;
import org.eclipse.aperi.snmp.V2TrapListener;
import org.eclipse.aperi.snmp.data.Counter64;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;

public class SnmpV2Monitor
extends SnmpMonitor
implements V2TrapFilter,
V2TrapListener {
    private EventCorrelatorFactory eventMonitor = null;
    private SnmpTrap v1Trap = null;

    public SnmpV2Monitor(EventCorrelatorFactory eventCorrelatorFactory) {
        super(eventCorrelatorFactory);
        String string = "SnmpMonitor";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
    }

    public void handle(SnmpV2PDU snmpV2PDU) {
        String string = "handlev2";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        super.handle(this.v1Trap);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public boolean filter(SnmpV2PDU snmpV2PDU) {
        System.currentTimeMillis();
        String string = "filterv2";
        this.v1Trap = this.mapToV1Trap((SnmpV2Trap)snmpV2PDU);
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger.isLogging()) {
            StringBuffer stringBuffer = new StringBuffer();
            Vector vector = snmpV2PDU.varBindList();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                SnmpVarBind snmpVarBind = (SnmpVarBind)iterator.next();
                stringBuffer.append("\t(" + snmpVarBind.get_printable_oid() + "=");
                if (snmpVarBind.get_value() instanceof OctetString) {
                    stringBuffer.append(String.valueOf(((OctetString)snmpVarBind.get_value()).toDisplayString()) + ")\n");
                    continue;
                }
                stringBuffer.append(String.valueOf(snmpVarBind.get_printable_value()) + ")\n");
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return super.filter(this.v1Trap);
    }

    private SnmpTrap mapToV1Trap(SnmpV2Trap snmpV2Trap) {
        SnmpVarBind snmpVarBind;
        OID oID = new OID("1.3.6.1.6.3.1.1.5");
        OID oID2 = new OID("1.3.6.1.6.3.1.1.4.3.0");
        Vector vector = snmpV2Trap.varBindList();
        SnmpVarBind snmpVarBind2 = (SnmpVarBind)vector.elementAt(0);
        SnmpVarBind snmpVarBind3 = (SnmpVarBind)vector.elementAt(1);
        SnmpVarBind snmpVarBind4 = null;
        SnmpTrap snmpTrap = new SnmpTrap();
        Iterator iterator = vector.iterator();
        iterator.next();
        iterator.next();
        while (iterator.hasNext()) {
            snmpVarBind = (SnmpVarBind)iterator.next();
            if (snmpVarBind.get_value() instanceof Counter64) continue;
            if (snmpVarBind.get_oid().equals((Object)oID2)) {
                snmpVarBind4 = snmpVarBind;
                continue;
            }
            snmpTrap.varBindList.addElement(snmpVarBind);
        }
        snmpTrap.agentAddr = new IPAddress(snmpV2Trap.senderAddr);
        snmpTrap.communityString = new OctetString(snmpV2Trap.communityString);
        snmpTrap.senderAddr = new IPAddress(snmpV2Trap.senderAddr);
        snmpTrap.timeStamp = (TimeTicks)snmpVarBind2.get_value();
        snmpVarBind = (OID)snmpVarBind3.get_value();
        int n = snmpVarBind.value.length;
        if (n == 10 && snmpVarBind.value[9] <= 6L && snmpVarBind.startsWith(oID)) {
            snmpTrap.specificTrap = 0;
            snmpTrap.genericTrap = (int)snmpVarBind.value[9] - 1;
            snmpTrap.enterprise = snmpVarBind4 != null ? snmpVarBind4.get_oid() : oID;
        } else {
            snmpTrap.genericTrap = 6;
            snmpTrap.specificTrap = (int)snmpVarBind.value[n - 1];
            snmpTrap.enterprise = snmpVarBind.value[n - 2] == 0L ? new OID(oID.value, n - 2) : new OID(oID.value, n - 1);
        }
        return snmpTrap;
    }
}

