/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableUpdater;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.HostManager;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogWrapper;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.PeerDataException;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.subagent.common.HostQueryInfo;

class AgentRegistrationListener {
    static final String className;
    private Map hostMap = null;
    private LogWrapper messages = SANDiskMgrHostService.messages;
    private LogWrapper trace = SANDiskMgrHostService.trace;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentRegistrationListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    AgentRegistrationListener(Map map) {
        this.hostMap = map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void agentRegistrationHeartbeat(HostQueryInfo hostQueryInfo) {
        block26: {
            Object object;
            AgentTableReader agentTableReader = null;
            if (this.trace.isLogging()) {
                this.trace.entry((Object)this, "agentRegistrationHeartbeat");
            }
            String string = hostQueryInfo.hostName;
            if (this.trace.isLogging()) {
                object = String.valueOf(string) + " " + hostQueryInfo.getUniqueAgentName() + ":  Got agent registration!  ";
                this.trace.text(IRecordType.TYPE_INFORMATION, (Object)className, "agentRegistrationHeartbeat", (String)object);
            }
            try {
                try {
                    object = null;
                    object = (TdmAgent)this.hostMap.get(hostQueryInfo.getUniqueAgentName());
                    if (object != null) {
                        Object object2;
                        boolean bl = false;
                        boolean bl2 = false;
                        new Integer(hostQueryInfo.hostPort);
                        if (!(object.agentName.equals(hostQueryInfo.hostName) && object.osname.equals(hostQueryInfo.osName) && object.ipAddress.equals(hostQueryInfo.hostIP) && this.versionsMatch(object.version, hostQueryInfo.hostVersion))) {
                            bl = true;
                            object2 = String.valueOf(object.getNameGuidPort()) + ":  Host information changed!";
                            this.trace.text(IRecordType.TYPE_INFORMATION, (Object)className, "agentRegistrationHeartbeat", (String)object2);
                        }
                        if (object.status.equals("IA")) {
                            bl2 = true;
                        }
                        if (bl || bl2) {
                            agentTableReader = SANDiskMgrHostService.getHostTableUpdater();
                            if (bl) {
                                int n;
                                object2 = HostManager.bldTdmHostObject(hostQueryInfo);
                                ((TdmAgent)object2).index = object.index;
                                String string2 = "index: " + ((TdmAgent)object2).index + " " + object2.getUniqueAgentName() + " " + object2.toString();
                                this.trace.text(IRecordType.TYPE_INFORMATION, (Object)className, "agentRegistrationHeartbeat", string2);
                                if (this.hostMap.remove(object.getUniqueAgentName()) == null) {
                                    String string3 = String.valueOf(object.getNameGuidPort()) + ":  Host could not be removed from map!";
                                    this.trace.text(IRecordType.TYPE_WARN, (Object)className, "agentRegistrationHeartbeat", string3);
                                }
                                if ((n = ((AgentTableUpdater)agentTableReader).updateHost((TdmAgent)object2, true)) <= 0) {
                                    object = null;
                                } else {
                                    this.hostMap.put(object2.getUniqueAgentName(), object2);
                                }
                            }
                            if (bl2 && object != null) {
                                object.status_lstchanged = new Date();
                                object.status = "AC";
                                object2 = new Timestamp(object.status_lstchanged.getTime());
                                int n = ((AgentTableUpdater)agentTableReader).updateStatus(object.guid, object.agentPort, (Timestamp)object2, object.status);
                                if (n <= 0) {
                                    this.hostMap.remove(object.getUniqueAgentName());
                                    object = null;
                                }
                            }
                            if (object != null) {
                                HostManager.fireDiskMgrHostEvent(object.guid, object.agentPort, "AC");
                                this.messages.message(IRecordType.TYPE_WARN, (Object)this, "agentRegistrationHeartbeat", "Agent_active", (Object)(String.valueOf(hostQueryInfo.hostName) + ":" + hostQueryInfo.hostPort));
                            }
                        } else {
                            object.status_lstchanged = new Date();
                            object.status = "AC";
                        }
                    }
                    if (object == null) {
                        if (this.trace.isLogging()) {
                            this.trace.text(IRecordType.TYPE_INFORMATION, (Object)className, "agentRegistrationHeartbeat", String.valueOf(hostQueryInfo.getUniqueAgentName()) + hostQueryInfo.hostName + " NEW host");
                        }
                        agentTableReader = SANDiskMgrHostService.getHostTableUpdater();
                        TdmAgent tdmAgent = HostManager.bldTdmHostObject(hostQueryInfo);
                        tdmAgent.status = "AC";
                        this.hostMap.put(tdmAgent.getUniqueAgentName(), tdmAgent);
                        HostManager.addTdmHost((AgentTableUpdater)agentTableReader, tdmAgent);
                        HostManager.fireDiskMgrHostEvent(tdmAgent.guid, tdmAgent.agentPort, "AC");
                        this.messages.message(IRecordType.TYPE_WARN, (Object)this, "agentRegistrationHeartbeat", "Agent_active", (Object)tdmAgent.toAgentString());
                    }
                }
                catch (PeerDataException peerDataException) {
                    this.messages.exception((Object)this, "agentRegistrationHeartbeat", (Throwable)((Object)peerDataException));
                    if (this.trace.isLogging()) {
                        this.trace.exception((Object)this, "agentRegistrationHeartbeat", (Throwable)((Object)peerDataException));
                    }
                }
                catch (Exception exception) {
                    this.messages.exception((Object)this, "agentRegistrationHeartbeat", (Throwable)exception);
                    if (this.trace.isLogging()) {
                        this.trace.exception((Object)this, "agentRegistrationHeartbeat", (Throwable)exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (agentTableReader != null) {
                    agentTableReader.close();
                }
                throw throwable;
            }
            {
                Object var10_17 = null;
                if (agentTableReader == null) break block26;
            }
            agentTableReader.close();
        }
        if (this.trace.isLogging()) {
            this.trace.exit((Object)this, "agentRegistrationHeartbeat");
        }
    }

    private boolean versionsMatch(String string, String string2) {
        boolean bl = false;
        if (string == null && string2 == null) {
            bl = true;
        }
        if (string != null && string2 != null && string.equals(string2)) {
            bl = true;
        }
        return bl;
    }
}

