/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.PropertyBindingHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;

public class PropertyBinding
extends Structure {
    public static final String PROPERTY_BINDING_STRUCT = "PropertyBinding";
    public static final String NAME_MEMBER = "name";
    public static final String ID_MEMBER = "id";
    public static final String VALUE_MEMBER = "value";
    protected String name = null;
    protected BigDecimal id = null;
    protected String value = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Object getIntrinsicProperty(String propName) {
        if (NAME_MEMBER.equalsIgnoreCase(propName)) {
            return this.name;
        }
        if (ID_MEMBER.equalsIgnoreCase(propName)) {
            return this.id;
        }
        if (VALUE_MEMBER.equalsIgnoreCase(propName)) {
            return this.value;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (NAME_MEMBER.equalsIgnoreCase(propName)) {
            this.name = (String)value;
        } else if (ID_MEMBER.equalsIgnoreCase(propName)) {
            this.id = (BigDecimal)value;
        } else if (VALUE_MEMBER.equalsIgnoreCase(propName)) {
            this.value = (String)value;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new PropertyBindingHandle(valueHandle, index);
    }

    public String getStructName() {
        return PROPERTY_BINDING_STRUCT;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setID(long id) {
        this.id = new BigDecimal((double)id);
    }

    public BigDecimal getID() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String expression) {
        this.value = expression;
    }

    public List validate(Module module, DesignElement element) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        if (StringUtil.isBlank(this.getName())) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), null, "Error.PropertyValueException.VALUE_REQUIRED"));
        } else if (this.id == null || module.getElementByID(this.id.longValue()) == null) {
            list.add(new SemanticError(element, new String[]{this.getName()}, "Error.SemanticError.INVALID_PROPERTY_BINDING_ID"));
        } else if (module.getElementByID(this.id.longValue()).getPropertyDefn(this.getName()) == null) {
            list.add(new SemanticError(element, new String[]{this.getName()}, "Error.SemanticError.INVALID_PROPERTY_NAME"));
        }
        return list;
    }

    static {
        $assertionsDisabled = !PropertyBinding.class.desiredAssertionStatus();
    }
}

