/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.extension.oda.OdaDummyProvider;
import org.eclipse.birt.report.model.parser.CompatibleOdaDataSourcePropertyState;
import org.eclipse.birt.report.model.parser.DataSourceState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OdaDataSourceState
extends DataSourceState {
    private static final String OBSOLETE_FLAT_FILE_ID = "org.eclipse.birt.report.data.oda.flatfile";
    private static final String NEW_FLAT_FILE_ID = "org.eclipse.datatools.connectivity.oda.flatfile";
    private boolean isValidExtensionId = true;
    private ODAProvider provider = null;
    static /* synthetic */ Class class$org$eclipse$birt$report$model$parser$OdaDataSourceState;

    public OdaDataSourceState(ModuleParserHandler handler) {
        super(handler);
        this.element = new OdaDataSource();
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.parseODADataSourceExtensionID(attrs, false);
        this.initElement(attrs, true);
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("property") && (this.handler.isVersion(0) || this.handler.isVersion(1000000))) {
            return new CompatibleOdaDataSourcePropertyState(this.handler, this.getElement());
        }
        if (this.isValidExtensionId) {
            return super.startElement(tagName);
        }
        return this.startDummyElement(tagName);
    }

    protected AbstractParseState startDummyElement(String tagName) {
        if ("property".equalsIgnoreCase(tagName) || "xml-property".equalsIgnoreCase(tagName) || "method".equalsIgnoreCase(tagName) || "expression".equalsIgnoreCase(tagName)) {
            return new DummyPropertyState(this.handler, this.getElement(), (OdaDummyProvider)this.provider);
        }
        return super.startElement(tagName);
    }

    private void parseODADataSourceExtensionID(Attributes attrs, boolean extensionNameRequired) {
        String extensionID = this.getAttrib(attrs, "extensionID");
        if (StringUtil.isBlank(extensionID)) {
            if (!extensionNameRequired) {
                return;
            }
            SemanticError e = new SemanticError(this.element, "Error.SemanticError.MISSING_EXTENSION");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
            return;
        }
        if (this.handler.versionNumber < 3000000 && OBSOLETE_FLAT_FILE_ID.equalsIgnoreCase(extensionID)) {
            extensionID = NEW_FLAT_FILE_ID;
        }
        this.setProperty("extensionID", extensionID);
        this.provider = ((OdaDataSource)this.element).getProvider();
        if (this.provider == null) {
            return;
        }
        if (this.provider instanceof OdaDummyProvider) {
            SemanticError e = new SemanticError((DesignElement)this.element, new String[]{extensionID}, "Error.SemanticError.EXTENSION_NOT_FOUND");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
            this.isValidExtensionId = false;
        }
    }

    static class DummyPropertyState
    extends PropertyState {
        private OdaDummyProvider provider = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DummyPropertyState(ModuleParserHandler theHandler, DesignElement element, OdaDummyProvider provider) {
            super(theHandler, element);
            this.provider = provider;
        }

        public void end() throws SAXException {
            String value = this.text.toString();
            this.propDefn = this.element.getPropertyDefn(this.name);
            if (this.propDefn != null) {
                this.doEnd(value);
                return;
            }
            if (!$assertionsDisabled && this.provider == null) {
                throw new AssertionError();
            }
            this.provider.saveValue(this.name, value, this.elementName);
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$model$parser$OdaDataSourceState == null ? (class$org$eclipse$birt$report$model$parser$OdaDataSourceState = OdaDataSourceState.class$("org.eclipse.birt.report.model.parser.OdaDataSourceState")) : class$org$eclipse$birt$report$model$parser$OdaDataSourceState).desiredAssertionStatus();
        }
    }
}

