/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.snmp.SessionInfo;
import org.eclipse.aperi.snmp.SessionInfoCommString;
import org.eclipse.aperi.snmp.SnmpBERlength;
import org.eclipse.aperi.snmp.SnmpDecodeException;
import org.eclipse.aperi.snmp.SnmpEncodeException;
import org.eclipse.aperi.snmp.SnmpMsgBuffer;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.SnmpV2Trap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.SnmpWrongVersion;
import org.eclipse.aperi.snmp.data.Counter;
import org.eclipse.aperi.snmp.data.Counter64;
import org.eclipse.aperi.snmp.data.EndOfMibView;
import org.eclipse.aperi.snmp.data.FullCounter64;
import org.eclipse.aperi.snmp.data.Gauge;
import org.eclipse.aperi.snmp.data.Hex;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.NoSuchInstance;
import org.eclipse.aperi.snmp.data.NoSuchObject;
import org.eclipse.aperi.snmp.data.Null;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.Opaque;
import org.eclipse.aperi.snmp.data.TimeTicks;

public abstract class SnmpAsn1 {
    private static final byte GET_TAG = -96;
    private static final byte GETNEXT_TAG = -95;
    private static final byte RESPONSE_TAG = -94;
    private static final byte SET_TAG = -93;
    private static final byte V1_TRAP_TAG = -92;
    private static final byte GETBULK_TAG = -91;
    private static final byte INFORM_TAG = -90;
    private static final byte V2_TRAP_TAG = -89;
    private static final byte REPORT_TAG = -88;
    protected static final byte SEQUENCE_TAG = 48;
    protected static final byte INTEGER_TAG = 2;
    private static final byte BIT_STRING = 3;
    protected static final byte OCTET_TAG = 4;
    private static final byte NULL_TAG = 5;
    private static final byte OID_TAG = 6;
    private static final byte IPADDRESS_TAG = 64;
    private static final byte COUNTER_TAG = 65;
    private static final byte GAUGE_TAG = 66;
    private static final byte TIMETICKS_TAG = 67;
    private static final byte OPAQUE_TAG = 68;
    private static final byte COUNTER64_TAG = 70;
    private static final byte CONSTRUCTED_FLAG = 32;
    private static final byte CLASS_MASK_TAG = -64;
    private static final byte CLASS_FLAG_MASK = -32;
    private static final byte UNIVERSAL = 0;
    private static final byte APPLICATION_WIDE = 64;
    private static final byte CONTEXT_SPECIFIC = -128;
    private static final byte PRIVATE_TAG = -64;
    private static final byte NOSUCHOBJECT_TAG = -128;
    private static final byte NOSUCHINSTANCE_TAG = -127;
    private static final byte ENDOFMIBVIEW_TAG = -126;
    private static Null nullInstance = new Null();
    private static final byte[] opType = new byte[]{-96, -95, -94, -93, -91, -90, -89, -88};

    public static int asnReadLen(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        int n = 0;
        int n2 = snmpMsgBuffer.index;
        if (snmpMsgBuffer.buf[n2] == -128) {
            throw new SnmpDecodeException("Indefinite Length not supported");
        }
        if ((snmpMsgBuffer.buf[n2] & 0x80) == 0) {
            snmpMsgBuffer.lenLen = 1;
            snmpMsgBuffer.len = snmpMsgBuffer.buf[n2] & 0x7F;
            return snmpMsgBuffer.len;
        }
        snmpMsgBuffer.lenLen = (snmpMsgBuffer.buf[n2] & 0x7F) + 1;
        if (snmpMsgBuffer.lenLen > 5 || snmpMsgBuffer.lenLen > snmpMsgBuffer.buf.length - ++n2 + 1) {
            throw new SnmpDecodeException("Length of len too big (" + snmpMsgBuffer.lenLen + ")");
        }
        int n3 = snmpMsgBuffer.index + snmpMsgBuffer.lenLen - 1;
        n = 0;
        while (n2 <= n3) {
            n = n << 8 | snmpMsgBuffer.buf[n2] & 0xFF;
            ++n2;
        }
        snmpMsgBuffer.len = n;
        return n;
    }

    public static int asnDecodeLen(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        int n = SnmpAsn1.asnReadLen(snmpMsgBuffer);
        snmpMsgBuffer.index += snmpMsgBuffer.lenLen;
        if (snmpMsgBuffer.buf.length - snmpMsgBuffer.index < n) {
            throw new SnmpDecodeException("Data smaller than its encoded length!");
        }
        snmpMsgBuffer.len = n;
        return n;
    }

    public static void asnEncodeLen(SnmpMsgBuffer snmpMsgBuffer, int n) throws SnmpEncodeException {
        if (n <= 127) {
            if (snmpMsgBuffer.buf.length - snmpMsgBuffer.index - n < 1) {
                throw new SnmpEncodeException("Buffer can't take this len+data! has: " + (snmpMsgBuffer.buf.length - snmpMsgBuffer.index) + " needs: " + (n + 1));
            }
            snmpMsgBuffer.buf[snmpMsgBuffer.index++] = (byte)(n & 0x7F);
            snmpMsgBuffer.len = n;
            snmpMsgBuffer.lenLen = 1;
            return;
        }
        if (n <= 254) {
            if (snmpMsgBuffer.buf.length - (snmpMsgBuffer.index + n) < 2) {
                throw new SnmpEncodeException("Buffer can't take this len+data!\n \thas: " + (snmpMsgBuffer.buf.length - snmpMsgBuffer.index) + " needs: " + (n + 2) + "\n");
            }
            snmpMsgBuffer.buf[snmpMsgBuffer.index++] = -127;
            snmpMsgBuffer.buf[snmpMsgBuffer.index++] = (byte)(n & 0xFF);
            snmpMsgBuffer.len = n;
            snmpMsgBuffer.lenLen = 2;
            return;
        }
        int n2 = -8388608;
        int n3 = 0;
        int n4 = 4;
        while (n4 > 1 && (n2 & n) == 0) {
            n2 >>>= 8;
            --n4;
        }
        if (snmpMsgBuffer.buf.length - (snmpMsgBuffer.index + n) < n4) {
            throw new SnmpEncodeException("Buffer can't take this len+data! b.size=" + snmpMsgBuffer.buf.length + " b.index=" + snmpMsgBuffer.index + " b.len=" + snmpMsgBuffer.len + " datalen=" + n + " lenLen=" + n4);
        }
        snmpMsgBuffer.len = n;
        snmpMsgBuffer.lenLen = n4;
        snmpMsgBuffer.buf[snmpMsgBuffer.index++] = (byte)(0x80 | n4 & 0x7F);
        snmpMsgBuffer.index = n3 = snmpMsgBuffer.index + n4;
        while (n4-- > 0) {
            snmpMsgBuffer.buf[--n3] = (byte)(n & 0xFF);
            n >>>= 8;
        }
    }

    public static byte asnDecodeHeader(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        byte by;
        if (((by = snmpMsgBuffer.buf[snmpMsgBuffer.index++]) & 0x1F) == 31) {
            throw new SnmpDecodeException("Extended Tags not supported");
        }
        int n = SnmpAsn1.asnReadLen(snmpMsgBuffer);
        if (snmpMsgBuffer.index + n + snmpMsgBuffer.lenLen > snmpMsgBuffer.buf.length) {
            throw new SnmpDecodeException("Data len (" + (snmpMsgBuffer.index + n + snmpMsgBuffer.lenLen + 1) + ")" + " > buf.length (" + snmpMsgBuffer.buf.length + ")?!");
        }
        snmpMsgBuffer.index += snmpMsgBuffer.lenLen;
        snmpMsgBuffer.len = n;
        return by;
    }

    public static void asnEncodeHeader(SnmpMsgBuffer snmpMsgBuffer, byte by, int n) throws SnmpEncodeException {
        if (snmpMsgBuffer.buf.length - snmpMsgBuffer.index < 1) {
            throw new SnmpEncodeException("No room in buf to take even a tag!");
        }
        snmpMsgBuffer.buf[snmpMsgBuffer.index++] = by;
        SnmpAsn1.asnEncodeLen(snmpMsgBuffer, n);
    }

    public static byte asnDecodeNull(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        byte by = snmpMsgBuffer.buf[snmpMsgBuffer.index++];
        if (snmpMsgBuffer.buf[snmpMsgBuffer.index++] != 0) {
            throw new SnmpDecodeException("Not ASN.1 NULL where expected");
        }
        return by;
    }

    public static void asnEncodeNull(SnmpMsgBuffer snmpMsgBuffer, byte by) throws SnmpEncodeException {
        if (snmpMsgBuffer.buf.length - snmpMsgBuffer.index < 2) {
            throw new SnmpEncodeException("No room in the msg buffer!");
        }
        snmpMsgBuffer.buf[snmpMsgBuffer.index++] = by;
        snmpMsgBuffer.buf[snmpMsgBuffer.index++] = 0;
    }

    public static int asnDecodeInt(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        SnmpAsn1.asnDecodeHeader(snmpMsgBuffer);
        int n = (snmpMsgBuffer.buf[snmpMsgBuffer.index] & 0x80) > 0 ? -1 : 0;
        int n2 = snmpMsgBuffer.index + snmpMsgBuffer.len;
        while (snmpMsgBuffer.index < n2) {
            n = n << 8 | snmpMsgBuffer.buf[snmpMsgBuffer.index++] & 0xFF;
        }
        return n;
    }

    public static void asnEncodeInt(SnmpMsgBuffer snmpMsgBuffer, byte by, int n) throws SnmpEncodeException {
        int n2 = -8388608;
        int n3 = n >= 0 ? n : ~n;
        int n4 = 4;
        int n5 = 0;
        while (n4 > 1 && (n2 & n3) == 0) {
            n2 >>>= 8;
            --n4;
        }
        n5 = n4;
        SnmpAsn1.asnEncodeHeader(snmpMsgBuffer, by, n4);
        while (n4-- > 0) {
            snmpMsgBuffer.buf[snmpMsgBuffer.index + n4] = (byte)(n & 0xFF);
            n >>>= 8;
        }
        snmpMsgBuffer.index += n5;
    }

    public static int asnDecodeUInt(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        SnmpAsn1.asnDecodeHeader(snmpMsgBuffer);
        int n = snmpMsgBuffer.index + snmpMsgBuffer.len;
        int n2 = 0;
        while (snmpMsgBuffer.index < n) {
            n2 = n2 << 8 | snmpMsgBuffer.buf[snmpMsgBuffer.index++] & 0xFF;
        }
        return n2;
    }

    public static void asnEncodeUInt(SnmpMsgBuffer snmpMsgBuffer, byte by, int n) throws SnmpEncodeException {
        int n2 = -8388608;
        int n3 = Integer.MIN_VALUE;
        int n4 = 4;
        int n5 = 0;
        while (n4 > 1 && (n2 & n) == 0) {
            n2 >>>= 8;
            n3 >>>= 8;
            --n4;
        }
        if ((n & n3) != 0) {
            ++n4;
        }
        n5 = n4;
        SnmpAsn1.asnEncodeHeader(snmpMsgBuffer, by, n4);
        while (n4-- > 0) {
            snmpMsgBuffer.buf[snmpMsgBuffer.index + n4] = (byte)(n & 0xFF);
            n >>>= 8;
        }
        snmpMsgBuffer.index += n5;
    }

    public static byte[] asnDecodeOctetString(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        byte cfr_ignored_0 = snmpMsgBuffer.buf[snmpMsgBuffer.index++];
        byte[] byArray = new byte[SnmpAsn1.asnDecodeLen(snmpMsgBuffer)];
        System.arraycopy(snmpMsgBuffer.buf, snmpMsgBuffer.index, byArray, 0, byArray.length);
        snmpMsgBuffer.index += byArray.length;
        return byArray;
    }

    public static void asnEncodeOctetString(SnmpMsgBuffer snmpMsgBuffer, byte by, byte[] byArray) throws SnmpEncodeException {
        if (byArray == null) {
            SnmpAsn1.asnEncodeNull(snmpMsgBuffer, by);
            return;
        }
        SnmpAsn1.asnEncodeHeader(snmpMsgBuffer, by, byArray.length);
        System.arraycopy(byArray, 0, snmpMsgBuffer.buf, snmpMsgBuffer.index, byArray.length);
        snmpMsgBuffer.index += byArray.length;
    }

    public static long[] asnDecodeOid(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        SnmpAsn1.asnDecodeHeader(snmpMsgBuffer);
        int n = 2;
        int n2 = 0;
        int n3 = 0;
        int n4 = snmpMsgBuffer.len;
        if (n4 == 0) {
            long[] lArray = new long[2];
            lArray[1] = 0L;
            lArray[0] = 0L;
            return lArray;
        }
        n3 = snmpMsgBuffer.index + n4;
        n2 = snmpMsgBuffer.index;
        while (n2 < n3) {
            if (snmpMsgBuffer.buf[n2] >= 0) {
                ++n;
            }
            ++n2;
        }
        long[] lArray = new long[--n];
        int n5 = 0;
        n5 = 1;
        while (n4 > 0) {
            lArray[n5] = 0L;
            while (n4-- > 0) {
                lArray[n5] = lArray[n5] << 7 | (long)(snmpMsgBuffer.buf[snmpMsgBuffer.index] & 0x7F);
                if ((snmpMsgBuffer.buf[snmpMsgBuffer.index++] & 0x80) != 128) break;
            }
            ++n5;
        }
        if (lArray[1] / 40L >= 2L) {
            lArray[0] = 2L;
            lArray[1] = (byte)(lArray[1] - 80L);
        } else {
            lArray[0] = (byte)(lArray[1] / 40L);
            lArray[1] = (byte)(lArray[1] % 40L);
        }
        return lArray;
    }

    public static void asnEncodeOid(SnmpMsgBuffer snmpMsgBuffer, byte by, long[] lArray) throws SnmpEncodeException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        if (lArray == null) {
            SnmpAsn1.asnEncodeNull(snmpMsgBuffer, by);
            return;
        }
        if (lArray[0] > 2L || lArray[1] > 39L && lArray[1] <= 1L) {
            throw new SnmpEncodeException("Illegal OID! Shrink...");
        }
        lArray[1] = lArray[1] + lArray[0] * 40L;
        n2 = 1;
        n = 0;
        while (n2 < lArray.length) {
            n = lArray[n2] < 255L ? ++n : (lArray[n2] < 65535L ? (n += 2) : (lArray[n2] < 0xFFFFFFL ? (n += 3) : (lArray[n2] < 0xFFFFFFFFL ? (n += 4) : (lArray[n2] < 0xFFFFFFFFFFL ? (n += 5) : (lArray[n2] < 0xFFFFFFFFFFFFL ? (n += 6) : (lArray[n2] < 0xFFFFFFFFFFFFFFL ? (n += 7) : (n += 8)))))));
            ++n2;
        }
        byte[] byArray = new byte[2 * ++n];
        n3 = 2 * n - 1;
        n = 0;
        n2 = lArray.length - 1;
        while (n2 >= 1) {
            n4 = 1;
            l = lArray[n2];
            while (n3 >= snmpMsgBuffer.index) {
                byArray[n3] = (byte)(l & 0x7FL);
                l >>= 7;
                if (n4 > 1) {
                    int n5 = n3;
                    byArray[n5] = (byte)(byArray[n5] | 0xFFFFFF80);
                }
                --n3;
                if (l == 0L) break;
                ++n4;
            }
            n += n4;
            --n2;
        }
        SnmpAsn1.asnEncodeHeader(snmpMsgBuffer, by, n);
        System.arraycopy(byArray, n3 + 1, snmpMsgBuffer.buf, snmpMsgBuffer.index, n);
        lArray[1] = lArray[1] - lArray[0] * 40L;
        snmpMsgBuffer.index += n;
        byArray = null;
    }

    public static Serializable asnDecodePrimitive(SnmpMsgBuffer snmpMsgBuffer) throws SnmpDecodeException {
        byte by = snmpMsgBuffer.buf[snmpMsgBuffer.index];
        Serializable serializable = null;
        serializable = by == 2 ? new Integer(SnmpAsn1.asnDecodeInt(snmpMsgBuffer)) : (by == 4 ? new OctetString(SnmpAsn1.asnDecodeOctetString(snmpMsgBuffer)) : (by == 6 ? new OID(SnmpAsn1.asnDecodeOid(snmpMsgBuffer)) : (by == 67 ? new TimeTicks(SnmpAsn1.asnDecodeUInt(snmpMsgBuffer)) : (by == 65 ? new Counter(SnmpAsn1.asnDecodeUInt(snmpMsgBuffer)) : (by == 66 ? new Gauge(SnmpAsn1.asnDecodeUInt(snmpMsgBuffer)) : (by == -128 ? new NoSuchObject() : (by == -127 ? new NoSuchInstance() : (by == -126 ? new EndOfMibView() : (by == 64 ? new IPAddress(SnmpAsn1.asnDecodeOctetString(snmpMsgBuffer), 0) : nullInstance)))))))));
        return serializable;
    }

    public static void asnEncodePrimitive(SnmpMsgBuffer snmpMsgBuffer, Serializable serializable) throws SnmpEncodeException {
        if (serializable instanceof Integer) {
            SnmpAsn1.asnEncodeInt(snmpMsgBuffer, (byte)2, (Integer)serializable);
        } else if (serializable instanceof OctetString) {
            SnmpAsn1.asnEncodeOctetString(snmpMsgBuffer, (byte)4, ((OctetString)serializable).value);
        } else if (serializable instanceof Gauge) {
            SnmpAsn1.asnEncodeUInt(snmpMsgBuffer, (byte)66, (int)((Gauge)serializable).getValue());
        } else if (serializable instanceof Counter) {
            SnmpAsn1.asnEncodeUInt(snmpMsgBuffer, (byte)65, (int)((Counter)serializable).getValue());
        } else if (serializable instanceof TimeTicks) {
            SnmpAsn1.asnEncodeUInt(snmpMsgBuffer, (byte)67, (int)((TimeTicks)serializable).getValue());
        } else if (serializable instanceof IPAddress) {
            SnmpAsn1.asnEncodeOctetString(snmpMsgBuffer, (byte)64, ((IPAddress)serializable).getBytes());
        } else if (serializable instanceof Null) {
            SnmpAsn1.asnEncodeNull(snmpMsgBuffer, (byte)5);
        } else if (serializable instanceof OID) {
            SnmpAsn1.asnEncodeOid(snmpMsgBuffer, (byte)6, ((OID)serializable).value);
        } else if (serializable instanceof NoSuchObject) {
            SnmpAsn1.asnEncodeNull(snmpMsgBuffer, (byte)-128);
        } else if (serializable instanceof NoSuchInstance) {
            SnmpAsn1.asnEncodeNull(snmpMsgBuffer, (byte)-127);
        } else if (serializable instanceof EndOfMibView) {
            SnmpAsn1.asnEncodeNull(snmpMsgBuffer, (byte)-126);
        }
    }

    public static void prettyPrint(byte[] byArray, int n) {
        SnmpMsgBuffer snmpMsgBuffer = new SnmpMsgBuffer(byArray);
        SnmpAsn1.prettyPrint(snmpMsgBuffer, 0, n);
    }

    public static void uriPrettyPrint(SnmpMsgBuffer snmpMsgBuffer, int n, int n2, int n3) {
        int n4 = snmpMsgBuffer.index;
        if (n2 >= snmpMsgBuffer.buf.length) {
            System.err.println("prettyPrint: Offset beyond the buffer end!\n(offset=" + n2 + " buf.length=" + snmpMsgBuffer.buf.length + "\n");
            return;
        }
        snmpMsgBuffer.index = n2;
        SnmpAsn1.prettyPrint(snmpMsgBuffer, n, n3);
        snmpMsgBuffer.index = n4;
    }

    public static void prettyPrint(SnmpMsgBuffer snmpMsgBuffer, int n, int n2) {
        if (snmpMsgBuffer.index > snmpMsgBuffer.buf.length) {
            System.err.println("prettyPrint: index beyond the buffer end!\n(b.index=" + snmpMsgBuffer.index + " buf.length=" + snmpMsgBuffer.buf.length + "\n");
            return;
        }
        if (snmpMsgBuffer.index == snmpMsgBuffer.buf.length) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(" ");
            ++n3;
        }
        String string = stringBuffer.toString();
        int n4 = 0;
        block27: while (snmpMsgBuffer.index < n2) {
            try {
                switch (snmpMsgBuffer.buf[snmpMsgBuffer.index]) {
                    case 0: {
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        if (n4 != 0) continue block27;
                        return;
                    }
                    case 48: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "Sequence [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -96: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "GET [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -93: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "SET [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -95: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "GET NEXT [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -91: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "GET BULK [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -94: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "RESPONSE [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -92: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "V1 Trap [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -89: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "V2 Trap [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -88: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "Report [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case -90: {
                        ++snmpMsgBuffer.index;
                        n4 = SnmpAsn1.asnDecodeLen(snmpMsgBuffer);
                        System.out.println(String.valueOf(string) + "Inform [" + n4 + "]");
                        SnmpAsn1.prettyPrint(snmpMsgBuffer, n + 2, n2);
                        break;
                    }
                    case 2: {
                        System.out.println(String.valueOf(string) + "Int =" + SnmpAsn1.asnDecodeInt(snmpMsgBuffer));
                        break;
                    }
                    case 4: {
                        ++snmpMsgBuffer.index;
                        System.out.print(String.valueOf(string) + "OctetString [0x" + Integer.toHexString(SnmpAsn1.asnReadLen(snmpMsgBuffer)) + "] =");
                        --snmpMsgBuffer.index;
                        System.out.println(Hex.toString(SnmpAsn1.asnDecodeOctetString(snmpMsgBuffer)));
                        break;
                    }
                    case 6: {
                        System.out.println(String.valueOf(string) + "OID =" + new OID(SnmpAsn1.asnDecodeOid(snmpMsgBuffer)).toString());
                        break;
                    }
                    case 67: {
                        System.out.println(String.valueOf(string) + "TIMETICKS =" + SnmpAsn1.asnDecodeUInt(snmpMsgBuffer));
                        break;
                    }
                    case 65: {
                        System.out.println(String.valueOf(string) + "Counter =" + SnmpAsn1.asnDecodeUInt(snmpMsgBuffer));
                        break;
                    }
                    case 66: {
                        System.out.println(String.valueOf(string) + "Gauge =" + SnmpAsn1.asnDecodeUInt(snmpMsgBuffer));
                        break;
                    }
                    case 64: {
                        System.out.println(String.valueOf(string) + "IP Address =" + Hex.toString(SnmpAsn1.asnDecodeOctetString(snmpMsgBuffer)));
                        break;
                    }
                    case -127: {
                        System.out.println(String.valueOf(string) + "NoSuchInstance");
                        SnmpAsn1.asnDecodeNull(snmpMsgBuffer);
                        break;
                    }
                    case -128: {
                        System.out.println(String.valueOf(string) + "NoSuchObject");
                        SnmpAsn1.asnDecodeNull(snmpMsgBuffer);
                        break;
                    }
                    case -126: {
                        System.out.println(String.valueOf(string) + "EndOfMibView");
                        SnmpAsn1.asnDecodeNull(snmpMsgBuffer);
                        break;
                    }
                    case 5: {
                        System.out.println(String.valueOf(string) + "Null");
                        SnmpAsn1.asnDecodeNull(snmpMsgBuffer);
                        break;
                    }
                    default: {
                        System.out.print(String.valueOf(string) + snmpMsgBuffer.buf[snmpMsgBuffer.index] + " --- Huh?!");
                        SnmpAsn1.asnDecodeHeader(snmpMsgBuffer);
                        System.out.println(" (len=" + snmpMsgBuffer.len);
                        snmpMsgBuffer.index += snmpMsgBuffer.len;
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error in parse:");
                exception.printStackTrace();
            }
        }
    }

    static boolean matchByte(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void dump(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (n % 16 == 0) {
                System.out.println();
            }
            System.out.print(String.valueOf(Integer.toHexString(0xFF & byArray[n])) + " ");
            ++n;
        }
    }

    public static void dump(byte[] byArray, int n) {
        int n2 = 0;
        n2 = n > byArray.length ? byArray.length : n;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 % 16 == 0) {
                System.out.println();
            }
            System.out.print(String.valueOf(Integer.toHexString(0xFF & byArray[n3])) + " ");
            ++n3;
        }
    }

    public static int calculate_vb_length(SnmpPDU snmpPDU) {
        int n = 0;
        int n2 = snmpPDU.varBindList.size();
        if (snmpPDU.operation == 0 || snmpPDU.operation == 1) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = SnmpAsn1.getOIDlength((SnmpVarBind)snmpPDU.varBindList.elementAt(n3));
                n4 += 3 + SnmpBERlength.size(n4);
                n += n4 + 1 + SnmpBERlength.size(n4);
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = SnmpAsn1.getBERlength((SnmpVarBind)snmpPDU.varBindList.elementAt(n5));
                n += n6 + 1 + SnmpBERlength.size(n6);
                ++n5;
            }
        }
        return n;
    }

    public static int getBERlength(SnmpVarBind snmpVarBind) {
        if (snmpVarBind.oidBERlength == 0) {
            SnmpAsn1.getOIDlength(snmpVarBind);
        }
        int n = snmpVarBind.oidBERlength + 1 + SnmpBERlength.size(snmpVarBind.oidBERlength);
        if (snmpVarBind.varBERlength == 0) {
            SnmpAsn1.getVarLength(snmpVarBind);
        }
        return n += snmpVarBind.varBERlength + 1 + SnmpBERlength.size(snmpVarBind.varBERlength);
    }

    public static int getOIDlength(SnmpVarBind snmpVarBind) {
        if (snmpVarBind.oidBERlength == 0) {
            snmpVarBind.oidBERlength = snmpVarBind.oid.getBERlength();
        }
        return snmpVarBind.oidBERlength;
    }

    public static int getVarLength(SnmpVarBind snmpVarBind) {
        if (snmpVarBind.varBERlength == 0) {
            if (snmpVarBind.variable instanceof Integer) {
                int n = (Integer)snmpVarBind.variable;
                snmpVarBind.varBERlength = n < 128 && n >= -128 ? 1 : (n < 32768 && n >= Short.MIN_VALUE ? 2 : (n < 0x800000 && n >= -8388608 ? 3 : 4));
            } else if (snmpVarBind.variable instanceof OctetString) {
                snmpVarBind.varBERlength = ((OctetString)snmpVarBind.variable).value.length;
            } else if (snmpVarBind.variable instanceof Gauge) {
                long l = ((Gauge)snmpVarBind.variable).value;
                snmpVarBind.varBERlength = SnmpAsn1.getLongLength(l);
            } else if (snmpVarBind.variable instanceof TimeTicks) {
                long l = ((TimeTicks)snmpVarBind.variable).value;
                snmpVarBind.varBERlength = SnmpAsn1.getLongLength(l);
            } else if (snmpVarBind.variable instanceof IPAddress) {
                snmpVarBind.varBERlength = 4;
            } else if (snmpVarBind.variable instanceof Null) {
                snmpVarBind.varBERlength = 0;
            } else if (snmpVarBind.variable instanceof Counter) {
                long l = ((Counter)snmpVarBind.variable).value;
                snmpVarBind.varBERlength = SnmpAsn1.getLongLength(l);
            } else if (snmpVarBind.variable instanceof Counter64) {
                long l = ((Counter64)snmpVarBind.variable).value;
                snmpVarBind.varBERlength = SnmpAsn1.getLongLength(l);
            } else if (snmpVarBind.variable instanceof FullCounter64) {
                BigInteger bigInteger = ((FullCounter64)snmpVarBind.variable).value;
                snmpVarBind.varBERlength = bigInteger.toByteArray().length;
            } else if (snmpVarBind.variable instanceof OID) {
                snmpVarBind.varBERlength = ((OID)snmpVarBind.variable).getBERlength();
            } else if (snmpVarBind.variable instanceof NoSuchObject) {
                snmpVarBind.varBERlength = 0;
            } else if (snmpVarBind.variable instanceof NoSuchInstance) {
                snmpVarBind.varBERlength = 0;
            } else if (snmpVarBind.variable instanceof EndOfMibView) {
                snmpVarBind.varBERlength = 0;
            }
        }
        return snmpVarBind.varBERlength;
    }

    public static int getLongLength(long l) {
        if (l < 0L) {
            return 9;
        }
        if (l < 128L) {
            return 1;
        }
        if (l < 32768L) {
            return 2;
        }
        if (l < 0x800000L) {
            return 3;
        }
        if (l < 0x80000000L) {
            return 4;
        }
        if (l < 0x8000000000L) {
            return 5;
        }
        if (l < 0x800000000000L) {
            return 6;
        }
        if (l < 0x80000000000000L) {
            return 7;
        }
        if (l <= 0x7F00000000000000L) {
            return 8;
        }
        return 9;
    }

    protected static int getMessageId(byte[] byArray) {
        int n = 0;
        try {
            if (48 == byArray[n]) {
                ++n;
                if (2 == byArray[n += SnmpBERlength.size(byArray, n)]) {
                    n += SnmpAsn1.nextField(byArray, n);
                } else {
                    SnmpAsn1.decodeError("Version required for SNMP messages", n, byArray, -1);
                }
                if (48 == byArray[n]) {
                    ++n;
                    if (2 == byArray[n += SnmpBERlength.size(byArray, n)]) {
                        return SnmpAsn1.decode_int(byArray, n);
                    }
                    SnmpAsn1.decodeError("MessageID is not tagged as an Integer", n, byArray, -1);
                }
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return -1;
    }

    private static long[] decode_OID(byte[] byArray, int n) {
        int n2 = SnmpBERlength.decode(byArray, ++n);
        n += SnmpBERlength.size(byArray, n);
        int n3 = 2;
        int n4 = n2 + n;
        int n5 = 1 + n;
        while (n5 < n4) {
            if (byArray[n5] >= 0) {
                ++n3;
            }
            ++n5;
        }
        long[] lArray = new long[n3];
        if (byArray[n] == 43) {
            lArray[0] = 1L;
            lArray[1] = 3L;
        } else {
            lArray[0] = byArray[n] / 40;
            lArray[1] = byArray[n] % 40;
        }
        ++n;
        int n6 = 2;
        while (n6 < n3) {
            if (byArray[n] >= 0) {
                lArray[n6] = byArray[n++];
            } else {
                lArray[n6] = 0L;
                do {
                    lArray[n6] = lArray[n6] << 7 | (long)(byArray[n] & 0x7F);
                } while (byArray[n++] < 0);
            }
            ++n6;
        }
        return lArray;
    }

    private static Serializable decode_snmp_var(byte[] byArray, int n) {
        byte by = byArray[n];
        Serializable serializable = null;
        if (by == 65) {
            serializable = new Counter(SnmpAsn1.decode_long(byArray, n));
        } else if (by == 66) {
            serializable = new Gauge(SnmpAsn1.decode_long(byArray, n));
        } else if (by == 2) {
            serializable = new Integer(SnmpAsn1.decode_int(byArray, n));
        } else if (by == 70) {
            serializable = SnmpV1API.isCounter64Full() ? new FullCounter64(SnmpAsn1.decode_big_int(byArray, n)) : new Counter64(SnmpAsn1.decode_long(byArray, n));
        } else if (by == 67) {
            serializable = new TimeTicks(SnmpAsn1.decode_long(byArray, n));
        } else if (by == 4) {
            byte[] byArray2 = new byte[SnmpBERlength.decode(byArray, ++n)];
            System.arraycopy(byArray, n + SnmpBERlength.size(byArray, n), byArray2, 0, byArray2.length);
            serializable = new OctetString(byArray2);
        } else if (by == 64) {
            serializable = new IPAddress(byArray, n + 2);
        } else if (by == 6) {
            serializable = new OID(SnmpAsn1.decode_OID(byArray, n), true);
        } else if (by == 5) {
            serializable = nullInstance;
        } else if (by == -128) {
            serializable = new NoSuchObject();
        } else if (by == -127) {
            serializable = new NoSuchInstance();
        } else if (by == -126) {
            serializable = new EndOfMibView();
        } else if (by == 68) {
            byte[] byArray3 = new byte[SnmpBERlength.decode(byArray, ++n)];
            System.arraycopy(byArray, n + SnmpBERlength.size(byArray, n), byArray3, 0, byArray3.length);
            serializable = new Opaque(byArray3);
        } else {
            serializable = nullInstance;
        }
        return serializable;
    }

    protected static int decode_int(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (byArray[n + 1] >= 0) {
            n3 = 1;
            n4 = n + 2;
            n5 = byArray[n + 1] + n4;
        } else {
            n3 = SnmpBERlength.size(byArray, n + 1);
            n4 = n + 1 + n3;
            n5 = n4 + SnmpBERlength.decode(byArray, n + 1);
        }
        n2 = byArray[n + 1 + n3] >= 0 ? 0 : -1;
        int n6 = n4;
        while (n6 < n5) {
            n2 = n2 << 8 | byArray[n6] & 0xFF;
            ++n6;
        }
        return n2;
    }

    private static long decode_long(byte[] byArray, int n) {
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (byArray[n + 1] >= 0) {
            n2 = 1;
            n3 = n + 2;
            n4 = byArray[n + 1] + n3;
        } else {
            n2 = SnmpBERlength.size(byArray, n + 1);
            n3 = n + 1 + n2;
            n4 = n3 + SnmpBERlength.decode(byArray, n + 1);
        }
        l = byArray[n + 1 + n2] >= 0 ? 0 : -1;
        int n5 = n3;
        while (n5 < n4) {
            l = l << 8 | (long)(byArray[n5] & 0xFF);
            ++n5;
        }
        return l;
    }

    private static BigInteger decode_big_int(byte[] byArray, int n) {
        BigInteger bigInteger = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (byArray[n + 1] >= 0) {
            n2 = 1;
            n3 = n + 2;
            n4 = byArray[n + 1] + n3;
        } else {
            n2 = SnmpBERlength.size(byArray, n + 1);
            n3 = n + 1 + n2;
            n4 = n3 + SnmpBERlength.decode(byArray, n + 1);
        }
        byte[] byArray2 = new byte[n4 - n3];
        int n5 = 0;
        int n6 = n3;
        while (n6 < n4) {
            byArray2[n5] = byArray[n6];
            ++n6;
            ++n5;
        }
        bigInteger = new BigInteger(byArray2);
        return bigInteger;
    }

    protected static int nextField(byte[] byArray, int n) {
        int n2;
        if (byArray[++n] >= 0) {
            n2 = 2 + byArray[n];
        } else {
            int n3 = byArray[n] & 0x7F;
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                n2 = n2 << 8 | byArray[++n] & 0xFF;
                ++n4;
            }
            n2 += 2 + n3;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private static int encode_oid(byte[] var0, int var1_1, OID var2_2, int var3_3) {
        var0[var1_1++] = 6;
        var1_1 = SnmpBERlength.encode(var3_3, var0, var1_1);
        var4_4 = var2_2.value;
        var5_5 = var4_4.length;
        var0[var1_1++] = (byte)(var4_4[0] * 40L + var4_4[1]);
        var6_6 = 2;
        while (var6_6 < var5_5) {
            block4: {
                var8_8 = var4_4[var6_6];
                if (var8_8 >= 0L) break block4;
                var7_7 = 49;
                ** GOTO lbl17
            }
            if (var8_8 < 128L) {
                var0[var1_1++] = (byte)var8_8;
            } else {
                var7_7 = var8_8 < 16384L ? 7 : (var8_8 < 0x200000L ? 14 : (var8_8 < 0x10000000L ? 21 : (var8_8 < 0x800000000L ? 28 : (var8_8 < 0x40000000000L ? 35 : (var8_8 < 0x2000000000000L ? 42 : 49)))));
lbl17:
                // 3 sources

                while (var7_7 > 0) {
                    var0[var1_1++] = (byte)(var8_8 >>> var7_7 | 128L);
                    var7_7 -= 7;
                }
                var0[var1_1++] = (byte)(var8_8 & 127L);
            }
            ++var6_6;
        }
        return var1_1;
    }

    private static int encode_snmp_var(byte[] byArray, int n, Serializable serializable, int n2) {
        if (serializable instanceof Integer) {
            byArray[n++] = 2;
            byArray[n++] = (byte)n2;
            int n3 = (Integer)serializable;
            int n4 = 0;
            int n5 = (n2 - 1) * 8;
            while (n4 < n2) {
                byArray[n++] = (byte)(n3 >> n5);
                ++n4;
                n5 -= 8;
            }
        } else if (serializable instanceof OctetString) {
            byte[] byArray2 = ((OctetString)serializable).value;
            byArray[n++] = 4;
            n = SnmpBERlength.encode(n2, byArray, n);
            System.arraycopy(byArray2, 0, byArray, n, n2);
            n += n2;
        } else if (serializable instanceof Gauge) {
            byArray[n++] = 66;
            long l = ((Gauge)serializable).value;
            n = SnmpAsn1.encode_long(byArray, n, n2, l);
        } else if (serializable instanceof TimeTicks) {
            byArray[n++] = 67;
            long l = ((TimeTicks)serializable).value;
            n = SnmpAsn1.encode_long(byArray, n, n2, l);
        } else if (serializable instanceof IPAddress) {
            n = SnmpAsn1.encodeIpAddressAndTag(((IPAddress)serializable).getIpAddress(), byArray, n);
        } else if (serializable instanceof Null) {
            byArray[n++] = 5;
            byArray[n++] = 0;
        } else if (serializable instanceof Counter) {
            byArray[n++] = 65;
            long l = ((Counter)serializable).value;
            n = SnmpAsn1.encode_long(byArray, n, n2, l);
        } else if (serializable instanceof Counter64) {
            byArray[n++] = 70;
            long l = ((Counter64)serializable).value;
            n = SnmpAsn1.encode_long(byArray, n, n2, l);
        } else if (serializable instanceof FullCounter64) {
            byArray[n++] = 70;
            BigInteger bigInteger = ((FullCounter64)serializable).value;
            n = SnmpAsn1.encode_big_int(byArray, n, n2, bigInteger);
        } else if (serializable instanceof OID) {
            n = SnmpAsn1.encode_oid(byArray, n, (OID)serializable, n2);
        } else if (serializable instanceof NoSuchObject) {
            byArray[n++] = -128;
            byArray[n++] = 0;
        } else if (serializable instanceof NoSuchInstance) {
            byArray[n++] = -127;
            byArray[n++] = 0;
        } else if (serializable instanceof EndOfMibView) {
            byArray[n++] = -126;
            byArray[n++] = 0;
        } else if (serializable instanceof Opaque) {
            byte[] byArray3 = ((Opaque)serializable).value;
            byArray[n++] = 68;
            n = SnmpBERlength.encode(n2, byArray, n);
            System.arraycopy(byArray3, 0, byArray, n, n2);
            n += n2;
        }
        return n;
    }

    public static int intLength(int n) {
        if (n < 128 && n >= -128) {
            return 1;
        }
        if (n < 32768 && n > Short.MIN_VALUE) {
            return 2;
        }
        if (n < 0x800000 && n > -8388608) {
            return 3;
        }
        return 4;
    }

    protected static int encodeInt(int n, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        int n5 = (n - 1) * 8;
        while (n4 < n) {
            byArray[n3++] = (byte)(n2 >> n5);
            ++n4;
            n5 -= 8;
        }
        return n3;
    }

    private static int encode_long(byte[] byArray, int n, int n2, long l) {
        byArray[n++] = (byte)n2;
        int n3 = 0;
        int n4 = (n2 - 1) * 8;
        while (n3 < n2) {
            byArray[n++] = n4 == 64 ? (byte)0 : (byte)(l >> n4 & 0xFFL);
            ++n3;
            n4 -= 8;
        }
        return n;
    }

    private static int encode_big_int(byte[] byArray, int n, int n2, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        byArray[n++] = (byte)byArray2.length;
        int n3 = 0;
        while (n3 < byArray2.length) {
            byArray[n++] = byArray2[n3];
            ++n3;
        }
        return n;
    }

    private static int encodeIpAddressAndTag(String string, byte[] byArray, int n) {
        byArray[n++] = 64;
        byArray[n++] = 4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        byArray[n++] = (byte)Integer.parseInt(string2);
        string2 = stringTokenizer.nextToken();
        byArray[n++] = (byte)Integer.parseInt(string2);
        string2 = stringTokenizer.nextToken();
        byArray[n++] = (byte)Integer.parseInt(string2);
        string2 = stringTokenizer.nextToken();
        byArray[n++] = (byte)Integer.parseInt(string2);
        return n;
    }

    public static SnmpTrap decodeTrap(byte[] byArray) throws SnmpDecodeException {
        byte by;
        SnmpTrap snmpTrap = new SnmpTrap();
        int n = 0;
        if (48 == byArray[n]) {
            ++n;
            if (2 == byArray[n += SnmpBERlength.size(byArray, n)]) {
                snmpTrap.version = byArray[n + 2];
                n += 3;
            } else {
                SnmpAsn1.decodeError("RequestID not tagged as INTEGER", n, byArray, -1);
            }
            if (4 == byArray[n]) {
                snmpTrap.communityString = new OctetString(byArray, n + 2, SnmpBERlength.decode(byArray, n + 1));
                n += SnmpAsn1.nextField(byArray, n);
            } else {
                SnmpAsn1.decodeError("CommunityName not tagged as OCTET STRING", n, byArray, -1);
            }
        }
        if ((by = byArray[n]) != -92) {
            SnmpAsn1.decodeError("Trap not tagged as a TRAP", n, byArray, -1);
        }
        ++n;
        if (6 == byArray[n += SnmpBERlength.size(byArray, n)]) {
            snmpTrap.enterprise = new OID(SnmpAsn1.decode_OID(byArray, n), true);
            n += SnmpAsn1.nextField(byArray, n);
        } else {
            SnmpAsn1.decodeError("Enterprise not tagged as OID", n, byArray, -1);
        }
        if (64 == byArray[n]) {
            snmpTrap.agentAddr = new IPAddress(byArray, n + 2);
            n += SnmpAsn1.nextField(byArray, n);
        } else {
            SnmpAsn1.decodeError("Agent Address not tagged as IP Address", n, byArray, -1);
        }
        if (2 == byArray[n]) {
            if (byArray[n + 1] == 1) {
                snmpTrap.genericTrap = byArray[n + 2];
                n += 3;
            } else {
                snmpTrap.genericTrap = SnmpAsn1.decode_int(byArray, n);
                n += SnmpAsn1.nextField(byArray, n);
            }
        } else {
            SnmpAsn1.decodeError("Generic Trap value not tagged as an INTEGER", n, byArray, -1);
        }
        if (2 == byArray[n]) {
            if (byArray[n + 1] == 1) {
                snmpTrap.specificTrap = byArray[n + 2];
                n += 3;
            } else {
                snmpTrap.specificTrap = SnmpAsn1.decode_int(byArray, n);
                n += SnmpAsn1.nextField(byArray, n);
            }
        } else {
            SnmpAsn1.decodeError("Specific Trap value not tagged as an INTEGER", n, byArray, -1);
        }
        if (67 == byArray[n]) {
            snmpTrap.timeStamp = new TimeTicks(SnmpAsn1.decode_long(byArray, n));
            n += SnmpAsn1.nextField(byArray, n);
        } else {
            SnmpAsn1.decodeError("Time Stamp value not tagged as a Time Tick", n, byArray, -1);
        }
        if (48 == byArray[n]) {
            snmpTrap.varBindList = new Vector();
            int n2 = n + SnmpAsn1.nextField(byArray, n);
            ++n;
            n += SnmpBERlength.size(byArray, n);
            while (n < n2) {
                if (48 == byArray[n]) {
                    ++n;
                    n += SnmpBERlength.size(byArray, n);
                    long[] lArray = SnmpAsn1.decode_OID(byArray, n);
                    OID oID = new OID(lArray, true);
                    n += SnmpAsn1.nextField(byArray, n);
                    Serializable serializable = SnmpAsn1.decode_snmp_var(byArray, n);
                    n += SnmpAsn1.nextField(byArray, n);
                    SnmpVarBind snmpVarBind = new SnmpVarBind(oID, serializable);
                    snmpTrap.varBindList.addElement(snmpVarBind);
                    continue;
                }
                SnmpAsn1.decodeError("VarBind not tagged as a SEQUENCE", n, byArray, -1);
            }
        } else {
            SnmpAsn1.decodeError("Var Bind list not tagged as a SEQUENCE", n, byArray, -1);
        }
        return snmpTrap;
    }

    public static byte[] encode(SnmpTrap snmpTrap, SessionInfo sessionInfo) {
        int n;
        int n2 = 0;
        int n3 = snmpTrap.varBindList.size();
        int n4 = 0;
        while (n4 < n3) {
            n = SnmpAsn1.getBERlength((SnmpVarBind)snmpTrap.varBindList.elementAt(n4));
            n2 += n + 1 + SnmpBERlength.size(n);
            ++n4;
        }
        n = n2;
        n2 += 1 + SnmpBERlength.size(n2);
        int n5 = snmpTrap.enterprise.getBERlength();
        int n6 = 4;
        int n7 = SnmpAsn1.intLength(snmpTrap.genericTrap);
        int n8 = SnmpAsn1.intLength(snmpTrap.specificTrap);
        int n9 = SnmpAsn1.getLongLength(snmpTrap.timeStamp.value);
        n2 += 2 + n5;
        n2 += 2 + n6;
        n2 += 2 + n7;
        n2 += 2 + n8;
        int n10 = n2 += 2 + n9;
        n2 += 1 + SnmpBERlength.size(n2);
        n2 += 3;
        int n11 = snmpTrap.communityString.value.length;
        int n12 = n2 += 2 + n11;
        n2 += 1 + SnmpBERlength.size(n2);
        byte[] byArray = new byte[n2];
        byArray[0] = 48;
        int n13 = 1;
        n13 = SnmpBERlength.encode(n12, byArray, n13);
        byArray[n13++] = 2;
        byArray[n13++] = 1;
        byArray[n13++] = 0;
        byArray[n13++] = 4;
        n13 = SnmpBERlength.encode(n11, byArray, n13);
        n4 = 0;
        while (n4 < n11) {
            byArray[n13++] = snmpTrap.communityString.value[n4];
            ++n4;
        }
        byArray[n13++] = -92;
        n13 = SnmpBERlength.encode(n10, byArray, n13);
        n13 = SnmpAsn1.encode_oid(byArray, n13, snmpTrap.enterprise, n5);
        n13 = SnmpAsn1.encodeIpAddressAndTag(snmpTrap.agentAddr.getIpAddress(), byArray, n13);
        byArray[n13++] = 2;
        n13 = SnmpBERlength.encode(n7, byArray, n13);
        n13 = SnmpAsn1.encodeInt(n7, snmpTrap.genericTrap, byArray, n13);
        byArray[n13++] = 2;
        n13 = SnmpBERlength.encode(n8, byArray, n13);
        n13 = SnmpAsn1.encodeInt(n8, snmpTrap.specificTrap, byArray, n13);
        byArray[n13++] = 67;
        n13 = SnmpAsn1.encode_long(byArray, n13, n9, snmpTrap.timeStamp.value);
        byArray[n13++] = 48;
        n13 = SnmpBERlength.encode(n, byArray, n13);
        n4 = 0;
        while (n4 < n3) {
            byArray[n13++] = 48;
            SnmpVarBind snmpVarBind = (SnmpVarBind)snmpTrap.varBindList.elementAt(n4);
            int n14 = SnmpAsn1.getBERlength(snmpVarBind);
            n13 = SnmpBERlength.encode(n14, byArray, n13);
            n13 = SnmpAsn1.encode_oid(byArray, n13, snmpVarBind.oid, snmpVarBind.oidBERlength);
            n13 = SnmpAsn1.encode_snmp_var(byArray, n13, snmpVarBind.variable, snmpVarBind.varBERlength);
            ++n4;
        }
        return byArray;
    }

    public static byte[] encode(SnmpPDU snmpPDU) throws SnmpEncodeException {
        return SnmpAsn1.encode(snmpPDU, null);
    }

    public static byte[] encode(SnmpPDU snmpPDU, SessionInfo sessionInfo) throws SnmpEncodeException {
        int n = 0;
        OctetString octetString = sessionInfo != null ? (snmpPDU.operation == 3 ? ((SessionInfoCommString)sessionInfo).setCommunityNameOctet : ((SessionInfoCommString)sessionInfo).getCommunityNameOctet) : snmpPDU.communityString;
        int n2 = n = SnmpAsn1.calculate_vb_length(snmpPDU);
        n += 1 + SnmpBERlength.size(n);
        int n3 = snmpPDU.varBindList.size();
        int n4 = SnmpAsn1.intLength(snmpPDU.requestId);
        int n5 = SnmpAsn1.intLength(snmpPDU.errorStatus);
        int n6 = SnmpAsn1.intLength(snmpPDU.errorIndex);
        n += 2 + n4;
        n += 2 + n5;
        int n7 = n += 2 + n6;
        n += 1 + SnmpBERlength.size(n);
        n += 3;
        int n8 = octetString.value.length;
        n += 1 + SnmpBERlength.size(n8);
        if (SnmpBERlength.size(n8) != 1) {
            System.out.println("CommunityNameLen != 1 -- actual is " + SnmpBERlength.size(n8));
        }
        int n9 = n += n8;
        n += 1 + SnmpBERlength.size(n);
        byte[] byArray = new byte[n];
        byArray[0] = 48;
        int n10 = 1;
        n10 = SnmpBERlength.encode(n9, byArray, n10);
        byArray[n10++] = 2;
        byArray[n10++] = 1;
        byArray[n10++] = sessionInfo != null ? (sessionInfo.version == 0 ? (byte)0 : 1) : (snmpPDU instanceof SnmpV2PDU ? (byte)1 : 0);
        byArray[n10++] = 4;
        n10 = SnmpBERlength.encode(n8, byArray, n10);
        int n11 = 0;
        while (n11 < n8) {
            byArray[n10++] = octetString.value[n11];
            ++n11;
        }
        byArray[n10++] = opType[snmpPDU.operation];
        n10 = SnmpBERlength.encode(n7, byArray, n10);
        byArray[n10++] = 2;
        snmpPDU.requestIdPos = n10 = SnmpBERlength.encode(n4, byArray, n10);
        n10 = SnmpAsn1.encodeInt(n4, snmpPDU.requestId, byArray, n10);
        byArray[n10++] = 2;
        n10 = SnmpBERlength.encode(n5, byArray, n10);
        n10 = SnmpAsn1.encodeInt(n5, snmpPDU.errorStatus, byArray, n10);
        byArray[n10++] = 2;
        n10 = SnmpBERlength.encode(n6, byArray, n10);
        n10 = SnmpAsn1.encodeInt(n6, snmpPDU.errorIndex, byArray, n10);
        byArray[n10++] = 48;
        n10 = SnmpBERlength.encode(n2, byArray, n10);
        if (snmpPDU.operation == 0 || snmpPDU.operation == 1) {
            n11 = 0;
            while (n11 < n3) {
                byArray[n10++] = 48;
                SnmpVarBind snmpVarBind = (SnmpVarBind)snmpPDU.varBindList.elementAt(n11);
                int n12 = SnmpAsn1.getOIDlength(snmpVarBind);
                int n13 = 3 + n12 + SnmpBERlength.size(n12);
                n10 = SnmpBERlength.encode(n13, byArray, n10);
                n10 = SnmpAsn1.encode_oid(byArray, n10, snmpVarBind.oid, snmpVarBind.oidBERlength);
                byArray[n10++] = 5;
                byArray[n10++] = 0;
                ++n11;
            }
        } else {
            n11 = 0;
            while (n11 < n3) {
                byArray[n10++] = 48;
                SnmpVarBind snmpVarBind = (SnmpVarBind)snmpPDU.varBindList.elementAt(n11);
                int n14 = SnmpAsn1.getBERlength(snmpVarBind);
                n10 = SnmpBERlength.encode(n14, byArray, n10);
                n10 = SnmpAsn1.encode_oid(byArray, n10, snmpVarBind.oid, snmpVarBind.oidBERlength);
                n10 = SnmpAsn1.encode_snmp_var(byArray, n10, snmpVarBind.variable, snmpVarBind.varBERlength);
                ++n11;
            }
        }
        return byArray;
    }

    public static SnmpPDU decodePDU(byte[] byArray, int n) {
        SnmpPDU snmpPDU = new SnmpPDU();
        SnmpAsn1.decode(snmpPDU, byArray, n);
        return snmpPDU;
    }

    private static void decode(SnmpPDU snmpPDU, byte[] byArray, int n) {
        int n2 = 0;
        try {
            if (48 == byArray[n2]) {
                ++n2;
                if (2 == byArray[n2 += SnmpBERlength.size(byArray, n2)]) {
                    if (byArray[n2 + 1] == 1) {
                        snmpPDU.version = byArray[n2 + 2];
                        n2 += 3;
                    } else {
                        snmpPDU.version = SnmpAsn1.decode_int(byArray, n2);
                        n2 += SnmpAsn1.nextField(byArray, n2);
                    }
                } else {
                    SnmpAsn1.decodeError("RequestID is not tagged as an Integer", n2, byArray, n);
                }
                if (4 == byArray[n2]) {
                    snmpPDU.communityString = new OctetString(byArray, n2 + 2, SnmpBERlength.decode(byArray, n2 + 1));
                    n2 += SnmpAsn1.nextField(byArray, n2);
                } else {
                    if (snmpPDU.version != 0) {
                        throw new SnmpWrongVersion("Version 1 PDU contains version : " + snmpPDU.version);
                    }
                    SnmpAsn1.decodeError("CommunityName is not tagged as an OctetString", n2, byArray, n);
                }
            }
            byte by = byArray[n2];
            switch (by) {
                case -94: {
                    snmpPDU.operation = 2;
                    break;
                }
                case -96: {
                    snmpPDU.operation = 0;
                    break;
                }
                case -95: {
                    snmpPDU.operation = 1;
                    break;
                }
                case -93: {
                    snmpPDU.operation = 3;
                    break;
                }
                default: {
                    snmpPDU.operation = 7;
                }
            }
            ++n2;
            n2 += SnmpBERlength.size(byArray, n2);
            if (2 == byArray[n2]) {
                snmpPDU.requestId = SnmpAsn1.decode_int(byArray, n2);
                n2 += SnmpAsn1.nextField(byArray, n2);
            } else {
                SnmpAsn1.decodeError("RequestID is not tagged as an Integer", n2, byArray, n);
            }
            if (2 == byArray[n2]) {
                if (byArray[n2 + 1] == 1) {
                    snmpPDU.errorStatus = byArray[n2 + 2];
                    n2 += 3;
                } else {
                    snmpPDU.errorStatus = SnmpAsn1.decode_int(byArray, n2);
                    n2 += SnmpAsn1.nextField(byArray, n2);
                }
            } else {
                SnmpAsn1.decodeError("ErrorStatus is not tagged as an Integer", n2, byArray, n);
            }
            if (2 == byArray[n2]) {
                if (byArray[n2 + 1] == 1) {
                    snmpPDU.errorIndex = byArray[n2 + 2];
                    n2 += 3;
                } else {
                    snmpPDU.errorIndex = SnmpAsn1.decode_int(byArray, n2);
                    n2 += SnmpAsn1.nextField(byArray, n2);
                }
            } else {
                SnmpAsn1.decodeError("ErrorIndex is not tagged as an Integer", n2, byArray, n);
            }
            snmpPDU.varBindList = SnmpAsn1.decode_varBindList(byArray, n2, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Vector decode_varBindList(byte[] byArray, int n, int n2) throws Exception {
        if (48 == byArray[n]) {
            Vector<SnmpVarBind> vector = new Vector<SnmpVarBind>();
            int n3 = n + SnmpAsn1.nextField(byArray, n);
            ++n;
            n += SnmpBERlength.size(byArray, n);
            while (n < n3) {
                if (48 == byArray[n]) {
                    ++n;
                    n += SnmpBERlength.size(byArray, n);
                    long[] lArray = SnmpAsn1.decode_OID(byArray, n);
                    OID oID = new OID(lArray, true);
                    n += SnmpAsn1.nextField(byArray, n);
                    Serializable serializable = SnmpAsn1.decode_snmp_var(byArray, n);
                    n += SnmpAsn1.nextField(byArray, n);
                    SnmpVarBind snmpVarBind = new SnmpVarBind(oID, serializable);
                    vector.addElement(snmpVarBind);
                    continue;
                }
                SnmpAsn1.decodeError("Var Bind is not tagged as a Sequence", n, byArray, n2);
            }
            return vector;
        }
        SnmpAsn1.decodeError("Var Bind List is not tagged as a Sequence", n, byArray, n2);
        return null;
    }

    private static void decodeError(String string, int n, byte[] byArray, int n2) throws SnmpDecodeException {
        SnmpDecodeException snmpDecodeException = new SnmpDecodeException(String.valueOf(string) + " at location " + n + " - it contains " + Hex.toString(byArray[n]) + " total PDU length = " + n2);
        if (SnmpV1API.isTracing()) {
            String string2 = snmpDecodeException.toString();
            string2 = n2 > 0 ? String.valueOf(string2) + Hex.toString(byArray, 0, n2) : String.valueOf(string2) + Hex.toString(byArray, 0, byArray.length < n ? byArray.length : n + 6) + "...";
            SnmpV1API.trace(string2);
        } else {
            System.out.println(snmpDecodeException.toString());
            if (n2 > 0) {
                System.out.println(Hex.toString(byArray, 0, n2));
            } else {
                System.out.println(String.valueOf(Hex.toString(byArray, 0, byArray.length < n ? byArray.length : n + 6)) + "...");
            }
        }
        throw snmpDecodeException;
    }

    private static int encode_V2_pdu(SnmpV2PDU snmpV2PDU, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        byArray[n++] = opType[snmpV2PDU.operation];
        n = SnmpBERlength.encode(n2, byArray, n);
        byArray[n++] = 2;
        n = SnmpBERlength.encode(n3, byArray, n);
        n = SnmpAsn1.encodeInt(n3, snmpV2PDU.requestId, byArray, n);
        if (snmpV2PDU.operation == 4) {
            byArray[n++] = 2;
            n = SnmpBERlength.encode(n4, byArray, n);
            n = SnmpAsn1.encodeInt(n4, snmpV2PDU.nonRepeaters, byArray, n);
            byArray[n++] = 2;
            n = SnmpBERlength.encode(n5, byArray, n);
            n = SnmpAsn1.encodeInt(n5, snmpV2PDU.maxRepetitions, byArray, n);
        } else {
            byArray[n++] = 2;
            n = SnmpBERlength.encode(n4, byArray, n);
            n = SnmpAsn1.encodeInt(n4, snmpV2PDU.errorStatus, byArray, n);
            byArray[n++] = 2;
            n = SnmpBERlength.encode(n5, byArray, n);
            n = SnmpAsn1.encodeInt(n5, snmpV2PDU.errorIndex, byArray, n);
        }
        byArray[n++] = 48;
        n = SnmpBERlength.encode(n6, byArray, n);
        int n7 = snmpV2PDU.varBindList.size();
        if (snmpV2PDU.operation == 0 || snmpV2PDU.operation == 1 || snmpV2PDU.operation == 4) {
            int n8 = 0;
            while (n8 < n7) {
                byArray[n++] = 48;
                SnmpVarBind snmpVarBind = (SnmpVarBind)snmpV2PDU.varBindList.elementAt(n8);
                int n9 = SnmpAsn1.getOIDlength(snmpVarBind);
                int n10 = 3 + n9 + SnmpBERlength.size(n9);
                n = SnmpBERlength.encode(n10, byArray, n);
                n = SnmpAsn1.encode_oid(byArray, n, snmpVarBind.oid, snmpVarBind.oidBERlength);
                byArray[n++] = 5;
                byArray[n++] = 0;
                ++n8;
            }
        } else {
            int n11 = 0;
            while (n11 < n7) {
                byArray[n++] = 48;
                SnmpVarBind snmpVarBind = (SnmpVarBind)snmpV2PDU.varBindList.elementAt(n11);
                int n12 = SnmpAsn1.getBERlength(snmpVarBind);
                n = SnmpBERlength.encode(n12, byArray, n);
                n = SnmpAsn1.encode_oid(byArray, n, snmpVarBind.oid, snmpVarBind.oidBERlength);
                n = SnmpAsn1.encode_snmp_var(byArray, n, snmpVarBind.variable, snmpVarBind.varBERlength);
                ++n11;
            }
        }
        return n;
    }

    public static byte[] encodeV2PDU(SnmpV2PDU snmpV2PDU, SessionInfo sessionInfo) throws SnmpEncodeException {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        OctetString octetString = snmpV2PDU.operation == 3 ? ((SessionInfoCommString)sessionInfo).setCommunityNameOctet : ((SessionInfoCommString)sessionInfo).getCommunityNameOctet;
        int n5 = n3 = SnmpAsn1.calculate_vb_length(snmpV2PDU);
        n3 = n5 + 1 + SnmpBERlength.size(n5);
        int n6 = SnmpAsn1.intLength(snmpV2PDU.requestId);
        n3 += 2 + n6;
        if (snmpV2PDU.operation != 4) {
            n2 = SnmpAsn1.intLength(snmpV2PDU.errorStatus);
            n = SnmpAsn1.intLength(snmpV2PDU.errorIndex);
        } else {
            n2 = SnmpAsn1.intLength(snmpV2PDU.nonRepeaters);
            n = SnmpAsn1.intLength(snmpV2PDU.maxRepetitions);
        }
        n3 += 2 + n2;
        int n7 = n3 += 2 + n;
        n3 += 1 + SnmpBERlength.size(n3);
        n3 += 3;
        int n8 = octetString.value.length;
        int n9 = n3 += 2 + n8;
        n3 += 1 + SnmpBERlength.size(n3);
        byte[] byArray = new byte[n3];
        byArray[n4++] = 48;
        n4 = SnmpBERlength.encode(n9, byArray, n4);
        byArray[n4++] = 2;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 4;
        n4 = SnmpBERlength.encode(n8, byArray, n4);
        int n10 = 0;
        while (n10 < n8) {
            byArray[n4++] = octetString.value[n10];
            ++n10;
        }
        SnmpAsn1.encode_V2_pdu(snmpV2PDU, byArray, n4, n7, n6, n2, n, n5);
        return byArray;
    }

    private static SnmpV2PDU decode_V2_pdu(SnmpV2PDU snmpV2PDU, byte[] byArray, int n, int n2) {
        try {
            byte by = byArray[n];
            switch (by) {
                case -94: {
                    snmpV2PDU.operation = 2;
                    break;
                }
                case -96: {
                    snmpV2PDU.operation = 0;
                    break;
                }
                case -95: {
                    snmpV2PDU.operation = 1;
                    break;
                }
                case -93: {
                    snmpV2PDU.operation = 3;
                    break;
                }
                case -91: {
                    snmpV2PDU.operation = 4;
                    break;
                }
                case -90: {
                    snmpV2PDU.operation = 5;
                    break;
                }
                case -89: {
                    snmpV2PDU.operation = 6;
                    break;
                }
                case -88: {
                    snmpV2PDU.operation = 7;
                    break;
                }
                default: {
                    snmpV2PDU.operation = 99;
                }
            }
            ++n;
            n += SnmpBERlength.size(byArray, n);
            if (2 == byArray[n]) {
                snmpV2PDU.requestId = SnmpAsn1.decode_int(byArray, n);
                n += SnmpAsn1.nextField(byArray, n);
            } else {
                SnmpAsn1.decodeError("SNMP V2 - RequestID must be tagged as an Integer", n, byArray, n2);
            }
            if (2 == byArray[n]) {
                if (snmpV2PDU.operation != 4) {
                    snmpV2PDU.errorStatus = byArray[n + 2];
                    n += 3;
                } else if (byArray[n + 1] == 1) {
                    snmpV2PDU.nonRepeaters = byArray[n + 2];
                    n += 3;
                } else {
                    snmpV2PDU.nonRepeaters = SnmpAsn1.decode_int(byArray, n);
                    n += SnmpAsn1.nextField(byArray, n);
                }
            } else {
                SnmpAsn1.decodeError("SNMP V2 - ErrorStatus/Non-Repeaters must be tagged as an Integer", n, byArray, n2);
            }
            if (2 == byArray[n]) {
                if (byArray[n + 1] == 1) {
                    if (snmpV2PDU.operation != 4) {
                        snmpV2PDU.errorIndex = byArray[n + 2];
                    } else {
                        snmpV2PDU.maxRepetitions = byArray[n + 2];
                    }
                    n += 3;
                } else {
                    if (snmpV2PDU.operation != 4) {
                        snmpV2PDU.errorIndex = SnmpAsn1.decode_int(byArray, n);
                    } else {
                        snmpV2PDU.maxRepetitions = SnmpAsn1.decode_int(byArray, n);
                    }
                    n += SnmpAsn1.nextField(byArray, n);
                }
            } else {
                SnmpAsn1.decodeError("SNMP V2 - ErrorIndex/Max-Repeaters must be tagged as an Integer", n, byArray, n2);
            }
            snmpV2PDU.varBindList = SnmpAsn1.decode_varBindList(byArray, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return snmpV2PDU;
    }

    protected static SnmpV2PDU decodeV2PDU(byte[] byArray, int n) {
        return SnmpAsn1.decodeV2PDU(byArray, n, true);
    }

    protected static SnmpV2PDU decodeV2PDU(byte[] byArray, int n, boolean bl) {
        int n2 = 0;
        SnmpV2PDU snmpV2PDU = bl ? new SnmpV2PDU() : new SnmpV2Trap();
        try {
            if (48 == byArray[n2]) {
                ++n2;
                if (2 == byArray[n2 += SnmpBERlength.size(byArray, n2)]) {
                    snmpV2PDU.version = byArray[n2 + 2];
                    n2 += 3;
                } else {
                    SnmpAsn1.decodeError("SNMP V2 - RequestID must be tagged as an Integer", n2, byArray, n);
                }
                if (4 == byArray[n2]) {
                    snmpV2PDU.communityString = new OctetString(byArray, n2 + 2, SnmpBERlength.decode(byArray, n2 + 1));
                    n2 += SnmpAsn1.nextField(byArray, n2);
                } else {
                    SnmpAsn1.decodeError("SNMP V2 -communityString must be tagged as an OctetString", n2, byArray, n);
                }
            }
            SnmpAsn1.decode_V2_pdu(snmpV2PDU, byArray, n2, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return snmpV2PDU;
    }
}

