/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.test;

import java.io.Serializable;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpTrapSession;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.data.Counter;
import org.eclipse.aperi.snmp.data.Gauge;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;

public class TrapSenderSample {
    private boolean result = true;

    public static void main(String[] stringArray) {
        int n = 8976;
        if (stringArray.length != 2) {
            System.out.println("Usage:\n java TrapSenderSample <destination host name> <destination port>");
            return;
        }
        try {
            new TrapSenderSample();
            SnmpV1API.initialize(-1);
            SnmpTrapSession snmpTrapSession = SnmpTrapSession.open(stringArray[0], Integer.parseInt(stringArray[1]));
            SnmpTrap snmpTrap = new SnmpTrap();
            snmpTrap.enterprise = new OID("1.2.3.4.5.6.7.8.9");
            snmpTrap.communityString = new OctetString("public", true);
            snmpTrap.agentAddr = new IPAddress("9.67.222.98");
            snmpTrap.genericTrap = 2;
            snmpTrap.specificTrap = 3;
            snmpTrap.timeStamp = new TimeTicks(n);
            snmpTrap.addVarBind("1.3.18", (Serializable)new Counter(34L));
            snmpTrap.addVarBind("1.3.18", (Serializable)new OctetString("A test for the pointy-haired boss", true));
            snmpTrap.addVarBind("1.3.18.1", (Serializable)new Counter(3L));
            snmpTrap.addVarBind("1.3.18.2", (Serializable)new Gauge(34L));
            snmpTrap.addVarBind("1.3.18.3", (Serializable)new Gauge(3L));
            snmpTrap.addVarBind("1.3.5", (Serializable)new OID("1.3.4.6.34"));
            snmpTrap.addVarBind("1.0.0.0.2");
            SnmpTrap snmpTrap2 = new SnmpTrap();
            snmpTrap2.enterprise = new OID("1.2.3.4.5.6.7.8.9");
            snmpTrap2.communityString = new OctetString("public", true);
            snmpTrap2.agentAddr = new IPAddress("9.67.222.99");
            snmpTrap2.genericTrap = 0;
            snmpTrap2.specificTrap = 3;
            snmpTrap2.timeStamp = new TimeTicks(n);
            snmpTrap2.addVarBind("1.3.18", (Serializable)new Counter(34L));
            SnmpTrap snmpTrap3 = new SnmpTrap();
            snmpTrap3.enterprise = new OID("1.2.3.4.5.6.7.8.9");
            snmpTrap3.communityString = new OctetString("public", true);
            snmpTrap3.agentAddr = new IPAddress("9.67.222.100");
            snmpTrap3.genericTrap = 1;
            snmpTrap3.specificTrap = 3;
            snmpTrap3.timeStamp = new TimeTicks(n);
            snmpTrap3.addVarBind("1.3.18", (Serializable)new Counter(34L));
            while (true) {
                int n2;
                System.out.println("hit enter to start sending traps");
                try {
                    int n3 = System.in.read();
                    if (n3 == 113) break;
                    int n4 = System.in.available();
                    n2 = 0;
                    while (n2 < n4) {
                        System.in.read();
                        ++n2;
                    }
                }
                catch (Exception exception) {}
                long l = System.currentTimeMillis();
                n2 = 0;
                while (n2 < 3) {
                    System.out.print("+");
                    snmpTrapSession.send(snmpTrap);
                    snmpTrapSession.send(snmpTrap2);
                    snmpTrapSession.send(snmpTrap3);
                    snmpTrap.timeStamp = new TimeTicks(n += 7);
                    snmpTrap2.timeStamp = new TimeTicks(n);
                    snmpTrap3.timeStamp = new TimeTicks(n);
                    ++n2;
                }
                long l2 = System.currentTimeMillis();
                System.out.println("elapsed time = " + (l2 - l));
                System.out.println("");
            }
            SnmpV1API.terminate();
        }
        catch (Exception exception) {
            System.out.println("error:" + exception.toString());
        }
    }
}

